/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.preferences;

import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.core.notify.EnableImportEventManager;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.parts.AgentRepositoryTable;
import com.ibm.cic.common.core.preferences.CicPreferenceManager;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.core.preferences.ICicPreferenceHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class AgentMainPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private final List repLocations = new ArrayList();
    private final Map locationProperties = new HashMap();
    private final Map locationOpen = new HashMap();
    private final Map locationStatus = new HashMap();
    private AgentRepositoryTable repositoryTable;
    private final CicPreferenceManager prefMan;
    private final ICicPreferenceHandler prefDefaultHandler;
    private final ICicPreferenceHandler prefCurrentHandler;
    private Button useServiceRepButton;
    private boolean useServiceRep = true;
    private IDialogSettings dialogSettings;
    private static final String col1_width = "rep_col_width";
    private static final String col2_width = "connectioin_col_width";
    public static final String PREFERENCE_DLG_SETTINGS = "com.ibm.cic.agent.ui.preferenceDlg.settings";
    private int rep_col_width;
    private int connect_col_width;

    public AgentMainPreferencePage() {
        this.setPreferenceStore(AgentUI.getDefault().getAgentPreferenceStore());
        this.prefMan = CicPreferenceManager.getInstance();
        this.prefCurrentHandler = this.prefMan.getCurrentPreferenceHandler();
        this.prefDefaultHandler = this.prefMan.getDefaultsPreferenceHandler();
    }

    public void createControl(Composite parent) {
        Button restoreDefaultButton;
        super.createControl(parent);
        if (!SharedUIUtils.isPreferenceEditable((ICicPreferenceConstants.PreferenceTag)ICicPreferenceConstants.REPOSITORY_LOCATIONS) && !SharedUIUtils.isPreferenceEditable((ICicPreferenceConstants.PreferenceTag)ICicPreferenceConstants.USE_SERVICE_REPOSITORIES) && (restoreDefaultButton = this.getDefaultsButton()) != null) {
            restoreDefaultButton.setEnabled(false);
        }
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.cic.agent.ui.AgentMainPreferencePage");
        this.initializeDialogUnits((Control)parent);
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        result.setLayout((Layout)layout);
        result.setLayoutData((Object)new GridData(1808));
        this.readConfiguration();
        this.repositoryTable = new AgentRepositoryTable(this.repLocations, this.locationProperties, this.locationOpen, this.locationStatus, this.rep_col_width, this.connect_col_width);
        this.repositoryTable.loadRepositorySettings(this.getPreferenceStore(), this.prefMan, false);
        this.repositoryTable.createControl(result, false, null, 1);
        if (!SharedUIUtils.isPreferenceEditable((ICicPreferenceConstants.PreferenceTag)ICicPreferenceConstants.REPOSITORY_LOCATIONS)) {
            this.repositoryTable.setEnabled(false);
        }
        new Label(result, 0);
        this.loadServiceRepositorySettings(false);
        Label serviceRepLabel = new Label(result, 64);
        serviceRepLabel.setFont(parent.getFont());
        serviceRepLabel.setText(Messages.ServiceRepository_useServiceRepLabel);
        GridData gd = new GridData(4, 4, true, false);
        gd.widthHint = this.rep_col_width > 0 && this.connect_col_width > 0 ? this.rep_col_width + this.connect_col_width : 500;
        serviceRepLabel.setLayoutData((Object)gd);
        this.useServiceRepButton = new Button(result, 96);
        this.useServiceRepButton.setFont(parent.getFont());
        this.useServiceRepButton.setText(Messages.ServiceRepository_useServiceRepository);
        GridData data = new GridData(4, 4, true, false);
        this.useServiceRepButton.setLayoutData((Object)data);
        this.useServiceRepButton.setSelection(this.useServiceRep);
        this.useServiceRepButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AgentMainPreferencePage.this.useServiceRep = AgentMainPreferencePage.this.useServiceRepButton.getSelection();
            }
        });
        if (!SharedUIUtils.isPreferenceEditable((ICicPreferenceConstants.PreferenceTag)ICicPreferenceConstants.USE_SERVICE_REPOSITORIES)) {
            this.useServiceRepButton.setEnabled(false);
        }
        new Label(result, 0);
        return result;
    }

    public void init(IWorkbench workbench) {
    }

    public void resetAccessibility() {
        if (this.repositoryTable != null) {
            this.repositoryTable.resetRepositoryStatus();
        }
    }

    public boolean performOk() {
        this.prefCurrentHandler.remove(AgentRepositoryTable.prefTag);
        if (this.isDifferentFromdefault()) {
            if (this.repLocations.isEmpty()) {
                this.prefCurrentHandler.addValue(AgentRepositoryTable.prefTag.key(), "");
            } else {
                boolean isImportEnabledSet = this.prefMan.isSet(ICicPreferenceConstants.IMPORT_ENABLED.key());
                for (String location : this.repLocations) {
                    List importEnabledRepLocations;
                    this.prefCurrentHandler.addValue(AgentRepositoryTable.prefTag.key(), location);
                    List nameValueMaps = (List)this.locationProperties.get(location);
                    String settings = this.repositoryTable.constructSettings(nameValueMaps);
                    if (settings.isEmpty()) {
                        this.prefCurrentHandler.remove(AgentRepositoryTable.repoSpecialSettingsTag.replaceKey(1, location).key());
                    } else {
                        this.prefCurrentHandler.setValue(AgentRepositoryTable.repoSpecialSettingsTag.replaceKey(1, location).key(), settings);
                    }
                    Boolean open = (Boolean)this.locationOpen.get(location);
                    this.prefCurrentHandler.setValue(AgentRepositoryTable.repoIsOpenTag.replaceKey(1, location).key(), open.booleanValue());
                    if (isImportEnabledSet || !open.booleanValue() || !(importEnabledRepLocations = this.repositoryTable.getImportEnabledRepLocations()).contains(location)) continue;
                    this.prefMan.setBoolean(ICicPreferenceConstants.IMPORT_ENABLED, true);
                    EnableImportEventManager.getInstance().fireEnableImportEvent(null);
                    isImportEnabledSet = true;
                }
            }
        }
        this.prefMan.setBoolean(ICicPreferenceConstants.USE_SERVICE_REPOSITORIES, this.useServiceRep);
        this.prefCurrentHandler.save();
        AgentUI.getDefault().firePropertyChange("PreferenceChange", null, null);
        AgentUI.getDefault().getAgent().resetRepositoryGroup();
        return true;
    }

    boolean isDifferentFromdefault() {
        boolean return_value = false;
        String[] defPrefs = this.prefDefaultHandler.getStringArray(AgentRepositoryTable.prefTag.key());
        int i = 0;
        if (defPrefs.length != this.repLocations.size()) {
            return_value = true;
        } else {
            Iterator it = this.repLocations.iterator();
            while (it.hasNext() && !return_value) {
                String location = (String)it.next();
                if (location.equals(defPrefs[i++])) {
                    List nameValueMaps = (List)this.locationProperties.get(location);
                    String settings = this.repositoryTable.constructSettings(nameValueMaps);
                    if (!this.prefDefaultHandler.getString(AgentRepositoryTable.repoSpecialSettingsTag.replaceKey(1, location).key()).equals(settings)) {
                        return_value = true;
                        continue;
                    }
                    Boolean open = (Boolean)this.locationOpen.get(location);
                    if (this.prefDefaultHandler.getBoolean(AgentRepositoryTable.repoIsOpenTag.replaceKey(1, location).key()) == open.booleanValue()) continue;
                    return_value = true;
                    continue;
                }
                return_value = true;
            }
        }
        return return_value;
    }

    private void loadServiceRepositorySettings(boolean useDefaultPreferences) {
        this.useServiceRep = useDefaultPreferences ? this.prefDefaultHandler.getBoolean(ICicPreferenceConstants.USE_SERVICE_REPOSITORIES.key()) : this.prefMan.getBoolean(ICicPreferenceConstants.USE_SERVICE_REPOSITORIES.key());
    }

    protected void performDefaults() {
        if (SharedUIUtils.isPreferenceEditable((ICicPreferenceConstants.PreferenceTag)ICicPreferenceConstants.REPOSITORY_LOCATIONS)) {
            this.repositoryTable.loadRepositorySettings(this.getPreferenceStore(), this.prefMan, true);
            this.repositoryTable.getRepositoriesViewer().setInput((Object)this.repLocations);
            Object[] openReps = this.repositoryTable.getOpenRepositories(this.locationOpen);
            this.repositoryTable.getRepositoriesViewer().setCheckedElements(openReps);
        }
        if (SharedUIUtils.isPreferenceEditable((ICicPreferenceConstants.PreferenceTag)ICicPreferenceConstants.USE_SERVICE_REPOSITORIES)) {
            this.loadServiceRepositorySettings(true);
            this.useServiceRepButton.setSelection(this.useServiceRep);
        }
        super.performDefaults();
    }

    public void dispose() {
        this.writeConfiguration(this.repositoryTable.getTable());
        this.repositoryTable.dispose();
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings settings = AgentUI.getDefault().getDialogSettings();
        this.dialogSettings = settings.getSection(PREFERENCE_DLG_SETTINGS);
        if (this.dialogSettings == null) {
            this.dialogSettings = settings.addNewSection(PREFERENCE_DLG_SETTINGS);
        }
        return this.dialogSettings;
    }

    private void readConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        try {
            this.rep_col_width = s.getInt(col1_width);
            this.connect_col_width = s.getInt(col2_width);
        }
        catch (NumberFormatException numberFormatException) {
            this.rep_col_width = 0;
            this.connect_col_width = 0;
        }
    }

    private void writeConfiguration(Table table) {
        IDialogSettings s = this.getDialogSettings();
        s.put(col1_width, table.getColumn(0).getWidth());
        int col2Width = table.getColumn(1).getWidth();
        int maxCol2Width = this.calculateMaxCol2Width(table);
        if (col2Width > maxCol2Width) {
            col2Width = maxCol2Width;
        }
        s.put(col2_width, col2Width);
    }

    private int calculateMaxCol2Width(Table table) {
        int width = 0;
        GC gc = null;
        try {
            gc = new GC((Drawable)table);
            gc.setFont(table.getFont());
            String colText = table.getColumn(1).getText();
            width = gc.textExtent((String)colText).x + 15;
        }
        finally {
            if (gc != null) {
                gc.dispose();
            }
        }
        return width;
    }

    public void updateRepositoryTableViewer() {
        if (this.repositoryTable != null) {
            this.repositoryTable.updateRepositoryTableViewer();
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.repositoryTable != null) {
            this.repositoryTable.updateClearCredentialButton();
        }
    }
}

