/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.parts;

import com.ibm.cic.agent.internal.ui.views.IPreviewTask;
import com.ibm.cic.agent.internal.ui.views.IPreviewTaskProvider;
import com.ibm.cic.common.ui.parts.IFormContext;
import com.ibm.cic.common.ui.parts.TreeSection;
import com.ibm.cic.common.ui.services.UiServices;
import java.util.Hashtable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public abstract class TreeMasterPart
extends TreeSection
implements IPreviewTaskProvider {
    protected Hashtable previewTasks;

    public TreeMasterPart(IFormContext context, Composite parent, String[] buttonLabels) {
        super(context, parent, 640, buttonLabels);
    }

    public TreeMasterPart(IFormContext context, Composite parent, int sectionStyle, String[] buttonLabels, int buttonsOrientation) {
        super(context, parent, sectionStyle, buttonLabels, buttonsOrientation);
    }

    @Override
    protected void configureViewer(TreeViewer viewer) {
        super.configureViewer(viewer);
        viewer.getTree().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000E) {
                    TreeMasterPart.this.refresh();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.makePreviewTasks();
    }

    @Override
    protected void createClient(Section section, FormToolkit toolkit) {
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.createViewerPartControl(container, 2, 2, toolkit);
        UiServices.getInstance().paintBordersFor(toolkit, container);
        section.setClient((Control)container);
    }

    protected void makePreviewTasks() {
        this.previewTasks = new Hashtable();
    }

    @Override
    public IPreviewTask[] getPreviewTasksFor(ISelection selection) {
        Class<?> key;
        Object object = ((StructuredSelection)selection).getFirstElement();
        if (object != null && (key = object.getClass()) != null && this.previewTasks.containsKey(key)) {
            IPreviewTask[] tasks;
            IPreviewTask[] iPreviewTaskArray = tasks = (IPreviewTask[])this.previewTasks.get(key);
            int n = tasks.length;
            int n2 = 0;
            while (n2 < n) {
                IPreviewTask task = iPreviewTaskArray[n2];
                task.setArgument(object);
                ++n2;
            }
            return tasks;
        }
        return new IPreviewTask[0];
    }

    @Override
    protected void selectionChanged(IStructuredSelection selection) {
        this.getManagedForm().fireSelectionChanged((IFormPart)this, (ISelection)selection);
    }

    protected FormToolkit getToolkit() {
        return this.getContext().getForm().getToolkit();
    }
}

