/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.console.views;

import com.ibm.cic.common.core.console.actions.IConAction;
import com.ibm.cic.common.core.console.manager.IConIO;
import com.ibm.cic.common.core.console.manager.rules.IConLineMatcher;
import com.ibm.cic.common.core.console.views.AConView;
import com.ibm.cic.common.core.console.views.ConViewText;
import com.ibm.cic.common.core.utils.OutputFormatter;
import java.util.ArrayList;
import java.util.List;

public class ConViewProperties
extends AConView {
    private ConViewText m_commonHeader;
    private String m_keyHeader;
    private String m_valueHeader;
    private final List<Prop> m_properties = new ArrayList<Prop>();
    private final int m_tabNrOffset;
    private final boolean m_addNLatTheEnd;
    private String m_formatString = "%-27s:  %s";

    public ConViewProperties(String a_commonHeader, String a_keyHeader, String a_valueHeader, int a_tabNrOffset, boolean a_addNLatTheEnd) {
        this.m_commonHeader = new ConViewText(a_commonHeader, true);
        this.m_keyHeader = a_keyHeader;
        this.m_valueHeader = a_valueHeader;
        this.m_tabNrOffset = a_tabNrOffset;
        this.m_addNLatTheEnd = a_addNLatTheEnd;
    }

    public ConViewProperties(String a_commonHeader, String a_keyHeader, String a_valueHeader) {
        this(a_commonHeader, a_keyHeader, a_valueHeader, 1, false);
        this.m_commonHeader = new ConViewText(a_commonHeader, true);
        this.m_keyHeader = a_keyHeader;
        this.m_valueHeader = a_valueHeader;
    }

    public ConViewProperties() {
        this(null, null, null, 0, true);
    }

    public void addProperty(String a_key, String a_value) {
        this.m_properties.add(new Prop(a_key, a_value));
    }

    public void setFormatString(String string) {
        this.m_formatString = string;
    }

    @Override
    public String findKey(IConLineMatcher a_matcher) {
        return null;
    }

    @Override
    public IConAction getAction(IConIO a_input) {
        return null;
    }

    @Override
    public void present(OutputFormatter a_output) {
        this.m_commonHeader.present(a_output);
        int i = 0;
        while (i < this.m_tabNrOffset) {
            a_output.incTab();
            ++i;
        }
        if (this.m_keyHeader != null && this.m_valueHeader != null) {
            a_output.appendTnl(new String[]{String.format(this.m_formatString, this.m_keyHeader, this.m_valueHeader)});
            a_output.nl();
        }
        for (Prop pr : this.m_properties) {
            a_output.appendTnl(new String[]{String.format(this.m_formatString, pr.m_key, pr.m_val)});
        }
        i = 0;
        while (i < this.m_tabNrOffset) {
            a_output.decTab();
            ++i;
        }
        if (this.m_addNLatTheEnd) {
            a_output.nl();
        }
    }

    public void clear() {
        this.m_properties.clear();
    }

    private static class Prop {
        final String m_key;
        final String m_val;

        public Prop(String a_key, String a_val) {
            this.m_key = a_key;
            this.m_val = a_val;
        }
    }
}

