/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.console.views;

import com.ibm.cic.common.core.console.ConCommonCommandKeys;
import com.ibm.cic.common.core.console.actions.AConActionEntry;
import com.ibm.cic.common.core.console.manager.IConIO;
import com.ibm.cic.common.core.console.manager.rules.IConLineMatcher;
import com.ibm.cic.common.core.console.views.AConView;
import com.ibm.cic.common.core.console.views.ConViewListEntry;
import com.ibm.cic.common.core.utils.OutputFormatter;
import java.util.ArrayList;
import java.util.List;

public class ConViewList
extends AConView {
    private String m_header;
    boolean m_verticalLayout;
    protected List<ConViewListEntry> m_entryList = new ArrayList<ConViewListEntry>();
    private boolean m_newLineAfterList = true;
    private boolean m_hideHeaderIfListEmpty = false;
    private int m_indent = 0;
    protected boolean m_selectable = false;

    public ConViewList(String a_header, boolean a_verticalLayout) {
        this(a_header, a_verticalLayout, 0);
    }

    public ConViewList(String a_header, boolean a_verticalLayout, int indent) {
        this.setHeader(a_header);
        this.m_verticalLayout = a_verticalLayout;
        this.m_indent = indent;
    }

    public ConViewList(String a_header, boolean a_verticalLayout, boolean a_selectable, int indent) {
        this(a_header, a_verticalLayout, indent);
        this.m_selectable = a_selectable;
    }

    public ConViewList() {
        this(null, true);
    }

    public ConViewList(String a_header) {
        this(a_header, true);
    }

    public void setNewLineAfterList(boolean b) {
        this.m_newLineAfterList = b;
    }

    public boolean isNewLineAfterList() {
        return this.m_newLineAfterList;
    }

    public void setHeader(String a_header) {
        this.m_header = a_header;
    }

    public ConViewListEntry addEntry(String a_name, String[] a_keys, AConActionEntry a_action) {
        ConViewListEntry newEntry = new ConViewListEntry(a_name, a_keys, a_action);
        this.m_entryList.add(newEntry);
        return newEntry;
    }

    public ConViewListEntry addEntry(String a_name, String key, AConActionEntry a_action) {
        return this.addEntry(a_name, new String[]{key}, a_action);
    }

    public ConViewListEntry addEntry(String a_name) {
        return this.addEntry(a_name, ConCommonCommandKeys.keys_NoKeys, null);
    }

    @Override
    public AConActionEntry getAction(IConIO a_input) {
        String input = a_input.getString();
        int index = 0;
        for (ConViewListEntry e : this.m_entryList) {
            String[] keys;
            String[] stringArray = keys = e.getKeys();
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s.equalsIgnoreCase("")) {
                    return e.getAction();
                }
                if (input.equalsIgnoreCase(s)) {
                    AConActionEntry a = e.getAction();
                    if (a != null) {
                        a.setEntry(e);
                        a.setEntryIndex(index, 0);
                    }
                    return a;
                }
                ++n2;
            }
            ++index;
        }
        return null;
    }

    @Override
    public void present(OutputFormatter a_output) {
        if (!this.m_entryList.isEmpty() || !this.m_hideHeaderIfListEmpty) {
            int indent = this.m_indent;
            while (indent > 0) {
                a_output.incTab();
                --indent;
            }
            this.presentHeader(a_output);
            a_output.incTab();
            int i = 0;
            for (ConViewListEntry e : this.m_entryList) {
                if (this.m_verticalLayout) {
                    a_output.appendT(new String[]{this.presentKey(e, i)});
                    a_output.appendNT(this.presentSelected(e, i));
                    a_output.appendNTnl(this.presentName(e, i));
                } else {
                    if (i > 0) {
                        a_output.appendNT(", ");
                    }
                    a_output.appendT(new String[]{this.presentKey(e, i)});
                    a_output.appendNT(this.presentSelected(e, i));
                    a_output.appendNT(this.presentName(e, i));
                }
                ++i;
            }
            a_output.decTab();
            this.presentTail(a_output);
            int indent2 = this.m_indent;
            while (indent2 > 0) {
                a_output.decTab();
                --indent2;
            }
        }
    }

    protected String presentKey(ConViewListEntry e, int index) {
        String[] keys = e.getKeys();
        if (keys.length == 0) {
            return "      ";
        }
        return String.format("%4s. ", e.getKeys()[0]);
    }

    protected String presentSelected(ConViewListEntry e, int index) {
        String return_value = "";
        if (this.m_selectable) {
            return_value = "[" + (e.isSelected() ? "X" : " ") + "] ";
        }
        return return_value;
    }

    protected String presentName(ConViewListEntry e, int index) {
        return e.getName();
    }

    protected void presentHeader(OutputFormatter a_output) {
        if (this.m_header != null) {
            a_output.appendTnl(new String[]{this.m_header});
        }
    }

    protected void presentTail(OutputFormatter a_output) {
        if (this.m_newLineAfterList) {
            a_output.nl();
        }
    }

    public void clearList() {
        this.m_entryList.clear();
    }

    @Override
    public String findKey(IConLineMatcher a_matcher) {
        for (ConViewListEntry e : this.m_entryList) {
            if (a_matcher.matches(e.getName()) != 1) continue;
            String[] keys = e.getKeys();
            return keys.length > 0 ? e.getKeys()[0] : null;
        }
        return null;
    }

    public void setHideHeaderIfListEmpty(boolean hideIfEmpty) {
        this.m_hideHeaderIfListEmpty = hideIfEmpty;
    }
}

