/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.console.dialogs;

import com.ibm.cic.common.core.console.manager.AConManager;
import com.ibm.cic.common.core.console.manager.ConIOSimple;
import com.ibm.cic.common.core.console.manager.IConIO;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.console.pages.AConPage;
import com.ibm.cic.common.core.console.views.ConViewList;
import com.ibm.cic.common.logging.Logger;
import org.eclipse.core.runtime.IStatus;

public abstract class AConDialog {
    private static final Logger log = Logger.getLogger(AConDialog.class);
    private static IConIO overrideConIO = null;
    private final IConManager parent;
    private final String title;
    private final ConDialogManager manager;
    private int returnCode = -1;

    public AConDialog(IConManager parent, String title) {
        this.parent = parent;
        this.title = title;
        this.manager = new ConDialogManager(this);
    }

    public int open() {
        IStatus consoleStatus = this.manager.run();
        log.statusNotOK(consoleStatus);
        return this.getReturnCode();
    }

    @Deprecated
    public static void setOverrideConIO(IConIO overrideConIO) {
        AConDialog.overrideConIO = overrideConIO;
    }

    protected abstract AConDialogPage createPage();

    protected IConManager getParent() {
        return this.parent;
    }

    protected String getTitle() {
        return this.title;
    }

    protected ConDialogManager getManager() {
        return this.manager;
    }

    protected int getReturnCode() {
        return this.returnCode;
    }

    protected void setReturnCode(int returnCode) {
        this.returnCode = returnCode;
    }

    protected static abstract class AConDialogPage
    extends AConPage {
        private final AConDialog dialog;

        protected AConDialogPage(AConDialog dialog) {
            super(dialog.getManager());
            this.dialog = dialog;
        }

        protected AConDialog getDialog() {
            return this.dialog;
        }

        @Override
        public void init() {
            this.setHeaderView(this.createHeader());
            this.createContent();
            this.addView(this.createActions());
            super.init();
        }

        protected String createHeader() {
            StringBuilder sb = new StringBuilder();
            String applicationName = this.dialog.getManager().getApplicationName();
            sb.append(applicationName);
            String title = this.dialog.getTitle();
            if (title != null) {
                if (sb.length() > 0) {
                    sb.append("> ");
                }
                sb.append(title);
            }
            return sb.toString();
        }

        protected abstract void createContent();

        protected abstract ConViewList createActions();
    }

    protected static final class ConDialogManager
    extends AConManager {
        private final AConDialog dialog;

        protected ConDialogManager(AConDialog dialog) {
            super(ConDialogManager.getConIO(dialog), ConDialogManager.getApplicationName(dialog));
            this.dialog = dialog;
        }

        private static IConIO getConIO(AConDialog dialog) {
            IConManager conManager = dialog.getParent();
            if (conManager != null) {
                return conManager.getConIO();
            }
            if (overrideConIO != null) {
                return overrideConIO;
            }
            return new ConIOSimple();
        }

        private static String getApplicationName(AConDialog dialog) {
            IConManager conManager = dialog.getParent();
            return conManager != null ? conManager.getApplicationName() : null;
        }

        @Override
        protected AConPage getWelcomePage() {
            return this.getDialog().createPage();
        }

        protected AConDialog getDialog() {
            return this.dialog;
        }
    }
}

