/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.console;

import com.ibm.cic.common.core.console.shared.pages.ConCredentialPrompter;
import com.ibm.cic.common.core.console.shared.pages.ConDiskChangePrompter;
import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.volrepo.DiskPrompter;
import com.ibm.cic.common.core.volrepo.IDiskChangePrompter;
import com.ibm.cic.common.core.volrepo.IDiskInsertedValidator;
import com.ibm.cic.common.downloads.CredentialPrompter;
import com.ibm.cic.common.downloads.ICredentialPrompter;
import java.util.Locale;
import org.eclipse.core.runtime.IStatus;

public class PrompterUtils {

    public static class ConsoleCredentialPrompter {
        private static final ConsoleCredentialPrompter NO_PROMPTER = new ConsoleCredentialPrompter(null){

            @Override
            public void restore() {
            }
        };
        private final ICredentialPrompter previousCredentialPrompter;

        public static ConsoleCredentialPrompter create(String application, boolean prompt) {
            return !prompt ? NO_PROMPTER : new ConsoleCredentialPrompter(application.toUpperCase(Locale.ENGLISH));
        }

        private ConsoleCredentialPrompter(String application) {
            if (application == null) {
                this.previousCredentialPrompter = null;
            } else {
                this.previousCredentialPrompter = CredentialPrompter.INSTANCE.getPrompter();
                CredentialPrompter.INSTANCE.setPrompter((ICredentialPrompter)new ConCredentialPrompter(application));
            }
        }

        public void restore() {
            CredentialPrompter.INSTANCE.setPrompter(this.previousCredentialPrompter);
        }
    }

    public static class ConsoleDiskPrompter
    implements IHasRestore {
        private final IDiskChangePrompter previousPrompter = DiskPrompter.INSTANCE.getPrompter();

        public ConsoleDiskPrompter(String application) {
            DiskPrompter.INSTANCE.setPrompter((IDiskChangePrompter)new ConDiskChangePrompter(application));
        }

        @Override
        public void restore() {
            DiskPrompter.INSTANCE.setPrompter(this.previousPrompter);
        }
    }

    public static class ConsoleNoDiskPrompter
    implements IHasRestore {
        private IDiskChangePrompter previousPrompter = DiskPrompter.INSTANCE.getPrompter();

        public ConsoleNoDiskPrompter() {
            DiskPrompter.INSTANCE.setPrompter(new IDiskChangePrompter(){

                public IStatus promptInsertDisk(IDiskInsertedValidator validator, ICicLocation rootDir, String diskLabel, String diskSetId, int diskNum) {
                    String msg = diskLabel != null ? NLS.bind((String)Messages.PrompterUtils_failedToFindDiskWithoutPrompter, (Object[])new Object[]{diskNum, diskLabel, rootDir}) : NLS.bind((String)Messages.PrompterUtils_failedToFindDiskNoLabelWithoutPrompter, (Object)diskNum, (Object)rootDir);
                    return Statuses.CANCEL.get(202, msg, new Object[0]);
                }
            });
        }

        @Override
        public void restore() {
            DiskPrompter.INSTANCE.setPrompter(this.previousPrompter);
        }
    }

    public static interface IHasRestore {
        public void restore();
    }
}

