/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management;

import com.ibm.lang.management.DynamicMXBeanImpl;
import com.ibm.lang.management.ManagementUtils;
import com.ibm.lang.management.MemoryMXBeanImpl;
import com.ibm.lang.management.MemoryNotificationThread;
import com.ibm.lang.management.MemoryPoolMXBean;
import java.lang.management.ManagementPermission;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.Iterator;
import java.util.LinkedList;
import javax.management.MBeanInfo;

public final class MemoryPoolMXBeanImpl
extends DynamicMXBeanImpl
implements MemoryPoolMXBean {
    private final String name;
    private final int id;
    private final MemoryType type;
    private final MemoryMXBeanImpl memBean;
    private static MemoryPoolMXBean javaHeapMemoryPoolMXBean;
    private static MemoryPoolMXBeanImpl tempInstance;

    static synchronized MemoryPoolMXBean getJavaHeapMemoryPoolMXBean(String string, int n, MemoryMXBeanImpl memoryMXBeanImpl) {
        if (javaHeapMemoryPoolMXBean == null) {
            javaHeapMemoryPoolMXBean = new MemoryPoolMXBeanImpl(string, MemoryType.HEAP, n, memoryMXBeanImpl);
        }
        return javaHeapMemoryPoolMXBean;
    }

    MemoryPoolMXBeanImpl(String string, MemoryType memoryType, int n, MemoryMXBeanImpl memoryMXBeanImpl) {
        super(ManagementUtils.createObjectName("java.lang:type=MemoryPool", string));
        this.name = string;
        this.type = memoryType;
        this.id = n;
        this.memBean = memoryMXBeanImpl;
        if (this.isUsageThresholdSupported() || this.isCollectionUsageThresholdSupported()) {
            MemoryNotificationThread memoryNotificationThread = new MemoryNotificationThread(memoryMXBeanImpl, this, n);
            memoryNotificationThread.setDaemon(true);
            memoryNotificationThread.setName("MemoryPoolMXBean notification dispatcher");
            memoryNotificationThread.setPriority(6);
            memoryNotificationThread.start();
        }
    }

    MemoryPoolMXBeanImpl() {
        super(null);
        this.name = null;
        this.type = null;
        this.id = -1;
        this.memBean = null;
    }

    static MemoryPoolMXBeanImpl getInstanceFromMgmtUtils() {
        return tempInstance;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        if (this.info == null) {
            this.setMBeanInfo(ManagementUtils.getMBeanInfo(java.lang.management.MemoryPoolMXBean.class.getName()));
        }
        return this.info;
    }

    private native MemoryUsage getCollectionUsageImpl();

    @Override
    public MemoryUsage getCollectionUsage() {
        return this.getCollectionUsageImpl();
    }

    private native MemoryUsage getPreCollectionUsageImpl();

    @Override
    public MemoryUsage getPreCollectionUsage() {
        return this.getPreCollectionUsageImpl();
    }

    private native long getCollectionUsageThresholdImpl();

    @Override
    public long getCollectionUsageThreshold() {
        if (!this.isCollectionUsageThresholdSupported()) {
            throw new UnsupportedOperationException("VM does not support collection usage threshold.");
        }
        return this.getCollectionUsageThresholdImpl();
    }

    private native long getCollectionUsageThresholdCountImpl();

    @Override
    public long getCollectionUsageThresholdCount() {
        if (!this.isCollectionUsageThresholdSupported()) {
            throw new UnsupportedOperationException("VM does not support collection usage threshold.");
        }
        return this.getCollectionUsageThresholdCountImpl();
    }

    @Override
    public String[] getMemoryManagerNames() {
        Iterator<MemoryManagerMXBean> iterator = this.memBean.getMemoryManagerMXBeans().iterator();
        LinkedList<String> linkedList = new LinkedList<String>();
        block0: while (iterator.hasNext()) {
            MemoryManagerMXBean memoryManagerMXBean = iterator.next();
            String[] stringArray = memoryManagerMXBean.getMemoryPoolNames();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(this.name)) continue;
                linkedList.add(memoryManagerMXBean.getName());
                continue block0;
            }
        }
        return linkedList.toArray(new String[0]);
    }

    @Override
    public String getName() {
        return this.name;
    }

    private native MemoryUsage getPeakUsageImpl();

    @Override
    public MemoryUsage getPeakUsage() {
        return this.getPeakUsageImpl();
    }

    @Override
    public MemoryType getType() {
        return this.type;
    }

    private native MemoryUsage getUsageImpl();

    @Override
    public MemoryUsage getUsage() {
        return this.getUsageImpl();
    }

    private native long getUsageThresholdImpl();

    @Override
    public long getUsageThreshold() {
        if (!this.isUsageThresholdSupported()) {
            throw new UnsupportedOperationException("VM does not support usage threshold.");
        }
        return this.getUsageThresholdImpl();
    }

    private native long getUsageThresholdCountImpl();

    @Override
    public long getUsageThresholdCount() {
        if (!this.isUsageThresholdSupported()) {
            throw new UnsupportedOperationException("VM does not support usage threshold.");
        }
        return this.getUsageThresholdCountImpl();
    }

    private native boolean isCollectionUsageThresholdExceededImpl();

    @Override
    public boolean isCollectionUsageThresholdExceeded() {
        if (!this.isCollectionUsageThresholdSupported()) {
            throw new UnsupportedOperationException("VM does not support collection usage threshold.");
        }
        return this.isCollectionUsageThresholdExceededImpl();
    }

    private native boolean isCollectionUsageThresholdSupportedImpl();

    @Override
    public boolean isCollectionUsageThresholdSupported() {
        return this.isCollectionUsageThresholdSupportedImpl();
    }

    private native boolean isUsageThresholdExceededImpl();

    @Override
    public boolean isUsageThresholdExceeded() {
        if (!this.isUsageThresholdSupported()) {
            throw new UnsupportedOperationException("VM does not support usage threshold.");
        }
        return this.isUsageThresholdExceededImpl();
    }

    private native boolean isUsageThresholdSupportedImpl();

    @Override
    public boolean isUsageThresholdSupported() {
        return this.isUsageThresholdSupportedImpl();
    }

    private native boolean isValidImpl();

    @Override
    public boolean isValid() {
        return this.isValidImpl();
    }

    private native void resetPeakUsageImpl();

    @Override
    public void resetPeakUsage() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ManagementPermission("control"));
        }
        this.resetPeakUsageImpl();
    }

    private native void setCollectionUsageThresholdImpl(long var1);

    @Override
    public void setCollectionUsageThreshold(long l) {
        if (!this.isCollectionUsageThresholdSupported()) {
            throw new UnsupportedOperationException("VM does not support collection usage threshold.");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ManagementPermission("control"));
        }
        if (l < 0L) {
            throw new IllegalArgumentException("Collection usage threshold cannot be negative.");
        }
        if (this.exceedsMaxPoolSize(l)) {
            throw new IllegalArgumentException("Collection usage threshold cannot exceed maximum amount of memory for pool.");
        }
        this.setCollectionUsageThresholdImpl(l);
    }

    private native void setUsageThresholdImpl(long var1);

    @Override
    public void setUsageThreshold(long l) {
        if (!this.isUsageThresholdSupported()) {
            throw new UnsupportedOperationException("VM does not support usage threshold.");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ManagementPermission("control"));
        }
        if (l < 0L) {
            throw new IllegalArgumentException("Usage threshold cannot be negative.");
        }
        if (this.exceedsMaxPoolSize(l)) {
            throw new IllegalArgumentException("Usage threshold cannot exceed maximum amount of memory for pool.");
        }
        this.setUsageThresholdImpl(l);
    }

    private boolean exceedsMaxPoolSize(long l) {
        MemoryUsage memoryUsage = this.getUsage();
        return memoryUsage.getMax() != -1L && memoryUsage.getMax() < l;
    }

    static {
        tempInstance = new MemoryPoolMXBeanImpl();
    }
}

