/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.product;

import com.ibm.websphere.product.WASProductInfo;
import com.ibm.ws.pak.internal.NIFConstants;
import com.ibm.ws.pak.internal.utils.URIUtils;
import com.ibm.ws.pak.internal.utils.componentactions.ComponentMapRepositoryParser;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import com.ibm.ws.pak.internal.utils.product.ProductPlugin;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WASProductPlugin
extends ProductPlugin {
    private static final String S_KEYFILE_RELATIVE_PATH = "/was.primary.pak/repository/nif.componentmap.primary/properties/version/was.kf";
    private static final String S_EMPTY = "";
    private static final String S_RELATIVE_VERSION_PATH = "properties/version";
    private static final String[] AS_OFFERING_KEY_MAPPING = new String[]{"ND;7168777A72756E", "BASE;65647668647373", "BASETRIAL;77756C646F65647668", "EXPRESS;687B7375687676", "EXPRESSTRIAL;77756C646F687B7375687676"};
    private static final String[] AS_OPTIONAL_PARAMS = new String[0];
    private static final String[] AS_WASPRODUCT_PLUGIN_PARAMS = new String[]{"offering", "offeringname", "version", "installroot", "componentmaprepository"};
    private static String S_PRODUCT_FILE_EXTENSION = ".product";
    private static final String PATTERN_PRODUCT_NODE = "<product\\s*(.*?)\\s*</product>";
    private static final String PATTERN_NAME = "name=\"(.*?)\"";
    private static final String PATTERN_ID = "<id>\\s*(.*?)\\s*</id>";
    private static final String PATTERN_VERSION = "<version>\\s*(.*?)\\s*</version>";
    private static final String PATTERN_DATE = "date=\"(.*?)\"";
    private static final String PATTERN_LEVEL = "level=\"(.*?)\"";
    private static final String S_ID_BASETRIAL = "BASETRIAL";
    private static final String S_ID_EXPRESSTRIAL = "EXPRESSTRIAL";
    private String m_sKeyfilePath = null;
    private String[] m_asOfferingKeyMapping = AS_OFFERING_KEY_MAPPING;
    private static final String className = "WASProductPlugin";

    @Override
    public String getProductcurrentversion() {
        try {
            WASProductInfo[] wasproductinfoarrayThis = this.getWASProductInfoInstances(this.getParamValue("installroot"));
            String sProductVersion = this.getProductVersionByProductID(wasproductinfoarrayThis, this.getParamValue("offering"));
            if (sProductVersion == null) {
                return this.getProductgaversion();
            }
            return sProductVersion;
        }
        catch (Exception exception) {
            return S_EMPTY;
        }
    }

    @Override
    public String getAllinstalledproductfeatures() throws IOException {
        Vector allInstalledFeatures;
        block3: {
            try {
                FileSystemEntry fseComponentMapRepository = new FileSystemEntry(URIUtils.convertPathToDefaultTargetMachineFSURI(this.getComponentmaprepository(), this.getInstallToolkitBridge()), this.getInstallToolkitBridge());
                ComponentMapRepositoryParser cmrpComponentMapsAlreadyInstalled = new ComponentMapRepositoryParser(fseComponentMapRepository, this.getInstallToolkitBridge());
                allInstalledFeatures = cmrpComponentMapsAlreadyInstalled.getTheListOfFeaturesAlreadyInstalled();
                if (allInstalledFeatures != null && allInstalledFeatures.size() != 0) break block3;
                return S_EMPTY;
            }
            catch (URISyntaxException e) {
                throw new IOException(e.getMessage());
            }
        }
        return this.getStringRepresentation(allInstalledFeatures);
    }

    @Override
    public String getProductgaversion() {
        return this.getParamValue("productgaversion");
    }

    @Override
    public boolean isTheGivenProductInstalledAtTheGivenLocation() {
        return true;
    }

    @Override
    public String getBackuppath() {
        return NIFConstants.getBackuppath();
    }

    public String getComponentmaprepository() {
        return this.getParamValue("componentmaprepository");
    }

    public String getProductbackuprepository() {
        return NIFConstants.getBackuppath();
    }

    @Override
    public String getOffering() {
        return this.getParamValue("offering");
    }

    protected String getKeyfilePath() {
        if (this.m_sKeyfilePath == null) {
            this.m_sKeyfilePath = String.valueOf(NIFConstants.getCurrentAppDirectory()) + S_KEYFILE_RELATIVE_PATH;
        }
        return this.m_sKeyfilePath;
    }

    protected void setKeyfilePath(String sFilePath) {
        this.m_sKeyfilePath = sFilePath;
    }

    protected String[] getOfferingKeyMapping() {
        return this.m_asOfferingKeyMapping;
    }

    protected void setOfferingKeyMapping(String[] asOfferingKeyMapping) {
        this.m_asOfferingKeyMapping = asOfferingKeyMapping;
    }

    @Override
    protected String[] getRequiredParams() {
        return AS_WASPRODUCT_PLUGIN_PARAMS;
    }

    @Override
    protected String[] getOptionalParams() {
        return AS_OPTIONAL_PARAMS;
    }

    protected String getProductVersionByProductID(WASProductInfo[] wasproductinfoarrayThis, String sProductID) {
        if (S_ID_BASETRIAL.equalsIgnoreCase(sProductID)) {
            sProductID = "BASE";
        } else if (S_ID_EXPRESSTRIAL.equalsIgnoreCase(sProductID)) {
            sProductID = "EXPRESS";
        }
        WASProductInfo[] wASProductInfoArray = wasproductinfoarrayThis;
        int n = wasproductinfoarrayThis.length;
        int n2 = 0;
        while (n2 < n) {
            WASProductInfo wasproductinfoarrayThi = wASProductInfoArray[n2];
            if (wasproductinfoarrayThi.getId().equalsIgnoreCase(sProductID)) {
                return wasproductinfoarrayThi.getVersion();
            }
            ++n2;
        }
        return null;
    }

    protected WASProductInfo[] getWASProductInfoInstances(String sInstallLocation) {
        Vector vWASProductInfo;
        block7: {
            vWASProductInfo = new Vector();
            String sProductFileLocation = String.valueOf(sInstallLocation) + "/" + S_RELATIVE_VERSION_PATH;
            try {
                FileSystemEntry[] fseFilesUnderVersionDir;
                FileSystemEntry fseVersionDirectory = URIUtils.convertPathToDefaultTargetMachineFSE(sProductFileLocation, this.getInstallToolkitBridge());
                if (!fseVersionDirectory.isDirectory()) break block7;
                FileSystemEntry[] fileSystemEntryArray = fseFilesUnderVersionDir = fseVersionDirectory.getDirectoryEntries();
                int n = fseFilesUnderVersionDir.length;
                int n2 = 0;
                while (n2 < n) {
                    FileSystemEntry element = fileSystemEntryArray[n2];
                    if (element.getURI().getPath().endsWith(S_PRODUCT_FILE_EXTENSION)) {
                        try {
                            Vector vWASProductInfoPerProductFile = this.parseProductFileFromInputStream(element.getInputStream());
                            vWASProductInfo.addAll(vWASProductInfoPerProductFile);
                        }
                        catch (IOException ioe) {
                            Logr.warn(className, "getWASProductInfoInstances", ioe.getMessage(), ioe);
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                Logr.warn(className, "getWASProductInfoInstances", e.getMessage(), e);
            }
        }
        WASProductInfo[] wasproductinfoarrayReturned = new WASProductInfo[vWASProductInfo.size()];
        int i = 0;
        while (i < vWASProductInfo.size()) {
            wasproductinfoarrayReturned[i] = (WASProductInfo)vWASProductInfo.elementAt(i);
            ++i;
        }
        return wasproductinfoarrayReturned;
    }

    private String parseInputStreamToString(InputStream inputStream) {
        String sFileContents = null;
        try {
            byte[] abTotal = new byte[inputStream.available()];
            inputStream.read(abTotal);
            sFileContents = new String(abTotal);
            inputStream.close();
        }
        catch (IOException ex) {
            ex.getMessage();
        }
        return sFileContents;
    }

    private Vector parseProductFileFromInputStream(InputStream inputstream) {
        Vector<WASProductInfo> vWASProductInfoReturn = new Vector<WASProductInfo>();
        String sProductFileContent = this.parseInputStreamToString(inputstream);
        if (sProductFileContent != null) {
            Pattern patternProduct = Pattern.compile(PATTERN_PRODUCT_NODE, 32);
            Matcher matcherProduct = patternProduct.matcher(sProductFileContent);
            while (matcherProduct.find()) {
                String sProductString = matcherProduct.group();
                WASProductInfo wasproductinfoThis = this.parseProductString(sProductString);
                vWASProductInfoReturn.add(wasproductinfoThis);
            }
        }
        return vWASProductInfoReturn;
    }

    private WASProductInfo parseProductString(String sProductString) {
        String name = S_EMPTY;
        String id = S_EMPTY;
        String version = S_EMPTY;
        String date = S_EMPTY;
        String level = S_EMPTY;
        Pattern pattern = Pattern.compile(PATTERN_NAME, 32);
        Matcher matcher = pattern.matcher(sProductString);
        if (matcher.find()) {
            String nameString = matcher.group();
            name = nameString.substring(nameString.indexOf(34) + 1, nameString.lastIndexOf(34));
        }
        if ((matcher = (pattern = Pattern.compile(PATTERN_ID, 32)).matcher(sProductString)).find()) {
            String idString = matcher.group();
            id = idString.substring(idString.indexOf("<id>") + 4, idString.indexOf("</id>"));
        }
        if ((matcher = (pattern = Pattern.compile(PATTERN_VERSION, 32)).matcher(sProductString)).find()) {
            String versionString = matcher.group();
            version = versionString.substring(versionString.indexOf("<version>") + 9, versionString.indexOf("</version>"));
        }
        if ((matcher = (pattern = Pattern.compile(PATTERN_DATE, 32)).matcher(sProductString)).find()) {
            String dateString = matcher.group();
            date = dateString.substring(dateString.indexOf(34) + 1, dateString.lastIndexOf(34));
        }
        if ((matcher = (pattern = Pattern.compile(PATTERN_LEVEL, 32)).matcher(sProductString)).find()) {
            String levelString = matcher.group();
            level = levelString.substring(levelString.indexOf(34) + 1, levelString.lastIndexOf(34));
        }
        return new WASProductInfo(name, id, version, date, level);
    }
}

