/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.macroresolvers;

import com.ibm.ws.pak.internal.utils.logging.Logr;
import com.ibm.ws.pak.internal.utils.macroresolvers.MacroResolver;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;

public class RepaceAllMacroResolver
extends MacroResolver {
    private static final Pattern PATTERN_REPLACEALL_ATTRIBUTE = Pattern.compile("^(.+?),(.+?),(.+?)$");
    private static final String S_REPLACEALL_ATTRIBUTE_MACRO_ID = "REPLACEALL";
    private static final String className = "RepaceAllMacroResolver";

    @Override
    protected boolean isMacroIDAcceptable(String sMacroID) {
        return S_REPLACEALL_ATTRIBUTE_MACRO_ID.equals(sMacroID);
    }

    @Override
    protected String resolveMacro(String sMacroID, String sMacroText, Document documentPluginDefinitions) {
        Logr.methodEntry(className, "resolveMacro");
        Matcher matcherNIFPAttribute = PATTERN_REPLACEALL_ATTRIBUTE.matcher(sMacroText);
        if (!matcherNIFPAttribute.matches()) {
            String s = MacroResolver.getUnresolvedMacro(S_REPLACEALL_ATTRIBUTE_MACRO_ID, sMacroText);
            Logr.methodReturn(className, "resolveMacro", s);
            return s;
        }
        String s1 = matcherNIFPAttribute.group(1).trim();
        String s2 = matcherNIFPAttribute.group(2).trim();
        String s3 = matcherNIFPAttribute.group(3).trim();
        String s = s1.replaceAll(s2, s3);
        Logr.methodReturn(className, "resolveMacro", s);
        return s;
    }
}

