/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.macroresolvers;

import com.ibm.ws.pak.internal.install.metadata.NIFPackageEntry;
import com.ibm.ws.pak.internal.install.metadata.NIFStack;
import com.ibm.ws.pak.internal.utils.StringUtils;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import com.ibm.ws.pak.internal.utils.macroresolvers.MacroResolver;
import java.util.Vector;
import org.w3c.dom.Document;

public class NIFStackPakDependentMaintenanceNameAndDescriptionMacroResolver
extends MacroResolver {
    private static final String S_PAKDEPENTVERSIONS_ATTRIBUTE_MACRO_ID = "NIFSTACKPAKDEPENTMAINTENANCENAMEANDDESCRIPTION";
    private static final String S_EMPTY = "";
    private static final String className = "NIFStackPakDependentMaintenanceNameAndDescriptionMacroResolver";

    @Override
    protected boolean isMacroIDAcceptable(String sMacroID) {
        return S_PAKDEPENTVERSIONS_ATTRIBUTE_MACRO_ID.equals(sMacroID);
    }

    @Override
    protected String resolveMacro(String sMacroID, String sMacroText, Document documentPluginDefinitions) {
        Logr.methodEntry(className, "resolveMacro");
        String sPayloadidAndPakversion = sMacroText;
        String[] asPayloadidAndPakversions = StringUtils.convertStringToTokenArray(sPayloadidAndPakversion, ";");
        if (asPayloadidAndPakversions == null || asPayloadidAndPakversions.length == 0) {
            Logr.methodReturn(className, "resolveMacro", S_EMPTY);
            return S_EMPTY;
        }
        Vector vNIFPackageEntries = new Vector();
        String[] stringArray = asPayloadidAndPakversions;
        int n = asPayloadidAndPakversions.length;
        int n2 = 0;
        while (n2 < n) {
            String asPayloadidAndPakversion2 = stringArray[n2];
            String[] asPayloadidAndPakversion = StringUtils.convertStringToTokenArray(asPayloadidAndPakversion2, ":");
            Vector vFeaturePackDependencies = NIFStack.findFeaturePackDependenciesOnThisPayloadidAndPakversion(asPayloadidAndPakversion[0], asPayloadidAndPakversion[1]);
            if (vFeaturePackDependencies != null && vFeaturePackDependencies.size() > 0) {
                vNIFPackageEntries.addAll(vFeaturePackDependencies);
            }
            ++n2;
        }
        if (vNIFPackageEntries.size() == 0) {
            Logr.methodReturn(className, "resolveMacro", S_EMPTY);
            return S_EMPTY;
        }
        vNIFPackageEntries = this.removeDuplicates(vNIFPackageEntries);
        String s = this.formatMaintenanceNameAndDescription(vNIFPackageEntries.toArray(new NIFPackageEntry[vNIFPackageEntries.size()]));
        Logr.methodReturn(className, "resolveMacro", s);
        return s;
    }

    private String formatMaintenanceNameAndDescription(NIFPackageEntry[] asNIFPackageOtherPaksDependOn) {
        String sFormatedMaintenanceNameAndDescription = S_EMPTY;
        int i = 0;
        while (i < asNIFPackageOtherPaksDependOn.length) {
            sFormatedMaintenanceNameAndDescription = String.valueOf(sFormatedMaintenanceNameAndDescription) + asNIFPackageOtherPaksDependOn[i].getParamValue("info");
            if (i + 1 < asNIFPackageOtherPaksDependOn.length) {
                sFormatedMaintenanceNameAndDescription = String.valueOf(sFormatedMaintenanceNameAndDescription) + ";";
            }
            ++i;
        }
        return sFormatedMaintenanceNameAndDescription;
    }

    private Vector removeDuplicates(Vector vNIFPackageEntries) {
        Vector vNIFPackageEntriesWithoutDup = new Vector();
        int i = 0;
        while (i < vNIFPackageEntries.size()) {
            if (!vNIFPackageEntriesWithoutDup.contains(vNIFPackageEntries.get(i))) {
                vNIFPackageEntriesWithoutDup.add(vNIFPackageEntries.get(i));
            }
            ++i;
        }
        return vNIFPackageEntriesWithoutDup;
    }
}

