/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.macroresolvers;

import com.ibm.ws.pak.internal.utils.StringUtils;
import com.ibm.ws.pak.internal.utils.VersionUtils;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import com.ibm.ws.pak.internal.utils.macroresolvers.MacroResolver;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;

public class ComparingVersionsMacroResolver
extends MacroResolver {
    private static final Pattern PATTERN_COMPARINGVERSION_ATTRIBUTE = Pattern.compile("^(.+?),(.+?)$");
    private static final String S_COMPARINGVERSIONS_ATTRIBUTE_MACRO_ID = "NIFCOMPARINGVERSIONS";
    private static final String className = "ComparingVersionsMacroResolver";

    @Override
    protected boolean isMacroIDAcceptable(String sMacroID) {
        return S_COMPARINGVERSIONS_ATTRIBUTE_MACRO_ID.equals(sMacroID);
    }

    @Override
    protected String resolveMacro(String sMacroID, String sMacroText, Document documentPluginDefinitions) {
        String[] asVersionsRequired;
        Logr.methodEntry(className, "resolveMacro");
        Matcher matcherNIFPAttribute = PATTERN_COMPARINGVERSION_ATTRIBUTE.matcher(sMacroText);
        if (!matcherNIFPAttribute.matches()) {
            return MacroResolver.getUnresolvedMacro(S_COMPARINGVERSIONS_ATTRIBUTE_MACRO_ID, sMacroText);
        }
        String sVersionCurrent = matcherNIFPAttribute.group(1).trim();
        String sVersionsRequired = matcherNIFPAttribute.group(2).trim();
        String[] stringArray = asVersionsRequired = StringUtils.convertStringToTokenArray(sVersionsRequired, ";");
        int n = asVersionsRequired.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            boolean fIsAcceptable = VersionUtils.isVersionAcceptableToTheseVersionParams(sVersionCurrent, element);
            if (fIsAcceptable) {
                Logr.methodReturn(className, "resolveMacro", "true");
                return Boolean.TRUE.toString();
            }
            ++n2;
        }
        Logr.methodReturn(className, "resolveMacro", "false");
        return Boolean.FALSE.toString();
    }
}

