/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.installtoolkitbridge;

import com.ibm.io.file.NativeFile;
import com.ibm.ws.pak.internal.NIFConstants;
import com.ibm.ws.pak.internal.utils.installtoolkitbridge.InstallToolkitBridgeException;
import com.ibm.ws.pak.internal.utils.installtoolkitbridge.InstallToolkitBridgeImpl;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.w3c.dom.Document;

public class NGIInstallToolkitBridgeImpl
implements InstallToolkitBridgeImpl {
    private boolean isJNIInitialized = false;
    private Properties m_properties = null;
    private static final char COMMA = ',';
    private static final char C_UNIX_SLASH = '/';
    private static final String J_RESOLVER = "J";
    private static final String N_RESOLVER = "N";
    private static final String PSA_RESOLVER = "PSA";
    private static final String className = "NGIInstallToolkitBridgeImpl";

    private void initializeJNINativeLibrary(String sJNILibraryPath) {
        if (this.isJNIInitialized) {
            return;
        }
        NativeFile.initializeLibrary((File)new File(sJNILibraryPath), null, (boolean)true);
        Logr.debug("Native file function is initialized : " + NativeFile.isNativeFileFunctionalityAvailable());
        this.isJNIInitialized = true;
    }

    public NGIInstallToolkitBridgeImpl(Properties properties) {
        this.m_properties = properties;
        this.initializeJNINativeLibrary(NIFConstants.getJNILib());
    }

    @Override
    public long getPartitionFreeSpace(String sPartitionName) throws InstallToolkitBridgeException {
        try {
            NativeFile nf = new NativeFile(new File(sPartitionName));
            return nf.getFreeSpace();
        }
        catch (Exception e) {
            Logr.warn(className, "getPartitionFreeSpace", e.getMessage(), e);
            throw new InstallToolkitBridgeException(e);
        }
    }

    @Override
    public String getPartitionName(String sAbsolutePath, String[] aPartitionNames) throws InstallToolkitBridgeException {
        String sPartitionFound = "";
        try {
            String sPathToUseForQuery = new File(sAbsolutePath).getCanonicalPath();
            sPathToUseForQuery = this.convertToUnixSlash(sPathToUseForQuery);
            String[] stringArray = aPartitionNames;
            int n = aPartitionNames.length;
            int n2 = 0;
            while (n2 < n) {
                String aPartitionName = stringArray[n2];
                if (sPathToUseForQuery.length() >= aPartitionName.length() && aPartitionName.length() > 0 && new File(sPathToUseForQuery.substring(0, aPartitionName.length())).getCanonicalPath().equals(aPartitionName) && aPartitionName.length() > sPartitionFound.length()) {
                    sPartitionFound = aPartitionName;
                }
                ++n2;
            }
            return sPartitionFound;
        }
        catch (Exception e) {
            Logr.warn(className, "getPartitionName", e.getMessage(), e);
            throw new InstallToolkitBridgeException(e);
        }
    }

    @Override
    public String[] getPartitionNames() throws InstallToolkitBridgeException {
        try {
            NativeFile[] fs = NativeFile.getFileSystems();
            String[] sa_FilenSystem = new String[fs.length];
            int i = 0;
            while (i < fs.length) {
                sa_FilenSystem[i] = fs[i].getPath();
                ++i;
            }
            return sa_FilenSystem;
        }
        catch (Exception e) {
            Logr.warn(className, "getPartitionNames", e.getMessage(), e);
            throw new InstallToolkitBridgeException(e);
        }
    }

    @Override
    public void setPermissions(String sFilePath, int nPermissions) throws InstallToolkitBridgeException {
        try {
            NativeFile nf = new NativeFile(new File(sFilePath));
            int nUserPermission = nPermissions / 100;
            int nGroupPermission = (nPermissions - nUserPermission * 100) / 10;
            int nWorldPermission = nPermissions - nUserPermission * 100 - nGroupPermission * 10;
            nf.setUserPermissions(nUserPermission);
            nf.setGroupPermissions(nGroupPermission);
            nf.setWorldPermissions(nWorldPermission);
        }
        catch (Exception e) {
            Logr.warn(className, "setPermissions", e.getMessage(), e);
            throw new InstallToolkitBridgeException(e);
        }
    }

    @Override
    public int getPermissions(String sFilePath) throws InstallToolkitBridgeException {
        try {
            NativeFile nf = new NativeFile(new File(sFilePath));
            return nf.getUserPermissions() * 100 + nf.getGroupPermissions() * 10 + nf.getWorldPermissions();
        }
        catch (Exception e) {
            Logr.warn(className, "getPermissions", e.getMessage(), e);
            throw new InstallToolkitBridgeException(e);
        }
    }

    @Override
    public void log(int nLevel, String sMessage) {
        System.out.println(sMessage);
    }

    @Override
    public String resolveMacro(String sMacroID, String sMacroText, Document documentPluginDefinitions) {
        Logr.methodEntry(className, "resolveMacro");
        String sISMPMacroName = sMacroID.substring("ITB:".length());
        Logr.debug("sMacroID :" + sMacroID);
        Logr.debug("sMacroText :" + sMacroText);
        sMacroText = sMacroText.trim();
        if (sISMPMacroName.equals(J_RESOLVER)) {
            Logr.methodReturn(className, "resolveMacro", System.getProperty(sMacroText));
            return System.getProperty(sMacroText);
        }
        if (sISMPMacroName.equals(N_RESOLVER)) {
            try {
                Logr.methodReturn(className, "resolveMacro", new File(sMacroText).getCanonicalPath());
                return new File(sMacroText).getCanonicalPath();
            }
            catch (IOException iOException) {
                Logr.methodReturn(className, "resolveMacro", sMacroText);
                return sMacroText;
            }
        }
        if (sISMPMacroName.equals(PSA_RESOLVER)) {
            String sNewMacroText;
            int index = sMacroText.indexOf(44);
            sMacroText = sNewMacroText = sMacroText.substring(0, ++index).concat(sMacroText.substring(index).trim());
        }
        Logr.methodReturn(className, "resolveMacro", this.m_properties.getProperty(sMacroText));
        return this.m_properties.getProperty(sMacroText);
    }

    private String convertToUnixSlash(String sPath) {
        String sReturn = sPath;
        if (File.separatorChar != '/') {
            sReturn = sReturn.replace(File.separatorChar, '/');
        }
        return sReturn;
    }
}

