/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.filesystems;

import com.ibm.ws.pak.internal.NIFConstants;
import com.ibm.ws.pak.internal.utils.filesystems.PlatformConstants;
import com.ibm.ws.pak.internal.utils.filesystems.ProcessTimeoutThread;
import com.ibm.ws.pak.internal.utils.filesystems.StreamCollectionThread;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.io.IOException;
import java.util.Vector;

public class ExecEngine {
    private String m_sOut = "";
    private String m_sErr = "";
    private int m_nRetVal = -1;
    private int m_nTimeOut = NIFConstants.N_DEFAULT_PROCESS_TIME_OUT_TIME;
    private boolean m_fWaitFlag = true;
    private static final String S_EMPTY = "";
    private static final int N_HP_WAIT_TIME = 4000;
    private static final String className = "ExecEngine";

    public void executeIncomingArgumentsAsync(String[] asArguments) {
        this.m_fWaitFlag = false;
        this.spawnProcess(asArguments, 4000);
    }

    public void executeIncomingArgumentsAsync(Vector vArgs) {
        this.m_fWaitFlag = false;
        String[] asArguments = new String[vArgs.size()];
        int i = 0;
        while (i < vArgs.size()) {
            asArguments[i] = (String)vArgs.elementAt(i);
            ++i;
        }
        this.spawnProcess(asArguments, 4000);
    }

    public int executeIncomingArguments(String[] asArguments, int nTimeOut) {
        this.m_fWaitFlag = true;
        this.m_nTimeOut = nTimeOut;
        return this.spawnProcess(asArguments, 1);
    }

    public int executeIncomingArguments(Vector vArgs, int nTimeOut) {
        this.m_fWaitFlag = true;
        this.m_nTimeOut = nTimeOut;
        String[] asArguments = new String[vArgs.size()];
        int i = 0;
        while (i < vArgs.size()) {
            asArguments[i] = (String)vArgs.elementAt(i);
            ++i;
        }
        return this.spawnProcess(asArguments, 1);
    }

    public String getProcessStdOut() {
        return this.m_sOut;
    }

    public String getProcessStdErr() {
        return this.m_sErr;
    }

    public int getProcessRetCode() {
        return this.m_nRetVal;
    }

    protected void doWaitForProcessToTerminateOrTimeOut(Process processThis) throws InterruptedException {
        ProcessTimeoutThread pttThisProcess = new ProcessTimeoutThread(processThis, this.m_nTimeOut);
        pttThisProcess.startTiming();
        processThis.waitFor();
        pttThisProcess.stopTiming();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int spawnProcess(String[] asArguments, int nStreamWait) {
        int nRetVal = -1;
        try {
            Process processThis = Runtime.getRuntime().exec(asArguments);
            if (PlatformConstants.getCurrentPlatform() == 2) {
                ExecEngine execEngine = this;
                synchronized (execEngine) {
                    this.wait(nStreamWait);
                }
            }
            if (this.m_fWaitFlag) {
                StreamCollectionThread sctOutput = new StreamCollectionThread(processThis.getInputStream());
                StreamCollectionThread sctError = new StreamCollectionThread(processThis.getErrorStream());
                sctOutput.startCollecting();
                sctError.startCollecting();
                this.doWaitForProcessToTerminateOrTimeOut(processThis);
                nRetVal = this.m_nRetVal = processThis.exitValue();
                sctOutput.stopCollecting();
                sctError.stopCollecting();
                this.m_sOut = sctOutput.toString();
                this.m_sErr = sctError.toString();
            }
        }
        catch (IOException e) {
            Logr.warn(className, "spawnProcess", e.getMessage(), e);
            this.m_sErr = e.getLocalizedMessage();
            nRetVal = -1;
        }
        catch (InterruptedException e) {
            Logr.warn(className, "spawnProcess", e.getMessage(), e);
            this.m_sErr = e.getLocalizedMessage();
            nRetVal = -1;
        }
        catch (IllegalThreadStateException e) {
            Logr.warn(className, "spawnProcess", e.getMessage(), e);
            this.m_sErr = e.getLocalizedMessage();
            nRetVal = -1;
        }
        return nRetVal;
    }
}

