/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.filesystems;

import com.ibm.ws.pak.internal.NIFConstants;
import com.ibm.ws.pak.internal.PakCoreMessages;
import com.ibm.ws.pak.internal.utils.filesystems.ExecEngine;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystem;
import com.ibm.ws.pak.internal.utils.filesystems.PlatformConstants;
import com.ibm.ws.pak.internal.utils.installtoolkitbridge.InstallToolkitBridgeException;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class DiskFileSystem
extends FileSystem {
    public static final String S_DISK_FS_SCHEME = "file";
    private static final String S_INVALID_FS_FOR_SYMLINK_ATTEMPT = "Invalid filesystem for symbolic link attempt or host and target filesystems don't match.";
    private static final String S_SOFTLINK_OPTION = "-s";
    private static final String S_FORCE_OPTION = "-f";
    private static final String S_LN_LOCATION_1 = "/bin/ln";
    private static final String S_LN_LOCATION_2 = "/usr/bin/ln";
    private static final String S_NO_LN_1 = "Symbolic linking ";
    private static final String S_NO_LN_2 = "->";
    private static final String S_NO_LN_3 = " failed as ln command was not found.";
    private static final String S_GENERIC_FAILURE_1 = "Symbolic linking ";
    private static final String S_GENERIC_FAILURE_2 = "->";
    private static final String S_GENERIC_FAILURE_3 = " failed.  Standard Error : ";
    private static final int N_LN_SUCCESS_CODE = 0;
    private static final String S_MKDIR_FAILED = "mkdirs failed for: ";
    private static final String S_DELETE_FAILED = "Failed to delete: ";
    private static final String S_RENAME_FAILED_1 = "Failed to rename: ";
    private static final String S_RENAME_FAILED_2 = ", to: ";
    private static final String S_DOTDOT = "..";
    private static final String S_EMPTY = "";
    private static final String className = "DiskFileSystem";

    @Override
    public long getSize(URI uriPath) {
        return new File(uriPath).length();
    }

    @Override
    public void setLastModifiedTime(URI uriPath, long lTime) {
        new File(uriPath).setLastModified(lTime);
    }

    @Override
    public InputStream readEntry(URI uriPath) throws IOException {
        return new FileInputStream(new File(uriPath));
    }

    @Override
    public OutputStream writeEntry(URI uriPath) throws IOException {
        return this.writeEntry(uriPath, false);
    }

    @Override
    @Deprecated
    public OutputStream writeEntry(URI uriPath, boolean fAppend) throws IOException {
        if (!this.exists(this.getParent(uriPath))) {
            this.mkdirs(this.getParent(uriPath));
        }
        if (PlatformConstants.isCurrentPlatformOS400()) {
            throw new IOException(PakCoreMessages.PAK_CORE_S_OS400_IS_NOT_SUPPORTED);
        }
        return this.getInstallToolkitBridge().getUnifiedFileIO().writeFile(new File(uriPath).getAbsolutePath(), fAppend);
    }

    @Override
    public void deleteEntry(URI uriPath) throws IOException {
        File file = new File(uriPath);
        if (!file.delete() && file.exists()) {
            throw new IOException(S_DELETE_FAILED + uriPath);
        }
        this.deleteIfItIsAnEmptyDir(file.getParentFile());
    }

    @Override
    public void deleteEntryOnExit(URI uriPath) {
        new File(uriPath).deleteOnExit();
    }

    @Override
    public void setPermissions(URI uriPath, int nPermissions) throws IOException {
        try {
            if (PlatformConstants.isOS400Install()) {
                return;
            }
            this.getUnifiedFileIOObject().setPermissions(new File(uriPath).getAbsolutePath(), nPermissions);
        }
        catch (InstallToolkitBridgeException e) {
            Logr.warn(className, "setPermissions", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public int getPermissions(URI uriPath) throws IOException {
        block3: {
            try {
                if (!PlatformConstants.isOS400Install()) break block3;
                return 755;
            }
            catch (InstallToolkitBridgeException e) {
                Logr.warn(className, "getPermissions", e.getMessage(), e);
                throw new IOException(e.getMessage());
            }
        }
        return this.getUnifiedFileIOObject().getPermissions(new File(uriPath).getAbsolutePath());
    }

    @Override
    public long getLastModified(URI uriPath) {
        return new File(uriPath).lastModified();
    }

    @Override
    public void createSymbolicLink(URI uriSymbolicLinkPath, String sPathToLinkTo) throws IOException {
        File fileSymbolicLink;
        if (PlatformConstants.isOS400Install()) {
            return;
        }
        if (!uriSymbolicLinkPath.getScheme().equalsIgnoreCase(S_DISK_FS_SCHEME)) {
            Logr.warn(S_INVALID_FS_FOR_SYMLINK_ATTEMPT);
            throw new IOException(S_INVALID_FS_FOR_SYMLINK_ATTEMPT);
        }
        if (!new File(this.getParent(uriSymbolicLinkPath)).exists()) {
            this.mkdirs(this.getParent(uriSymbolicLinkPath));
        }
        if ((fileSymbolicLink = new File(uriSymbolicLinkPath)).exists()) {
            fileSymbolicLink.delete();
        }
        String sLink = new File(uriSymbolicLinkPath).getAbsolutePath();
        String sLNCommand = this.getLNCommand();
        if (sLNCommand == null) {
            Logr.warn("Symbolic linking " + sLink + "->" + sPathToLinkTo + S_NO_LN_3);
            throw new IOException("Symbolic linking " + sLink + "->" + sPathToLinkTo + S_NO_LN_3);
        }
        String[] asArgs = new String[]{sLNCommand, S_SOFTLINK_OPTION, S_FORCE_OPTION, sPathToLinkTo, sLink};
        ExecEngine ee = new ExecEngine();
        ee.executeIncomingArguments(asArgs, NIFConstants.N_DEFAULT_PROCESS_TIME_OUT_TIME);
        if (ee.getProcessRetCode() != 0) {
            String err = "Symbolic linking " + sLink + "->" + sPathToLinkTo + S_GENERIC_FAILURE_3 + ee.getProcessStdErr();
            Logr.debug("createSymbolicLink : getProcessStdOut : " + ee.getProcessStdOut());
            Logr.warn(err);
            throw new IOException(err);
        }
    }

    @Override
    public URI getFSURI(URI uriParent, String sEntryPath) {
        return new File(new File(uriParent).getAbsolutePath(), sEntryPath).toURI();
    }

    @Override
    public boolean exists(URI uriPath) {
        return new File(uriPath).exists();
    }

    @Override
    public boolean isDirectory(URI uriPath) {
        return new File(uriPath).isDirectory();
    }

    @Override
    public void mkdirs(URI uriPath) throws IOException {
        if (!new File(uriPath).mkdirs()) {
            Logr.warn(S_MKDIR_FAILED + uriPath);
            throw new IOException(S_MKDIR_FAILED + uriPath);
        }
    }

    @Override
    public URI getParent(URI uriPath) {
        return new File(uriPath).getParentFile().toURI();
    }

    @Override
    public String getEntryName(URI uriPath) {
        return new File(uriPath).getName();
    }

    @Override
    public String getCanonicalPath(URI uriPath) throws IOException {
        return new File(uriPath).getCanonicalPath();
    }

    @Override
    public String getAbsolutePath(URI uriPath) {
        return new File(uriPath).getAbsolutePath();
    }

    @Override
    public void renameTo(URI uriPath, URI uriPathTo) throws IOException {
        if (!new File(uriPath).renameTo(new File(uriPathTo))) {
            Logr.warn(S_RENAME_FAILED_1 + uriPath + S_RENAME_FAILED_2 + uriPathTo);
            throw new IOException(S_RENAME_FAILED_1 + uriPath + S_RENAME_FAILED_2 + uriPathTo);
        }
    }

    @Override
    public URI[] getDirectoryEntries(URI uriPath) {
        File[] afiles = new File(uriPath).listFiles();
        if (afiles != null) {
            URI[] auris = new URI[afiles.length];
            int i = 0;
            while (i < afiles.length) {
                auris[i] = afiles[i].toURI();
                ++i;
            }
            return auris;
        }
        return new URI[0];
    }

    @Override
    public String getSymbolicLinkTarget(URI uriPath) throws IOException {
        String sCanonicalPath;
        File f = new File(uriPath.normalize());
        if (!f.exists()) {
            return null;
        }
        String sAbsolutePath = f.getAbsolutePath();
        if (sAbsolutePath.equals(sCanonicalPath = f.getCanonicalPath())) {
            return null;
        }
        return this.getRelativePathFromPath1ToPath2(sAbsolutePath, sCanonicalPath);
    }

    @Override
    public void flushFileSystemFor(URI uriPath) {
    }

    @Override
    public void setHidden(URI uriPath) {
        if (PlatformConstants.isCurrentPlatformWindows()) {
            String sPath = new File(uriPath).getAbsolutePath();
            String[] asCommandArguments = new String[]{"attrib", "+h", sPath};
            ExecEngine eeThis = new ExecEngine();
            eeThis.executeIncomingArgumentsAsync(asCommandArguments);
        }
    }

    @Override
    protected String getSupportedScheme() {
        return S_DISK_FS_SCHEME;
    }

    @Override
    protected void flush() {
    }

    private void deleteIfItIsAnEmptyDir(File fileCurrentDir) {
        File[] children = fileCurrentDir.listFiles();
        if (children != null && children.length == 0) {
            fileCurrentDir.delete();
            this.deleteIfItIsAnEmptyDir(fileCurrentDir.getParentFile());
        }
    }

    private String getRelativePathFromPath1ToPath2(String sPath1, String sPath2) {
        String sPatha = new File(sPath1).toURI().normalize().getPath();
        String sPathb = new File(sPath2).toURI().normalize().getPath();
        StringTokenizer st1 = new StringTokenizer(sPatha, File.separator);
        StringTokenizer st2 = new StringTokenizer(sPathb, File.separator);
        String sReturn = S_EMPTY;
        while (st1.hasMoreTokens() && st2.hasMoreTokens()) {
            sReturn = st2.nextToken();
            if (!st1.nextToken().equals(sReturn)) break;
        }
        while (st1.hasMoreTokens()) {
            st1.nextToken();
            sReturn = S_DOTDOT + File.separator + sReturn;
        }
        while (st2.hasMoreTokens()) {
            sReturn = String.valueOf(sReturn) + File.separator + st2.nextToken();
        }
        return sReturn;
    }

    private String getLNCommand() {
        String sLNCommand = null;
        if (new File(S_LN_LOCATION_1).exists()) {
            sLNCommand = S_LN_LOCATION_1;
        }
        if (new File(S_LN_LOCATION_2).exists()) {
            sLNCommand = S_LN_LOCATION_2;
        }
        return sLNCommand;
    }

    @Override
    public boolean isReadable(URI uriPath) {
        return new File(uriPath).canRead();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isWriteable(URI uriPath) {
        try {
            File testFile = new File(uriPath);
            if (PlatformConstants.isCurrentPlatformWindows() && !testFile.exists()) {
                return this.canMakeDirsInThisPath(testFile);
            }
            while (true) {
                if (testFile.exists()) {
                    if (!testFile.isDirectory()) break;
                    return this.isThisPathWritable(testFile);
                }
                testFile = testFile.getParentFile();
            }
            if (!PlatformConstants.isCurrentPlatformWindows()) {
                return testFile.canWrite();
            }
            try {
                FileOutputStream fileoutputstreamThisFile = new FileOutputStream(testFile, true);
                fileoutputstreamThisFile.close();
                return true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                return false;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    private boolean isThisPathWritable(File dir) {
        try {
            File fTemp = File.createTempFile("_write_", "_test_", dir);
            fTemp.delete();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    private boolean canMakeDirsInThisPath(File dir) {
        try {
            File fTmp = dir;
            Vector<File> vfDirsToBeDeleted = new Vector<File>();
            while (!fTmp.exists()) {
                vfDirsToBeDeleted.add(fTmp);
                fTmp = fTmp.getParentFile();
            }
            if (dir.mkdirs()) {
                int i = 0;
                while (i < vfDirsToBeDeleted.size()) {
                    ((File)vfDirsToBeDeleted.elementAt(i)).delete();
                    ++i;
                }
                return true;
            }
            return false;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    @Override
    public void copyThisEntryInThisSourceToThisZipFileWithThisName(URI uriSourceFile, String sSourceEntryName, ZipOutputStream zopTo, String sTargetEntryName) throws IOException {
        try {
            ZipEntry zipentryThis = new ZipEntry(sTargetEntryName);
            zopTo.putNextEntry(zipentryThis);
            InputStream in = this.getEntry(this.normalizeLocationURI(uriSourceFile, sSourceEntryName)).getInputStream();
            this.transferInputStreamToOutputStreamCompletely(in, zopTo);
            in.close();
        }
        catch (Exception e) {
            Logr.warn(className, "copyThisEntryInThisSourceToThisZipFileWithThisName", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
    }
}

