/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils;

import com.ibm.websphere.product.WASProductInfo;
import com.ibm.ws.pak.internal.utils.URIUtils;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.installtoolkitbridge.InstallToolkitBridge;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProductUtils {
    public static final String S_ID_WAS = "WAS";
    private static final String S_RELATIVE_VERSION_PATH = "properties/version";
    private static String S_PRODUCT_FILE_EXTENSION = ".product";
    private static final String PATTERN_PRODUCT_NODE = "<product\\s*(.*?)\\s*</product>";
    private static final String PATTERN_NAME = "name=\"(.*?)\"";
    private static final String PATTERN_ID = "<id>\\s*(.*?)\\s*</id>";
    private static final String PATTERN_VERSION = "<version>\\s*(.*?)\\s*</version>";
    private static final String PATTERN_DATE = "date=\"(.*?)\"";
    private static final String PATTERN_LEVEL = "level=\"(.*?)\"";
    private static final String className = "ProductUtils";

    public static String[] getProductIds(String sInstallLocation, InstallToolkitBridge itb) {
        WASProductInfo[] wasProductInfo;
        Vector<String> ids = new Vector<String>();
        WASProductInfo[] wASProductInfoArray = wasProductInfo = ProductUtils.getWASProductInfoInstances(sInstallLocation, itb);
        int n = wasProductInfo.length;
        int n2 = 0;
        while (n2 < n) {
            WASProductInfo element = wASProductInfoArray[n2];
            String id = element.getId();
            ids.add(id);
            ++n2;
        }
        return ids.toArray(new String[ids.size()]);
    }

    public static String getProductVersion(String sInstallLocation, String sProductId, InstallToolkitBridge itb) {
        WASProductInfo[] wasProductInfo;
        WASProductInfo[] wASProductInfoArray = wasProductInfo = ProductUtils.getWASProductInfoInstances(sInstallLocation, itb);
        int n = wasProductInfo.length;
        int n2 = 0;
        while (n2 < n) {
            WASProductInfo element = wASProductInfoArray[n2];
            String id = element.getId();
            if (id.equals(sProductId)) {
                return element.getVersion();
            }
            ++n2;
        }
        return "0.0.0.0";
    }

    public static String getProductName(String sInstallLocation, String sProductId, InstallToolkitBridge itb) {
        WASProductInfo[] wasProductInfo;
        WASProductInfo[] wASProductInfoArray = wasProductInfo = ProductUtils.getWASProductInfoInstances(sInstallLocation, itb);
        int n = wasProductInfo.length;
        int n2 = 0;
        while (n2 < n) {
            WASProductInfo element = wASProductInfoArray[n2];
            String id = element.getId();
            if (id.equals(sProductId)) {
                return element.getName();
            }
            ++n2;
        }
        return "";
    }

    public static WASProductInfo[] getWASProductInfoInstances(String sInstallLocation, InstallToolkitBridge itb) {
        Vector vWASProductInfo;
        block7: {
            vWASProductInfo = new Vector();
            String sProductFileLocation = String.valueOf(sInstallLocation) + "/" + S_RELATIVE_VERSION_PATH;
            try {
                FileSystemEntry[] fseFilesUnderVersionDir;
                FileSystemEntry fseVersionDirectory = URIUtils.convertPathToDefaultTargetMachineFSE(sProductFileLocation, itb);
                if (!fseVersionDirectory.isDirectory()) break block7;
                FileSystemEntry[] fileSystemEntryArray = fseFilesUnderVersionDir = fseVersionDirectory.getDirectoryEntries();
                int n = fseFilesUnderVersionDir.length;
                int n2 = 0;
                while (n2 < n) {
                    FileSystemEntry element = fileSystemEntryArray[n2];
                    if (element.getURI().getPath().endsWith(S_PRODUCT_FILE_EXTENSION)) {
                        try {
                            Vector vWASProductInfoPerProductFile = ProductUtils.parseProductFileFromInputStream(element.getInputStream());
                            vWASProductInfo.addAll(vWASProductInfoPerProductFile);
                        }
                        catch (IOException ioe) {
                            Logr.error(className, "getWASProductInfoInstances", ioe.getMessage(), ioe);
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                Logr.error(className, "getWASProductInfoInstances", e.getMessage(), e);
            }
        }
        WASProductInfo[] wasproductinfoarrayReturned = new WASProductInfo[vWASProductInfo.size()];
        int i = 0;
        while (i < vWASProductInfo.size()) {
            wasproductinfoarrayReturned[i] = (WASProductInfo)vWASProductInfo.elementAt(i);
            ++i;
        }
        return wasproductinfoarrayReturned;
    }

    private static Vector parseProductFileFromInputStream(InputStream inputstream) {
        Vector<WASProductInfo> vWASProductInfoReturn = new Vector<WASProductInfo>();
        String sProductFileContent = ProductUtils.parseInputStreamToString(inputstream);
        if (sProductFileContent != null) {
            Pattern patternProduct = Pattern.compile(PATTERN_PRODUCT_NODE, 32);
            Matcher matcherProduct = patternProduct.matcher(sProductFileContent);
            while (matcherProduct.find()) {
                String sProductString = matcherProduct.group();
                WASProductInfo wasproductinfoThis = ProductUtils.parseProductString(sProductString);
                vWASProductInfoReturn.add(wasproductinfoThis);
            }
        }
        return vWASProductInfoReturn;
    }

    private static WASProductInfo parseProductString(String sProductString) {
        String name = "";
        String id = "";
        String version = "";
        String date = "";
        String level = "";
        Pattern pattern = Pattern.compile(PATTERN_NAME, 32);
        Matcher matcher = pattern.matcher(sProductString);
        if (matcher.find()) {
            String nameString = matcher.group();
            name = nameString.substring(nameString.indexOf(34) + 1, nameString.lastIndexOf(34));
        }
        if ((matcher = (pattern = Pattern.compile(PATTERN_ID, 32)).matcher(sProductString)).find()) {
            String idString = matcher.group();
            id = idString.substring(idString.indexOf("<id>") + 4, idString.indexOf("</id>"));
        }
        if ((matcher = (pattern = Pattern.compile(PATTERN_VERSION, 32)).matcher(sProductString)).find()) {
            String versionString = matcher.group();
            version = versionString.substring(versionString.indexOf("<version>") + 9, versionString.indexOf("</version>"));
        }
        if ((matcher = (pattern = Pattern.compile(PATTERN_DATE, 32)).matcher(sProductString)).find()) {
            String dateString = matcher.group();
            date = dateString.substring(dateString.indexOf(34) + 1, dateString.lastIndexOf(34));
        }
        if ((matcher = (pattern = Pattern.compile(PATTERN_LEVEL, 32)).matcher(sProductString)).find()) {
            String levelString = matcher.group();
            level = levelString.substring(levelString.indexOf(34) + 1, levelString.lastIndexOf(34));
        }
        return new WASProductInfo(name, id, version, date, level);
    }

    private static String parseInputStreamToString(InputStream inputStream) {
        String sFileContents = null;
        try {
            byte[] abTotal = new byte[inputStream.available()];
            inputStream.read(abTotal);
            sFileContents = new String(abTotal);
            inputStream.close();
        }
        catch (IOException ex) {
            ex.getMessage();
            Logr.error(className, "parseInputStreamToString", ex.getMessage(), ex);
        }
        return sFileContents;
    }
}

