/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.install.metadata;

import com.ibm.ws.pak.internal.install.metadata.NIFPackageEntry;
import com.ibm.ws.pak.internal.utils.SimpleXMLParser;
import com.ibm.ws.pak.internal.utils.XMLUtils;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.installtoolkitbridge.InstallToolkitBridge;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class NIFHistory {
    private static Vector m_vnifpeContainer = null;
    private static FileSystemEntry m_fseBackupRepositoryDir = null;
    private static FileSystemEntry m_fseHistoryXml = null;
    private static boolean m_fIsOpen = false;
    private static final String S_PATH_MAINTENANCE = "maintenance-history/maintenance";
    private static final String className = "NIFHistory";

    public static void open(FileSystemEntry fseUPDIBackupRepositoryDir, InstallToolkitBridge itb) throws IOException, ParserConfigurationException, SAXException {
        Logr.methodEntry(className, "open");
        if (m_fseBackupRepositoryDir != null && m_fseBackupRepositoryDir.equals(fseUPDIBackupRepositoryDir)) {
            Logr.debug("m_fseBackupRepositoryDir is null.");
            return;
        }
        m_fseBackupRepositoryDir = fseUPDIBackupRepositoryDir;
        m_fseHistoryXml = NIFHistory.createHistoryXMLFileSystemEntry(m_fseBackupRepositoryDir, itb);
        NIFHistory.readHistory();
        NIFHistory.sortHistoryElementContainer();
        m_fIsOpen = true;
        Logr.methodExit(className, "open");
    }

    public static void setToHighestOrder(NIFPackageEntry nifpeEntry) {
        Logr.methodEntry(className, "setToHighestOrder");
        String sTimeStamp = nifpeEntry.getParamValue("timestamp");
        int nIndex = -1;
        int i = m_vnifpeContainer.size() - 1;
        while (i >= 0) {
            NIFPackageEntry nifpeThis = (NIFPackageEntry)m_vnifpeContainer.elementAt(i);
            String sTimeStampThis = nifpeThis.getParamValue("timestamp");
            if (sTimeStampThis.equals(sTimeStamp)) {
                nIndex = i;
                break;
            }
            --i;
        }
        if (nIndex > -1) {
            m_vnifpeContainer.remove(nIndex);
            NIFHistory.sortHistoryElementContainer();
        }
        nifpeEntry.setOrder(m_vnifpeContainer.size());
        m_vnifpeContainer.add(nifpeEntry);
        Logr.methodExit(className, "setToHighestOrder");
    }

    public static NIFPackageEntry addToHighestOrder(String sName, Vector vsAPARs, Vector vsSupercedesapars, Vector vsSupercedes, Vector vsTargetproductids, Vector vsTargetsubproductids, String sBuilddate, String sAutouninstallable, String sIsbackuppackage, String sIsofficialfix, String sInfo, String sStatus, String sFilename, String sAction, String sUninstallableByUPDI, String sWasinstalledasprimary, String sPackagetype, String sWasinstalledasmaintenance, String sPayloadid, String sPakversion, String sIsenablingifix, String sUritoreinstall, String sDependson, String sTargetOSandArchs) {
        Logr.methodEntry(className, "addToHighestOrder");
        int nOrder = NIFHistory.getNextAvailableOrder();
        NIFPackageEntry nifpeEntry = new NIFPackageEntry(sName, nOrder);
        int i = 0;
        while (i < vsAPARs.size()) {
            nifpeEntry.addParam("apar", (String)vsAPARs.elementAt(i));
            ++i;
        }
        i = 0;
        while (i < vsSupercedes.size()) {
            nifpeEntry.addParam("supercedes", (String)vsSupercedes.elementAt(i));
            ++i;
        }
        i = 0;
        while (i < vsSupercedesapars.size()) {
            nifpeEntry.addParam("supercedesapars", (String)vsSupercedesapars.elementAt(i));
            ++i;
        }
        i = 0;
        while (i < vsTargetproductids.size()) {
            nifpeEntry.addParam("targetproductid", (String)vsTargetproductids.elementAt(i));
            ++i;
        }
        i = 0;
        while (i < vsTargetsubproductids.size()) {
            nifpeEntry.addParam("targetsubproductid", (String)vsTargetsubproductids.elementAt(i));
            ++i;
        }
        String sTimestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ").format(Calendar.getInstance().getTime());
        nifpeEntry.addParam("timestamp", sTimestamp);
        nifpeEntry.addParam("action", sAction);
        nifpeEntry.addParam("filename", sFilename);
        nifpeEntry.addParam("status", sStatus);
        nifpeEntry.addParam("info", sInfo);
        nifpeEntry.addParam("isofficialfix", sIsofficialfix);
        nifpeEntry.addParam("isbackuppackage", sIsbackuppackage);
        nifpeEntry.addParam("autouninstallable", sAutouninstallable);
        nifpeEntry.addParam("builddate", sBuilddate);
        if (sUninstallableByUPDI != null) {
            nifpeEntry.addParam("uninstallablebyupdi", sUninstallableByUPDI);
        }
        if (sWasinstalledasprimary != null) {
            nifpeEntry.addParam("wasinstalledasprimary", sWasinstalledasprimary);
        }
        if (sPackagetype != null) {
            nifpeEntry.addParam("packagetype", sPackagetype);
        }
        if (sWasinstalledasmaintenance != null) {
            nifpeEntry.addParam("wasinstalledasmaintenance", sWasinstalledasmaintenance);
        }
        if (sPayloadid != null) {
            nifpeEntry.addParam("payloadid", sPayloadid);
        }
        if (sPakversion != null) {
            nifpeEntry.addParam("pakversion", sPakversion);
        }
        if (sIsenablingifix != null) {
            nifpeEntry.addParam("isenablingifix", sIsenablingifix);
        }
        if (sUritoreinstall != null) {
            nifpeEntry.addParam("uritoreinstall", sUritoreinstall);
        }
        if (sDependson != null) {
            nifpeEntry.addParam("dependsOn", sDependson);
        }
        if (sTargetOSandArchs != null) {
            nifpeEntry.addParam("targetOSandArchs", sTargetOSandArchs);
        }
        m_vnifpeContainer.add(nifpeEntry);
        Logr.methodExit(className, "addToHighestOrder");
        return (NIFPackageEntry)m_vnifpeContainer.lastElement();
    }

    public static void addParamEntryToHighestOrderElement(String sParamName, String sParamValue) {
        Logr.methodEntry(className, "addParamEntryToHighestOrderElement");
        if (m_vnifpeContainer.size() == 0) {
            return;
        }
        NIFPackageEntry element = (NIFPackageEntry)m_vnifpeContainer.lastElement();
        element.addParam(sParamName, sParamValue);
        Logr.methodExit(className, "addParamEntryToHighestOrderElement");
    }

    public static void updateParamEntryOfHighestOrderElement(String sParamName, String sParamValue) {
        Logr.methodEntry(className, "updateParamEntryOfHighestOrderElement");
        if (m_vnifpeContainer.size() == 0) {
            return;
        }
        NIFPackageEntry nifpe = (NIFPackageEntry)m_vnifpeContainer.lastElement();
        nifpe.updateOrAddParam(sParamName, sParamValue);
        Logr.methodExit(className, "updateParamEntryOfHighestOrderElement");
    }

    public static int getNextAvailableOrder() {
        Logr.methodEntry(className, "getNextAvailableOrder");
        int nHighest = -1;
        int i = 0;
        while (i < m_vnifpeContainer.size()) {
            int nOrderThis = ((NIFPackageEntry)m_vnifpeContainer.elementAt(i)).getOrder();
            if (nOrderThis > nHighest) {
                nHighest = nOrderThis;
            }
            ++i;
        }
        Logr.methodExit(className, "getNextAvailableOrder");
        return nHighest + 1;
    }

    public static void commitAndClose() throws IOException, ParserConfigurationException {
        Logr.methodEntry(className, "commitAndClose");
        NIFHistory.commit();
        NIFHistory.close();
        Logr.methodExit(className, "commitAndClose");
    }

    public static void commit() throws IOException, ParserConfigurationException {
        Logr.methodEntry(className, "commit");
        if (m_vnifpeContainer == null) {
            Logr.debug("m_vnifpeContainer is null.");
            return;
        }
        Document documentThis = SimpleXMLParser.createNewDocument();
        Element elementRoot = SimpleXMLParser.addNestedElement("maintenance-history", null, null, documentThis);
        int i = 0;
        while (i < m_vnifpeContainer.size()) {
            NIFPackageEntry mseElementThis = (NIFPackageEntry)m_vnifpeContainer.elementAt(i);
            mseElementThis.setOrder(i);
            mseElementThis.addToThisDocument(elementRoot);
            ++i;
        }
        XMLUtils.saveDocument(documentThis, m_fseHistoryXml, true);
        Logr.methodExit(className, "commit");
    }

    public static void close() {
        Logr.methodEntry(className, "close");
        m_fseBackupRepositoryDir = null;
        m_fseHistoryXml = null;
        m_vnifpeContainer = null;
        m_fIsOpen = false;
        Logr.methodExit(className, "close");
    }

    public static Vector getNIFHistory() {
        return m_vnifpeContainer;
    }

    public static void readHistory() throws IOException, ParserConfigurationException, SAXException {
        Logr.methodEntry(className, "readHistory");
        if (!m_fseHistoryXml.exists()) {
            Logr.debug(String.valueOf(m_fseHistoryXml.getAbsolutePath()) + " does not exist.");
            return;
        }
        m_vnifpeContainer = new Vector();
        SimpleXMLParser sxpParser = null;
        sxpParser = XMLUtils.getSimpleXMLParserFromFileSystemEntry(m_fseHistoryXml);
        Vector vnodeContainer = sxpParser.getNodes(S_PATH_MAINTENANCE);
        int i = 0;
        while (i < vnodeContainer.size()) {
            Node nodeThis = (Node)vnodeContainer.elementAt(i);
            m_vnifpeContainer.addElement(new NIFPackageEntry(nodeThis));
            ++i;
        }
        Logr.methodExit(className, "readHistory");
    }

    public static Vector findMaintenanceNamesFromPayloadid(String sPayloadid, boolean fIsRegExp) {
        Logr.methodEntry(className, "findMaintenanceNamesFromPayloadid");
        Vector<String> vsReturn = new Vector<String>();
        if (m_vnifpeContainer == null || sPayloadid == null || sPayloadid.trim().length() == 0) {
            return vsReturn;
        }
        Pattern pattern = null;
        if (fIsRegExp) {
            pattern = Pattern.compile(sPayloadid);
        }
        int i = 0;
        while (i < m_vnifpeContainer.size()) {
            NIFPackageEntry nifpeThis = (NIFPackageEntry)m_vnifpeContainer.elementAt(i);
            String sPayloadidThis = nifpeThis.getParamValue("payloadid");
            String sMaintenanceNameThis = nifpeThis.getNIFPackageName();
            if (sPayloadidThis != null && sPayloadidThis.trim().length() > 0) {
                if (fIsRegExp) {
                    Matcher match = pattern.matcher(sPayloadidThis);
                    if (match.matches()) {
                        vsReturn.add(sMaintenanceNameThis);
                    }
                } else if (sPayloadid.equals(sPayloadidThis)) {
                    vsReturn.add(sMaintenanceNameThis);
                }
            }
            ++i;
        }
        Logr.methodExit(className, "findMaintenanceNamesFromPayloadid");
        return vsReturn;
    }

    public static boolean isOpen() {
        return m_fIsOpen;
    }

    private static void sortHistoryElementContainer() {
        Logr.methodEntry(className, "sortHistoryElementContainer");
        Vector<NIFPackageEntry> vmseContainer = new Vector<NIFPackageEntry>();
        while (m_vnifpeContainer != null && m_vnifpeContainer.size() > 0) {
            NIFPackageEntry mseNextElement = NIFHistory.extractNextElement();
            mseNextElement.setOrder(vmseContainer.size());
            vmseContainer.add(mseNextElement);
        }
        m_vnifpeContainer = vmseContainer;
        Logr.methodExit(className, "sortHistoryElementContainer");
    }

    private static NIFPackageEntry extractNextElement() {
        Logr.methodEntry(className, "extractNextElement");
        NIFPackageEntry mseNextElement = (NIFPackageEntry)m_vnifpeContainer.elementAt(0);
        int nNextOrder = mseNextElement.getOrder();
        int nNextIndex = 0;
        int i = 1;
        while (i < m_vnifpeContainer.size()) {
            NIFPackageEntry mseThis = (NIFPackageEntry)m_vnifpeContainer.elementAt(i);
            if (mseThis.getOrder() < nNextOrder) {
                mseNextElement = mseThis;
                nNextOrder = mseNextElement.getOrder();
                nNextIndex = i;
            }
            ++i;
        }
        m_vnifpeContainer.removeElementAt(nNextIndex);
        Logr.methodExit(className, "extractNextElement");
        return mseNextElement;
    }

    private static FileSystemEntry createHistoryXMLFileSystemEntry(FileSystemEntry fseUPDIBackupRepositoryDir, InstallToolkitBridge itb) throws IOException {
        Logr.methodEntry(className, "createHistoryXMLFileSystemEntry");
        FileSystemEntry fseHistory = new FileSystemEntry(fseUPDIBackupRepositoryDir.getURI(), "NIFHistory.xml", itb);
        FileSystemEntry fseHistoryLegacy = new FileSystemEntry(fseUPDIBackupRepositoryDir.getURI(), "maintenanceHistory.xml", itb);
        if (!fseHistory.exists() && fseHistoryLegacy.exists()) {
            return fseHistoryLegacy;
        }
        return fseHistory;
    }
}

