/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.install.metadata;

import com.ibm.ws.pak.internal.NIFPlugin;
import com.ibm.ws.pak.internal.install.metadata.EnablingPackInfoPlugin;
import com.ibm.ws.pak.internal.utils.NIFPluginUtils;
import com.ibm.ws.pak.internal.utils.StringUtils;
import com.ibm.ws.pak.internal.utils.VersionUtils;
import com.ibm.ws.pak.internal.utils.installtoolkitbridge.InstallToolkitBridge;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import com.ibm.ws.pak.internal.utils.product.ProductPlugin;
import java.io.IOException;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class MaintenanceInfoPlugin
extends NIFPlugin {
    public static String S_ISBACKUP_PACKAGE_PARAM = "isbackuppackage";
    public static final String S_TARGETPRODUCTIDS_PARAM = "targetproductids";
    public static final String S_TARGETSUBPRODUCTIDS_PARAM = "targetsubproductids";
    public static final String S_UNINSTALLABLEBYUPDI_PARAM = "uninstallablebyupdi";
    private EnablingPackInfoPlugin[] m_aepipEnablingPackages = null;
    private static final String S_NAME_PARAM = "name";
    private static final String S_PAKVERSION_PARAM = "pakversion";
    private static final String S_PAYLOADID_PARAM = "payloadid";
    private static final String S_MSL_FILE_LOCATION_PARAM = "mslFileLocation";
    private static final String S_INFO_DEFAULT_LOCALE_PARAM = "info_en_US";
    private static final String S_ISOFFICIAL_FIX_PARAM = "isofficialfix";
    private static final String S_ISCOPYJDKREQUIRED_PARAM = "iscopyjdkrequired";
    private static final String S_APARS_PARAM = "apars";
    private static final String S_AUTO_UNINSTALLABLE_PARAM = "autouninstallable";
    private static final String S_BUILDDATE_PARAM = "builddate";
    private static final String S_SUPERCEDESAPARS_PARAM = "supercedesapars";
    private static final String S_SUPERCEDEDAPARS_PARAM = "supercededApars";
    private static final String S_SUPERCEDES_PARAM = "supercedes";
    private static final String S_HASPROFILEUPDATES_PARAM = "hasprofileupdates";
    private static final String S_INSTALLROOTSPACEREQUIRED_PARAM = "installrootspacerequired";
    private static final String S_TEMPROOTSPACEREQUIRED_PARAM = "temprootspacerequired";
    private static final String S_SATELLITES_PARAM = "satellites";
    private static final String S_SATELLITESROOTPATH_PARAM = "satellitesrootpath";
    private static final String S_WASINSTALLEDASPRIMARY = "wasinstalledasprimary";
    private static final String S_WASINSTALLEDASMAINTENANCE = "wasinstalledasmaintenance";
    private static final String S_PACKAGETYPE = "packagetype";
    private static final String S_INSTALLROOT = "installroot";
    private static final String S_EMBEDDEDSATELLITESDIRURI = "embeddedsatelitesdirurl";
    private static final String S_REQUIRED_WAS_VERSION = "requiredwasversion";
    private static final String S_URISTOBEUNINSTALLEDDURINGUNINSTALL = "URIsToBeUninstalledDuringUninstall";
    private static final String S_PRODUCTTYPE_PARAM = "producttype";
    private static final String S_ENABLINGPACKSRELATIVEPLUGINPATH = "enablingpacksrelativepluginpath";
    private static final String S_ISENABLINGIFIX_PARAM = "isenablingifix";
    private static final String S_URITOREINSTALL_PARAM = "uritoreinstall";
    private static final String S_TARGETOSANDARCHS_PARAM = "targetOSandArchs";
    private static final String S_DEPENDSON_PARAM = "dependsOn";
    private static final String S_ENABLINGIFIXNAME_PARAM = "enablingifixname";
    private static final String S_CONDITION_PARAM = "condition";
    private static final String S_INSTALLCONDITION_PARAM = "installcondition";
    private static final String S_UNINSTALLCONDITION_PARAM = "uninstallcondition";
    private static final String[] AS_REQUIRED_PARAMS = new String[]{"name", "info_en_US", "isofficialfix", S_ISBACKUP_PACKAGE_PARAM, "apars", "autouninstallable", "builddate"};
    private static final String[] AS_OPTIONAL_PARAMS = new String[]{"pakversion", "payloadid", "mslFileLocation", "info_de", "info_de_DE", "info_es", "info_es_ES", "info_fr", "info_fr_FR", "info_it", "info_it_IT", "info_ja", "info_ja_JP", "info_ko", "info_ko_KR", "info_pt", "info_pt_BR", "info_zh", "info_zh_CN", "info_zh_TW", "iscopyjdkrequired", "supercedesapars", "supercededApars", "supercedes", "targetproductids", "targetsubproductids", "hasprofileupdates", "installrootspacerequired", "temprootspacerequired", "uninstallablebyupdi", "satellites", "satellitesrootpath", "wasinstalledasmaintenance", "wasinstalledasprimary", "packagetype", "installroot", "embeddedsatelitesdirurl", "requiredwasversion", "isenablingifix", "uritoreinstall", "dependsOn", "enablingifixname", "targetOSandArchs", "URIsToBeUninstalledDuringUninstall", "producttype", "commonComponentRequires", "condition", "installcondition", "uninstallcondition"};
    private static final String S_INFO_PARAM = "info";
    private static final String S_UNDERSCORE = "_";
    private static final String S_EMPTY = "";
    private static final String className = "MaintenanceInfoPlugin";

    public static MaintenanceInfoPlugin getMaintenanceInfoPlugin(Document documentInstallPackage, InstallToolkitBridge itb) throws ClassNotFoundException, IOException, IllegalAccessException, InstantiationException, ParserConfigurationException, SAXException {
        Logr.methodEntry(className, "getMaintenanceInfoPlugin");
        NIFPlugin[] anifp = NIFPlugin.createPlugins(documentInstallPackage, "install-package/information", itb);
        NIFPluginUtils.enforceAllThesePluginsAssignableFromThisClass(MaintenanceInfoPlugin.class, anifp);
        MaintenanceInfoPlugin mipThis = (MaintenanceInfoPlugin)anifp[0];
        mipThis.initEnablingPackInfoPlugins();
        Logr.methodExit(className, "getMaintenanceInfoPlugin");
        return mipThis;
    }

    public String getName() {
        return this.getParamValue(S_NAME_PARAM);
    }

    public String getPakversion() {
        return this.getParamValue(S_PAKVERSION_PARAM);
    }

    public String getPayloadid() {
        return this.getParamValue(S_PAYLOADID_PARAM);
    }

    public String getMslFileLocation() {
        return this.getParamValue(S_MSL_FILE_LOCATION_PARAM);
    }

    public String getIsofficialfix() {
        String s = this.getParamValue(S_ISOFFICIAL_FIX_PARAM);
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    public String getHasProfileUpdates() {
        return this.getParamValue(S_HASPROFILEUPDATES_PARAM);
    }

    public String getAutouninstallable() {
        return this.getParamValue(S_AUTO_UNINSTALLABLE_PARAM);
    }

    public String getUninstallableByUPDITag() {
        String sUninstallableByUPDITag = this.getParamValue(S_UNINSTALLABLEBYUPDI_PARAM);
        if (sUninstallableByUPDITag == null) {
            return Boolean.TRUE.toString();
        }
        return new Boolean(sUninstallableByUPDITag).toString();
    }

    public String getIscopyjdkrequired() {
        return this.getParamValue(S_ISCOPYJDKREQUIRED_PARAM);
    }

    public String getInfo() {
        String sLocaleCurrent = String.valueOf(Locale.getDefault().getLanguage()) + S_UNDERSCORE + Locale.getDefault().getCountry();
        String sInfo = this.getParamValue("info_" + sLocaleCurrent);
        if (sInfo != null) {
            return sInfo;
        }
        sLocaleCurrent = Locale.getDefault().getLanguage();
        sInfo = this.getParamValue("info_" + sLocaleCurrent);
        if (sInfo != null) {
            return sInfo;
        }
        return this.getParamValue(S_INFO_DEFAULT_LOCALE_PARAM);
    }

    public String getIsbackuppackage() {
        return this.getParamValue(S_ISBACKUP_PACKAGE_PARAM);
    }

    public boolean isBackupPackage() {
        return new Boolean(this.getParamValue(S_ISBACKUP_PACKAGE_PARAM));
    }

    public String getApars() {
        String sApars = this.getParamValue(S_APARS_PARAM);
        Vector vsApars = this.getExpandedParams(sApars);
        if (vsApars.isEmpty()) {
            sApars = this.getName();
        }
        return sApars;
    }

    public Vector getListOfAparsContained() {
        return this.getExpandedParams(this.getApars());
    }

    public String getEmbeddedsatelitesdirurl() {
        return this.getParamValue(S_EMBEDDEDSATELLITESDIRURI);
    }

    public boolean isAutoUninstallable() {
        if (!new Boolean(this.getUninstallableByUPDITag()).booleanValue()) {
            return false;
        }
        String sIsAutoUninstallable = this.getParamValue(S_AUTO_UNINSTALLABLE_PARAM);
        return new Boolean(sIsAutoUninstallable);
    }

    public String getBuildDate() {
        return this.getParamValue(S_BUILDDATE_PARAM);
    }

    public String getSupercededMaintenancePackages() {
        return StringUtils.replaceSeparators(this.getParamValue(S_SUPERCEDES_PARAM), ",\t:; ", ";");
    }

    public Vector getListOfSupercededMaintenancePackages() {
        String s = this.getSupercededMaintenancePackages();
        if (s == null || s.trim().length() == 0) {
            return new Vector();
        }
        StringTokenizer st = new StringTokenizer(s, ";");
        Vector<String> vsReturn = new Vector<String>();
        while (st.hasMoreTokens()) {
            vsReturn.add(st.nextToken().trim());
        }
        return vsReturn;
    }

    public String getSupercededApars() {
        String sResult = this.getParamValue(S_SUPERCEDEDAPARS_PARAM);
        if (sResult == null) {
            sResult = this.getParamValue(S_SUPERCEDESAPARS_PARAM);
        }
        return StringUtils.replaceSeparators(sResult, ",\t:; ", ";");
    }

    public String getSupercedesapars() {
        String sResult = this.getParamValue(S_SUPERCEDESAPARS_PARAM);
        if (sResult == null) {
            sResult = this.getParamValue(S_SUPERCEDEDAPARS_PARAM);
        }
        return StringUtils.replaceSeparators(sResult, ",\t:; ", ";");
    }

    public String getSupercedes() {
        return StringUtils.replaceSeparators(this.getParamValue(S_SUPERCEDES_PARAM), ",\t:; ", ";");
    }

    public Vector getListOfSupercededApars() {
        String s = this.getParamValue(S_SUPERCEDESAPARS_PARAM);
        if (s == null) {
            return new Vector();
        }
        s = StringUtils.replaceSeparators(s, ",\t:; ", ";");
        StringTokenizer st = new StringTokenizer(s, ";");
        Vector<String> vsReturn = new Vector<String>();
        while (st.hasMoreTokens()) {
            vsReturn.add(st.nextToken().trim());
        }
        return vsReturn;
    }

    public Vector getListOfTargetproductids() {
        Vector<String> vsListOfTargetproductids = this.getParamListAsStringVector(S_TARGETPRODUCTIDS_PARAM);
        if (vsListOfTargetproductids == null) {
            vsListOfTargetproductids = new Vector<String>();
        }
        if (vsListOfTargetproductids.size() == 0) {
            vsListOfTargetproductids.add("NA");
        }
        return vsListOfTargetproductids;
    }

    public Vector getListOfTargetsubproductids() {
        Vector<String> vsListOfTargetsubproductids = this.getParamListAsStringVector(S_TARGETSUBPRODUCTIDS_PARAM);
        if (vsListOfTargetsubproductids == null) {
            vsListOfTargetsubproductids = new Vector<String>();
        }
        if (vsListOfTargetsubproductids.size() == 0) {
            vsListOfTargetsubproductids.add("NA");
        }
        return vsListOfTargetsubproductids;
    }

    public String getTargetproductids() {
        String sTargetproductids = this.getParamValue(S_TARGETPRODUCTIDS_PARAM);
        if (sTargetproductids == null || sTargetproductids.equals(S_EMPTY)) {
            sTargetproductids = "NA";
        }
        return sTargetproductids;
    }

    public String getTargetsubproductids() {
        String sTargetproductids = this.getParamValue(S_TARGETSUBPRODUCTIDS_PARAM);
        if (sTargetproductids == null || sTargetproductids.equals(S_EMPTY)) {
            sTargetproductids = "NA";
        }
        return sTargetproductids;
    }

    public void setUninstallableByUPDI(boolean fUninstallableByUPDI) {
        this.setPluginParam(S_UNINSTALLABLEBYUPDI_PARAM, new String[]{new Boolean(fUninstallableByUPDI).toString()});
    }

    public String getInstallrootspacerequired() {
        return this.getParamValue(S_INSTALLROOTSPACEREQUIRED_PARAM);
    }

    public String getTemprootspacerequired() {
        return this.getParamValue(S_TEMPROOTSPACEREQUIRED_PARAM);
    }

    public String getSatellites() {
        return this.getParamValue(S_SATELLITES_PARAM);
    }

    public String getSatellitesrootpath() {
        return this.getParamValue(S_SATELLITESROOTPATH_PARAM);
    }

    public String getInstallroot() {
        return this.getParamValue(S_INSTALLROOT);
    }

    public String getRequiredWASVersion() {
        return this.getParamValue(S_REQUIRED_WAS_VERSION);
    }

    public String getProducttype() {
        String sProducttype = this.getParamValue(S_PRODUCTTYPE_PARAM);
        if (sProducttype == null || sProducttype.trim().equals(S_EMPTY)) {
            sProducttype = "NA";
        }
        return sProducttype;
    }

    public String getWasinstalledasmaintenance() {
        String sWasinstalledasmaintenance = this.getParamValue(S_WASINSTALLEDASMAINTENANCE);
        if (sWasinstalledasmaintenance == null || sWasinstalledasmaintenance.trim().equals(S_EMPTY)) {
            return Boolean.TRUE.toString();
        }
        return new Boolean(sWasinstalledasmaintenance).toString();
    }

    public boolean wasinstalledasmaintenanceForRepositoryParsingPurpose() {
        if (new Boolean(this.getWasinstalledasmaintenance()).booleanValue()) {
            return true;
        }
        if (!new Boolean(this.getWasinstalledasprimary()).booleanValue()) {
            return true;
        }
        String sPakversion = this.getPakversion();
        if (sPakversion == null || sPakversion.trim().length() == 0) {
            return false;
        }
        if (VersionUtils.isTheThirdDigitGreaterThanOrEqualToOne(sPakversion)) {
            return true;
        }
        return VersionUtils.isTheFourthDigitGreaterThanOrEqualToOne(sPakversion);
    }

    public String getURIsToBeUninstalledDuringUninstall() {
        String sURIsToBeUninstalledDuringUninstall = this.getParamValue(S_URISTOBEUNINSTALLEDDURINGUNINSTALL);
        if (sURIsToBeUninstalledDuringUninstall == null) {
            return S_EMPTY;
        }
        return sURIsToBeUninstalledDuringUninstall;
    }

    public boolean isIfix() {
        String sPackagetype = this.getPackagetype();
        if (sPackagetype.equalsIgnoreCase("IFIX")) {
            return true;
        }
        return new Boolean(this.getParamValue(S_AUTO_UNINSTALLABLE_PARAM));
    }

    public String getPackagetype() {
        String sPackagetype = this.getParamValue(S_PACKAGETYPE);
        if (sPackagetype == null || sPackagetype.trim().equals(S_EMPTY)) {
            sPackagetype = "NA";
        }
        return sPackagetype;
    }

    public String getWasinstalledasprimary() {
        String sWasinstalledasprimary = this.getParamValue(S_WASINSTALLEDASPRIMARY);
        if (sWasinstalledasprimary == null || sWasinstalledasprimary.trim().equals(S_EMPTY)) {
            return Boolean.TRUE.toString();
        }
        return new Boolean(sWasinstalledasprimary).toString();
    }

    public boolean isThisPackageApplicableForTheCurrentProduct() {
        String sCurrentProduct = ProductPlugin.getCurrentProductOffering();
        String sTargetProductIds = this.getTargetproductids();
        if (sTargetProductIds == null || sTargetProductIds.equals(S_EMPTY) || sTargetProductIds.equals("NA") || sTargetProductIds.equals("WAS")) {
            return true;
        }
        return StringUtils.isThisStringContainingThisToken(sTargetProductIds, sCurrentProduct, ";");
    }

    public String getIsenablingifix() {
        String sIsenablingifix = this.getParamValue(S_ISENABLINGIFIX_PARAM);
        return new Boolean(sIsenablingifix).toString();
    }

    public String getUritoreinstall() {
        String s = this.getParamValue(S_URITOREINSTALL_PARAM);
        if (s == null) {
            s = S_EMPTY;
        }
        return s;
    }

    public String getDependsOn() {
        return this.getParamValue(S_DEPENDSON_PARAM);
    }

    public String getEnablingIfixName() {
        return this.getParamValue(S_ENABLINGIFIXNAME_PARAM);
    }

    public String getTargetOSandArchs() {
        return this.getParamValue(S_TARGETOSANDARCHS_PARAM);
    }

    public String getCondition() {
        if (this.isBackupPackage()) {
            return this.getUninstallcondition();
        }
        return this.getInstallcondition();
    }

    public String getInstallcondition() {
        String s = this.getParamValue(S_INSTALLCONDITION_PARAM);
        if (s == null || s.trim().length() == 0) {
            return "true";
        }
        return S_EMPTY + new Boolean(s);
    }

    public String getUninstallcondition() {
        String s = this.getParamValue(S_UNINSTALLCONDITION_PARAM);
        if (s == null || s.trim().length() == 0) {
            return "true";
        }
        return S_EMPTY + new Boolean(s);
    }

    public EnablingPackInfoPlugin[] getEnablingPackInfoPlugins() {
        return this.m_aepipEnablingPackages;
    }

    public String getCommonComponentRequires() {
        return this.getParamValue("commonComponentRequires");
    }

    @Override
    protected String[] getRequiredParams() {
        return AS_REQUIRED_PARAMS;
    }

    @Override
    protected String[] getOptionalParams() {
        return AS_OPTIONAL_PARAMS;
    }

    private EnablingPackInfoPlugin[] initEnablingPackInfoPlugins() throws ClassNotFoundException, InstantiationException, IllegalAccessException, ParserConfigurationException, SAXException, IOException {
        String sPluginRelativePath = this.getParamValue(S_ENABLINGPACKSRELATIVEPLUGINPATH);
        if (sPluginRelativePath == null || sPluginRelativePath.trim().equals(S_EMPTY)) {
            return new EnablingPackInfoPlugin[0];
        }
        NIFPlugin[] anifp = NIFPlugin.createChildPlugins(this, sPluginRelativePath, this.getInstallToolkitBridge());
        NIFPluginUtils.enforceAllThesePluginsAssignableFromThisClass(EnablingPackInfoPlugin.class, anifp);
        this.m_aepipEnablingPackages = new EnablingPackInfoPlugin[anifp.length];
        int i = 0;
        while (i < anifp.length) {
            this.m_aepipEnablingPackages[i] = (EnablingPackInfoPlugin)anifp[i];
            ++i;
        }
        return this.m_aepipEnablingPackages;
    }

    private Vector getParamListAsStringVector(String sParamName) {
        if (this.getParamValue(sParamName) == null) {
            return new Vector();
        }
        StringTokenizer st = new StringTokenizer(this.getParamValue(sParamName), ";");
        Vector<String> vsReturn = new Vector<String>();
        while (st.hasMoreTokens()) {
            vsReturn.add(st.nextToken().trim());
        }
        return vsReturn;
    }
}

