/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.xml.core.internal.parser;

import com.ibm.cic.common.xml.core.ITagScanner;
import com.ibm.cic.common.xml.core.IXMLTagToken;
import com.ibm.cic.common.xml.core.internal.parser.XMLToken;
import java.util.ArrayList;

public class XMLTagScanner
implements ITagScanner {
    private final String fContent;
    private final ArrayList fTokens;
    private boolean fMalformed;
    private int fCurIdx;

    public XMLTagScanner(String content) {
        this.fContent = content;
        this.fTokens = new ArrayList();
        this.fCurIdx = 0;
        this.read();
    }

    private void read() {
        int index = 0;
        XMLToken token = null;
        if (this.fContent == null || this.fContent.length() < 1) {
            return;
        }
        char c = this.fContent.charAt(index);
        while (this.isWhitespace(c) && c != '<') {
            c = this.fContent.charAt(++index);
        }
        if (c != '<') {
            this.fMalformed = true;
            return;
        }
        token = new XMLToken(1, ++index);
        StringBuffer contentBuffer = new StringBuffer();
        while (index < this.fContent.length()) {
            switch (token.getType()) {
                case 1: {
                    index = this.readWord(index, contentBuffer);
                    if (index >= this.fContent.length()) {
                        return;
                    }
                    token.set(contentBuffer.toString());
                    this.fTokens.add(token);
                    contentBuffer.setLength(0);
                    index = this.seekPastWhitespace(index);
                    if (this.isTagEnd(c) || index >= this.fContent.length()) {
                        return;
                    }
                    token = new XMLToken(2, index);
                    break;
                }
                case 2: {
                    index = this.readWord(index, contentBuffer);
                    token.set(contentBuffer.toString());
                    this.fTokens.add(token);
                    contentBuffer.setLength(0);
                    index = this.seekPastWhitespace(index);
                    if (index >= this.fContent.length() || this.fContent.charAt(index) != '=') {
                        this.fMalformed = true;
                        return;
                    }
                    if (++index >= this.fContent.length()) {
                        this.fMalformed = true;
                        return;
                    }
                    char test = this.fContent.charAt(index = this.seekPastWhitespace(index));
                    if (test != '\"' && test != '\'' || index + 1 >= this.fContent.length()) {
                        this.fMalformed = true;
                        return;
                    }
                    token = new XMLToken(3, ++index);
                    break;
                }
                case 3: {
                    index = this.readLiteral(index, contentBuffer);
                    token.set(contentBuffer.toString());
                    this.fTokens.add(token);
                    contentBuffer.setLength(0);
                    char qTest = this.fContent.charAt(index);
                    if (qTest != '\'' && qTest != '\"') {
                        this.fMalformed = true;
                        return;
                    }
                    if (++index >= this.fContent.length()) {
                        return;
                    }
                    if ((index = this.seekPastWhitespace(index)) >= this.fContent.length()) {
                        return;
                    }
                    qTest = this.fContent.charAt(index);
                    if (this.isTagEnd(qTest)) {
                        return;
                    }
                    token = new XMLToken(2, index);
                    break;
                }
            }
        }
    }

    public boolean isWhitespace(char c) {
        return c == ' ' || c == '\r' || c == '\t' || c == '\n';
    }

    private boolean isTagEnd(char c) {
        return c == '/' || c == '>';
    }

    @Override
    public boolean hasNextToken() {
        return this.fCurIdx < this.fTokens.size();
    }

    @Override
    public IXMLTagToken nextToken() {
        if (!this.hasNextToken()) {
            return null;
        }
        IXMLTagToken token = (IXMLTagToken)this.fTokens.get(this.fCurIdx);
        ++this.fCurIdx;
        return token;
    }

    private boolean isControlChar(char c) {
        return c == '<' || c == '/' || c == '>' || c == '=';
    }

    private int readLiteral(int start, StringBuffer buffer) {
        char c = this.fContent.charAt(start);
        while (c != '\'' && c != '\"' && start + 1 < this.fContent.length()) {
            buffer.append(c);
            c = this.fContent.charAt(++start);
        }
        return start;
    }

    private int readWord(int start, StringBuffer buffer) {
        char c = this.fContent.charAt(start);
        while (!this.isWhitespace(c) && !this.isControlChar(c) && start < this.fContent.length()) {
            buffer.append(c);
            if (++start >= this.fContent.length()) continue;
            c = this.fContent.charAt(start);
        }
        return start;
    }

    private int seekPastWhitespace(int start) {
        if (start < this.fContent.length()) {
            char c = this.fContent.charAt(start);
            while (this.isWhitespace(c) && start < this.fContent.length()) {
                if (++start >= this.fContent.length()) continue;
                c = this.fContent.charAt(start);
            }
        }
        return start;
    }

    @Override
    public boolean isMalformed() {
        return this.fMalformed;
    }

    @Override
    public void toFirst() {
        this.fCurIdx = 0;
    }

    @Override
    public boolean hasPrevious() {
        return this.fCurIdx > 0;
    }

    @Override
    public IXMLTagToken previous() {
        if (!this.hasPrevious()) {
            return null;
        }
        --this.fCurIdx;
        return (IXMLTagToken)this.fTokens.get(this.fCurIdx);
    }
}

