/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.xml.core.internal.model.schema;

import com.ibm.cic.common.xml.core.CicXMLCore;
import com.ibm.cic.common.xml.core.internal.Messages;
import com.ibm.cic.common.xml.core.internal.model.schema.IValueRefinement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Element;

public class LengthRefinement
implements IValueRefinement {
    private int fLength;
    private boolean fValid;

    public LengthRefinement(Element domElement) {
        String val = domElement.getAttribute("value");
        try {
            this.fLength = Integer.parseInt(val);
            this.fValid = true;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            CicXMLCore.getDefault().getLog().log((IStatus)new Status(4, "com.ibm.cic.common.xml.core", 0, Messages.intErr_invalid_schema_length, (Throwable)e));
            this.fValid = false;
        }
    }

    @Override
    public boolean isValueValid(String value) {
        if (value == null) {
            return false;
        }
        if (!this.fValid) {
            return false;
        }
        return value.length() == this.fLength;
    }

    @Override
    public String getFailureMessage(String attribute, String value) {
        return Messages.bind((String)Messages.err_length_refinement, (Object)attribute, (Object)String.valueOf(this.fLength));
    }
}

