/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.xml.core.internal.ext;

import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.xml.core.CicXMLCore;
import com.ibm.cic.common.xml.core.internal.Messages;
import com.ibm.cic.common.xml.core.model.schema.ISchema;
import com.ibm.cic.common.xml.core.model.schema.IValueRestriction;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class SchemaHolder {
    private final URL fURL;
    private ISchema fSchema;
    private final IConfigurationElement fElement;
    private static final String ELEMENT_VALIDATOR = "typeValidator";
    private static final String ATTR_TYPE = "typeName";
    private static final String ATTR_CLASS = "class";

    public SchemaHolder(IConfigurationElement element, URL schemaURL) {
        this.fURL = schemaURL;
        this.fElement = element;
    }

    public ISchema getSchema() {
        if (this.fSchema == null) {
            this.fSchema = this.readSchema(this.fURL);
        }
        return this.fSchema;
    }

    protected ISchema readSchema(URL schema) {
        ISchema ret = null;
        try {
            InputStream in = schema.openStream();
            ret = CicXMLCore.getDefault().readSchema(in);
            FileUtil.close((Closeable)in);
            if (ret == null) {
                CicXMLCore.getDefault().getLog().log((IStatus)new Status(4, "com.ibm.cic.common.xml.core", Messages.bind((String)Messages.SchemaHolder_errUnableToLoadSchema, (Object)schema.toExternalForm()), null));
            }
        }
        catch (Exception e) {
            CicXMLCore.getDefault().logException(e);
        }
        if (ret != null) {
            this.loadValidators(ret);
        }
        return ret;
    }

    private void loadValidators(ISchema schema) {
        IConfigurationElement[] validators;
        IConfigurationElement[] iConfigurationElementArray = validators = this.fElement.getChildren(ELEMENT_VALIDATOR);
        int n = validators.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement validator2 = iConfigurationElementArray[n2];
            String type = validator2.getAttribute(ATTR_TYPE);
            try {
                Object validator = validator2.createExecutableExtension(ATTR_CLASS);
                IValueRestriction v = (IValueRestriction)validator;
                v.init(schema);
                schema.addTypeRule(type, (IValueRestriction)validator);
            }
            catch (CoreException e) {
                CicXMLCore.getDefault().logException(e);
            }
            ++n2;
        }
    }
}

