/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.xml.core.delta;

import com.ibm.cic.common.xml.core.delta.AbstractXMLDelta;
import com.ibm.cic.common.xml.core.delta.AttributeDelta;
import com.ibm.cic.common.xml.core.delta.IXMLDelta;
import com.ibm.cic.common.xml.core.model.IXMLTextModelItem;
import java.util.ArrayList;

public class ElementDelta
extends AbstractXMLDelta
implements IXMLDelta {
    private boolean fHasAttrDeltas;
    private final ArrayList fIgnoredAttrs;

    public ElementDelta(IXMLTextModelItem source, IXMLTextModelItem target, IXMLDelta parent, ArrayList ignoredAttrs) {
        super(source, target);
        this.fIgnoredAttrs = ignoredAttrs;
        if (source != null || target != null) {
            this.compute();
            this.checkAttributes();
        }
        if (parent != null) {
            parent.addChild(this);
        }
    }

    protected void compute() {
        if (this.fSource == null && this.fTarget != null) {
            this.fDelta = 1;
        } else if (this.fSource != null && this.fTarget == null) {
            this.fDelta = (byte)4;
        } else if (this.fSource != null && this.fTarget != null) {
            if (!this.fSource.getName().equals(this.fTarget.getName())) {
                this.fDelta = (byte)(this.fDelta | 0x10);
            }
            String sDat = this.normalizeCData(this.fSource.getElementCDATA());
            String tDat = this.normalizeCData(this.fTarget.getElementCDATA());
            if (sDat == null && tDat != null || sDat != null && tDat == null) {
                this.fDelta = (byte)(this.fDelta | 8);
            } else if (sDat != null && tDat != null && !sDat.equals(tDat)) {
                this.fDelta = (byte)(this.fDelta | 8);
            }
        }
    }

    private String normalizeCData(String in) {
        if (in == null) {
            return null;
        }
        if (in.trim().length() == 0) {
            return null;
        }
        return in.trim();
    }

    private void checkAttributes() {
        AttributeDelta delta;
        int i;
        ArrayList<String> processed = new ArrayList<String>();
        if (this.fSource != null) {
            String[] sAttrs = this.fSource.getAttributeNames();
            i = 0;
            while (i < sAttrs.length) {
                if (!this.fIgnoredAttrs.contains(sAttrs[i]) && !processed.contains(sAttrs[i])) {
                    delta = new AttributeDelta(this.fSource, this.fTarget, sAttrs[i], this);
                    this.addAttributeDelta(delta);
                    processed.add(sAttrs[i]);
                }
                ++i;
            }
        }
        if (this.fTarget != null) {
            String[] tAttrs = this.fTarget.getAttributeNames();
            i = 0;
            while (i < tAttrs.length) {
                if (!this.fIgnoredAttrs.contains(tAttrs[i]) && !processed.contains(tAttrs[i])) {
                    delta = new AttributeDelta(this.fSource, this.fTarget, tAttrs[i], this);
                    this.addAttributeDelta(delta);
                }
                ++i;
            }
        }
        processed.clear();
    }

    @Override
    public byte getDelta() {
        return this.fDelta;
    }

    public boolean containsDelta(byte delta) {
        return (this.fDelta & delta) == delta;
    }

    private void addAttributeDelta(AttributeDelta delta) {
        if (delta.getDelta() != 0) {
            this.fHasAttrDeltas = true;
        }
        this.addChild(delta);
    }

    @Override
    public String getName() {
        if (this.fSource != null) {
            return this.fSource.getName();
        }
        if (this.fTarget != null) {
            return this.fTarget.getName();
        }
        return null;
    }

    @Override
    public String getSourceName() {
        if (this.fSource != null) {
            return this.fSource.getName();
        }
        return null;
    }

    @Override
    public String getSourceValue() {
        if (this.fSource != null) {
            return this.fSource.getElementCDATA();
        }
        return null;
    }

    @Override
    public String getTargetName() {
        if (this.fTarget != null) {
            return this.fTarget.getName();
        }
        return null;
    }

    @Override
    public String getTargetValue() {
        if (this.fTarget != null) {
            return this.fTarget.getElementCDATA();
        }
        return null;
    }

    public boolean hasAttributeNonEqualDeltas() {
        return this.fHasAttrDeltas;
    }

    @Override
    public byte getType() {
        return 0;
    }
}

