/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.xml.core.delta;

import com.ibm.cic.common.xml.core.delta.IXMLDelta;
import com.ibm.cic.common.xml.core.model.IXMLTextModelItem;
import java.util.ArrayList;

public abstract class AbstractXMLDelta
implements IXMLDelta {
    private final ArrayList fChildren = new ArrayList();
    protected IXMLTextModelItem fSource;
    protected IXMLTextModelItem fTarget;
    protected IXMLDelta fParent;
    protected byte fDelta;

    public AbstractXMLDelta(IXMLTextModelItem source, IXMLTextModelItem target) {
        this.fSource = source;
        this.fTarget = target;
    }

    @Override
    public IXMLTextModelItem getSource() {
        return this.fSource;
    }

    @Override
    public IXMLTextModelItem getTarget() {
        return this.fTarget;
    }

    @Override
    public IXMLDelta[] getChildren() {
        IXMLDelta[] ret = new IXMLDelta[this.fChildren.size()];
        return this.fChildren.toArray(ret);
    }

    @Override
    public void setParent(IXMLDelta parent) {
        this.fParent = parent;
    }

    @Override
    public IXMLDelta getParent() {
        return this.fParent;
    }

    @Override
    public void addToDelta(byte flag) {
        this.fDelta = (byte)(this.fDelta | flag);
    }

    @Override
    public void addChild(IXMLDelta delta) {
        if (!this.fChildren.contains(delta)) {
            this.fChildren.add(delta);
            if (delta.getDelta() != 0) {
                this.fDelta = (byte)(this.fDelta | 0x20);
                IXMLDelta parent = this.getParent();
                while (parent != null) {
                    parent.addToDelta((byte)32);
                    parent = parent.getParent();
                }
            }
            delta.setParent(this);
        }
    }

    @Override
    public void acceptVisitor(IXMLDelta.IXMLDeltaVisitor v) {
        if (v.visit(this)) {
            for (IXMLDelta delta : this.fChildren) {
                delta.acceptVisitor(v);
            }
        }
    }

    @Override
    public boolean hasDelta(byte flag) {
        return (this.fDelta & flag) == flag;
    }
}

