/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.xml.core;

public class XMLString {
    private static final String UNI = "#";
    private static final String QUT = "quot";
    private static final String APOS = "apos";
    private static final String GT = "gt";
    private static final String LT = "lt";
    private static final String AMP = "amp";

    public static final String encode(String in) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < in.length()) {
            char c = in.charAt(i);
            if (c > '\u007f' || c < ' ') {
                buf.append('&');
                buf.append(UNI);
                buf.append(Integer.toString(c));
                buf.append(';');
            } else {
                switch (c) {
                    case '&': {
                        int idx;
                        buf.append(c);
                        if (i + 1 < in.length() && (idx = in.indexOf(59, i + 1)) > -1) {
                            String sub = in.substring(i + 1, idx);
                            if (AMP.equals(sub) || LT.equals(sub) || GT.equals(sub) || APOS.equals(sub) || QUT.equals(sub)) {
                                buf.append(sub);
                                i += sub.length();
                                break;
                            }
                            if (sub.startsWith(UNI)) {
                                String numCheck = sub.substring(1);
                                try {
                                    Integer.parseInt(numCheck);
                                    buf.append(sub);
                                    i += sub.length();
                                    break;
                                }
                                catch (Exception exception) {}
                            }
                        }
                        buf.append(AMP);
                        buf.append(';');
                        break;
                    }
                    case '<': {
                        buf.append('&');
                        buf.append(LT);
                        buf.append(';');
                        break;
                    }
                    case '>': {
                        buf.append('&');
                        buf.append(GT);
                        buf.append(';');
                        break;
                    }
                    case '\'': {
                        buf.append('&');
                        buf.append(APOS);
                        buf.append(';');
                        break;
                    }
                    case '\"': {
                        buf.append('&');
                        buf.append(QUT);
                        buf.append(';');
                        break;
                    }
                    default: {
                        buf.append(c);
                    }
                }
            }
            ++i;
        }
        return buf.toString();
    }
}

