/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.core.history.impl;

import com.ibm.cic.agent.internal.core.history.IFeatureInfo;
import com.ibm.cic.agent.internal.core.history.IOfferingInfo;
import com.ibm.cic.agent.internal.core.history.IProblemsResolvedInfo;
import com.ibm.cic.agent.internal.core.history.impl.XMLElement;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.Information;
import com.ibm.cic.common.core.model.SimpleIdentity;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.osgi.framework.Version;

public class OfferingInfoImpl
extends XMLElement
implements IOfferingInfo {
    private Information information = null;
    private IIdentity offeringIdentity = null;
    private Version offeringVersion = null;

    public OfferingInfoImpl() {
        super("offering");
    }

    public OfferingInfoImpl(IOfferingOrFix offering) {
        this();
        this.setOfferingIdentity(offering.getIdentity());
        this.setOfferingVersion(offering.getVersion());
        this.setInformation(offering.getInformation());
    }

    @Override
    public Information getInformation() {
        if (this.information == null) {
            String name = super.getAttribute("name");
            String version = super.getAttribute("localizedVersion");
            String provider = super.getAttribute("provider");
            String description = super.getAttribute("description");
            if (name != null) {
                this.information = new Information(name, version, description, provider);
            }
        }
        return this.information;
    }

    @Override
    public void setInformation(Information information) {
        if (information != null) {
            String description;
            String version;
            String name = information.getName();
            if (name != null) {
                super.addAttribute("name", name);
            }
            if ((version = information.getVersion()) != null) {
                super.addAttribute("localizedVersion", version);
            }
            if ((description = information.getDescription()) != null) {
                super.addAttribute("description", description);
            }
            this.information = information;
        }
    }

    @Override
    public IIdentity getOfferingIdentity() {
        String attrValue;
        if (this.offeringIdentity == null && (attrValue = super.getAttribute("id")) != null) {
            this.offeringIdentity = new SimpleIdentity(attrValue);
        }
        return this.offeringIdentity;
    }

    @Override
    public void setOfferingIdentity(IIdentity offeringIdentity) {
        String attrValue = offeringIdentity.getId();
        super.addAttribute("id", attrValue);
        this.offeringIdentity = offeringIdentity;
    }

    @Override
    public Version getOfferingVersion() {
        String attrValue;
        if (this.offeringVersion == null && (attrValue = super.getAttribute("version")) != null) {
            try {
                this.offeringVersion = Version.parseVersion((String)attrValue);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.offeringVersion = null;
            }
        }
        return this.offeringVersion;
    }

    @Override
    public void setOfferingVersion(Version offeringVersion) {
        String attrValue = offeringVersion.toString();
        super.addAttribute("version", attrValue);
        this.offeringVersion = offeringVersion;
    }

    @Override
    public void addFeature(IFeatureInfo featureInfo) {
        super.addChild(featureInfo);
    }

    @Override
    public Iterator getFeatures() {
        List children = super.getChildrenAsList();
        ArrayList featuresList = new ArrayList();
        int i = 0;
        while (i < children.size()) {
            if (children.get(i) instanceof IFeatureInfo) {
                featuresList.add(children.get(i));
            }
            ++i;
        }
        return featuresList.iterator();
    }

    @Override
    public int getNumberofFeatures() {
        int numOfFeatures = 0;
        List children = super.getChildrenAsList();
        int i = 0;
        while (i < children.size()) {
            if (children.get(i) instanceof IFeatureInfo) {
                ++numOfFeatures;
            }
            ++i;
        }
        return numOfFeatures;
    }

    @Override
    public String getOfferingName() {
        String name;
        Information info = this.getInformation();
        if (info != null && (name = info.getName()) != null && name.length() != 0) {
            return name;
        }
        return this.getOfferingIdentity().getId();
    }

    @Override
    public String getLocalizedVersion() {
        String version;
        Information info = this.getInformation();
        if (info != null && (version = info.getVersion()) != null && version.length() != 0) {
            return version;
        }
        return super.getAttribute("version");
    }

    @Override
    public void addProblemsResolved(IProblemsResolvedInfo problemsResolved) {
        super.addChild(problemsResolved);
    }

    @Override
    public Iterator getProblemsResolvedLists() {
        List children = super.getChildrenAsList();
        ArrayList problemsResolvedList = new ArrayList();
        int i = 0;
        while (i < children.size()) {
            if (children.get(i) instanceof IProblemsResolvedInfo) {
                problemsResolvedList.add(children.get(i));
            }
            ++i;
        }
        return problemsResolvedList.iterator();
    }

    @Override
    public int getNumberofProblemsResolvedLists() {
        int numOfProblemsResolved = 0;
        List children = super.getChildrenAsList();
        int i = 0;
        while (i < children.size()) {
            if (children.get(i) instanceof IProblemsResolvedInfo) {
                ++numOfProblemsResolved;
            }
            ++i;
        }
        return numOfProblemsResolved;
    }
}

