/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.core.debug;

import com.ibm.cic.agent.core.AbstractInstallOperation;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentActivator;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.api.IProfile;
import com.ibm.cic.agent.internal.core.InstallOrderManager;
import com.ibm.cic.agent.internal.core.InstallRegistry;
import com.ibm.cic.agent.internal.core.debug.InstallOperationDebug;
import com.ibm.cic.agent.internal.core.debug.InstallOperationDebugVariable;
import com.ibm.cic.common.core.internal.debug.IInstallOperationDebugValue;
import com.ibm.cic.common.core.internal.debug.IInstallOperationDebugVariable;
import com.ibm.cic.common.core.internal.utils.CicCommonCorePluginTrace;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IInstallableUnitContainer;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.InstallableUnitPair;
import com.ibm.cic.common.core.model.Phases;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.utils.IdentityUtil;
import com.ibm.cic.common.core.utils.LinkedProperties;
import com.ibm.cic.common.logging.Logger;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public abstract class InstallOperationDebugValue
extends UnicastRemoteObject
implements IInstallOperationDebugValue {
    private static final long serialVersionUID = 1L;
    private static final CicCommonCorePluginTrace trace = AgentActivator.getDefault().getTrace();
    private static final String NULL_VALUE_STRING = "null";
    protected InstallOperationDebugValue parentValue;
    protected InstallOperationDebugVariable variable;

    public InstallOperationDebugValue(InstallOperationDebugValue parentValue) throws IOException {
        this.parentValue = parentValue;
    }

    @Override
    public String toString() {
        String valueString = this.doGetValueString();
        return String.valueOf(valueString) + " [" + this.getTypeInfo().getName() + ']';
    }

    public String getTypeName() {
        trace.entering();
        String name = this.getTypeInfo().getName();
        trace.exiting((Object)name);
        return name;
    }

    public String getValueString() {
        trace.entering();
        String valueString = this.doGetValueString();
        trace.exiting((Object)valueString);
        return valueString;
    }

    public IInstallOperationDebugVariable[] getVariables() {
        Object[] variables;
        trace.entering();
        if (this.parentValue != null && this.getValueObject() == null) {
            variables = InstallOperationDebugVariable.EMPTY_VARIABLES;
        } else {
            Map<String, Method> map = this.getTypeInfo().getCreateVarsMap();
            Map<String, Method> visiblesMap = this.getTypeInfo().getVisiblesMap();
            ArrayList<IInstallOperationDebugVariable> vars = new ArrayList<IInstallOperationDebugVariable>(map.size());
            for (Map.Entry<String, Method> entry : map.entrySet()) {
                String name = entry.getKey();
                Method visiblesMethod = visiblesMap.get(name);
                if (visiblesMethod != null) {
                    try {
                        Boolean isVisible = (Boolean)visiblesMethod.invoke((Object)this, new Object[0]);
                        if (!isVisible.booleanValue()) {
                            continue;
                        }
                    }
                    catch (Exception e) {
                        Logger.getGlobalLogger().error((Throwable)e);
                    }
                }
                Method method = entry.getValue();
                try {
                    vars.add((IInstallOperationDebugVariable)method.invoke((Object)this, name));
                }
                catch (Exception e) {
                    Logger.getGlobalLogger().error((Throwable)e);
                }
            }
            variables = vars.toArray(new IInstallOperationDebugVariable[vars.size()]);
        }
        trace.exiting(variables);
        return variables;
    }

    public boolean hasVariables() {
        boolean hasVars;
        trace.entering();
        if (this.parentValue == null) {
            hasVars = !this.getTypeInfo().getGettersMap().isEmpty();
        } else {
            boolean bl = hasVars = this.getValueObject() != null;
        }
        if (InstallOperationDebugValue.trace.traceExiting) {
            trace.exiting((Object)hasVars);
        }
        return hasVars;
    }

    protected String doGetValueString() {
        Object obj = this.getValueObject();
        return obj == null ? NULL_VALUE_STRING : obj.toString();
    }

    protected Object getValueObject() {
        return this.parentValue == null ? null : this.parentValue.getValueObject(this.variable.getName());
    }

    protected Object getValueObject(String variableName) {
        try {
            return this.getTypeInfo().getGettersMap().get(variableName).invoke((Object)this, new Object[0]);
        }
        catch (Exception e) {
            Logger.getGlobalLogger().error((Throwable)e);
            return null;
        }
    }

    protected boolean supportsModification() {
        if (this.parentValue != null) {
            return this.parentValue.supportsModification(this.variable.getName());
        }
        return false;
    }

    protected boolean supportsModification(String variableName) {
        return this.getTypeInfo().getSettersMap().get(variableName) != null;
    }

    protected boolean verifyValue(String expression) {
        return false;
    }

    protected void setValue(String expression) {
        if (this.supportsModification() && this.verifyValue(expression)) {
            Object obj = this.toValueObject(expression.trim());
            Method method = this.parentValue.getTypeInfo().getSettersMap().get(this.variable.getName());
            try {
                method.invoke((Object)this.parentValue, obj);
            }
            catch (Exception e) {
                Logger.getGlobalLogger().error((Throwable)e);
            }
        }
    }

    protected Object toValueObject(String expression) {
        return expression;
    }

    protected abstract TypeInfo getTypeInfo();

    public static class ArrayValue
    extends InstallOperationDebugValue {
        private static final long serialVersionUID = 1L;
        private static final TypeInfo TYPE_INFO = new TypeInfo("[]");
        private final String typeName;
        private transient Constructor constructor;
        private transient Method valueOfMethod;

        public ArrayValue(InstallOperationDebugValue parentValue, TypeInfo elementTypeInfo) throws IOException {
            super(parentValue);
            this.typeName = String.valueOf(elementTypeInfo.getName()) + "[]";
            this.constructor = this.findConstructor(elementTypeInfo.getValueClass());
            this.valueOfMethod = this.findValueOfMethod(elementTypeInfo.getValueClass());
        }

        @Override
        public TypeInfo getTypeInfo() {
            return TYPE_INFO;
        }

        @Override
        public String getTypeName() {
            return this.typeName;
        }

        @Override
        protected Object getValueObject(String variableName) {
            Object[] arrayValue = (Object[])this.getValueObject();
            if (arrayValue == null) {
                return null;
            }
            int index = Integer.parseInt(variableName.substring(1, variableName.length() - 1));
            return arrayValue[index];
        }

        @Override
        protected boolean supportsModification(String variableName) {
            return false;
        }

        @Override
        public IInstallOperationDebugVariable[] getVariables() {
            Object[] variables;
            trace.entering();
            Object[] arrayValue = (Object[])this.getValueObject();
            if (arrayValue == null || arrayValue.length == 0) {
                variables = InstallOperationDebugVariable.EMPTY_VARIABLES;
            } else {
                ArrayList<InstallOperationDebugVariable> vars = new ArrayList<InstallOperationDebugVariable>(arrayValue.length);
                int i = 0;
                while (i < arrayValue.length) {
                    String name = "[" + i + ']';
                    try {
                        InstallOperationDebugValue value = (InstallOperationDebugValue)this.constructor.newInstance(this);
                        vars.add(new InstallOperationDebugVariable(name, value));
                    }
                    catch (Exception e) {
                        Logger.getGlobalLogger().error((Throwable)e);
                    }
                    ++i;
                }
                variables = vars.toArray(new IInstallOperationDebugVariable[vars.size()]);
            }
            trace.exiting(variables);
            return variables;
        }

        @Override
        public boolean hasVariables() {
            boolean hasVars;
            trace.entering();
            Object[] arrayValue = (Object[])this.getValueObject();
            boolean bl = hasVars = arrayValue != null && arrayValue.length != 0;
            if (trace.traceExiting) {
                trace.exiting((Object)hasVars);
            }
            return hasVars;
        }

        @Override
        protected String doGetValueString() {
            Object[] arrayValue = (Object[])this.getValueObject();
            if (arrayValue == null) {
                return InstallOperationDebugValue.NULL_VALUE_STRING;
            }
            StringBuilder sb = new StringBuilder(128);
            sb.append('[');
            int i = 0;
            while (i < arrayValue.length) {
                Object elemValue = arrayValue[i];
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(this.getElemValueString(elemValue));
                ++i;
            }
            sb.append(']');
            return sb.toString();
        }

        private String getElemValueString(Object elemValue) {
            if (elemValue == null) {
                return InstallOperationDebugValue.NULL_VALUE_STRING;
            }
            if (this.valueOfMethod != null) {
                try {
                    return (String)this.valueOfMethod.invoke(null, elemValue);
                }
                catch (Exception e) {
                    Logger.getGlobalLogger().error((Throwable)e);
                }
            }
            return elemValue.toString();
        }

        private Constructor findConstructor(Class elementValueType) {
            assert (elementValueType != this.getClass());
            Constructor<?>[] ctors = elementValueType.getDeclaredConstructors();
            assert (ctors.length == 1);
            return ctors[0];
        }

        private Method findValueOfMethod(Class elementValueType) {
            Method[] methods;
            Method[] methodArray = methods = elementValueType.getDeclaredMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                String name;
                Method method = methodArray[n2];
                int modifiers = method.getModifiers();
                if (Modifier.isStatic(modifiers) && "valueOf".equals(name = method.getName())) {
                    return method;
                }
                ++n2;
            }
            return null;
        }
    }

    public static class BooleanValue
    extends PrimitiveValue {
        private static final long serialVersionUID = 1L;
        public static final TypeInfo TYPE_INFO = new TypeInfo("boolean", BooleanValue.class, Boolean.TYPE);

        public BooleanValue(InstallOperationDebugValue parentValue) throws IOException {
            super(parentValue);
        }

        @Override
        public TypeInfo getTypeInfo() {
            return TYPE_INFO;
        }

        @Override
        protected boolean verifyValue(String expression) {
            if (expression == null) {
                return false;
            }
            String trimmedExpression = expression.trim();
            return Boolean.TRUE.toString().equalsIgnoreCase(trimmedExpression) || Boolean.FALSE.toString().equalsIgnoreCase(trimmedExpression);
        }

        @Override
        protected Object toValueObject(String expression) {
            return Boolean.valueOf(expression);
        }
    }

    public static class Context
    extends InstallOperationDebugValue {
        private static final long serialVersionUID = 1L;
        public static final TypeInfo TYPE_INFO = new TypeInfo("InstallContext", Context.class, InstallContext.class);

        public Context(InstallOperationDebugValue parentValue) throws IOException {
            super(parentValue);
        }

        @Override
        public TypeInfo getTypeInfo() {
            return TYPE_INFO;
        }

        public InstallOperationDebugVariable createVar_id(String name) throws IOException {
            return InstallOperationDebugVariable.createStringVariable(name, this);
        }

        public String get_id() {
            InstallContext context = (InstallContext)this.getValueObject();
            return context == null ? null : context.getId();
        }

        public InstallOperationDebugVariable createVar_parentInstallContext(String name) throws IOException {
            return InstallOperationDebugVariable.createContextVariable(name, this);
        }

        public InstallContext get_parentInstallContext() {
            InstallContext context = (InstallContext)this.getValueObject();
            return context == null ? null : context.getParentContext();
        }

        public InstallOperationDebugVariable createVar_parentPackageGroup(String name) throws IOException {
            return InstallOperationDebugVariable.createPackageGroupVariable(name, this);
        }

        public Profile get_parentPackageGroup() {
            InstallContext context = (InstallContext)this.getValueObject();
            return context == null ? null : context.getEnclosingProfile();
        }

        public InstallOperationDebugVariable createVar_subInstallContexts(String name) throws IOException {
            return InstallOperationDebugVariable.createArrayVariable(name, this, TYPE_INFO);
        }

        public InstallContext[] get_subInstallContexts() {
            InstallContext context = (InstallContext)this.getValueObject();
            return context == null ? null : context.getSubcontexts();
        }

        public InstallOperationDebugVariable createVar_properties(String name) throws IOException {
            return InstallOperationDebugVariable.createPropertiesVariable(name, this);
        }

        public LinkedProperties get_properties() {
            InstallContext context = (InstallContext)this.getValueObject();
            return context == null ? null : context.getLocalProperties();
        }

        public static String valueOf(InstallContext context) {
            if (context == null) {
                return InstallOperationDebugValue.NULL_VALUE_STRING;
            }
            return context.getId();
        }

        @Override
        protected String doGetValueString() {
            return Context.valueOf((InstallContext)this.getValueObject());
        }
    }

    public static class EngineOperation
    extends InstallOperationDebugValue {
        private static final long serialVersionUID = 1L;
        public static final TypeInfo TYPE_INFO = new TypeInfo("EngineOperation", EngineOperation.class, InstallOrderManager.EngineOperation.class);

        public EngineOperation(InstallOperationDebugValue parentValue) throws IOException {
            super(parentValue);
        }

        @Override
        public TypeInfo getTypeInfo() {
            return TYPE_INFO;
        }

        public InstallOperationDebugVariable createVar_id(String name) throws IOException {
            return InstallOperationDebugVariable.createIntVariable(name, this);
        }

        public int get_id() {
            InstallOrderManager.EngineOperation engineOperation = (InstallOrderManager.EngineOperation)this.getValueObject();
            return engineOperation == null ? 0 : engineOperation.getId();
        }

        public InstallOperationDebugVariable createVar_installContext(String name) throws IOException {
            return InstallOperationDebugVariable.createContextVariable(name, this);
        }

        public InstallContext get_installContext() {
            InstallOrderManager.EngineOperation engineOperation = (InstallOrderManager.EngineOperation)this.getValueObject();
            return engineOperation == null ? null : engineOperation.getContext();
        }

        public InstallOperationDebugVariable createVar_unitPairs(String name) throws IOException {
            return InstallOperationDebugVariable.createArrayVariable(name, this, Pair.TYPE_INFO);
        }

        public InstallableUnitPair[] get_unitPairs() {
            InstallOrderManager.EngineOperation engineOperation = (InstallOrderManager.EngineOperation)this.getValueObject();
            return engineOperation == null ? null : engineOperation.getPairs().getPairs();
        }

        public static String valueOf(InstallOrderManager.EngineOperation engineOperation) {
            if (engineOperation == null) {
                return InstallOperationDebugValue.NULL_VALUE_STRING;
            }
            return InstallOrderManager.EngineOperation.toString(engineOperation);
        }

        @Override
        protected String doGetValueString() {
            return EngineOperation.valueOf((InstallOrderManager.EngineOperation)this.getValueObject());
        }
    }

    public static abstract class EnumValue
    extends PrimitiveValue {
        private static final long serialVersionUID = 1L;
        private final Enum[] values;

        public EnumValue(InstallOperationDebugValue parentValue, Enum[] values) throws IOException {
            super(parentValue);
            this.values = values;
        }

        @Override
        protected boolean verifyValue(String expression) {
            if (expression == null) {
                return false;
            }
            String trimmedExpression = expression.trim();
            Enum[] enumArray = this.values;
            int n = this.values.length;
            int n2 = 0;
            while (n2 < n) {
                Enum value = enumArray[n2];
                if (value.toString().equalsIgnoreCase(trimmedExpression)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public static String valueOf(Enum value) {
            if (value == null) {
                return InstallOperationDebugValue.NULL_VALUE_STRING;
            }
            return value.toString().toLowerCase(Locale.ENGLISH);
        }

        @Override
        protected String doGetValueString() {
            return EnumValue.valueOf((Enum)this.getValueObject());
        }
    }

    public static class Feature
    extends InstallOperationDebugValue {
        private static final long serialVersionUID = 1L;
        public static final TypeInfo TYPE_INFO = new TypeInfo("IFeature", Feature.class, IFeature.class);

        public Feature(InstallOperationDebugValue parentValue) throws IOException {
            super(parentValue);
        }

        @Override
        public TypeInfo getTypeInfo() {
            return TYPE_INFO;
        }

        public InstallOperationDebugVariable createVar_id(String name) throws IOException {
            return InstallOperationDebugVariable.createStringVariable(name, this);
        }

        public String get_id() {
            IFeature feature = (IFeature)this.getValueObject();
            return feature == null ? null : feature.getIdentity().getId();
        }

        public InstallOperationDebugVariable createVar_name(String name) throws IOException {
            return InstallOperationDebugVariable.createStringVariable(name, this);
        }

        public String get_name() {
            IFeature feature = (IFeature)this.getValueObject();
            return feature == null ? null : OfferingUtil.getFeatureName((IFeature)feature);
        }

        public static String valueOf(IFeature feature) {
            if (feature == null) {
                return InstallOperationDebugValue.NULL_VALUE_STRING;
            }
            return feature.getIdentity().getId();
        }

        @Override
        protected String doGetValueString() {
            return Feature.valueOf((IFeature)this.getValueObject());
        }
    }

    public static class ForceStatusValue
    extends EnumValue {
        private static final long serialVersionUID = 1L;
        public static final TypeInfo TYPE_INFO = new TypeInfo("ForceStatus", ForceStatusValue.class, InstallOperationDebug.ForceStatus.class);

        public ForceStatusValue(InstallOperationDebugValue parentValue) throws IOException {
            super(parentValue, InstallOperationDebug.ForceStatus.values());
        }

        @Override
        public TypeInfo getTypeInfo() {
            return TYPE_INFO;
        }

        @Override
        protected Object toValueObject(String expression) {
            return InstallOperationDebug.ForceStatus.valueOf(expression.toUpperCase(Locale.ENGLISH));
        }
    }

    public static class InstallInfo
    extends InstallOperationDebugValue {
        private static final long serialVersionUID = 1L;
        public static final TypeInfo TYPE_INFO = new TypeInfo("InstallInfo", InstallInfo.class, InstallRegistry.class);

        public InstallInfo(InstallOperationDebugValue parentValue) throws IOException {
            super(parentValue);
        }

        @Override
        public TypeInfo getTypeInfo() {
            return TYPE_INFO;
        }

        public InstallOperationDebugVariable createVar_packageGroups(String name) throws IOException {
            return InstallOperationDebugVariable.createArrayVariable(name, this, PackageGroup.TYPE_INFO);
        }

        public Profile[] get_packageGroups() {
            InstallRegistry registry = (InstallRegistry)this.getValueObject();
            return registry == null ? null : registry.getProfiles();
        }

        public InstallOperationDebugVariable createVar_properties(String name) throws IOException {
            return InstallOperationDebugVariable.createPropertiesVariable(name, this);
        }

        public LinkedProperties get_properties() {
            InstallRegistry registry = (InstallRegistry)this.getValueObject();
            return registry == null ? null : InstallInfo.getProperties(registry);
        }

        private static LinkedProperties getProperties(InstallRegistry registry) {
            LinkedProperties props = registry.getProperties();
            LinkedProperties newProps = new LinkedProperties();
            newProps.putAll(props);
            newProps.put((Object)"cacheLocation", (Object)registry.getCacheLocation());
            return newProps;
        }

        public static String valueOf(InstallRegistry registry) {
            if (registry == null) {
                return InstallOperationDebugValue.NULL_VALUE_STRING;
            }
            return registry.getProperty("cic.appDataLocation");
        }

        @Override
        protected String doGetValueString() {
            return InstallInfo.valueOf((InstallRegistry)this.getValueObject());
        }
    }

    public static class IntValue
    extends PrimitiveValue {
        private static final long serialVersionUID = 1L;
        public static final TypeInfo TYPE_INFO = new TypeInfo("int", IntValue.class, Integer.TYPE);

        public IntValue(InstallOperationDebugValue parentValue) throws IOException {
            super(parentValue);
        }

        @Override
        public TypeInfo getTypeInfo() {
            return TYPE_INFO;
        }
    }

    public static class Job
    extends InstallOperationDebugValue {
        private static final long serialVersionUID = 1L;
        public static final TypeInfo TYPE_INFO = new TypeInfo("AgentJob", Job.class, AgentJob.class);

        public Job(InstallOperationDebugValue parentValue) throws IOException {
            super(parentValue);
        }

        @Override
        public TypeInfo getTypeInfo() {
            return TYPE_INFO;
        }

        public InstallOperationDebugVariable createVar_type(String name) throws IOException {
            return InstallOperationDebugVariable.createStringVariable(name, this);
        }

        public String get_type() {
            AgentJob job = (AgentJob)this.getValueObject();
            return job == null ? null : job.getType().getJobType();
        }

        public InstallOperationDebugVariable createVar_package(String name) throws IOException {
            return InstallOperationDebugVariable.createPackageVariable(name, this);
        }

        public IOfferingOrFix get_package() {
            AgentJob job = (AgentJob)this.getValueObject();
            return job == null ? null : job.getOfferingOrFix();
        }

        public InstallOperationDebugVariable createVar_features(String name) throws IOException {
            return InstallOperationDebugVariable.createArrayVariable(name, this, Feature.TYPE_INFO);
        }

        public IFeature[] get_features() {
            AgentJob job = (AgentJob)this.getValueObject();
            return job == null ? null : job.getFeaturesArray();
        }

        public InstallOperationDebugVariable createVar_packageGroup(String name) throws IOException {
            return InstallOperationDebugVariable.createPackageGroupVariable(name, this);
        }

        public Profile get_packageGroup() {
            AgentJob job = (AgentJob)this.getValueObject();
            return job == null ? null : job.getProfile();
        }
    }

    public static class Operation
    extends InstallOperationDebugValue {
        private static final long serialVersionUID = 1L;
        public static final TypeInfo TYPE_INFO = new TypeInfo("InstallOperation", Operation.class, AbstractInstallOperation.class);

        public Operation(InstallOperationDebugValue parentValue) throws IOException {
            super(parentValue);
        }

        @Override
        public TypeInfo getTypeInfo() {
            return TYPE_INFO;
        }

        public InstallOperationDebugVariable createVar_undoing(String name) throws IOException {
            return InstallOperationDebugVariable.createBooleanVariable(name, this);
        }

        public boolean get_undoing() {
            AbstractInstallOperation op = (AbstractInstallOperation)this.getValueObject();
            return op == null ? false : op.isUndoing();
        }

        public InstallOperationDebugVariable createVar_phase(String name) throws IOException {
            return InstallOperationDebugVariable.createStringVariable(name, this);
        }

        public String get_phase() {
            AbstractInstallOperation op = (AbstractInstallOperation)this.getValueObject();
            return op == null ? null : Phases.phaseToName((int)op.getPhase());
        }

        public InstallOperationDebugVariable createVar_unit(String name) throws IOException {
            return InstallOperationDebugVariable.createUnitVariable(name, this);
        }

        public IInstallableUnit get_unit() {
            AbstractInstallOperation op = (AbstractInstallOperation)this.getValueObject();
            return op == null ? null : op.getUnit();
        }

        public InstallOperationDebugVariable createVar_name(String name) throws IOException {
            return InstallOperationDebugVariable.createStringVariable(name, this);
        }

        public String get_name() {
            AbstractInstallOperation op = (AbstractInstallOperation)this.getValueObject();
            return op == null ? null : op.getOperationData().getElementName();
        }

        public InstallOperationDebugVariable createVar_index(String name) throws IOException {
            return InstallOperationDebugVariable.createIntVariable(name, this);
        }

        public int get_index() {
            AbstractInstallOperation op = (AbstractInstallOperation)this.getValueObject();
            return op == null ? 0 : op.getOperationIndex();
        }

        public InstallOperationDebugVariable createVar_resumeAction(String name) throws IOException {
            return InstallOperationDebugVariable.createResumeActionVariable(name, this);
        }

        public InstallOperationDebug.ResumeAction get_resumeAction() {
            return InstallOperationDebug.INSTANCE.getResumeAction();
        }

        public boolean visible_resumeAction() {
            return InstallOperationDebug.INSTANCE.getResumeAction() != null;
        }

        public static String valueOf(AbstractInstallOperation op) {
            if (op == null) {
                return InstallOperationDebugValue.NULL_VALUE_STRING;
            }
            return InstallOperationDebug.INSTANCE.toString(op);
        }

        @Override
        protected String doGetValueString() {
            return Operation.valueOf((AbstractInstallOperation)this.getValueObject());
        }
    }

    public static class Package
    extends InstallOperationDebugValue {
        private static final long serialVersionUID = 1L;
        public static final TypeInfo TYPE_INFO = new TypeInfo("Package", Package.class, IOfferingOrFix.class);

        public Package(InstallOperationDebugValue parentValue) throws IOException {
            super(parentValue);
        }

        @Override
        public TypeInfo getTypeInfo() {
            return TYPE_INFO;
        }

        public InstallOperationDebugVariable createVar_kind(String name) throws IOException {
            return InstallOperationDebugVariable.createStringVariable(name, this);
        }

        public String get_kind() {
            IOfferingOrFix oof = (IOfferingOrFix)this.getValueObject();
            return oof == null ? null : Package.getPackageKind(oof);
        }

        public InstallOperationDebugVariable createVar_name(String name) throws IOException {
            return InstallOperationDebugVariable.createStringVariable(name, this);
        }

        public String get_name() {
            IOfferingOrFix oof = (IOfferingOrFix)this.getValueObject();
            return oof == null ? null : oof.getName();
        }

        public InstallOperationDebugVariable createVar_version(String name) throws IOException {
            return InstallOperationDebugVariable.createStringVariable(name, this);
        }

        public String get_version() {
            IOfferingOrFix oof = (IOfferingOrFix)this.getValueObject();
            return oof == null ? null : OfferingUtil.getDisplayableVersion((IOfferingOrFix)oof);
        }

        public InstallOperationDebugVariable createVar_id(String name) throws IOException {
            return InstallOperationDebugVariable.createStringVariable(name, this);
        }

        public String get_id() {
            IOfferingOrFix oof = (IOfferingOrFix)this.getValueObject();
            return oof == null ? null : oof.getIdentity().getId();
        }

        public InstallOperationDebugVariable createVar_internalVersion(String name) throws IOException {
            return InstallOperationDebugVariable.createStringVariable(name, this);
        }

        public String get_internalVersion() {
            IOfferingOrFix oof = (IOfferingOrFix)this.getValueObject();
            return oof == null ? null : oof.getVersion().toString();
        }

        public InstallOperationDebugVariable createVar_installedFeatures(String name) throws IOException {
            return InstallOperationDebugVariable.createArrayVariable(name, this, Feature.TYPE_INFO);
        }

        public IFeature[] get_installedFeatures() {
            return this.getInstalledFeatures((IOfferingOrFix)this.getValueObject());
        }

        public boolean visible_installedFeatures() {
            return this.getInstalledFeatures((IOfferingOrFix)this.getValueObject()) != null;
        }

        public static String valueOf(IOfferingOrFix oof) {
            if (oof == null) {
                return InstallOperationDebugValue.NULL_VALUE_STRING;
            }
            return String.valueOf(Package.getPackageKind(oof)) + ' ' + IdentityUtil.getVersionedId((IContent)oof);
        }

        @Override
        protected String doGetValueString() {
            return Package.valueOf((IOfferingOrFix)this.getValueObject());
        }

        private static String getPackageKind(IOfferingOrFix oof) {
            return oof instanceof IOffering ? "offering" : "fix";
        }

        private IFeature[] getInstalledFeatures(IOfferingOrFix oof) {
            if (!(oof instanceof IOffering)) {
                return null;
            }
            IOffering offering = (IOffering)oof;
            Profile profile = this.getEnclosingProfile();
            if (profile == null) {
                return null;
            }
            return Agent.getInstance().getInstalledFeatures((IProfile)profile, offering);
        }

        private Profile getEnclosingProfile() {
            if (this.parentValue == null || !(this.parentValue instanceof ArrayValue)) {
                return null;
            }
            ArrayValue arrayValue = (ArrayValue)this.parentValue;
            if (arrayValue.parentValue == null || !(arrayValue.parentValue instanceof PackageGroup)) {
                return null;
            }
            PackageGroup group = (PackageGroup)arrayValue.parentValue;
            return (Profile)group.getValueObject();
        }
    }

    public static class PackageGroup
    extends InstallOperationDebugValue {
        private static final long serialVersionUID = 1L;
        public static final TypeInfo TYPE_INFO = new TypeInfo("PackageGroup", PackageGroup.class, Profile.class);

        public PackageGroup(InstallOperationDebugValue parentValue) throws IOException {
            super(parentValue);
        }

        @Override
        public TypeInfo getTypeInfo() {
            return TYPE_INFO;
        }

        public InstallOperationDebugVariable createVar_id(String name) throws IOException {
            return InstallOperationDebugVariable.createStringVariable(name, this);
        }

        public String get_id() {
            Profile profile = (Profile)this.getValueObject();
            return profile == null ? null : profile.getProfileId();
        }

        public InstallOperationDebugVariable createVar_installLocation(String name) throws IOException {
            return InstallOperationDebugVariable.createStringVariable(name, this);
        }

        public String get_installLocation() {
            Profile profile = (Profile)this.getValueObject();
            return profile == null ? null : profile.getInstallLocation();
        }

        public InstallOperationDebugVariable createVar_kind(String name) throws IOException {
            return InstallOperationDebugVariable.createStringVariable(name, this);
        }

        public String get_kind() {
            Profile profile = (Profile)this.getValueObject();
            return profile == null ? null : profile.getProfileKind();
        }

        public InstallOperationDebugVariable createVar_rootInstallContext(String name) throws IOException {
            return InstallOperationDebugVariable.createContextVariable(name, this);
        }

        public InstallContext get_rootInstallContext() {
            Profile profile = (Profile)this.getValueObject();
            return profile == null ? null : profile.getRootContext();
        }

        public InstallOperationDebugVariable createVar_packages(String name) throws IOException {
            return InstallOperationDebugVariable.createArrayVariable(name, this, Package.TYPE_INFO);
        }

        public IOfferingOrFix[] get_packages() {
            Profile profile = (Profile)this.getValueObject();
            return profile == null ? null : this.getInstalledOfferingsAndFixes(profile);
        }

        public InstallOperationDebugVariable createVar_properties(String name) throws IOException {
            return InstallOperationDebugVariable.createPropertiesVariable(name, this);
        }

        public LinkedProperties get_properties() {
            Profile profile = (Profile)this.getValueObject();
            return profile == null ? null : profile.getAllData();
        }

        public static String valueOf(Profile profile) {
            if (profile == null) {
                return InstallOperationDebugValue.NULL_VALUE_STRING;
            }
            return profile.getProfileId();
        }

        @Override
        protected String doGetValueString() {
            return PackageGroup.valueOf((Profile)this.getValueObject());
        }

        private IOfferingOrFix[] getInstalledOfferingsAndFixes(Profile profile) {
            IOffering[] offerings = profile.getInstalledOfferings();
            IFix[] fixes = profile.getInstalledFixes();
            IOfferingOrFix[] offeringsAndFixes = new IOfferingOrFix[offerings.length + fixes.length];
            System.arraycopy(offerings, 0, offeringsAndFixes, 0, offerings.length);
            System.arraycopy(fixes, 0, offeringsAndFixes, offerings.length, fixes.length);
            return offeringsAndFixes;
        }
    }

    public static class Pair
    extends InstallOperationDebugValue {
        private static final long serialVersionUID = 1L;
        public static final TypeInfo TYPE_INFO = new TypeInfo("InstallableUnitPair", Pair.class, InstallableUnitPair.class);

        public Pair(InstallOperationDebugValue parentValue) throws IOException {
            super(parentValue);
        }

        @Override
        public TypeInfo getTypeInfo() {
            return TYPE_INFO;
        }

        public InstallOperationDebugVariable createVar_from(String name) throws IOException {
            return InstallOperationDebugVariable.createUnitVariable(name, this);
        }

        public IInstallableUnit get_from() {
            InstallableUnitPair pair = (InstallableUnitPair)this.getValueObject();
            return pair == null ? null : pair.getFrom();
        }

        public InstallOperationDebugVariable createVar_to(String name) throws IOException {
            return InstallOperationDebugVariable.createUnitVariable(name, this);
        }

        public IInstallableUnit get_to() {
            InstallableUnitPair pair = (InstallableUnitPair)this.getValueObject();
            return pair == null ? null : pair.getTo();
        }

        public static String valueOf(InstallableUnitPair pair) {
            if (pair == null) {
                return InstallOperationDebugValue.NULL_VALUE_STRING;
            }
            return pair.toQualifiedString();
        }

        @Override
        protected String doGetValueString() {
            return Pair.valueOf((InstallableUnitPair)this.getValueObject());
        }
    }

    public static abstract class PrimitiveValue
    extends InstallOperationDebugValue {
        private static final long serialVersionUID = 1L;

        public PrimitiveValue(InstallOperationDebugValue parentValue) throws IOException {
            super(parentValue);
        }

        @Override
        public IInstallOperationDebugVariable[] getVariables() {
            return InstallOperationDebugVariable.EMPTY_VARIABLES;
        }

        @Override
        public boolean hasVariables() {
            return false;
        }
    }

    public static class PropertiesValue
    extends InstallOperationDebugValue {
        private static final long serialVersionUID = 1L;
        private static final TypeInfo TYPE_INFO = new TypeInfo("Properties");

        public PropertiesValue(InstallOperationDebugValue parentValue) throws IOException {
            super(parentValue);
        }

        @Override
        public TypeInfo getTypeInfo() {
            return TYPE_INFO;
        }

        @Override
        protected Object getValueObject(String variableName) {
            LinkedProperties properties = (LinkedProperties)this.getValueObject();
            if (properties == null) {
                return null;
            }
            String propName = variableName.substring(1, variableName.length() - 1);
            return properties.getProperty(propName);
        }

        @Override
        protected boolean supportsModification(String variableName) {
            return false;
        }

        @Override
        public IInstallOperationDebugVariable[] getVariables() {
            Object[] variables;
            trace.entering();
            LinkedProperties properties = (LinkedProperties)this.getValueObject();
            if (properties == null || properties.isEmpty()) {
                variables = InstallOperationDebugVariable.EMPTY_VARIABLES;
            } else {
                ArrayList<InstallOperationDebugVariable> vars = new ArrayList<InstallOperationDebugVariable>(properties.size());
                Set entries = properties.entrySet();
                for (Map.Entry entry : entries) {
                    String name = String.valueOf('[') + (String)entry.getKey() + ']';
                    try {
                        StringValue value = new StringValue(this);
                        vars.add(new InstallOperationDebugVariable(name, value));
                    }
                    catch (Exception e) {
                        Logger.getGlobalLogger().error((Throwable)e);
                    }
                }
                variables = vars.toArray(new IInstallOperationDebugVariable[vars.size()]);
            }
            trace.exiting(variables);
            return variables;
        }

        @Override
        public boolean hasVariables() {
            boolean hasVars;
            trace.entering();
            LinkedProperties properties = (LinkedProperties)this.getValueObject();
            boolean bl = hasVars = properties != null && !properties.isEmpty();
            if (trace.traceExiting) {
                trace.exiting((Object)hasVars);
            }
            return hasVars;
        }
    }

    public static class ResumeActionValue
    extends InstallOperationDebugValue {
        private static final long serialVersionUID = 1L;
        public static final TypeInfo TYPE_INFO = new TypeInfo("ResumeAction", ResumeActionValue.class, InstallOperationDebug.ResumeAction.class);

        public ResumeActionValue(InstallOperationDebugValue parentValue) throws IOException {
            super(parentValue);
        }

        @Override
        public TypeInfo getTypeInfo() {
            return TYPE_INFO;
        }

        public InstallOperationDebugVariable createVar_enabled(String name) throws IOException {
            return InstallOperationDebugVariable.createBooleanVariable(name, this);
        }

        public boolean get_enabled() {
            InstallOperationDebug.ResumeAction resumeAction = (InstallOperationDebug.ResumeAction)this.getValueObject();
            return resumeAction == null ? false : resumeAction.enabled;
        }

        public void set_enabled(boolean enabled) {
            InstallOperationDebug.ResumeAction resumeAction = (InstallOperationDebug.ResumeAction)this.getValueObject();
            if (resumeAction != null) {
                resumeAction.enabled = enabled;
            }
        }

        public InstallOperationDebugVariable createVar_when(String name) throws IOException {
            return InstallOperationDebugVariable.createWhenVariable(name, this);
        }

        public InstallOperationDebug.When get_when() {
            InstallOperationDebug.ResumeAction resumeAction = (InstallOperationDebug.ResumeAction)this.getValueObject();
            return resumeAction == null ? InstallOperationDebug.When.BEFORE : resumeAction.when;
        }

        public void set_when(InstallOperationDebug.When when) {
            InstallOperationDebug.ResumeAction resumeAction = (InstallOperationDebug.ResumeAction)this.getValueObject();
            if (resumeAction != null) {
                resumeAction.when = when;
            }
        }

        public InstallOperationDebugVariable createVar_forceStatus(String name) throws IOException {
            return InstallOperationDebugVariable.createForceStatusVariable(name, this);
        }

        public InstallOperationDebug.ForceStatus get_forceStatus() {
            InstallOperationDebug.ResumeAction resumeAction = (InstallOperationDebug.ResumeAction)this.getValueObject();
            return resumeAction == null ? InstallOperationDebug.ForceStatus.ERROR : resumeAction.forceStatus;
        }

        public void set_forceStatus(InstallOperationDebug.ForceStatus forceStatus) {
            InstallOperationDebug.ResumeAction resumeAction = (InstallOperationDebug.ResumeAction)this.getValueObject();
            if (resumeAction != null) {
                resumeAction.forceStatus = forceStatus;
            }
        }
    }

    public static class StringValue
    extends PrimitiveValue {
        private static final long serialVersionUID = 1L;
        public static final TypeInfo TYPE_INFO = new TypeInfo("String", StringValue.class, String.class);

        public StringValue(InstallOperationDebugValue parentValue) throws IOException {
            super(parentValue);
        }

        @Override
        public TypeInfo getTypeInfo() {
            return TYPE_INFO;
        }
    }

    public static class TypeInfo {
        private static final String CREATE_VAR_PREFIX = "createVar_";
        private static final String GETTER_PREFIX = "get_";
        private static final String SETTER_PREFIX = "set_";
        private static final String VISIBLE_PREFIX = "visible_";
        private static final Map<String, Method> EMPTY_METHODS_MAP = Collections.emptyMap();
        private final String name;
        private final Class valueClass;
        private final Class valueObjectClass;
        private final Map<String, Method> createVarsMap;
        private final Map<String, Method> gettersMap;
        private final Map<String, Method> settersMap;
        private final Map<String, Method> visiblesMap;

        private TypeInfo(String name, Class valueClass, Class valueObjectClass, Map<String, Method> createVarsMap, Map<String, Method> gettersMap, Map<String, Method> settersMap, Map<String, Method> visiblesMap) {
            this.name = name;
            this.valueClass = valueClass;
            this.valueObjectClass = valueObjectClass;
            assert (createVarsMap.keySet().equals(gettersMap.keySet()));
            this.createVarsMap = createVarsMap;
            this.gettersMap = gettersMap;
            assert (gettersMap.keySet().containsAll(settersMap.keySet()));
            this.settersMap = settersMap;
            assert (gettersMap.keySet().containsAll(visiblesMap.keySet()));
            this.visiblesMap = visiblesMap;
        }

        public TypeInfo(String name, Class valueClass, Class valueObjectClass) {
            this(name, valueClass, valueObjectClass, TypeInfo.createMethodsMap(valueClass, CREATE_VAR_PREFIX), TypeInfo.createMethodsMap(valueClass, GETTER_PREFIX), TypeInfo.createMethodsMap(valueClass, SETTER_PREFIX), TypeInfo.createMethodsMap(valueClass, VISIBLE_PREFIX));
        }

        public TypeInfo(Class valueClass) {
            this(valueClass.getSimpleName(), valueClass, null);
        }

        public TypeInfo(String name) {
            this(name, null, null, EMPTY_METHODS_MAP, EMPTY_METHODS_MAP, EMPTY_METHODS_MAP, EMPTY_METHODS_MAP);
        }

        public String getName() {
            return this.name;
        }

        public Class getValueClass() {
            return this.valueClass;
        }

        public Class getValueObjectClass() {
            return this.valueObjectClass;
        }

        public Map<String, Method> getCreateVarsMap() {
            return this.createVarsMap;
        }

        public Map<String, Method> getGettersMap() {
            return this.gettersMap;
        }

        public Map<String, Method> getSettersMap() {
            return this.settersMap;
        }

        public Map<String, Method> getVisiblesMap() {
            return this.visiblesMap;
        }

        private static Map<String, Method> createMethodsMap(Class cls, String methodPrefix) {
            LinkedHashMap<String, Method> map = new LinkedHashMap<String, Method>();
            try {
                TypeInfo.initMethodsMap(map, cls, methodPrefix);
            }
            catch (Exception e) {
                Logger.getGlobalLogger().error((Throwable)e);
            }
            return Collections.unmodifiableMap(map);
        }

        private static void initMethodsMap(Map<String, Method> map, Class cls, String methodPrefix) {
            Method[] methods;
            Method[] methodArray = methods = cls.getDeclaredMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                String methodName = method.getName();
                if (methodName.startsWith(methodPrefix)) {
                    String varName = methodName.substring(methodPrefix.length());
                    map.put(varName, method);
                }
                ++n2;
            }
        }
    }

    public static class Unit
    extends InstallOperationDebugValue {
        private static final long serialVersionUID = 1L;
        public static final TypeInfo TYPE_INFO = new TypeInfo("IInstallableUnit", Unit.class, IInstallableUnit.class);

        public Unit(InstallOperationDebugValue parentValue) throws IOException {
            super(parentValue);
        }

        @Override
        public TypeInfo getTypeInfo() {
            return TYPE_INFO;
        }

        public InstallOperationDebugVariable createVar_parentId(String name) throws IOException {
            return InstallOperationDebugVariable.createStringVariable(name, this);
        }

        public String get_parentId() {
            IInstallableUnit unit = (IInstallableUnit)this.getValueObject();
            if (unit == null) {
                return null;
            }
            IInstallableUnitContainer parent = unit.getParent();
            return parent.getIdentity().getId();
        }

        public InstallOperationDebugVariable createVar_parentVersion(String name) throws IOException {
            return InstallOperationDebugVariable.createStringVariable(name, this);
        }

        public String get_parentVersion() {
            IInstallableUnit unit = (IInstallableUnit)this.getValueObject();
            if (unit == null) {
                return null;
            }
            IInstallableUnitContainer parent = unit.getParent();
            return parent.getVersion().toString();
        }

        public InstallOperationDebugVariable createVar_id(String name) throws IOException {
            return InstallOperationDebugVariable.createStringVariable(name, this);
        }

        public String get_id() {
            IInstallableUnit unit = (IInstallableUnit)this.getValueObject();
            return unit == null ? null : unit.getIdentity().getId();
        }

        public InstallOperationDebugVariable createVar_version(String name) throws IOException {
            return InstallOperationDebugVariable.createStringVariable(name, this);
        }

        public String get_version() {
            IInstallableUnit unit = (IInstallableUnit)this.getValueObject();
            return unit == null ? null : unit.getVersion().toString();
        }

        public InstallOperationDebugVariable createVar_sourceFileName(String name) throws IOException {
            return InstallOperationDebugVariable.createStringVariable(name, this);
        }

        public String get_sourceFileName() {
            IInstallableUnit unit = (IInstallableUnit)this.getValueObject();
            IInstallableUnitContainer parent = unit.getParent();
            ICicLocation location = parent.getLocation();
            return location == null ? null : location.getFileName();
        }

        public InstallOperationDebugVariable createVar_lineNumber(String name) throws IOException {
            return InstallOperationDebugVariable.createIntVariable(name, this);
        }

        public int get_lineNumber() {
            IInstallableUnit unit = (IInstallableUnit)this.getValueObject();
            return unit == null ? 0 : unit.getLineNumber();
        }

        public static String valueOf(IInstallableUnit unit) {
            if (unit == null) {
                return InstallOperationDebugValue.NULL_VALUE_STRING;
            }
            return IdentityUtil.getQualifiedVersionedId((IInstallableUnit)unit);
        }

        @Override
        protected String doGetValueString() {
            return Unit.valueOf((IInstallableUnit)this.getValueObject());
        }
    }

    public static class WhenValue
    extends EnumValue {
        private static final long serialVersionUID = 1L;
        public static final TypeInfo TYPE_INFO = new TypeInfo("When", WhenValue.class, InstallOperationDebug.When.class);

        public WhenValue(InstallOperationDebugValue parentValue) throws IOException {
            super(parentValue, InstallOperationDebug.When.values());
        }

        @Override
        public TypeInfo getTypeInfo() {
            return TYPE_INFO;
        }

        @Override
        protected Object toValueObject(String expression) {
            return InstallOperationDebug.When.valueOf(expression.toUpperCase(Locale.ENGLISH));
        }
    }
}

