/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.core;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.IAgentEngine;
import com.ibm.cic.agent.core.IInstallOperation;
import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.InstallContextTree;
import com.ibm.cic.agent.core.InstallTransaction;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.internal.expander.ExpansionResult;
import com.ibm.cic.agent.core.utils.AgentUserOptions;
import com.ibm.cic.agent.internal.core.InstallRegistry;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.agent.internal.core.debug.InstallOperationDebug;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IInstallableUnitContainer;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.InstallableUnitPair;
import com.ibm.cic.common.core.model.SimpleIdentity;
import com.ibm.cic.common.core.model.utils.InstallableUnitUtil;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.utils.IdentityUtil;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.logging.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;

public class InstallOrderManager {
    private static final Logger log = Logger.getLogger(InstallOrderManager.class);
    private static final Version INITIAL_AGENT_VERSION_WHERE_IMPLICIT_ORDER_DEPENDENCIES_ARE_SUPPRESSED = new Version(1, 2, 1000);
    private final IAgentEngine engine;
    private final IAgentEngine p2engine;
    private ExpansionResult expansionResult;
    private Map allOrderDependencies = new LinkedHashMap();
    private Map crossContextOrderDependencies = null;
    private Map intraContextOrderDependencies = null;
    private Boolean intuitiveOrderRequired = null;
    private Boolean nonIntuitiveOrderRequired = null;
    private Boolean implicitDependenciesSuppressed = null;
    private final OrderDependencyMap originalOrderDependencies = new OrderDependencyMap();
    private static final Map WELL_KNOWN_ORDER_DEPENDENCIES = new LinkedHashMap();
    private static final Map WELL_KNOWN_PASSIVE_ORDER_DEPENDENCIES = new LinkedHashMap();

    public InstallOrderManager(IAgentEngine engine, IAgentEngine p2engine) {
        WELL_KNOWN_ORDER_DEPENDENCIES.put("com.ibm.sdp.eclipse.ide/com.ibm.java.jdk..changeJREPermission", "com.ibm.java.linux.jre");
        WELL_KNOWN_ORDER_DEPENDENCIES.put("com.ibm.sdp.native/com.ibm.java.jdk.native.context..changeJREPermission.native.context", "com.ibm.java.linux.jre.native.context");
        WELL_KNOWN_PASSIVE_ORDER_DEPENDENCIES.put("com.ibm.sdp.eclipse.ide/com.ibm.rad.shortcut..com.ibm.rad.shortcut.win32", "com.ibm.sdp.eclipse.ide/org.eclipse.rcp.feature..org.eclipse.executable.win32.win32.x86");
        WELL_KNOWN_PASSIVE_ORDER_DEPENDENCIES.put("com.ibm.sdp.native/ibmdci.linux_ia32.response..ibmdci.linux_ia32.response", "com.ibm.sdp.eclipse.ide/com.ibm.java.jdk..changeJREPermission,com.ibm.sdp.native/com.ibm.java.jdk.native.context..changeJREPermission.native.context");
        this.engine = engine;
        this.p2engine = p2engine;
    }

    public String toString() {
        if (this.allOrderDependencies.size() == 0) {
            return "order dependencies: (empty)";
        }
        StringBuffer sb = new StringBuffer();
        this.appendOrderDependencies(sb, null, this.allOrderDependencies.values());
        if (this.crossContextOrderDependencies != null && this.crossContextOrderDependencies.size() != 0) {
            this.appendOrderDependencies(sb, "cross install context", this.crossContextOrderDependencies.values());
        }
        if (this.intraContextOrderDependencies != null && this.intraContextOrderDependencies.size() != 0) {
            for (Map.Entry entry : this.intraContextOrderDependencies.entrySet()) {
                InstallContext context = (InstallContext)entry.getKey();
                Map orderDependencies = (Map)entry.getValue();
                this.appendOrderDependencies(sb, String.valueOf(context.getId()) + " intra install context", orderDependencies.values());
            }
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public void setExpansionResult(ExpansionResult expansionResult) {
        this.expansionResult = expansionResult;
    }

    public void computeOrderDependentPairs() {
        HashSet seenBefore = new HashSet();
        List<InstallContextTree> trees = this.expansionResult.getFullContextTree();
        Iterator<InstallContextTree> iterator = trees.iterator();
        while (iterator.hasNext()) {
            InstallContextTree element;
            InstallContextTree tree = element = iterator.next();
            this.computeOrderDependentPairs(tree, seenBefore);
        }
        this.logDependencies();
        this.topsortOrderDependencies();
        this.removeNonDependentsForThisOperation();
    }

    public void addAllReinstalledIUs(Set set) {
        Collection dependencies = this.allOrderDependencies.values();
        for (OrderDependency dependency : dependencies) {
            InstallableUnitPair pair = dependency.getPair();
            if (!pair.isIdentical()) continue;
            set.add(pair.getTo());
        }
    }

    public Collection getAllOrderDependencies() {
        return this.allOrderDependencies.values();
    }

    public List getEngineInstallOperations(boolean isRollback) {
        this.prepareForOperation();
        List<InstallContextTree> fullTree = this.expansionResult.getFullContextTree();
        List operations = new ArrayList(fullTree.size() + 2 * this.allOrderDependencies.size());
        Collection dependencies = this.crossContextOrderDependencies.values();
        boolean intuitiveOrder = this.intuitiveUninstallInstallOrderRequired();
        if (!intuitiveOrder) {
            this.addFromInstallOperations(operations, dependencies);
        }
        this.addContextInstallOperations(operations, isRollback, fullTree);
        if (intuitiveOrder) {
            this.addFromInstallOperations(operations, dependencies);
        }
        this.addToInstallOperations(operations, dependencies);
        operations = this.coalesceOperations(operations);
        if (intuitiveOrder) {
            operations = this.getUninstallInstallEngineOperations(operations, false);
        }
        if (this.nonIntuitiveUninstallInstallOrderRequired()) {
            log.info(Messages.InstallOrderManager_nonIntuitiveOrderInEffect);
        }
        operations = this.segregateP2EngineOperations(operations, false);
        return operations;
    }

    public List getEngineUninstallOperations() {
        this.prepareForOperation();
        List<InstallContextTree> fullTree = this.expansionResult.getFullContextTree();
        List operations = new ArrayList(fullTree.size() + this.allOrderDependencies.size());
        Collection dependencies = this.crossContextOrderDependencies.values();
        boolean intuitiveOrder = this.intuitiveUninstallInstallOrderRequired();
        if (!intuitiveOrder) {
            this.addFromUninstallOperations(operations, dependencies);
        }
        this.addContextUninstallOperations(operations, fullTree);
        if (intuitiveOrder) {
            this.addFromUninstallOperations(operations, dependencies);
        }
        this.addToUninstallOperations(operations, dependencies);
        operations = this.coalesceOperations(operations);
        if (intuitiveOrder) {
            operations = this.getUninstallInstallEngineOperations(operations, true);
        }
        if (this.nonIntuitiveUninstallInstallOrderRequired()) {
            log.info(Messages.InstallOrderManager_nonIntuitiveOrderInEffect);
        }
        operations = this.segregateP2EngineOperations(operations, true);
        return operations;
    }

    private List segregateP2EngineOperations(List operations, boolean isUninstall) {
        if (this.p2engine == null) {
            return operations;
        }
        ArrayList newOperations = new ArrayList(operations.size());
        for (EngineOperation operation : operations) {
            this.segregateP2EngineOperation(operation, isUninstall, newOperations);
        }
        return newOperations;
    }

    private void segregateP2EngineOperation(EngineOperation operation, boolean isUninstall, List newOperations) {
        InstallableUnitPairList pairs = operation.getPairs();
        boolean hasP2Pairs = false;
        Iterator iterator = pairs.iterator();
        while (iterator.hasNext()) {
            InstallableUnitPair pair = (InstallableUnitPair)iterator.next();
            IInstallableUnit unit = pair.getLatest();
            if (!"p2Eclipse".equals(unit.getAdapterId())) continue;
            hasP2Pairs = true;
            iterator.remove();
        }
        if (!hasP2Pairs) {
            newOperations.add(operation);
            return;
        }
        InstallableUnitPairList uninstallPairs = new InstallableUnitPairList(pairs.size());
        InstallableUnitPairList otherPairs = new InstallableUnitPairList(pairs.size());
        for (InstallableUnitPair pair : pairs) {
            IInstallableUnit unit = pair.getLatest();
            if (InstallOrderManager.isP2BootstrapUnit(unit)) continue;
            if (pair.isUninstall()) {
                uninstallPairs.add(pair);
                continue;
            }
            otherPairs.add(pair);
        }
        InstallContextTree tree = operation.getContextTree();
        if (uninstallPairs.size() != 0) {
            newOperations.add(InstallOrderManager.newUninstallInstallEngineOperation(isUninstall, this.engine, tree, uninstallPairs));
        }
        newOperations.add(InstallOrderManager.newUninstallInstallEngineOperation(isUninstall, this.p2engine, tree, this.getOriginalP2Pairs(tree)));
        if (otherPairs.size() != 0) {
            newOperations.add(InstallOrderManager.newUninstallInstallEngineOperation(isUninstall, this.engine, tree, otherPairs));
        }
        tree.getInstallContext().setIsP2Managed(true);
    }

    private InstallableUnitPairList getOriginalP2Pairs(InstallContextTree tree) {
        InstallableUnitPair.List originalPairs = tree.getOriginalPairs();
        InstallableUnitPairList result = new InstallableUnitPairList(originalPairs.size());
        for (InstallableUnitPair pair : originalPairs) {
            IInstallableUnit unit = pair.getLatest();
            if (!"p2Eclipse".equals(unit.getAdapterId())) continue;
            result.add(pair);
        }
        return result;
    }

    private static boolean isP2BootstrapUnit(IInstallableUnit unit) {
        String adapterId = unit.getAdapterId();
        if ("eclipse".equals(adapterId)) {
            return false;
        }
        return unit.getIdentity().getId().startsWith("org.eclipse.equinox.p2.bootstrap");
    }

    private List getOrderDependenciesProperty(InstallContextTree tree, IInstallableUnit unit) {
        String dependencyKey;
        String wellKnownOrderDependencies;
        List orderDependencies = InstallableUnitUtil.getOrderDependencies((IInstallableUnit)unit);
        if (orderDependencies.size() == 0 && !this.implicitOrderDependenciesAreSuppressed() && (wellKnownOrderDependencies = (String)WELL_KNOWN_ORDER_DEPENDENCIES.get(dependencyKey = InstallOrderManager.getDependencyKey(tree, unit))) != null) {
            orderDependencies.addAll(Util.splitStringAsList((String)wellKnownOrderDependencies, (String)","));
        }
        return orderDependencies;
    }

    private List getPassiveOrderDependenciesProperty(InstallContextTree tree, IInstallableUnit unit) {
        String dependencyKey;
        String wellKnownPassiveOrderDependencies;
        List orderDependencies = InstallableUnitUtil.getPassiveOrderDependencies((IInstallableUnit)unit);
        if (orderDependencies.size() == 0 && !this.implicitOrderDependenciesAreSuppressed() && (wellKnownPassiveOrderDependencies = (String)WELL_KNOWN_PASSIVE_ORDER_DEPENDENCIES.get(dependencyKey = InstallOrderManager.getDependencyKey(tree, unit))) != null) {
            orderDependencies.addAll(Util.splitStringAsList((String)wellKnownPassiveOrderDependencies, (String)","));
        }
        return orderDependencies;
    }

    private boolean implicitOrderDependenciesAreSuppressed() {
        if (this.implicitDependenciesSuppressed == null) {
            this.implicitDependenciesSuppressed = this.computeImplicitOrderDependenciesAreSuppressed();
        }
        return this.implicitDependenciesSuppressed;
    }

    private boolean computeImplicitOrderDependenciesAreSuppressed() {
        IOffering[] installedOfferings;
        if (this.nonIntuitiveUninstallInstallOrderRequired()) {
            return true;
        }
        Version agentVersion = INITIAL_AGENT_VERSION_WHERE_IMPLICIT_ORDER_DEPENDENCIES_ARE_SUPPRESSED;
        for (IOffering iOffering : this.expansionResult.getOfferings().keySet()) {
            IOffering offering = iOffering;
            if (!OfferingUtil.isMinimumAgentToleranceLessThan((IOfferingOrFix)offering, (Version)agentVersion)) continue;
            return false;
        }
        for (IOffering iOffering : this.expansionResult.getFixes()) {
            IFix fix = (IFix)iOffering;
            if (!OfferingUtil.isMinimumAgentToleranceLessThan((IOfferingOrFix)fix, (Version)agentVersion)) continue;
            return false;
        }
        Profile profile = this.expansionResult.getProfile();
        InstallRegistry.ProfileInstallRegistry installRegistry = profile.getInstallRegistry();
        IOffering[] iOfferingArray = installedOfferings = installRegistry.getInstalledOfferings();
        int n = installedOfferings.length;
        int n2 = 0;
        while (n2 < n) {
            IOffering installedOffering = iOfferingArray[n2];
            if (OfferingUtil.isMinimumAgentToleranceLessThan((IOfferingOrFix)installedOffering, (Version)agentVersion)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean areOrderDependenciesRetroactive(IInstallableUnit unit) {
        String retroactiveValue = unit.getProperties().getProperty("order.dependencies.are.retroactive");
        return "true".equalsIgnoreCase(retroactiveValue);
    }

    private static boolean installOnlyDuringAgentUpdate(IInstallableUnit unit) {
        String installOnlyValue = unit.getProperties().getProperty("install.only.during.agent.update");
        return "true".equalsIgnoreCase(installOnlyValue);
    }

    private void computeOrderDependentPairs(InstallContextTree tree, Set seenBefore) {
        InstallableUnitPair.List pairs = tree.getPairs();
        HashSet<IInstallableUnitContainer> parents = new HashSet<IInstallableUnitContainer>(pairs.size());
        Iterator iter = pairs.iterator();
        while (iter.hasNext()) {
            IInstallableUnit from;
            Agent agent;
            InstallableUnitPair pair = (InstallableUnitPair)iter.next();
            IInstallableUnit unit = pair.getLatest();
            IInstallableUnitContainer parent = unit.getParent();
            if (!parents.contains(parent)) {
                parents.add(parent);
                List simpleIDs = InstallableUnitUtil.getSimpleDependencies((IInstallableUnitContainer)parent, (String)"order.dependencies");
                if (simpleIDs.size() > 0) {
                    log.warningNoUid("Ignores the simple dependency IDs " + simpleIDs + " which are specified in the order.dependencies property of installable unit container " + parent, new Object[0]);
                }
                if ((simpleIDs = InstallableUnitUtil.getSimpleDependencies((IInstallableUnitContainer)parent, (String)"passive.order.dependencies")).size() > 0) {
                    log.warningNoUid("Ignores the simple dependency IDs " + simpleIDs + " which are specified in the passive.order.dependencies property of installable unit container " + parent, new Object[0]);
                }
            }
            if (!pair.isIdentical() && InstallOrderManager.installOnlyDuringAgentUpdate(unit) && ((agent = Agent.getInstance()).isAgentUpdatingItself() || agent.isAgentUninstallingItself()) && (from = pair.getFrom()) != null) {
                if (pair.getTo() != null) {
                    pair.setFrom(null);
                } else {
                    iter.remove();
                }
            }
            if (this.getOrderDependenciesProperty(tree, unit).size() <= 0 && this.getPassiveOrderDependenciesProperty(tree, unit).size() <= 0) continue;
            OrderDependency orderDependency = this.addOrderDependencies(tree, pair, seenBefore);
            this.addOrderDependncyToOriginalDepenencyMap(orderDependency);
        }
    }

    private OrderDependency addOrderDependencies(InstallContextTree tree, InstallableUnitPair pair, Set seenBefore) {
        String dependencyKey = InstallOrderManager.getDependencyKey(tree, pair);
        if (seenBefore.contains(dependencyKey)) {
            log.warning("circular order dependency in installable unit :" + IdentityUtil.getQualifiedVersionedId((IInstallableUnit)pair.getLatest()));
            return null;
        }
        OrderDependency dependency = (OrderDependency)this.allOrderDependencies.get(dependencyKey);
        if (dependency != null) {
            return dependency;
        }
        dependency = new OrderDependency(tree, pair, dependencyKey);
        this.allOrderDependencies.put(dependencyKey, dependency);
        IInstallableUnit unit = pair.getLatest();
        List orderDependencies = this.getOrderDependenciesProperty(tree, unit);
        List passiveOrderDependencies = this.getPassiveOrderDependenciesProperty(tree, unit);
        if (orderDependencies.size() == 0 && passiveOrderDependencies.size() == 0) {
            return dependency;
        }
        seenBefore.add(dependencyKey);
        if (passiveOrderDependencies.size() > 0) {
            this.addSuperOrderDependencies(true, dependency, tree, unit, passiveOrderDependencies, seenBefore);
        }
        if (orderDependencies.size() > 0) {
            this.addSuperOrderDependencies(false, dependency, tree, unit, orderDependencies, seenBefore);
        }
        seenBefore.remove(dependencyKey);
        return dependency;
    }

    private void addSuperOrderDependencies(boolean isPassive, OrderDependency dependency, InstallContextTree tree, IInstallableUnit unit, List orderDependenciesIds, Set seenBefore) {
        InstallContextTree[] dependencyTreeRef = new InstallContextTree[1];
        ArrayList dependencyPairs = new ArrayList();
        int i = 0;
        while (i < orderDependenciesIds.size()) {
            String orderDependencyId = (String)orderDependenciesIds.get(i);
            if (this.resolveDependency(tree, unit, orderDependencyId, dependencyTreeRef, dependencyPairs)) {
                for (InstallableUnitPair pair : dependencyPairs) {
                    OrderDependency superDependency = this.addOrderDependencies(dependencyTreeRef[0], pair, seenBefore);
                    if (superDependency == null) continue;
                    dependency.addDependency(superDependency, isPassive);
                }
            }
            ++i;
        }
    }

    private boolean resolveDependency(InstallContextTree tree, IInstallableUnit unit, String orderDependencyId, InstallContextTree[] dependencyTreeRef, List dependencyPairs) {
        InstallContextTree dependencyTree;
        dependencyPairs.clear();
        if (orderDependencyId.length() == 0) {
            log.warning("empty order dependency in IU " + IdentityUtil.getQualifiedVersionedId((IInstallableUnit)unit));
            return false;
        }
        boolean isCategory = orderDependencyId.startsWith("category:");
        String[] segments = Util.splitString((String)(isCategory ? orderDependencyId.substring("category:".length()) : orderDependencyId), (String)"/");
        if (segments.length == 1) {
            dependencyTree = tree;
        } else if (segments.length == 2) {
            String contextId = segments[0];
            if (contextId.length() == 0) {
                dependencyTree = this.expansionResult.getRootContextTree();
            } else {
                dependencyTree = this.expansionResult.getRootContextTree().findSubContext(contextId);
                if (dependencyTree == null) {
                    log.debug("install context in order dependency not found: " + IdentityUtil.getQualifiedVersionedId((IInstallableUnit)unit) + " -> " + orderDependencyId);
                    return false;
                }
            }
        } else {
            log.warning("install order dependencies on IUs in nested install contexts not supported: " + IdentityUtil.getQualifiedVersionedId((IInstallableUnit)unit) + " -> " + orderDependencyId);
            return false;
        }
        dependencyTreeRef[0] = dependencyTree;
        String dependency = segments[segments.length - 1];
        this.resolveUnit(dependencyPairs, dependencyTree, dependency, tree, unit, orderDependencyId, isCategory);
        return true;
    }

    private void resolveUnit(List dependencyPairs, InstallContextTree dependencyTree, String dependency, InstallContextTree dependentTree, IInstallableUnit dependentUnit, String orderDependencyId, boolean isCategory) {
        if (isCategory) {
            this.resolveToAllUnitsByCategory(dependencyPairs, dependencyTree, dependency, dependentTree, dependentUnit);
        } else if ("*".equals(dependency)) {
            this.resolveToAllContextUnits(dependencyPairs, dependencyTree, dependentTree, dependentUnit);
        } else {
            String[] splitIds = IdentityUtil.splitQualifiedId((String)dependency);
            if (splitIds[0] == null) {
                splitIds[0] = dependentUnit.getParent().getIdentity().getId();
            }
            String suId = splitIds[0];
            String iuId = splitIds[1];
            if ("*".equals(iuId)) {
                this.resolveToAllSuUnits(dependencyPairs, dependencyTree, suId, dependentTree, dependentUnit);
            } else {
                this.resolveToSingleUnit(dependencyPairs, dependencyTree, suId, iuId, dependentUnit, orderDependencyId);
            }
        }
    }

    private void resolveToAllContextUnits(List dependencyPairs, InstallContextTree dependencyTree, InstallContextTree dependentTree, IInstallableUnit dependentUnit) {
        String dependentSuId = null;
        String dependentIuId = null;
        if (dependentTree == dependencyTree) {
            dependentSuId = dependentUnit.getParent().getIdentity().getId();
            dependentIuId = dependentUnit.getIdentity().getId();
        }
        for (InstallableUnitPair pair : dependencyTree.getPairs()) {
            if (dependentSuId != null && dependentSuId.equals(pair.getParent().getIdentity().getId()) && dependentIuId.equals(pair.getIdentity().getId())) continue;
            dependencyPairs.add(pair);
        }
    }

    private void resolveToAllUnitsByCategory(List dependencyPairs, InstallContextTree dependencyTree, String category, InstallContextTree dependentTree, IInstallableUnit dependentUnit) {
        for (InstallableUnitPair pair : dependencyTree.getPairs()) {
            boolean isSibling = dependentTree == dependencyTree && dependentUnit.getParent().getIdentity().getId().equals(pair.getParent().getIdentity().getId());
            List orderDependenciesCategoriesList = InstallableUnitUtil.getOrderDependenciesCategories((IInstallableUnit)pair.getLatest(), (!isSibling ? 1 : 0) != 0);
            if (!orderDependenciesCategoriesList.contains(category)) continue;
            dependencyPairs.add(pair);
        }
    }

    private void resolveToAllSuUnits(List dependencyPairs, InstallContextTree dependencyTree, String suId, InstallContextTree dependentTree, IInstallableUnit dependentUnit) {
        String dependentIuId = null;
        if (dependentTree == dependencyTree && suId.equals(dependentUnit.getParent().getIdentity().getId())) {
            dependentIuId = dependentUnit.getIdentity().getId();
        }
        for (InstallableUnitPair pair : dependencyTree.getPairs()) {
            if (!suId.equals(pair.getParent().getIdentity().getId()) || dependentIuId != null && dependentIuId.equals(pair.getIdentity().getId())) continue;
            dependencyPairs.add(pair);
        }
    }

    private void resolveToSingleUnit(List dependencyPairs, InstallContextTree dependencyTree, String suId, String iuId, IInstallableUnit unit, String orderDependencyId) {
        SimpleIdentity qualifiedId = new SimpleIdentity(IdentityUtil.createQualifiedId((String)suId, (String)iuId));
        InstallableUnitPair dependencyPair = dependencyTree.getPairs().get((IIdentity)qualifiedId);
        if (dependencyPair != null) {
            dependencyPairs.add(dependencyPair);
        } else {
            log.debug("installable unit in order dependency not found: " + IdentityUtil.getQualifiedVersionedId((IInstallableUnit)unit) + " -> " + orderDependencyId);
        }
    }

    private static String getDependencyKey(InstallContextTree tree, IInstallableUnit unit) {
        return String.valueOf(tree.getId()) + '/' + unit.getQualifiedId().getId();
    }

    private static String getDependencyKey(InstallContextTree tree, InstallableUnitPair pair) {
        return String.valueOf(tree.getId()) + '/' + pair.getQualifiedId().getId();
    }

    private void prepareForOperation() {
        this.segregateContextDependencies();
    }

    private InstallableUnitPairList getNonDependentPairs(InstallContextTree tree) {
        InstallableUnitPair.List pairs = tree.getPairs();
        InstallableUnitPairList nonDependentPairs = new InstallableUnitPairList(pairs.size());
        Iterator iter = this.nonIntuitiveUninstallInstallOrderRequired() ? pairs.reverseList().iterator() : pairs.iterator();
        while (iter.hasNext()) {
            InstallableUnitPair pair = (InstallableUnitPair)iter.next();
            String dependencyKey = InstallOrderManager.getDependencyKey(tree, pair);
            if (this.allOrderDependencies.containsKey(dependencyKey)) continue;
            nonDependentPairs.add(pair);
        }
        return nonDependentPairs;
    }

    private void topsortOrderDependencies() {
        Set dependencies = this.allOrderDependencies.entrySet();
        this.allOrderDependencies = new LinkedHashMap();
        for (Map.Entry entry : dependencies) {
            String dependencyKey = (String)entry.getKey();
            OrderDependency dependency = (OrderDependency)entry.getValue();
            this.getAllOrderDependenciesInOrder(dependencyKey, dependency);
        }
    }

    private void getAllOrderDependenciesInOrder(String dependencyKey, OrderDependency dependency) {
        if (this.allOrderDependencies.containsKey(dependencyKey)) {
            return;
        }
        Map superDependencies = dependency.getDependencies();
        for (Map.Entry entry : superDependencies.entrySet()) {
            String superDependencyKey = (String)entry.getKey();
            OrderDependency superDependency = (OrderDependency)entry.getValue();
            this.getAllOrderDependenciesInOrder(superDependencyKey, superDependency);
        }
        this.allOrderDependencies.put(dependencyKey, dependency);
    }

    private void removeNonDependentsForThisOperation() {
        Set dependencies = this.allOrderDependencies.entrySet();
        this.allOrderDependencies = new LinkedHashMap();
        HashMap npMap = new HashMap();
        HashMap map = new HashMap();
        for (Map.Entry entry : dependencies) {
            String dependencyKey = (String)entry.getKey();
            OrderDependency dependency = (OrderDependency)entry.getValue();
            if (dependency.getDependencies().size() == 0) continue;
            if (dependency.getPair().isIdentical()) {
                if (dependency.nonPassiveDependenciesAreIdentical(npMap)) continue;
                this.allOrderDependencies.put(dependencyKey, dependency);
                continue;
            }
            if (dependency.dependenciesAreIdentical(map)) continue;
            this.allOrderDependencies.put(dependencyKey, dependency);
        }
    }

    private boolean hasCrossContextOrderDependency(OrderDependency dependency) {
        InstallContext dependencyContext = dependency.getContextTree().getInstallContext();
        Map superDependencies = dependency.getDependencies();
        for (Map.Entry entry : superDependencies.entrySet()) {
            String superDependencyKey = (String)entry.getKey();
            if (this.crossContextOrderDependencies.containsKey(superDependencyKey)) {
                return true;
            }
            OrderDependency superDependency = (OrderDependency)entry.getValue();
            InstallContext superDependencyContext = superDependency.getContextTree().getInstallContext();
            if (dependencyContext.equals(superDependencyContext) || !this.allOrderDependencies.containsKey(superDependencyKey) && superDependency.getPair().isIdentical()) continue;
            return true;
        }
        return false;
    }

    private void segregateContextDependencies() {
        this.crossContextOrderDependencies = new LinkedHashMap();
        this.intraContextOrderDependencies = new LinkedHashMap();
        if (this.allOrderDependencies.size() == 0) {
            return;
        }
        LinkedHashMap orderDependencies = new LinkedHashMap(this.allOrderDependencies);
        this.extractCrossContextDependencies(orderDependencies);
        this.extractIntraContextDependencies(orderDependencies);
    }

    private void extractCrossContextDependencies(Map orderDependencies) {
        int sizeBefore;
        int sizeAfter;
        do {
            String[] keys;
            sizeBefore = orderDependencies.size();
            Set keySet = orderDependencies.keySet();
            String[] stringArray = keys = keySet.toArray(new String[keySet.size()]);
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String dependencyKey = stringArray[n2];
                OrderDependency dependency = (OrderDependency)orderDependencies.get(dependencyKey);
                if (dependency != null && this.hasCrossContextOrderDependency(dependency)) {
                    this.extractCrossContextDependencies(orderDependencies, dependencyKey, dependency);
                }
                ++n2;
            }
        } while ((sizeAfter = orderDependencies.size()) != sizeBefore);
    }

    private void extractCrossContextDependencies(Map orderDependencies, String dependencyKey, OrderDependency dependency) {
        if (this.crossContextOrderDependencies.containsKey(dependencyKey)) {
            return;
        }
        Map superDependencies = dependency.getDependencies();
        for (Map.Entry entry : superDependencies.entrySet()) {
            String superDependencyKey = (String)entry.getKey();
            OrderDependency superDependency = (OrderDependency)entry.getValue();
            this.extractCrossContextDependencies(orderDependencies, superDependencyKey, superDependency);
        }
        Object removedDependency = orderDependencies.remove(dependencyKey);
        if (removedDependency != null) {
            this.crossContextOrderDependencies.put(dependencyKey, removedDependency);
        }
    }

    private void extractIntraContextDependencies(Map orderDependencies) {
        Set dependencies = orderDependencies.entrySet();
        for (Map.Entry entry : dependencies) {
            String dependencyKey = (String)entry.getKey();
            OrderDependency dependency = (OrderDependency)entry.getValue();
            InstallContext context = dependency.getContextTree().getInstallContext();
            LinkedHashMap<String, OrderDependency> contextOrderDependencies = (LinkedHashMap<String, OrderDependency>)this.intraContextOrderDependencies.get(context);
            if (contextOrderDependencies == null) {
                contextOrderDependencies = new LinkedHashMap<String, OrderDependency>();
                this.intraContextOrderDependencies.put(context, contextOrderDependencies);
            }
            contextOrderDependencies.put(dependencyKey, dependency);
        }
    }

    private void addFromInstallOperations(List operations, Collection dependencies) {
        ArrayList<EngineInstallOperation> fromOperations = new ArrayList<EngineInstallOperation>(dependencies.size());
        for (OrderDependency dependency : dependencies) {
            IInstallableUnit toUnit;
            InstallContextTree tree = dependency.getContextTree();
            InstallableUnitPair pair = dependency.getPair();
            IInstallableUnit fromUnit = pair.getFrom();
            if (fromUnit == null && InstallOrderManager.areOrderDependenciesRetroactive(toUnit = pair.getTo()) && this.retroactiveUninstallRequired(dependency)) {
                fromUnit = toUnit;
                pair.setFrom(fromUnit);
            }
            if (fromUnit == null) continue;
            InstallableUnitPairList pairs = new InstallableUnitPairList(1);
            pairs.addFrom(fromUnit);
            fromOperations.add(new EngineInstallOperation(this.engine, tree, pairs));
        }
        if (!this.intuitiveUninstallInstallOrderRequired()) {
            Collections.reverse(fromOperations);
        }
        operations.addAll(fromOperations);
    }

    private void addToInstallOperations(List operations, Collection dependencies) {
        for (OrderDependency dependency : dependencies) {
            IInstallableUnit fromUnit;
            InstallContextTree tree = dependency.getContextTree();
            InstallableUnitPair pair = dependency.getPair();
            IInstallableUnit toUnit = pair.getTo();
            if (toUnit == null && InstallOrderManager.areOrderDependenciesRetroactive(fromUnit = pair.getFrom()) && this.retroactiveInstallRequired(dependency)) {
                toUnit = fromUnit;
                pair.setTo(toUnit);
            }
            if (toUnit == null) continue;
            InstallableUnitPairList pairs = new InstallableUnitPairList(1);
            pairs.addTo(toUnit);
            operations.add(new EngineInstallOperation(this.engine, tree, pairs));
        }
    }

    private void addContextInstallOperations(List operations, boolean isRollback, List fullTree) {
        boolean intuitiveOrder = this.intuitiveUninstallInstallOrderRequired();
        Util.ReverseIterator i = this.nonIntuitiveUninstallInstallOrderRequired() ? new Util.ReverseIterator(fullTree) : fullTree.iterator();
        while (i.hasNext()) {
            InstallableUnitPairList pairs;
            Collection contextDependencies;
            InstallContextTree tree = (InstallContextTree)i.next();
            InstallContext context = tree.getInstallContext();
            Map orderDependencies = (Map)this.intraContextOrderDependencies.get(context);
            Collection collection = contextDependencies = orderDependencies != null ? orderDependencies.values() : null;
            if (contextDependencies != null && !intuitiveOrder) {
                this.addFromInstallOperations(operations, contextDependencies);
            }
            if ((pairs = this.getNonDependentPairs(tree)).size() != 0) {
                if (isRollback && !intuitiveOrder) {
                    pairs = pairs.reverseList();
                }
                operations.add(new EngineInstallOperation(this.engine, tree, pairs));
            }
            if (contextDependencies == null) continue;
            if (intuitiveOrder) {
                this.addFromInstallOperations(operations, contextDependencies);
            }
            this.addToInstallOperations(operations, contextDependencies);
        }
    }

    private void addFromUninstallOperations(List operations, Collection dependencies) {
        ArrayList<EngineUninstallOperation> fromOperations = new ArrayList<EngineUninstallOperation>(dependencies.size());
        for (OrderDependency dependency : dependencies) {
            InstallContextTree tree = dependency.getContextTree();
            InstallableUnitPair pair = dependency.getPair();
            IInstallableUnit fromUnit = pair.getFrom();
            if (fromUnit == null) continue;
            InstallableUnitPairList pairs = new InstallableUnitPairList(1);
            pairs.addFrom(fromUnit);
            fromOperations.add(new EngineUninstallOperation(this.engine, tree, pairs));
        }
        if (!this.intuitiveUninstallInstallOrderRequired()) {
            Collections.reverse(fromOperations);
        }
        operations.addAll(fromOperations);
    }

    private void addToUninstallOperations(List operations, Collection dependencies) {
        for (OrderDependency dependency : dependencies) {
            IInstallableUnit fromUnit;
            InstallContextTree tree = dependency.getContextTree();
            InstallableUnitPair pair = dependency.getPair();
            IInstallableUnit toUnit = pair.getTo();
            if (toUnit == null && InstallOrderManager.areOrderDependenciesRetroactive(fromUnit = pair.getFrom()) && this.retroactiveInstallRequired(dependency)) {
                toUnit = fromUnit;
                pair.setTo(toUnit);
            }
            if (toUnit == null) continue;
            InstallableUnitPairList pairs = new InstallableUnitPairList(1);
            pairs.addTo(toUnit);
            operations.add(new EngineUninstallOperation(this.engine, tree, pairs));
        }
    }

    private void addContextUninstallOperations(List operations, List fullTree) {
        boolean intuitiveOrder = this.intuitiveUninstallInstallOrderRequired();
        Object i = intuitiveOrder ? fullTree.iterator() : (this.nonIntuitiveUninstallInstallOrderRequired() ? fullTree.iterator() : new Util.ReverseIterator(fullTree));
        while (i.hasNext()) {
            InstallableUnitPairList pairs;
            Collection contextDependencies;
            InstallContextTree tree = (InstallContextTree)i.next();
            InstallContext context = tree.getInstallContext();
            Map orderDependencies = (Map)this.intraContextOrderDependencies.get(context);
            Collection collection = contextDependencies = orderDependencies != null ? orderDependencies.values() : null;
            if (contextDependencies != null && !intuitiveOrder) {
                this.addFromUninstallOperations(operations, contextDependencies);
            }
            if ((pairs = this.getNonDependentPairs(tree)).size() != 0) {
                if (!intuitiveOrder) {
                    pairs = pairs.reverseList();
                }
                operations.add(new EngineUninstallOperation(this.engine, tree, pairs));
            }
            if (contextDependencies == null) continue;
            if (intuitiveOrder) {
                this.addFromUninstallOperations(operations, contextDependencies);
            }
            this.addToUninstallOperations(operations, contextDependencies);
        }
    }

    private static boolean intuitiveUninstallInstallOrderRequiredForInstalledOfferings(Profile profile) {
        IOffering[] installedOfferings;
        InstallRegistry.ProfileInstallRegistry installRegistry = profile.getInstallRegistry();
        IOffering[] iOfferingArray = installedOfferings = installRegistry.getInstalledOfferings();
        int n = installedOfferings.length;
        int n2 = 0;
        while (n2 < n) {
            IOffering installedOffering = iOfferingArray[n2];
            if (InstallOrderManager.intuitiveUninstallInstallOrderRequired((IOfferingOrFix)installedOffering)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean intuitiveUninstallInstallOrderRequired(IOfferingOrFix offeringOrFix) {
        String prop = offeringOrFix.getProperties().getProperty("intuitive.uninstall.install.order.required");
        return Boolean.TRUE.equals(Boolean.valueOf(prop));
    }

    private static boolean intuitiveUninstallInstallOrderRequiredForSession() {
        return AgentUserOptions.CIC_INTUITIVE_UNINSTALL_INSTALL_ORDER_REQUIRED.isSet();
    }

    private static boolean intuitiveUninstallInstallOrderRequiredForProfile(Profile profile) {
        if (profile.isAgentProfile()) {
            return true;
        }
        String prop = profile.getData(Profile.INTUITIVE_UNINSTALL_INSTALL_ORDER_REQUIRED);
        return Boolean.TRUE.equals(Boolean.valueOf(prop));
    }

    private boolean computeIntuitiveUninstallInstallOrderRequired() {
        Profile profile = this.expansionResult.getProfile();
        if (InstallOrderManager.intuitiveUninstallInstallOrderRequiredForProfile(profile)) {
            return true;
        }
        if (InstallOrderManager.intuitiveUninstallInstallOrderRequiredForSession()) {
            return true;
        }
        for (IOffering element : this.expansionResult.getOfferings().keySet()) {
            IOffering offering = element;
            if (!InstallOrderManager.intuitiveUninstallInstallOrderRequired((IOfferingOrFix)offering)) continue;
            return true;
        }
        return InstallOrderManager.intuitiveUninstallInstallOrderRequiredForInstalledOfferings(profile);
    }

    private boolean intuitiveUninstallInstallOrderRequired() {
        if (this.intuitiveOrderRequired == null) {
            this.intuitiveOrderRequired = this.computeIntuitiveUninstallInstallOrderRequired();
        }
        return this.intuitiveOrderRequired;
    }

    private boolean computeNonIntuitiveUninstallInstallOrderRequired() {
        if (this.intuitiveUninstallInstallOrderRequired()) {
            return false;
        }
        return AgentUserOptions.CIC_NON_INTUITIVE_UNINSTALL_INSTALL_ORDER_REQUIRED.isSet();
    }

    private boolean nonIntuitiveUninstallInstallOrderRequired() {
        if (this.nonIntuitiveOrderRequired == null) {
            this.nonIntuitiveOrderRequired = this.computeNonIntuitiveUninstallInstallOrderRequired();
        }
        return this.nonIntuitiveOrderRequired;
    }

    private static EngineOperation newUninstallInstallEngineOperation(boolean isUninstall, IAgentEngine engine, InstallContextTree tree, InstallableUnitPairList pairs) {
        if (isUninstall) {
            return new EngineUninstallOperation(engine, tree, pairs);
        }
        return new EngineInstallOperation(engine, tree, pairs);
    }

    private void getUninstallInstallEngineOperations(EngineOperation operation, boolean isUninstall, ArrayList uninstallOperations, ArrayList installOperations) {
        InstallContextTree tree = operation.getContextTree();
        InstallableUnitPairList pairs = operation.getPairs();
        InstallableUnitPairList uninstallPairs = new InstallableUnitPairList(pairs.size());
        InstallableUnitPairList installPairs = new InstallableUnitPairList(pairs.size());
        for (InstallableUnitPair pair : pairs) {
            if (this.isEclipsePair(pair)) {
                installPairs.add(pair);
                continue;
            }
            if (pair.isUninstall()) {
                uninstallPairs.add(pair);
                continue;
            }
            if (pair.isInstall()) {
                installPairs.add(pair);
                continue;
            }
            uninstallPairs.addFrom(pair.getFrom());
            installPairs.addTo(pair.getTo());
        }
        if (uninstallPairs.size() != 0) {
            uninstallOperations.add(InstallOrderManager.newUninstallInstallEngineOperation(isUninstall, this.engine, tree, uninstallPairs.reverseList()));
        }
        if (installPairs.size() != 0) {
            installOperations.add(InstallOrderManager.newUninstallInstallEngineOperation(isUninstall, this.engine, tree, installPairs));
        }
    }

    private boolean isEclipsePair(InstallableUnitPair pair) {
        IInstallableUnit unit = pair.getLatest();
        String id = unit.getAdapterId();
        return "eclipse".equals(id) || "p2Eclipse".equals(id);
    }

    private List getUninstallInstallEngineOperations(List operations, boolean isUninstall) {
        log.info(Messages.InstallOrderManager_intuitiveOrderInEffect);
        if (InstallOrderManager.intuitiveUninstallInstallOrderRequiredForSession()) {
            this.expansionResult.setProfileIntuitiveInstallOrder(true);
        }
        ArrayList uninstallOperations = new ArrayList(operations.size());
        ArrayList installOperations = new ArrayList(operations.size());
        for (EngineOperation operation : operations) {
            this.getUninstallInstallEngineOperations(operation, isUninstall, uninstallOperations, installOperations);
        }
        Collections.reverse(uninstallOperations);
        uninstallOperations.addAll(installOperations);
        return uninstallOperations;
    }

    private List coalesceOperations(List operations) {
        ArrayList<EngineOperation> coalescedOperations = new ArrayList<EngineOperation>(operations.size());
        EngineOperation lastOperation = null;
        for (EngineOperation operation : operations) {
            InstallContext context = operation.getContext();
            InstallableUnitPairList pairs = operation.getPairs();
            if (lastOperation != null && context.equals(lastOperation.getContext())) {
                InstallableUnitPairList lastPairs = lastOperation.getPairs();
                lastPairs.addAll(pairs);
                continue;
            }
            coalescedOperations.add(operation);
            lastOperation = operation;
        }
        return coalescedOperations;
    }

    private boolean retroactiveUninstallRequired(OrderDependency dependency) {
        Collection dependencies = dependency.getDependencies().values();
        for (OrderDependency superDependency : dependencies) {
            InstallableUnitPair pair;
            if (superDependency.isPassive() || !((pair = superDependency.getPair()).isIdentical() ? this.isActive(superDependency) : !pair.isInstall())) continue;
            return true;
        }
        return false;
    }

    private boolean retroactiveInstallRequired(OrderDependency dependency) {
        Collection dependencies = dependency.getDependencies().values();
        for (OrderDependency superDependency : dependencies) {
            InstallableUnitPair pair;
            if (superDependency.isPassive() || !((pair = superDependency.getPair()).isIdentical() ? this.isActive(superDependency) : !pair.isUninstall())) continue;
            return true;
        }
        return false;
    }

    private boolean isActive(OrderDependency dependency) {
        String key = dependency.getDependencyKey();
        return this.allOrderDependencies.containsKey(key);
    }

    private void logDependencies() {
        if (log.isDebugLoggable()) {
            log.debug(this.toString());
        } else if (Statistics.slog.isDebugLoggable()) {
            Statistics.slog.debug(this.toString());
        }
    }

    private void appendOrderDependencies(StringBuffer sb, String label, Collection values) {
        OrderDependency[] dependencies = values.toArray(new OrderDependency[values.size()]);
        Arrays.sort(dependencies, new Comparator(){

            public int compare(Object o1, Object o2) {
                OrderDependency d1 = (OrderDependency)o1;
                OrderDependency d2 = (OrderDependency)o2;
                String k1 = d1.getDependencyKey();
                String k2 = d2.getDependencyKey();
                return k1.compareTo(k2);
            }
        });
        if (label != null) {
            sb.append(label).append(' ');
        }
        sb.append("order dependencies (count=").append(dependencies.length).append("):\n");
        Statistics statistics = null;
        if (Statistics.slog.isDebugLoggable()) {
            statistics = this.computeStatistics();
            sb.append("    overall statistics: ").append(statistics).append('\n');
        }
        OrderDependency[] orderDependencyArray = dependencies;
        int n = dependencies.length;
        int n2 = 0;
        while (n2 < n) {
            OrderDependency dependency = orderDependencyArray[n2];
            sb.append(dependency).append('\n');
            if (statistics != null && dependency.getDependencies().size() != 0) {
                Statistics curStatistics = (Statistics)statistics.graph.get(dependency.getDependencyKey());
                sb.append("    statistics: ").append(curStatistics).append('\n');
            }
            ++n2;
        }
    }

    private Statistics computeStatistics() {
        ArrayList<Statistics> statisticsChain = new ArrayList<Statistics>();
        Statistics statistics = new Statistics();
        statisticsChain.add(statistics);
        this.computeStatistics(statisticsChain, this.allOrderDependencies);
        return statistics;
    }

    private void computeStatistics(ArrayList statisticsChain, Map dependencies) {
        for (OrderDependency dependency : dependencies.values()) {
            this.computeStatistics(statisticsChain, dependency);
        }
    }

    private void computeStatistics(ArrayList statisticsChain, OrderDependency dependency) {
        Statistics statistics = this.getStatisticsSeenBefore(statisticsChain, dependency);
        if (statistics == null) {
            statistics = new Statistics(dependency);
            statisticsChain.add(statistics);
            Map superDependencies = dependency.getDependencies();
            if (superDependencies.size() != 0) {
                this.computeStatistics(statisticsChain, superDependencies);
            }
            statisticsChain.remove(statisticsChain.size() - 1);
        }
        this.addStatisticsGraph(statisticsChain, statistics);
        this.addChains(statisticsChain, statistics);
    }

    private Statistics getStatisticsSeenBefore(ArrayList statisticsChain, OrderDependency dependency) {
        Statistics rootStatistics = (Statistics)statisticsChain.get(0);
        return (Statistics)rootStatistics.graph.get(dependency.getDependencyKey());
    }

    private void addStatisticsGraph(ArrayList statisticsChain, Statistics statistics) {
        int lastIndex = statisticsChain.size() - 1;
        Statistics prevStatistics = (Statistics)statisticsChain.get(lastIndex);
        prevStatistics.graph.putAll(statistics.graph);
        if (lastIndex != 0) {
            Statistics rootStatistics = (Statistics)statisticsChain.get(0);
            rootStatistics.graph.putAll(statistics.graph);
        }
    }

    private void addChains(ArrayList statisticsChain, Statistics statistics) {
        int lastIndex = statisticsChain.size() - 1;
        Statistics prevStatistics = (Statistics)statisticsChain.get(lastIndex);
        long possibleMaxLength = statistics.maxPathLength;
        if (lastIndex != 0) {
            ++possibleMaxLength;
        }
        if (possibleMaxLength > prevStatistics.maxPathLength) {
            prevStatistics.maxPathLength = possibleMaxLength;
        }
        if (statistics.numberOfPaths == 0L) {
            if (lastIndex != 0) {
                ++prevStatistics.numberOfPaths;
                prevStatistics.sumOfPathLengths += 2L;
            }
        } else {
            prevStatistics.numberOfPaths += statistics.numberOfPaths;
            prevStatistics.sumOfPathLengths += statistics.sumOfPathLengths;
            if (lastIndex != 0) {
                prevStatistics.sumOfPathLengths += statistics.numberOfPaths;
            }
        }
    }

    public static String getFullyQualifiedIuId(InstallContext installContext, String iuId) {
        return String.valueOf(installContext.getId()) + '/' + iuId;
    }

    public static String getFullyQualifiedIuId(InstallContextTree installContextTree, String iuId) {
        return String.valueOf(installContextTree.getId()) + '/' + iuId;
    }

    private void addOrderDependncyToOriginalDepenencyMap(OrderDependency orderDependency) {
        String iuA = InstallOrderManager.getFullyQualifiedIuId(orderDependency.getContextTree(), orderDependency.getPair().getQualifiedId().toString());
        Map dependsOn = orderDependency.getDependencies();
        for (Map.Entry entry : dependsOn.entrySet()) {
            OrderDependency dependency = (OrderDependency)entry.getValue();
            String iuB = InstallOrderManager.getFullyQualifiedIuId(dependency.getContextTree(), dependency.getPair().getQualifiedId().toString());
            this.originalOrderDependencies.addOrderDependency(iuA, iuB);
        }
    }

    public boolean isDependsOnOrSame(IInstallableUnit iu1, InstallContext installContext1, String qualifiedIu2Id, InstallContext installContext2) {
        String fullyQualifiedIu2Id;
        String fullyQualifiedIu1Id = InstallOrderManager.getFullyQualifiedIuId(installContext1, iu1.getQualifiedId().toString());
        return fullyQualifiedIu1Id.equals(fullyQualifiedIu2Id = InstallOrderManager.getFullyQualifiedIuId(installContext2, qualifiedIu2Id)) || this.originalOrderDependencies.isDependsOn(fullyQualifiedIu1Id, fullyQualifiedIu2Id);
    }

    public static class EngineInstallOperation
    extends EngineOperation {
        public EngineInstallOperation(IAgentEngine engine, InstallContextTree tree, InstallableUnitPairList pairs) {
            super(engine, tree, pairs);
        }

        @Override
        public String toString() {
            return "install: " + super.toString();
        }

        @Override
        public IStatus perform(InstallTransaction transaction, IProgressMonitor monitor) {
            InstallOperationDebug.INSTANCE.setEngineOperation(this);
            IStatus status = this.engine.install(transaction, this.pairs.getPairs(), this.getContext(), monitor);
            InstallOperationDebug.INSTANCE.setEngineOperation(null);
            return status;
        }

        @Override
        public IStatus undoPerform(InstallTransaction transaction, IProgressMonitor monitor) {
            InstallOperationDebug.INSTANCE.reverseInstallOrderPairs();
            InstallOperationDebug.INSTANCE.setEngineOperation(this);
            IStatus status = this.engine.uninstall(transaction, this.pairs.reverse().getPairs(), this.getContext(), monitor);
            InstallOperationDebug.INSTANCE.setEngineOperation(null);
            return status;
        }
    }

    public static abstract class EngineOperation
    implements IInstallOperation {
        private static int nextAvailableId = 1;
        protected IAgentEngine engine;
        protected InstallContextTree tree;
        protected InstallableUnitPairList pairs;
        protected int id = nextAvailableId++;

        public EngineOperation(IAgentEngine engine, InstallContextTree tree, InstallableUnitPairList pairs) {
            this.engine = engine;
            this.tree = tree;
            this.pairs = pairs;
        }

        @Override
        public boolean shouldUndoOnError() {
            return false;
        }

        public static String toString(EngineOperation operation) {
            String result = NLS.bind((String)Messages.Director_Context_IUs, (Object)operation.getOperationContextId(), (Object)Integer.toString(operation.pairs.size()));
            return result;
        }

        public String toString() {
            return EngineOperation.toString(this);
        }

        public IAgentEngine getEngine() {
            return this.engine;
        }

        public InstallContextTree getContextTree() {
            return this.tree;
        }

        public InstallContext getContext() {
            return this.tree.getInstallContext();
        }

        public InstallableUnitPairList getPairs() {
            return this.pairs;
        }

        public int getId() {
            return this.id;
        }

        public static void log(Collection operations) {
            if (operations.size() == 0) {
                log.info(Messages.Director_No_Operations_To_Perform);
                return;
            }
            StringBuffer sb = new StringBuffer(1024);
            for (EngineOperation operation : operations) {
                InstallableUnitPairList list = operation.getPairs();
                sb.append(EngineOperation.toString(operation));
                sb.append('\n');
                if (!log.isDebugLoggable()) continue;
                for (InstallableUnitPair pair : list) {
                    if (pair.isIdentical()) continue;
                    sb.append("  ").append(pair).append('\n');
                }
            }
            sb.setLength(sb.length() - 1);
            if (log.isDebugLoggable()) {
                log.debug(sb.toString());
            } else {
                log.info(sb.toString());
            }
        }

        private String getOperationContextId() {
            String contextId = this.getContext().getFullId();
            String engineName = this.engine.getName();
            if (engineName != null && engineName.length() != 0) {
                contextId = String.valueOf(contextId) + " (" + engineName + ')';
            }
            return contextId;
        }
    }

    public static class EngineUninstallOperation
    extends EngineOperation {
        public EngineUninstallOperation(IAgentEngine engine, InstallContextTree tree, InstallableUnitPairList pairs) {
            super(engine, tree, pairs);
        }

        @Override
        public String toString() {
            return "uninstall: " + super.toString();
        }

        @Override
        public IStatus perform(InstallTransaction transaction, IProgressMonitor monitor) {
            InstallOperationDebug.INSTANCE.setEngineOperation(this);
            IStatus status = this.engine.uninstall(transaction, this.pairs.getPairs(), this.getContext(), monitor);
            InstallOperationDebug.INSTANCE.setEngineOperation(null);
            return status;
        }

        @Override
        public IStatus undoPerform(InstallTransaction transaction, IProgressMonitor monitor) {
            return null;
        }
    }

    public static class InstallableUnitPairList
    extends ArrayList {
        public InstallableUnitPairList() {
        }

        public InstallableUnitPairList(int initialCapacity) {
            super(initialCapacity);
        }

        public InstallableUnitPair[] getPairs() {
            return this.toArray(new InstallableUnitPair[this.size()]);
        }

        @Override
        public String toString() {
            if (this.size() == 0) {
                return "(empty)";
            }
            StringBuffer sb = new StringBuffer(50 * this.size());
            Iterator i = this.iterator();
            while (i.hasNext()) {
                sb.append(i.next()).append('\n');
            }
            sb.setLength(sb.length() - 1);
            return sb.toString();
        }

        public void addFrom(IInstallableUnit iu) {
            InstallableUnitPair pair = new InstallableUnitPair(iu, null);
            this.add(pair);
        }

        public void addTo(IInstallableUnit iu) {
            InstallableUnitPair pair = new InstallableUnitPair(null, iu);
            this.add(pair);
        }

        public InstallableUnitPairList reverse() {
            InstallableUnitPairList reversed = new InstallableUnitPairList(this.size());
            InstallableUnitPair[] pairs = this.getPairs();
            int i = pairs.length - 1;
            while (i >= 0) {
                reversed.add(pairs[i].reverse());
                --i;
            }
            return reversed;
        }

        public InstallableUnitPairList reverseList() {
            InstallableUnitPairList reversed = new InstallableUnitPairList(this.size());
            InstallableUnitPair[] pairs = this.getPairs();
            int i = pairs.length - 1;
            while (i >= 0) {
                reversed.add(pairs[i]);
                --i;
            }
            return reversed;
        }
    }

    public static class OrderDependency {
        private final InstallContextTree contextTree;
        private final InstallableUnitPair pair;
        private final Map dependsOn;
        private final String dependencyKey;

        protected OrderDependency(InstallContextTree contextTree, InstallableUnitPair pair, String dependencyKey, Map dependsOn) {
            this.contextTree = contextTree;
            this.pair = pair;
            this.dependencyKey = dependencyKey;
            this.dependsOn = dependsOn;
        }

        public OrderDependency(InstallContextTree contextTree, InstallableUnitPair pair, String dependencyKey) {
            this(contextTree, pair, dependencyKey, new LinkedHashMap());
        }

        public String toString() {
            String result = this.dependencyKey;
            if (this.dependsOn.size() != 0) {
                StringBuffer sb = new StringBuffer();
                for (Map.Entry entry : this.dependsOn.entrySet()) {
                    String key = (String)entry.getKey();
                    OrderDependency dependency = (OrderDependency)entry.getValue();
                    if (sb.length() != 0) {
                        sb.append(",\n    ");
                    }
                    sb.append(key);
                    if (!dependency.isPassive()) continue;
                    sb.append(" [PASSIVE]");
                }
                result = String.valueOf(result) + " -> " + sb.toString();
            }
            return result;
        }

        public void addDependency(OrderDependency dependency, boolean isPassive) {
            String key = dependency.getDependencyKey();
            if (isPassive && !dependency.isPassive()) {
                dependency = new PassiveOrderDependency(dependency);
            }
            if (this.dependsOn.containsKey(key)) {
                log.warning("installable unit in order dependency specified multiple times: " + IdentityUtil.getQualifiedVersionedId((IInstallableUnit)this.pair.getLatest()) + " -> " + key);
            }
            this.dependsOn.put(key, dependency);
        }

        public Map getDependencies() {
            return this.dependsOn;
        }

        public InstallContextTree getContextTree() {
            return this.contextTree;
        }

        public InstallableUnitPair getPair() {
            return this.pair;
        }

        public String getDependencyKey() {
            return this.dependencyKey;
        }

        public boolean dependenciesAreIdentical(Map identicalMap) {
            Boolean b = (Boolean)identicalMap.get(this.dependencyKey);
            if (b != null) {
                return b;
            }
            for (OrderDependency dependency : this.dependsOn.values()) {
                if (dependency.getPair().isIdentical() && dependency.dependenciesAreIdentical(identicalMap)) continue;
                identicalMap.put(this.dependencyKey, Boolean.FALSE);
                return false;
            }
            identicalMap.put(this.dependencyKey, Boolean.TRUE);
            return true;
        }

        public boolean nonPassiveDependenciesAreIdentical(Map identicalMap) {
            Boolean b = (Boolean)identicalMap.get(this.dependencyKey);
            if (b != null) {
                return b;
            }
            for (OrderDependency dependency : this.dependsOn.values()) {
                if (dependency.isPassive() || dependency.getPair().isIdentical() && dependency.nonPassiveDependenciesAreIdentical(identicalMap)) continue;
                identicalMap.put(this.dependencyKey, Boolean.FALSE);
                return false;
            }
            identicalMap.put(this.dependencyKey, Boolean.TRUE);
            return true;
        }

        public boolean isPassive() {
            return false;
        }
    }

    private static class OrderDependencyMap {
        private final Map orderDependencies = new HashMap();
        private final Map reverseOrderDependencies = new HashMap();

        private OrderDependencyMap() {
        }

        private void addDirectOrderDependency(String iu1FQN, String iu2FQN) {
            HashSet<String> dependsOnSet = (HashSet<String>)this.orderDependencies.get(iu1FQN);
            if (dependsOnSet == null) {
                dependsOnSet = new HashSet<String>();
                this.orderDependencies.put(iu1FQN, dependsOnSet);
            }
            dependsOnSet.add(iu2FQN);
            HashSet<String> reverseDependsOnSet = (HashSet<String>)this.reverseOrderDependencies.get(iu2FQN);
            if (reverseDependsOnSet == null) {
                reverseDependsOnSet = new HashSet<String>();
                this.reverseOrderDependencies.put(iu2FQN, reverseDependsOnSet);
            }
            reverseDependsOnSet.add(iu1FQN);
        }

        private void addDirectOrderDependency(String iuFQN, Set dependsOnFQNSet) {
            for (String dependsOnFQN : dependsOnFQNSet) {
                this.addDirectOrderDependency(iuFQN, dependsOnFQN);
            }
        }

        public void addOrderDependency(String iu1FQN, String iu2FQN) {
            HashSet<String> dependsOnSet = new HashSet<String>();
            dependsOnSet.add(iu2FQN);
            Set indirectDependsOnSet = (Set)this.orderDependencies.get(iu2FQN);
            if (indirectDependsOnSet != null) {
                dependsOnSet.addAll(indirectDependsOnSet);
            }
            this.addDirectOrderDependency(iu1FQN, dependsOnSet);
            Set reverseDependsOnSet = (Set)this.reverseOrderDependencies.get(iu1FQN);
            if (reverseDependsOnSet != null) {
                for (String iu3 : reverseDependsOnSet) {
                    this.addDirectOrderDependency(iu3, dependsOnSet);
                }
            }
        }

        public boolean isDependsOn(String iu1FQN, String iu2FQN) {
            Set dependsOn = (Set)this.orderDependencies.get(iu1FQN);
            return dependsOn != null && dependsOn.contains(iu2FQN);
        }
    }

    private static class PassiveOrderDependency
    extends OrderDependency {
        public PassiveOrderDependency(OrderDependency dependency) {
            super(dependency.getContextTree(), dependency.getPair(), dependency.getDependencyKey(), dependency.getDependencies());
        }

        @Override
        public boolean isPassive() {
            return true;
        }
    }

    private static final class Statistics {
        public static final Logger slog = Logger.getLogger(Statistics.class);
        long maxPathLength = 0L;
        long numberOfPaths = 0L;
        long sumOfPathLengths = 0L;
        HashMap graph = new HashMap();

        public Statistics() {
        }

        public Statistics(OrderDependency dependency) {
            this.graph.put(dependency.getDependencyKey(), this);
            this.maxPathLength = 1L;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("numberOfPaths=").append(this.numberOfPaths);
            sb.append(", maxPathLength=").append(this.maxPathLength);
            double averagePathLength = this.numberOfPaths == 0L ? 0.0 : (double)this.sumOfPathLengths / (double)this.numberOfPaths;
            sb.append(", averagePathLength=").append(averagePathLength);
            sb.append(", graphSize=").append(this.graph.size());
            return sb.toString();
        }
    }
}

