/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.core;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentActivator;
import com.ibm.cic.agent.core.AgentInstall;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentRegressingUpdateWarningUtil;
import com.ibm.cic.agent.core.AgentRelaunch;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.CacheLocationManager;
import com.ibm.cic.agent.core.CacheManager;
import com.ibm.cic.agent.core.Engine;
import com.ibm.cic.agent.core.IAgentEngine;
import com.ibm.cic.agent.core.IAgentEventManager;
import com.ibm.cic.agent.core.IInstallAdaptor;
import com.ibm.cic.agent.core.IInstallOperation;
import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.InstallContextTree;
import com.ibm.cic.agent.core.InstallJob;
import com.ibm.cic.agent.core.InstallTransaction;
import com.ibm.cic.agent.core.ModifyJob;
import com.ibm.cic.agent.core.PostSessionManager;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.UndoProgress;
import com.ibm.cic.agent.core.UninstallJob;
import com.ibm.cic.agent.core.UpdateOfferingJob;
import com.ibm.cic.agent.core.UserFeedback;
import com.ibm.cic.agent.core.internal.expander.ExpansionResult;
import com.ibm.cic.agent.core.utils.AgentUserOptions;
import com.ibm.cic.agent.internal.core.AdaptorManager;
import com.ibm.cic.agent.internal.core.DisableRestoreCancelEnablementHelper;
import com.ibm.cic.agent.internal.core.InstallOrderManager;
import com.ibm.cic.agent.internal.core.InstallRegistry;
import com.ibm.cic.agent.internal.core.MemoryCleanup;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.agent.internal.core.MetadataReplacer;
import com.ibm.cic.agent.internal.core.NoCancelProgressMonitor;
import com.ibm.cic.agent.internal.core.debug.InstallOperationDebug;
import com.ibm.cic.agent.internal.core.history.HistoryStore;
import com.ibm.cic.agent.internal.core.history.IActivity;
import com.ibm.cic.agent.internal.core.history.IHistory;
import com.ibm.cic.common.core.api.utils.PlatformUtils;
import com.ibm.cic.common.core.artifactrepo.ArtifactOfInstallableUnit;
import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.base.AddArtifacts;
import com.ibm.cic.common.core.artifactrepo.base.IArtifactOperation;
import com.ibm.cic.common.core.definitions.LanguageCode;
import com.ibm.cic.common.core.model.Action;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.ISelectionExpression;
import com.ibm.cic.common.core.model.InstallableUnitPair;
import com.ibm.cic.common.core.model.adapterdata.IAdapterData;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.utils.MaxInstallSizeInfo;
import com.ibm.cic.common.core.model.utils.MaxInstallSizeUtil;
import com.ibm.cic.common.core.model.utils.OfferingProperty;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.model.validation.ValidationService;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.repository.CompositeRepository;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.utils.Check;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.DeviceSystem;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.LinkedProperties;
import com.ibm.cic.common.core.utils.MultiStatusUtil;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.SubtaskOnlyProgressMonitor;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.downloads.DownloadLiveSupplementaryReporter;
import com.ibm.cic.common.downloads.SizeInfo;
import com.ibm.cic.common.eclipseAdapterData.EclipseAdapterData;
import com.ibm.cic.common.eclipseAdapterData.EclipseAgentBundleData;
import com.ibm.cic.common.eclipseAdapterData.IEclipseData;
import com.ibm.cic.common.logging.LogManager;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.osgi.framework.Version;

public class Director {
    private static final Logger log = Logger.getLogger(Director.class, (Plugin)AgentActivator.getDefault());
    private static final Logger slog = Logger.getLoggerUsingDebug((String)"com.ibm.cic.agent.core/debug/Director/sizes");
    private final Engine engine;
    private final IAgentEngine p2engine;
    private boolean shouldValidate;
    private final Agent agent;
    private SizeCache sizeCache = null;

    public Director(Agent agent) {
        this.agent = agent;
        this.engine = new Engine();
        this.p2engine = Director.getP2Engine();
        this.shouldValidate = false;
    }

    public void start() {
        this.engine.start();
        if (this.p2engine != null) {
            this.p2engine.start();
        }
    }

    public IStatus stop() {
        CicMultiStatus result = Statuses.OK.getMultiStatus();
        result.add(this.engine.stop());
        if (this.p2engine != null) {
            result.add(this.p2engine.stop());
        }
        return result;
    }

    public void setValidating(boolean value) {
        this.shouldValidate = value;
    }

    public void getSizeInfo(AgentJob[] jobs, SizeInfo profileSize, MaxInstallSizeInfo cacheSize, IProgressMonitor monitor) {
        this.getSizeInfo(jobs, profileSize, cacheSize, true, monitor);
    }

    private void getSizeInfo(AgentJob[] jobs, SizeInfo profileSize, MaxInstallSizeInfo cacheSize, boolean setCacheManager, IProgressMonitor monitor) {
        List<IArtifact> haveArtifacts;
        profileSize.setSizes(0L, 0L);
        cacheSize.setSizes(0L, 0L, 0L);
        if (jobs.length == 0) {
            return;
        }
        try {
            jobs = Util.checkAndAdjustJobs(jobs);
        }
        catch (CoreException e) {
            log.status(e.getStatus());
            return;
        }
        if (this.sizeCache == null) {
            this.sizeCache = new SizeCache();
        }
        if (this.sizeCache.get(jobs, profileSize, cacheSize)) {
            return;
        }
        slog.start(slog.debug("getSizeInfo: {0}", new Object[]{jobs}));
        if (setCacheManager) {
            try {
                IStatus status = Director.setCacheManager(jobs);
                if (!status.isOK()) {
                    log.status(status);
                    this.sizeCache.put(jobs, profileSize, cacheSize);
                    return;
                }
            }
            catch (IllegalArgumentException e) {
                log.error("Failed to get size info: {0}", new Object[]{e.getMessage()});
                this.sizeCache.put(jobs, profileSize, cacheSize);
                return;
            }
        }
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor).split(1, 10, 1);
        jobs[0].getProfile().getInstallRegistry().resolveIUs(pm.next());
        InstallOrderManager orderManager = new InstallOrderManager(this.engine, this.p2engine);
        CicMultiStatus ms = Statuses.OK.getMultiStatus();
        ExpansionResult expansionResult = this.expandAndQualify(ms, jobs, orderManager, pm.next());
        if (StatusUtil.isErrorOrCancel((IStatus)ms)) {
            ms = MultiStatusUtil.fixErrorMessage((CicMultiStatus)ms, (String)Messages.Director_errorDeterminingSizeInfo, (Object[])new Object[]{Arrays.toString(jobs)});
            log.status((IStatus)ms);
            return;
        }
        LinkedHashSet allIUs = new LinkedHashSet(this.getAllToIUs(expansionResult, orderManager));
        try {
            haveArtifacts = CacheManager.getDefaultInstance().getArtifacts(pm.next());
        }
        catch (CoreException coreException) {
            haveArtifacts = Collections.EMPTY_LIST;
        }
        MaxInstallSizeUtil.getSizeInfo(haveArtifacts, allIUs, (SizeInfo)profileSize, (MaxInstallSizeInfo)cacheSize);
        MaxInstallSizeUtil.subtractSizeInfo(this.getAllFromIUs(expansionResult), (SizeInfo)profileSize);
        this.sizeCache.put(jobs, profileSize, cacheSize);
        if (setCacheManager) {
            Director.clearCacheManager(jobs);
        }
        slog.debug("Sizes for {0}:\n  profile: {1}, cache: {2}", new Object[]{jobs, profileSize, cacheSize});
        slog.stop();
        pm.done();
    }

    public IStatus validate(AgentJob[] jobs, IProgressMonitor monitor) {
        CicMultiStatus status = Statuses.OK.getMultiStatus();
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, jobs.length);
        AgentJob[] agentJobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            status.add(this.validate(job.getOfferingOrFix(), pm.next()));
            ++n2;
        }
        if (!status.isOK()) {
            status.setMessage(Messages.Director_Validation_Failed);
            IStatus userFeedback = Util.operationPassed((IStatus)status);
            if (!userFeedback.isOK()) {
                if (userFeedback.matches(8)) {
                    log.status(userFeedback);
                }
                return userFeedback;
            }
        }
        return Status.OK_STATUS;
    }

    public IStatus validate(IOfferingOrFix offeringOrFix, IProgressMonitor monitor) {
        IStatus status = ValidationService.getDefault().validate((IContent)offeringOrFix, monitor);
        if (status.isOK()) {
            return status;
        }
        return Statuses.ST.createMultiStatus(status.getCode(), status.getChildren(), Messages.Director_Validation_Failed_For_Offering, new Object[]{offeringOrFix});
    }

    public Agent.IAssignedArtifacts collect(CicMultiStatus[] status, AgentJob[] jobs, IProgressMonitor monitor) {
        log.info(Util.collectLogString(jobs));
        ArrayList<CacheManager.ArtifactsToDownload> assigned = new ArrayList<CacheManager.ArtifactsToDownload>(4);
        try {
            jobs = Util.checkAndAdjustJobs(jobs);
            Collection profileJobsList = AgentUtil.groupByProfile(jobs, false);
            SplitProgressMonitor pm = new SplitProgressMonitor(monitor, Messages.Director_Collecting_Files, profileJobsList.size());
            CacheManager.ArtifactsToDownload priorAssignedArtifacts = null;
            Iterator i = profileJobsList.iterator();
            while (i.hasNext()) {
                SplitProgressMonitor pm2 = new SplitProgressMonitor(pm.next(), new int[]{1, 1, 4});
                AgentJob[] profileJobs = (AgentJob[])i.next();
                Profile profile = profileJobs[0].getProfile();
                profile.getInstallRegistry().resolveIUs(pm2.next());
                InstallOrderManager orderManager = new InstallOrderManager(this.engine, this.p2engine);
                ExpansionResult expansionResult = this.expandAndQualify(status[0], profileJobs, orderManager, pm2.next());
                if (!status[0].isOK()) {
                    status[0] = Util.fixStatus(status[0]);
                    break;
                }
                status[0].add(Director.setCacheManager(profileJobs));
                CacheManager.ArtifactsToDownload assignedArtifacts = new CacheManager.ArtifactsToDownload(profile.isAgentProfile() ? null : priorAssignedArtifacts);
                this.setCompositeRepositoryHints(profileJobs);
                CacheManager.getDefaultInstance().beginCollection(profileJobs, assignedArtifacts);
                this.collectNoBegin(status[0], assignedArtifacts, this.getAllToIUs(expansionResult, orderManager), pm2.next());
                CompositeRepository.clearOfferingOrFixesHints();
                assigned.add(assignedArtifacts);
                Director.clearCacheManager(profileJobs);
                if (profile.isAgentProfile()) continue;
                priorAssignedArtifacts = assignedArtifacts;
            }
        }
        catch (CoreException e) {
            status[0].add(e.getStatus());
        }
        if (status[0].isOK()) {
            if (assigned.size() == 1) {
                return (Agent.IAssignedArtifacts)assigned.get(0);
            }
            return new MultiAssignedArtifacts(assigned);
        }
        status[0] = MultiStatusUtil.fixErrorMessage((CicMultiStatus)status[0], (String)Messages.Director_Failed_To_Find_All_Installation_Files, (Object[])new Object[0]);
        log.status((IStatus)status[0]);
        return null;
    }

    public IStatus prepare(IOfferingOrFix toPrepare, String[] selectorIds, Profile profile, IProgressMonitor monitor) {
        InstallableUnitPair.List selectedUnits = this.computeIUsForPrepare(toPrepare, selectorIds, profile);
        return this.prepare(toPrepare, selectedUnits, profile, monitor);
    }

    public IStatus prepareAgentBundles(IOfferingOrFix toPrepare, String[] agentBundleIds, String[] selectorIds, Profile profile, IProgressMonitor monitor) {
        List ius;
        try {
            ius = this.computeIUsForAgentBundles(toPrepare, agentBundleIds, selectorIds);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        InstallableUnitPair.List selectedUnits = new InstallableUnitPair.List(4);
        selectedUnits.addAllTo((Collection)ius);
        return this.prepare(toPrepare, selectedUnits, profile, monitor);
    }

    private IStatus prepare(IOfferingOrFix toPrepare, InstallableUnitPair.List selectedUnits, Profile profile, IProgressMonitor monitor) {
        if (selectedUnits.size() == 0) {
            return Status.OK_STATUS;
        }
        log.start(log.info(Messages.Director_Preparing, new Object[]{toPrepare.getIdentity() + " " + toPrepare.getVersion()}));
        String msg = NLS.bind((String)Messages.Director_Preparing, (Object)toPrepare.getName());
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, msg, new int[]{1, 6, 4, 1, 1});
        CicMultiStatus status = Statuses.OK.getMultiStatus();
        CacheManager prevCacheManager = CacheManager.pushDefaultInstance(status, this.agent.getAgentBundleCacheManager());
        if (!status.isOK()) {
            return status;
        }
        DownloadLiveSupplementaryReporter dlLiveReporter = new DownloadLiveSupplementaryReporter();
        try {
            pm.next().worked(1);
            List ius = InstallableUnitPair.getAllToIUs((InstallableUnitPair.List)selectedUnits);
            CacheManager.ArtifactsToDownload collected = new CacheManager.ArtifactsToDownload();
            CompositeRepository.addOfferingOrFixesHint((IOfferingOrFix)toPrepare);
            this.collect(collected, status, ius, null, pm.next());
            CacheManager.ArtifactsToDownload downloaded = this.fetch(status, null, collected, pm.next());
            if (status.isOK()) {
                CacheManager.getDefaultInstance().setDownloadedArtifacts(downloaded);
                InstallableUnitPair[] pairs = selectedUnits.getPairs();
                this.explode(status, pairs, pm.next());
                if (status.isOK()) {
                    InstallTransaction transaction = new InstallTransaction(msg, false, status, pm.next());
                    status.add(this.engine.install(transaction, pairs, profile.getRootContext(), transaction.getTransactionMonitor()));
                }
            }
        }
        finally {
            this.checkKeepSupplementaryLog(dlLiveReporter, status);
        }
        CacheManager.getDefaultInstance().forgetDownloadState();
        CacheManager.popDefaultInstance(prevCacheManager);
        pm.done();
        status = MultiStatusUtil.fixErrorMessage((CicMultiStatus)status, (String)Messages.Director_Error_Preparing, (Object[])new Object[]{toPrepare.getName()});
        log.statusNotOK((IStatus)status);
        log.stop();
        return status;
    }

    public IStatus unloadAgentBundles(IOfferingOrFix toUnload, Profile profile, String[] agentBundleIds, String[] selectorIds, IProgressMonitor monitor) {
        List ius;
        try {
            ius = this.computeIUsForAgentBundles(toUnload, agentBundleIds, selectorIds);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        if (ius.size() == 0) {
            return Status.OK_STATUS;
        }
        InstallableUnitPair.List selectedUnits = new InstallableUnitPair.List(4);
        selectedUnits.addAllFrom((Collection)ius);
        InstallableUnitPair.List selectedIUs = new InstallableUnitPair.List(ius.size());
        selectedIUs.addAllFrom((Collection)ius);
        log.start(log.info(Messages.Director_Unpreparing, new Object[]{toUnload.getIdentity() + " " + toUnload.getVersion()}));
        String msg = NLS.bind((String)Messages.Director_Unpreparing, (Object)toUnload.getName());
        CicMultiStatus status = Statuses.OK.getMultiStatus();
        CacheManager prevCacheManager = CacheManager.pushDefaultInstance(status, this.agent.getAgentBundleCacheManager());
        if (!status.isOK()) {
            return status;
        }
        InstallableUnitPair[] pairs = selectedIUs.getPairs();
        InstallTransaction transaction = new InstallTransaction(msg, false, status, monitor);
        status.add(this.engine.uninstall(transaction, pairs, profile.getRootContext(), transaction.getTransactionMonitor()));
        CacheManager.popDefaultInstance(prevCacheManager);
        status = MultiStatusUtil.fixErrorMessage((CicMultiStatus)status, (String)Messages.Director_Error_Unpreparing, (Object[])new Object[]{toUnload.getName()});
        log.statusNotOK((IStatus)status);
        log.stop();
        return status;
    }

    private void checkKeepSupplementaryLog(DownloadLiveSupplementaryReporter dlLiveReporter, CicMultiStatus status) {
        boolean keepIfUsed = status.matches(12);
        String explanationMessage = null;
        dlLiveReporter.checkLastSupplementaryLogger(log, keepIfUsed, explanationMessage);
    }

    public static AgentJob getAdjustedJob(AgentJob job) {
        return Util.getAdjustedJob(job);
    }

    public IStatus checkJobs(boolean isInstall, AgentJob[] jobs, IProgressMonitor monitor) {
        try {
            jobs = Util.checkAndAdjustJobs(isInstall, AdjustedAgentJob.copy(jobs));
            Collection profileJobsList = AgentUtil.groupByProfile(jobs, false);
            SplitProgressMonitor pm = new SplitProgressMonitor(monitor, 3 * profileJobsList.size());
            for (AgentJob[] profileJobs : profileJobsList) {
                StatusUtil.throwIfError((IStatus)AgentUtil.validateCompatibleJobs(profileJobs));
                profileJobs[0].getProfile().getInstallRegistry().resolveIUs(pm.next());
                ExpansionResult expansionResult = ExpansionResult.expand(profileJobs, pm.next());
                StatusUtil.throwIfError((IStatus)expansionResult.getStatus());
                StatusUtil.throwIfError((IStatus)this.qualify(profileJobs, expansionResult.getRootContextTree(), pm.next()));
            }
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            log.status(e.getStatus());
            return e.getStatus();
        }
    }

    public IStatus install(AgentJob[] jobs, Agent.IAssignedArtifacts collected, Agent.IDisableCancel disableCancel, IProgressMonitor monitor) {
        IStatus postSessionBundleStatus;
        if (jobs.length == 0) {
            return Status.OK_STATUS;
        }
        this.agent.getEventManager().fireBeforeInstallSession(jobs);
        try {
            jobs = Util.checkAndAdjustJobs(true, jobs);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (this.shouldValidate) {
            IStatus validationStatus = this.validate(jobs, (IProgressMonitor)sm.newChild(5));
            if (!validationStatus.isOK()) {
                return validationStatus;
            }
            sm.setWorkRemaining(100);
        }
        IStatus preInstallStatus = this.preInstallSession(jobs, (IProgressMonitor)sm.newChild(1));
        CicMultiStatus result = Statuses.OK.getMultiStatus();
        if (!preInstallStatus.isOK()) {
            result.add(preInstallStatus);
        } else {
            Collection profileJobsList = AgentUtil.groupByProfile(jobs, true);
            sm.setWorkRemaining(10 * profileJobsList.size() + 1);
            AgentJob agentJob = null;
            for (AgentJob[] profileJobs : profileJobsList) {
                AgentJob job = profileJobs[0];
                if (job.getProfile().isAgentProfile()) {
                    assert (agentJob == null && profileJobs.length == 1);
                    agentJob = job;
                }
                IStatus regressingUpdateWarning = AgentRegressingUpdateWarningUtil.checkRegressingUpdateWarning(this.agent, profileJobs, profileJobsList.size() > 1, false);
                log.statusNotOK(regressingUpdateWarning);
                if (this.agent.isSilentMode()) {
                    result.add(regressingUpdateWarning);
                }
                log.start(log.info(Util.toString(profileJobs)));
                this.fireBeforeInstall(profileJobs);
                IActivity[] activities = this.createInstallActivities(profileJobs);
                this.beginActivities(activities);
                CicMultiStatus status = this.doInstall(profileJobs, collected, disableCancel, (IProgressMonitor)sm.newChild(9, 0));
                status = Director.fixErrorMessage(status, profileJobs);
                this.endActivities(activities, (IStatus)status);
                this.fireAfterInstall(profileJobs, (IStatus)status);
                log.statusNotOK((IStatus)status);
                log.stop();
                if (status.isErrorOrCancel()) {
                    if (agentJob != null) {
                        sm.setWorkRemaining(10);
                        this.undoAgentInstall(agentJob, (IProgressMonitor)sm.newChild(9, 0));
                    }
                    result = status;
                    break;
                }
                result.add((IStatus)status);
            }
            if (agentJob != null) {
                IStatus status = AgentInstall.getInstance().finish(agentJob.getProfile().getInstallLocation());
                result.add(status);
            }
        }
        sm.setWorkRemaining(2);
        IStatus postInstallStatus = this.postInstallSession(jobs, (IStatus)result, disableCancel, (IProgressMonitor)sm.newChild(1));
        if (result.isOK() && !postInstallStatus.isOK()) {
            result.add(postInstallStatus);
        }
        if (!(postSessionBundleStatus = PostSessionManager.getInstance().run(jobs, (IProgressMonitor)sm.newChild(1))).isOK()) {
            result.add(postSessionBundleStatus);
        }
        this.agent.getEventManager().fireAfterInstallSession(jobs, (IStatus)result);
        return result;
    }

    private void undoAgentInstall(AgentJob job, IProgressMonitor monitor) {
        AgentInstall ai = AgentInstall.getInstance();
        if (!job.getType().isInstall() || !ai.isAgentInstallerRunning()) {
            return;
        }
        Profile profile = job.getProfile();
        IOffering offering = job.getOffering();
        InstallRegistry.ProfileInstallRegistry installRegistry = profile.getInstallRegistry();
        IOffering[] installed = installRegistry.getInstalledOfferings(offering.getIdentity());
        if (installed.length != 1 || !installed[0].equals(offering)) {
            return;
        }
        for (InstallRegistry.ProfileInstallRegistry registry : InstallRegistry.getInstance().getProfileInstallRegistries()) {
            Profile profileInRegistry = registry.getProfile();
            if (profileInRegistry == null || profileInRegistry.equals(profile) || registry.isEmpty()) continue;
            return;
        }
        UninstallJob uninstallJob = new UninstallJob(profile, (IOfferingOrFix)offering);
        this.doUninstall(new AgentJob[]{uninstallJob}, new CacheManager.ArtifactsToDownload(), null, monitor);
        if (!installRegistry.isInstalled(offering)) {
            FileUtil.rm_r((File)ai.getLogicalInstallLocation(new File(profile.getInstallLocation())), (boolean)true);
        }
    }

    public IStatus uninstall(AgentJob[] jobs, Agent.IAssignedArtifacts collected, Agent.IDisableCancel disableCancel, IProgressMonitor monitor) {
        IStatus postSessionBundleStatus;
        if (jobs.length == 0) {
            return Status.OK_STATUS;
        }
        try {
            jobs = Util.checkAndAdjustJobs(false, jobs);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, new int[]{1, 94, 5, 2});
        this.agent.getEventManager().fireBeforeUninstallSession(jobs);
        CicMultiStatus result = Statuses.OK.getMultiStatus();
        IStatus preUninstallStatus = this.preUninstallSession(jobs, pm.next());
        if (!preUninstallStatus.isOK()) {
            result.add(preUninstallStatus);
            pm.next();
        } else {
            Collection profileJobsList = AgentUtil.groupByProfile(jobs, true);
            SplitProgressMonitor pmProfileJobsList = new SplitProgressMonitor(pm.next(), profileJobsList.size());
            for (AgentJob[] profileJobs : profileJobsList) {
                SplitProgressMonitor pm2 = new SplitProgressMonitor(pmProfileJobsList.next(), new int[]{1, 20});
                log.start(log.info(Util.toString(profileJobs)));
                this.fireBeforeUninstall(profileJobs);
                IActivity[] activities = this.createUninstallActivities(profileJobs);
                this.beginActivities(activities);
                CicMultiStatus status = this.doUninstall(profileJobs, collected, disableCancel, pm2.next());
                status = Director.fixErrorMessage(status, profileJobs);
                this.endActivities(activities, (IStatus)status);
                this.fireAfterUninstall(profileJobs, (IStatus)status);
                log.statusNotOK((IStatus)status);
                log.stop();
                if (status.isErrorOrCancel()) {
                    result = status;
                    break;
                }
                result.add((IStatus)status);
            }
        }
        IStatus postUninstallStatus = this.postUninstallSession(jobs, (IStatus)result, disableCancel, pm.next());
        if (result.isOK() && !postUninstallStatus.isOK()) {
            result.add(postUninstallStatus);
        }
        if (!(postSessionBundleStatus = PostSessionManager.getInstance().run(jobs, pm.next())).isOK()) {
            result.add(postSessionBundleStatus);
        }
        this.agent.getEventManager().fireAfterUninstallSession(jobs, (IStatus)result);
        return result;
    }

    private void fireBeforeInstall(AgentJob[] jobs) {
        IAgentEventManager eventManager = this.agent.getEventManager();
        AgentJob[] agentJobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            eventManager.fireBeforeInstallOfferingOrFix(job);
            ++n2;
        }
    }

    private void fireAfterInstall(AgentJob[] jobs, IStatus status) {
        IAgentEventManager eventManager = this.agent.getEventManager();
        AgentJob[] agentJobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            eventManager.fireAfterInstallOfferingOrFix(job, status);
            ++n2;
        }
    }

    private void fireBeforeUninstall(AgentJob[] jobs) {
        IAgentEventManager eventManager = this.agent.getEventManager();
        AgentJob[] agentJobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            eventManager.fireBeforeUninstallOfferingOrFix(job);
            ++n2;
        }
    }

    private void fireAfterUninstall(AgentJob[] jobs, IStatus status) {
        IAgentEventManager eventManager = this.agent.getEventManager();
        AgentJob[] agentJobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            eventManager.fireAfterUninstallOfferingOrFix(job, status);
            ++n2;
        }
    }

    private void fireFetchCompleted(AgentJob[] jobs, CicMultiStatus status, CacheManager.ArtifactsToDownload downloaded) {
        IAgentEventManager eventManager = this.agent.getEventManager();
        AgentJob[] agentJobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            eventManager.fireFetchCompleted(this.agent, job.getOfferingOrFix(), status, downloaded);
            ++n2;
        }
    }

    private void fireBeginFetch(AgentJob[] jobs, CicMultiStatus status) {
        IAgentEventManager eventManager = this.agent.getEventManager();
        AgentJob[] agentJobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            eventManager.fireBeginFetch(this.agent, job.getOfferingOrFix(), status);
            ++n2;
        }
    }

    private HistoryStore getHistory() {
        return this.agent.getHistoryStore();
    }

    private IActivity[] createInstallActivities(AgentJob[] jobs) {
        IActivity[] activities = new IActivity[jobs.length];
        int i = 0;
        while (i < jobs.length) {
            AgentJob job = jobs[i];
            AgentJob.AgentJobType type = job.getType();
            if (type == AgentJob.AgentJobType.INSTALL_JOB || type == AgentJob.AgentJobType.MODIFY_JOB) {
                activities[i] = this.getHistory().createInstallActivity(job.getOfferingOrFix(), job.getFeaturesArray(), job.getProfile());
            } else if (type == AgentJob.AgentJobType.UPDATE_JOB) {
                activities[i] = job instanceof UpdateOfferingJob ? this.getHistory().createUpdateActivity((IOfferingOrFix)((UpdateOfferingJob)job).getUpdatedOffering(), ((UpdateOfferingJob)job).getOfferingOrFix(), job.getFeaturesArray(), job.getProfile()) : this.getHistory().createInstallActivity(job.getOfferingOrFix(), job.getFeaturesArray(), job.getProfile());
            } else if (type == AgentJob.AgentJobType.ROLLBACK_JOB) {
                activities[i] = this.getHistory().createRollbackActivity(job.getOffering(), job.getFeaturesArray(), job.getProfile());
            }
            ++i;
        }
        return activities;
    }

    private IActivity[] createUninstallActivities(AgentJob[] jobs) {
        IActivity[] activities = new IActivity[jobs.length];
        int i = 0;
        while (i < jobs.length) {
            AgentJob job = jobs[i];
            activities[i] = this.getHistory().createUninstallActivity(job.getOfferingOrFix(), job.getFeaturesArray(), job.getProfile());
            ++i;
        }
        return activities;
    }

    private IStatus checkForIncompleteActivities(IActivity[] activities) {
        if (activities.length == 0) {
            return Status.OK_STATUS;
        }
        IHistory history = activities[0].getHistory();
        boolean profileIsEmpty = true;
        boolean incompleteActivities = false;
        Iterator iterator = history.getActivities();
        while (iterator.hasNext()) {
            IActivity activity = (IActivity)iterator.next();
            IStatus status = activity.getStatus();
            if (status == null) {
                if (!profileIsEmpty) {
                    incompleteActivities = true;
                }
            } else if (!StatusUtil.isErrorOrCancel((IStatus)status)) {
                profileIsEmpty = false;
            }
            if (!activity.activityEmptiedProfile()) continue;
            profileIsEmpty = true;
            incompleteActivities = false;
        }
        if (!incompleteActivities) {
            return Status.OK_STATUS;
        }
        return Statuses.WARNING.get(Messages.Director_Incomplete_Activities_In_Package_Group, new Object[]{history.getProfileInfo().getProfileIdentity().getProfileId()});
    }

    private void beginActivities(IActivity[] activities) {
        IStatus status = this.checkForIncompleteActivities(activities);
        log.statusNotOK(status);
        IActivity[] iActivityArray = activities;
        int n = activities.length;
        int n2 = 0;
        while (n2 < n) {
            IActivity activity = iActivityArray[n2];
            this.beginActivity(activity);
            ++n2;
        }
    }

    private void beginActivity(IActivity activity) {
        if (activity != null) {
            activity.setLogFile(LogManager.getDefaultLogFile());
            activity.setStatus(null);
            this.getHistory().beginUpdateHistory(activity.getHistory());
        }
    }

    private void endActivities(IActivity[] activities, IStatus status) {
        IActivity[] iActivityArray = activities;
        int n = activities.length;
        int n2 = 0;
        while (n2 < n) {
            IActivity activity = iActivityArray[n2];
            this.endActivity(activity, status);
            ++n2;
        }
    }

    private void endActivity(IActivity activity, IStatus status) {
        if (activity != null) {
            activity.setLogFile(LogManager.getDefaultLogFile());
            activity.setActivityEmptiedProfile(this.isProfileEmpty(activity));
            activity.endActivity();
            activity.setStatus(status);
            this.getHistory().updateHistory(activity.getHistory());
        }
    }

    private boolean isProfileEmpty(IActivity activity) {
        if (activity.getActivityType() == 1) {
            String profileId = activity.getHistory().getProfileInfo().getProfileIdentity().getProfileId();
            Profile profile = InstallRegistry.getInstance().getProfile(profileId);
            if (profile == null || profile.isInstallLocationChangeable()) {
                return true;
            }
        }
        return false;
    }

    private CicMultiStatus doInstall(AgentJob[] jobs, Agent.IAssignedArtifacts collected, Agent.IDisableCancel disableCancel, IProgressMonitor monitor) {
        CicMultiStatus status = Statuses.OK.getMultiStatus();
        if (jobs.length == 0) {
            return status;
        }
        status.add(AgentUtil.validateCompatibleJobs(jobs));
        status.add(Director.setCacheManager(jobs));
        if (status.isOK()) {
            DownloadLiveSupplementaryReporter dlLiveReporter = new DownloadLiveSupplementaryReporter();
            try {
                this.doInstall(status, jobs, collected, disableCancel, monitor);
            }
            finally {
                this.checkKeepSupplementaryLog(dlLiveReporter, status);
            }
        }
        Director.clearCacheManager(jobs);
        return status;
    }

    private void doInstall(CicMultiStatus status, AgentJob[] jobs, Agent.IAssignedArtifacts collected, Agent.IDisableCancel disableCancel, IProgressMonitor monitor) {
        AgentJob.AgentJobType jobType = jobs[0].getType();
        String jobsDescription = Util.getProgressMessage(jobs);
        SplitProgressMonitor pm = AgentUserOptions.CIC_AGENT_DOWNLOAD_ONLY.isSet() ? new SplitProgressMonitor(monitor, Messages.Director_Fetching, 1) : new SplitProgressMonitor(monitor, jobsDescription, 2);
        SplitProgressMonitor pm1 = new SplitProgressMonitor(pm.next(), new int[]{3, 3, 1, 10});
        Profile profile = jobs[0].getProfile();
        profile.getInstallRegistry().resolveIUs(pm1.next());
        InstallOrderManager orderManager = new InstallOrderManager(this.engine, this.p2engine);
        ExpansionResult expansionResult = this.expandAndQualify(status, jobs, orderManager, pm1.next());
        expansionResult.clearCache();
        if (status.isOK() && !AgentUserOptions.CIC_AGENT_DOWNLOAD_ONLY.isSet()) {
            expansionResult.getRootContextTree().installInstallContextIUs();
        }
        InstallSizeDebug isd = InstallSizeDebug.NULL;
        CacheManager.ArtifactsToDownload downloaded = null;
        if (!this.agent.isSkipInstall()) {
            if (status.isOK()) {
                collected = this.collectIfNeeded(status, collected, jobs, profile, expansionResult, orderManager, pm1.next());
            }
            if (!status.isOK()) {
                return;
            }
            isd = new InstallSizeDebug(this, jobs);
            this.fireBeginFetch(jobs, status);
            downloaded = this.fetch(status, jobs, collected, pm1.next());
            this.fireFetchCompleted(jobs, status, downloaded);
            this.sizeCache = null;
        }
        if (AgentUserOptions.CIC_AGENT_DOWNLOAD_ONLY.isSet()) {
            return;
        }
        SplitProgressMonitor pm2 = new SplitProgressMonitor(pm.next(), new int[]{1, 2, 18, 1, 1, 4});
        Director.saveMetadata(status, jobs, pm2.next());
        InstallRegistry.getInstance().updateVersion();
        boolean isRollback = jobType.isRollback();
        boolean isAgentInstallerUpdate = Util.checkForAgentInstallerUpdate(status, jobs[0]);
        DisableRestoreCancelEnablementHelper ceh = new DisableRestoreCancelEnablementHelper(disableCancel, isRollback || isAgentInstallerUpdate);
        if (monitor.isCanceled()) {
            status.add(Status.CANCEL_STATUS);
        }
        try {
            CacheManager.getDefaultInstance().setDownloadedArtifacts(downloaded);
            if (status.isOK()) {
                List operations = orderManager.getEngineInstallOperations(isRollback);
                InstallOrderManager.EngineOperation.log(operations);
                if (!this.agent.isSkipInstall()) {
                    this.explode(status, expansionResult.getRootContextTree(), pm2.next());
                    if (!status.isErrorOrCancel()) {
                        this.performEngineOperations(status, jobsDescription, operations, pm2.next(), true, expansionResult, orderManager);
                    }
                }
                if (!status.isErrorOrCancel()) {
                    if (!this.agent.isSkipInstall()) {
                        this.agent.cleanupAfterAgentInstall(expansionResult.getProfile());
                        status.add(profile.copyAgentBundleCache(pm2.next()));
                    }
                    status.add(expansionResult.saveInstallRegistry(pm2.next()));
                    this.sizeCache = null;
                    isd.finish();
                }
            }
            Util.cleanCache(status, downloaded, disableCancel, pm2.next(), false);
            InstallRegistry.getInstance().cleanup();
            MemoryCleanup.start();
            status.add(Util.cleanInstallLocation(jobs[0].getProfile()));
        }
        finally {
            ceh.restoreCancelEnablement();
        }
    }

    private Agent.IAssignedArtifacts collectIfNeeded(CicMultiStatus status, Agent.IAssignedArtifacts collected, AgentJob[] jobs, Profile profile, ExpansionResult expansionResult, InstallOrderManager orderManager, IProgressMonitor monitor) {
        boolean needCollecting = false;
        if (collected == null) {
            collected = new CacheManager.ArtifactsToDownload();
            needCollecting = true;
        } else if (!collected.hasArtifactsForProfile(profile)) {
            needCollecting = true;
        }
        if (needCollecting) {
            this.collect(collected, status, this.getAllToIUs(expansionResult, orderManager), jobs, monitor);
        }
        return collected;
    }

    private List getAllToIUs(ExpansionResult expansionResult, InstallOrderManager orderManager) {
        LinkedHashSet set = new LinkedHashSet(256);
        for (InstallContextTree tree : expansionResult.getFullContextTree()) {
            set.addAll(InstallableUnitPair.getAllToIUs((InstallableUnitPair.List)tree.getPairs()));
        }
        orderManager.addAllReinstalledIUs(set);
        return Collections.unmodifiableList(new ArrayList(set));
    }

    private List<IInstallableUnit> getAllFromIUs(ExpansionResult expansionResult) {
        LinkedHashSet set = new LinkedHashSet(256);
        for (InstallContextTree tree : expansionResult.getFullContextTree()) {
            set.addAll(InstallableUnitPair.getAllFromIUs((InstallableUnitPair.List)tree.getPairs()));
        }
        return Collections.unmodifiableList(new ArrayList(set));
    }

    private CicMultiStatus doUninstall(AgentJob[] jobs, Agent.IAssignedArtifacts collected, Agent.IDisableCancel disableCancel, IProgressMonitor monitor) {
        CicMultiStatus status;
        block10: {
            status = Statuses.OK.getMultiStatus();
            if (jobs.length == 0) {
                return status;
            }
            status.add(Director.setCacheManager(jobs));
            if (CacheManager.getDefaultInstance().isAgentSelf()) {
                assert (jobs[0].getProfile().isAgentProfile());
                this.agent.setAgentUninstallingItself(true);
            }
            try {
                if (!status.isOK()) break block10;
                DownloadLiveSupplementaryReporter dlLiveReporter = new DownloadLiveSupplementaryReporter();
                try {
                    this.doUninstall(status, jobs, collected, disableCancel, monitor);
                }
                finally {
                    this.checkKeepSupplementaryLog(dlLiveReporter, status);
                }
            }
            finally {
                if (!status.isErrorOrCancel() && this.agent.isAgentUninstallingItself()) {
                    AgentRelaunch.getInstance().setRelaunchForUninstall(CacheManager.getDefaultInstance().getCacheLocation());
                }
                Director.clearCacheManager(jobs);
            }
        }
        return status;
    }

    private void doUninstall(CicMultiStatus status, AgentJob[] jobs, Agent.IAssignedArtifacts collected, Agent.IDisableCancel disableCancel, IProgressMonitor monitor) {
        String jobsDescription = Util.getProgressMessage(jobs);
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, jobsDescription, new int[]{3, 3, 1, 3, 2, 5, 2, 10});
        Profile profile = jobs[0].getProfile();
        profile.getInstallRegistry().resolveIUs(pm.next());
        InstallOrderManager orderManager = new InstallOrderManager(this.engine, this.p2engine);
        ExpansionResult expansionResult = this.expandAndQualify(status, jobs, orderManager, pm.next());
        CacheManager.ArtifactsToDownload downloaded = null;
        if (!this.agent.isSkipInstall()) {
            if (status.isOK()) {
                collected = this.collectIfNeeded(status, collected, jobs, profile, expansionResult, orderManager, pm.next());
            }
            if (!status.isOK()) {
                return;
            }
            this.fireBeginFetch(jobs, status);
            downloaded = this.fetch(status, jobs, collected, pm.next());
            this.fireFetchCompleted(jobs, status, downloaded);
            this.sizeCache = null;
        }
        InstallRegistry.getInstance().updateVersion();
        DisableRestoreCancelEnablementHelper ceh = new DisableRestoreCancelEnablementHelper(disableCancel, true);
        if (pm.isCanceled()) {
            status.add(Status.CANCEL_STATUS);
        }
        try {
            CacheManager.getDefaultInstance().setDownloadedArtifacts(downloaded);
            if (status.isOK()) {
                List operations = orderManager.getEngineUninstallOperations();
                InstallOrderManager.EngineOperation.log(operations);
                if (!this.agent.isSkipInstall()) {
                    this.explode(status, expansionResult.getRootContextTree(), pm.next());
                    this.performEngineOperations(status, jobsDescription, operations, pm.next(), false, expansionResult, orderManager);
                }
                status.add(expansionResult.saveInstallRegistry(pm.next()));
                this.sizeCache = null;
            }
            Util.cleanCache(status, downloaded, disableCancel, pm.next(), true);
            InstallRegistry.getInstance().cleanup();
            MemoryCleanup.start();
            status.add(Util.cleanInstallLocation(jobs[0].getProfile()));
        }
        finally {
            ceh.restoreCancelEnablement();
        }
    }

    private static IStatus setCacheManager(AgentJob[] jobs) {
        Profile profile = jobs[0].getProfile();
        int i = 1;
        while (i < jobs.length) {
            if (!profile.equals(jobs[i].getProfile())) {
                throw new IllegalArgumentException(NLS.bind((String)"setCacheManager called with inconsistent profiles: {0} and {1}", (Object)profile.getProfileId(), (Object)jobs[i].getProfile().getProfileId()));
            }
            ++i;
        }
        if (profile.isAgentProfile()) {
            IStatus status = AgentInstall.getInstance().addInstallerArtifactRepository();
            if (!status.isOK()) {
                return status;
            }
            profile.massageAgentInstallLocation();
            String location = profile.getInstallLocation();
            InstallRegistry.getInstance().setProperty("agent.install.location", location);
            return CacheManager.setDefaultInstance(Agent.getInstance().newAgentSelfCacheManager(location));
        }
        return CacheManager.setDefaultInstance();
    }

    private static void clearCacheManager(AgentJob[] jobs) {
        Profile profile = jobs[0].getProfile();
        if (profile.isAgentProfile()) {
            AgentInstall.getInstance().closeInstallerArtifactRepository();
        }
        CacheManager.clearDefaultInstance();
    }

    private ExpansionResult expandAndQualify(CicMultiStatus status, AgentJob[] jobs, InstallOrderManager orderManager, IProgressMonitor monitor) {
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor).split(20, 1, 2);
        ExpansionResult expansionResult = ExpansionResult.expand(jobs, pm.next());
        status.add(Util.operationPassed(expansionResult.getStatus()));
        if (status.isOK()) {
            InstallContextTree contextTree = expansionResult.getRootContextTree();
            MetadataReplacer replacer = new MetadataReplacer();
            replacer.replace(status, contextTree, pm.next());
            if (status.isOK()) {
                status.add(Util.operationPassed(this.qualify(jobs, contextTree, pm.next())));
                orderManager.setExpansionResult(expansionResult);
                orderManager.computeOrderDependentPairs();
                for (InstallContextTree tree : expansionResult.getFullContextTree()) {
                    tree.getPairs().removeIdentical();
                }
            }
        }
        return expansionResult;
    }

    private void computeIUActions(ExpansionResult expansionResult, InstallOrderManager orderManager) {
        List<InstallContextTree> trees = expansionResult.getFullContextTree();
        Iterator<InstallContextTree> iterator = trees.iterator();
        while (iterator.hasNext()) {
            InstallContextTree element;
            InstallContextTree tree = element = iterator.next();
            this.computeIUActions(tree);
            tree.getInstallContext().setInstallOrderManager(orderManager);
        }
        Collection allOrderDependencies = orderManager.getAllOrderDependencies();
        for (InstallOrderManager.OrderDependency dependency : allOrderDependencies) {
            InstallableUnitPair pair = dependency.getPair();
            if (!pair.isIdentical()) continue;
            dependency.getContextTree().getInstallContext().setIUAction(pair, Action.REINSTALL);
        }
    }

    private void clearIUActions(ExpansionResult expansionResult) {
        List<InstallContextTree> trees = expansionResult.getFullContextTree();
        Iterator<InstallContextTree> iterator = trees.iterator();
        while (iterator.hasNext()) {
            InstallContextTree element;
            InstallContextTree tree = element = iterator.next();
            this.clearIUActions(tree);
        }
    }

    private void computeIUActions(InstallContextTree tree) {
        InstallContext installContext = tree.getInstallContext();
        InstallableUnitPair.List pairs = tree.getOriginalPairs();
        for (InstallableUnitPair pair : pairs) {
            installContext.setIUAction(pair, this.computeIUAction(pair));
        }
    }

    private void clearIUActions(InstallContextTree tree) {
        InstallContext installContext = tree.getInstallContext();
        installContext.clearIUActions();
    }

    private Action computeIUAction(InstallableUnitPair pair) {
        Action action = null;
        IInstallableUnit from = pair.getFrom();
        IInstallableUnit to = pair.getTo();
        if (from != null && to != null) {
            int compare = from.compareVersion((IContent)to);
            action = compare == 0 ? Action.NONE : (compare < 0 ? Action.UPDATE : Action.ROLLBACK);
        } else if (from == null) {
            action = Action.INSTALL;
        } else if (to == null) {
            action = Action.UNINSTALL;
        }
        assert (action != null);
        return action;
    }

    private void setCompositeRepositoryHints(AgentJob[] jobs) {
        if (jobs == null || jobs.length == 0) {
            return;
        }
        AgentJob[] agentJobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob agentJob = agentJobArray[n2];
            CompositeRepository.addOfferingOrFixesHint((IOfferingOrFix)agentJob.getOfferingOrFix());
            ++n2;
        }
    }

    private void collect(Agent.IAssignedArtifacts assignedArtifacts, CicMultiStatus status, List ius, AgentJob[] jobs, IProgressMonitor monitor) {
        try {
            this.setCompositeRepositoryHints(jobs);
            CacheManager.getDefaultInstance().beginCollection(jobs, assignedArtifacts);
            this.collectNoBegin(status, assignedArtifacts, ius, monitor);
            CompositeRepository.clearOfferingOrFixesHints();
        }
        catch (CacheManager.CacheManagerException e) {
            status.add(e.getStatus());
        }
    }

    private void collectNoBegin(CicMultiStatus status, Agent.IAssignedArtifacts assignedArtifacts, List ius, IProgressMonitor monitor) {
        CacheManager cm = CacheManager.getDefaultInstance();
        if (this.agent.isSkipInstall() && !cm.isAgentBundle()) {
            return;
        }
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, ius.size());
        CicMultiStatus collectStatus = Statuses.OK.getMultiStatus();
        for (IInstallableUnit iu : ius) {
            collectStatus.add(cm.collect(assignedArtifacts, iu, pm.next()));
            if (collectStatus.isCancel()) break;
        }
        if (collectStatus.isError()) {
            CicMultiStatus errorStatus = Statuses.ERROR.getMultiStatus(Messages.Director_Failed_To_Find_All_Installation_Files, new Object[0]);
            errorStatus.addAll((IStatus)collectStatus);
            status.add((IStatus)errorStatus);
            status.setMessage(Messages.Director_Failed_To_Find_All_Installation_Files);
        } else {
            status.addAll((IStatus)collectStatus);
        }
    }

    private CacheManager.ArtifactsToDownload fetch(CicMultiStatus status, AgentJob[] jobs, Agent.IAssignedArtifacts collected, IProgressMonitor monitor) {
        if (status.isOK()) {
            Util.logAssignedArtifacts(collected);
            return CacheManager.getDefaultInstance().downloadArtifacts(status, jobs, collected, monitor);
        }
        return null;
    }

    private static void saveMetadata(CicMultiStatus status, AgentJob[] jobs, IProgressMonitor monitor) {
        if (!status.isOK()) {
            return;
        }
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, jobs.length);
        AgentJob[] agentJobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            if (!job.getType().isUninstall() && !job.getType().isRollback()) {
                IOfferingOrFix offeringOrFix = job.getOfferingOrFix();
                try {
                    InstallRegistry.getInstance().saveMetadata(job.getProfile(), offeringOrFix, pm.next());
                }
                catch (CoreException e) {
                    CicMultiStatus ms = Statuses.ERROR.getMultiStatus(Messages.Director_Error_Saving_Metadata_For_Package, new Object[]{offeringOrFix.getIdentity(), offeringOrFix.getVersion()});
                    ms.add(e.getStatus());
                    status.add((IStatus)ms);
                }
            }
            ++n2;
        }
    }

    private static Collection selectIUsForPrepare(Collection ius, String[] selectorIds) {
        ArrayList<IInstallableUnit> selectedIUs = new ArrayList<IInstallableUnit>(ius.size());
        if (selectorIds != null) {
            final HashSet<String> extnCategorySet = new HashSet<String>(Arrays.asList(selectorIds));
            for (IInstallableUnit nextIU : ius) {
                IStatus status;
                ISelectionExpression expr = nextIU.getExpression();
                IStatus iStatus = status = expr == null ? Status.OK_STATUS : expr.evaluate(new ISelectionExpression.EvaluationContext(){

                    public IStatus evaluate(String selIdStr, String selValStr) {
                        return extnCategorySet.contains(selIdStr) ? Status.OK_STATUS : Status.CANCEL_STATUS;
                    }

                    public boolean canEvaluatePredefineds() {
                        return false;
                    }

                    public boolean mustIgnoreBundles() {
                        return true;
                    }
                });
                assert (status == null || status.getSeverity() != 1);
                if (status == null || !status.isOK()) continue;
                selectedIUs.add(nextIU);
            }
        } else {
            selectedIUs.addAll(ius);
        }
        return selectedIUs;
    }

    private InstallableUnitPair.List computeIUsForPrepare(IOfferingOrFix toPrepare, String[] selectorIds, Profile profile) {
        InstallableUnitPair.List selectedPairs = new InstallableUnitPair.List(4);
        Collection selectedIUs = Director.selectIUsForPrepare(toPrepare.getChildren(), selectorIds);
        selectedPairs.addAllTo(selectedIUs);
        if (toPrepare instanceof IFix) {
            IOffering[] baseOfferings;
            IFix fix = (IFix)toPrepare;
            IOffering[] iOfferingArray = baseOfferings = Agent.getInstance().getInstalledOfferingsForFix(profile, fix);
            int n = baseOfferings.length;
            int n2 = 0;
            while (n2 < n) {
                IOffering baseOffering = iOfferingArray[n2];
                selectedPairs.addAll(this.computeIUsForPrepare((IOfferingOrFix)baseOffering, selectorIds, profile));
                ++n2;
            }
        }
        return selectedPairs;
    }

    private List computeIUsForAgentBundles(IOfferingOrFix toPrepare, String[] agentBundleIds, String[] selectorIds) throws CoreException {
        List offeringIus = toPrepare.getChildren();
        List ius = selectorIds != null ? Director.selectIUsForPrepare(offeringIus, selectorIds) : offeringIus;
        ArrayList<IInstallableUnit> agentBundleIUs = new ArrayList<IInstallableUnit>(ius.size());
        HashSet<String> bundleIdSetToPrepare = agentBundleIds != null ? new HashSet<String>(Arrays.asList(agentBundleIds)) : null;
        HashSet<String> bundleIdSetFound = agentBundleIds != null ? new HashSet<String>(agentBundleIds.length) : null;
        for (IInstallableUnit unit : ius) {
            IEclipseData[] eclipseData;
            IAdapterData adapterData;
            if (!"eclipse".equals(unit.getAdapterId()) || !((adapterData = unit.getAdapterData()) instanceof EclipseAdapterData)) continue;
            EclipseAdapterData data = (EclipseAdapterData)adapterData;
            Collection elements = data.getDataElements();
            IEclipseData[] iEclipseDataArray = eclipseData = elements.toArray(new IEclipseData[elements.size()]);
            int n = eclipseData.length;
            int n2 = 0;
            while (n2 < n) {
                IEclipseData element = iEclipseDataArray[n2];
                String dataKind = element.getDataKind();
                if (EclipseAgentBundleData.getKind().equals(dataKind)) {
                    EclipseAgentBundleData agentBundleData = (EclipseAgentBundleData)element;
                    if ((bundleIdSetToPrepare == null || bundleIdSetToPrepare.contains(agentBundleData.getId())) && bundleIdSetFound != null) {
                        bundleIdSetFound.add(agentBundleData.getId());
                    }
                    agentBundleIUs.add(unit);
                }
                ++n2;
            }
        }
        if (agentBundleIds != null && agentBundleIds.length > 0 && selectorIds != null && selectorIds.length > 0) {
            HashSet<String> missingBundleIdSetToPrepare = new HashSet<String>(Arrays.asList(agentBundleIds));
            missingBundleIdSetToPrepare.removeAll(bundleIdSetFound);
            if (!missingBundleIdSetToPrepare.isEmpty()) {
                throw new CoreException((IStatus)Statuses.ERROR.get(Messages.Director_referencedBundlesNotFoundOrSelected0, new Object[]{toPrepare.getIdentity(), toPrepare.getVersion(), Arrays.asList(selectorIds), missingBundleIdSetToPrepare}));
            }
        }
        return agentBundleIUs;
    }

    public IStatus restart(Profile profile) {
        return this.engine.restart(profile);
    }

    private IStatus qualify(AgentJob[] jobs, InstallContextTree rootContext, IProgressMonitor monitor) {
        Profile profile = rootContext.getProfile();
        IInstallAdaptor[] allAdaptors = AdaptorManager.getInstance().getAllAdaptors();
        SubtaskOnlyProgressMonitor pmWrapper = new SubtaskOnlyProgressMonitor(monitor);
        SplitProgressMonitor pm = new SplitProgressMonitor((IProgressMonitor)pmWrapper, allAdaptors.length);
        try {
            IInstallAdaptor[] iInstallAdaptorArray = allAdaptors;
            int n = allAdaptors.length;
            int n2 = 0;
            while (n2 < n) {
                IInstallAdaptor adaptor = iInstallAdaptorArray[n2];
                IStatus status = adaptor.qualify(jobs, rootContext, profile, pm.next());
                if (!status.isOK()) {
                    IStatus iStatus = status;
                    return iStatus;
                }
                ++n2;
            }
        }
        finally {
            pm.done();
        }
        return Status.OK_STATUS;
    }

    private IStatus preInstallSession(AgentJob[] jobs, IProgressMonitor monitor) {
        IInstallAdaptor[] allAdaptors = AdaptorManager.getInstance().getAllAdaptors();
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, allAdaptors.length);
        CicMultiStatus status = Statuses.ST.createMultiStatus(Messages.Director_Pre_Session_Problem, new Object[0]);
        try {
            IInstallAdaptor[] iInstallAdaptorArray = allAdaptors;
            int n = allAdaptors.length;
            int n2 = 0;
            while (n2 < n) {
                IInstallAdaptor adaptor = iInstallAdaptorArray[n2];
                status.add(adaptor.preInstallSession(jobs, pm.next()));
                ++n2;
            }
        }
        finally {
            pm.done();
        }
        log.statusNotOK((IStatus)status);
        return status;
    }

    private IStatus postInstallSession(AgentJob[] jobs, IStatus sessionStatus, Agent.IDisableCancel disableCancel, IProgressMonitor monitor) {
        DisableRestoreCancelEnablementHelper ceh = new DisableRestoreCancelEnablementHelper(disableCancel, true);
        monitor = new NoCancelProgressMonitor((IProgressMonitor)monitor);
        IInstallAdaptor[] allAdaptors = AdaptorManager.getInstance().getAllAdaptors();
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, allAdaptors.length);
        CicMultiStatus status = Statuses.OK.getMultiStatus();
        try {
            IInstallAdaptor[] iInstallAdaptorArray = allAdaptors;
            int n = allAdaptors.length;
            int n2 = 0;
            while (n2 < n) {
                IInstallAdaptor adaptor = iInstallAdaptorArray[n2];
                status.add(adaptor.postInstallSession(jobs, sessionStatus, pm.next()));
                ++n2;
            }
        }
        finally {
            pm.done();
            ceh.restoreCancelEnablement();
        }
        log.statusNotOK((IStatus)status);
        return status;
    }

    private IStatus preUninstallSession(AgentJob[] jobs, IProgressMonitor monitor) {
        IInstallAdaptor[] allAdaptors = AdaptorManager.getInstance().getAllAdaptors();
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, allAdaptors.length);
        CicMultiStatus status = Statuses.ST.createMultiStatus(Messages.Director_Pre_Session_Problem, new Object[0]);
        try {
            IInstallAdaptor[] iInstallAdaptorArray = allAdaptors;
            int n = allAdaptors.length;
            int n2 = 0;
            while (n2 < n) {
                IInstallAdaptor adaptor = iInstallAdaptorArray[n2];
                status.add(adaptor.preUninstallSession(jobs, pm.next()));
                ++n2;
            }
        }
        finally {
            pm.done();
        }
        log.statusNotOK((IStatus)status);
        return status;
    }

    private IStatus postUninstallSession(AgentJob[] jobs, IStatus sessionStatus, Agent.IDisableCancel disableCancel, IProgressMonitor monitor) {
        DisableRestoreCancelEnablementHelper ceh = new DisableRestoreCancelEnablementHelper(disableCancel, true);
        monitor = new NoCancelProgressMonitor((IProgressMonitor)monitor);
        IInstallAdaptor[] allAdaptors = AdaptorManager.getInstance().getAllAdaptors();
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, allAdaptors.length);
        CicMultiStatus status = Statuses.OK.getMultiStatus();
        try {
            IInstallAdaptor[] iInstallAdaptorArray = allAdaptors;
            int n = allAdaptors.length;
            int n2 = 0;
            while (n2 < n) {
                IInstallAdaptor adaptor = iInstallAdaptorArray[n2];
                status.add(adaptor.postUninstallSession(jobs, sessionStatus, pm.next()));
                ++n2;
            }
        }
        finally {
            pm.done();
            ceh.restoreCancelEnablement();
        }
        log.statusNotOK((IStatus)status);
        return status;
    }

    public IStatus completeSession(AgentJob[] jobs, IProgressMonitor monitor) {
        IInstallAdaptor[] allAdaptors = AdaptorManager.getInstance().getAllAdaptors();
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, allAdaptors.length);
        CicMultiStatus status = Statuses.OK.getMultiStatus();
        try {
            IInstallAdaptor[] iInstallAdaptorArray = allAdaptors;
            int n = allAdaptors.length;
            int n2 = 0;
            while (n2 < n) {
                IInstallAdaptor adaptor = iInstallAdaptorArray[n2];
                status.add(adaptor.completeSession(jobs, pm.next()));
                ++n2;
            }
        }
        finally {
            pm.done();
        }
        log.statusNotOK((IStatus)status);
        return status;
    }

    private void performEngineOperations(CicMultiStatus status, String description, List operations, IProgressMonitor monitor, boolean undoable, ExpansionResult expansionResult, InstallOrderManager orderManager) {
        SubtaskOnlyProgressMonitor pmWrapper = new SubtaskOnlyProgressMonitor(monitor);
        InstallOperationDebug.INSTANCE.setEngineOperations(operations);
        this.computeIUActions(expansionResult, orderManager);
        description = String.valueOf(description) + ".  Performing " + String.valueOf(operations.size()) + " engine operations";
        InstallTransaction directorTransaction = new InstallTransaction(description, undoable, status, (IProgressMonitor)pmWrapper);
        IInstallOperation[] ops = operations.toArray(new IInstallOperation[operations.size()]);
        status.add(directorTransaction.performOperations(ops, this.getWeights(operations), directorTransaction.getTransactionMonitor()));
        if (status.isErrorOrCancel()) {
            directorTransaction.undoTransaction(UndoProgress.getUndoProgressMonitor());
        }
        this.clearIUActions(expansionResult);
        InstallOperationDebug.INSTANCE.setEngineOperations(null);
    }

    private int[] getWeights(List operations) {
        int[] weights = new int[operations.size()];
        int i = 0;
        while (i < operations.size()) {
            InstallOrderManager.EngineOperation operation = (InstallOrderManager.EngineOperation)operations.get(i);
            weights[i] = 10 * operation.getPairs().size() + 1;
            ++i;
        }
        return weights;
    }

    public static CicMultiStatus fixErrorMessage(CicMultiStatus status, AgentJob[] jobs) {
        AgentJob.AgentJobType jobType = jobs[0].getType();
        status = MultiStatusUtil.fixErrorMessage((CicMultiStatus)status, (String)(jobType.isModify() ? Messages.Director_Error_Modifying : (jobType.isRollback() ? Messages.Director_Error_Rolling_Back : (jobType.isUpdate() ? Messages.Director_Error_Updating : (jobType.isUninstall() ? Messages.Director_Error_Uninstalling : Messages.Director_Error_Installing)))), (Object[])new Object[0]);
        return status;
    }

    private static IAgentEngine getP2Engine() {
        IInstallAdaptor adaptor = AdaptorManager.getInstance().getAdaptor("p2Eclipse");
        if (adaptor == null || !(adaptor instanceof IAdaptable)) {
            return null;
        }
        IAdaptable adaptable = (IAdaptable)adaptor;
        IAgentEngine p2engine = (IAgentEngine)adaptable.getAdapter(IAgentEngine.class);
        return p2engine;
    }

    private void explode(CicMultiStatus result, InstallContextTree rootContext, IProgressMonitor monitor) {
        List trees = rootContext.getFullTree();
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, trees.size());
        try {
            Iterator i = trees.iterator();
            while (i.hasNext()) {
                if (monitor.isCanceled()) {
                    result.add(Status.CANCEL_STATUS);
                    return;
                }
                InstallContextTree tree = (InstallContextTree)i.next();
                this.explode(result, tree.getPairs().getPairs(), spm.next());
                if (!result.isErrorOrCancel()) continue;
                return;
            }
        }
        finally {
            spm.done();
            monitor.done();
        }
    }

    private void explode(CicMultiStatus result, InstallableUnitPair[] pairs, IProgressMonitor monitor) {
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, pairs.length);
        try {
            InstallableUnitPair[] installableUnitPairArray = pairs;
            int n = pairs.length;
            int n2 = 0;
            while (n2 < n) {
                InstallableUnitPair pair = installableUnitPairArray[n2];
                if (monitor.isCanceled()) {
                    result.add(Status.CANCEL_STATUS);
                    return;
                }
                IInstallableUnit unit = pair.getTo();
                if (unit == null) {
                    spm.next();
                } else {
                    this.explode(result, unit, spm.next());
                    if (result.isErrorOrCancel()) {
                        return;
                    }
                }
                ++n2;
            }
        }
        finally {
            spm.done();
            monitor.done();
        }
    }

    private void explode(CicMultiStatus result, IInstallableUnit unit, IProgressMonitor monitor) {
        IAdapterData data = unit.getAdapterData();
        Collection artifacts = data.getArtifacts();
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, artifacts.size());
        try {
            Iterator iterator = artifacts.iterator();
            while (iterator.hasNext()) {
                if (monitor.isCanceled()) {
                    result.add(Status.CANCEL_STATUS);
                    return;
                }
                IArtifact artifact = (IArtifact)iterator.next();
                this.explode(result, unit, artifact, spm.next());
                if (!result.matches(8)) continue;
                return;
            }
        }
        finally {
            spm.done();
            monitor.done();
        }
    }

    private void explode(CicMultiStatus result, IInstallableUnit unit, IArtifact artifact, IProgressMonitor monitor) {
        try {
            File artifactFile = CacheManager.getDefaultInstance().getArtifactLocation(unit, artifact, monitor);
            if (CicCommonSettings.getAccessRightsMode().isGroupMode() && artifact.isExploded() && (CicCommonSettings.isHpux() || CicCommonSettings.isZOS())) {
                String[] fileList = new String[]{FileUtil.getCanonicalPath((File)artifactFile)};
                PlatformUtils.chmod((String[])fileList, (String)"ug+rx", (boolean)true);
            }
        }
        catch (CacheManager.CacheManagerException e) {
            IStatus status = e.getStatus();
            if (status.matches(8)) {
                result.add(e.getStatus());
                return;
            }
            String msg = NLS.bind((String)Messages.Director_errorGettingArtifactLocation, (Object)e.getMessage());
            status = new Status(4, Agent.PI_AGENT, 1, msg, (Throwable)((Object)e));
            result.add(status);
        }
    }

    private static class AdjustedAgentJob
    extends AgentJob {
        private List adjustedFeatures;

        public static AgentJob[] copy(AgentJob[] jobs) {
            AgentJob[] result = new AgentJob[jobs.length];
            int i = 0;
            while (i < jobs.length) {
                AgentJob job = jobs[i];
                result[i] = job.getOffering() == null ? job : new AdjustedAgentJob(job, job.getFeatures());
                ++i;
            }
            return result;
        }

        public AdjustedAgentJob(AgentJob job, List features) {
            super(job.getType(), job.getOfferingOrFix(), job.getProfile());
            this.adjustedFeatures = features;
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + "; adjusted: " + com.ibm.cic.common.core.utils.Util.toFeatureIdString((Collection)this.adjustedFeatures);
        }

        @Override
        public List getFeatures() {
            return this.adjustedFeatures;
        }

        @Override
        public void setFeatures(Collection features) {
            assert (features != null);
            this.adjustedFeatures = new ArrayList(features);
        }
    }

    private static class InstallSizeDebug {
        private static final Logger dlog = Logger.getLogger((String)"InstallSize");
        public static final InstallSizeDebug NULL = new InstallSizeDebug();
        private final Map mtInfo;

        public InstallSizeDebug(Director director, AgentJob[] jobs) {
            if (!dlog.isDebugLoggable()) {
                this.mtInfo = null;
                return;
            }
            this.mtInfo = new HashMap();
            Profile profile = jobs[0].getProfile();
            SizeInfo profileSize = new SizeInfo();
            MaxInstallSizeInfo cacheSize = new MaxInstallSizeInfo();
            director.getSizeInfo(jobs, profileSize, cacheSize, false, null);
            this.doLocation(cacheSize.getMaxSize(), CacheManager.getDefaultInstance().getCacheLocation());
            this.doLocation(profileSize.getInstallSize(), new File(profile.getInstallLocation()));
        }

        private InstallSizeDebug() {
            this.mtInfo = null;
        }

        public String toString() {
            return this.mtInfo == null ? "<disabled>" : this.mtInfo.toString();
        }

        private void doLocation(long expected, File location) {
            File mt = DeviceSystem.getMountPoint((File)location);
            MtInfo info = (MtInfo)this.mtInfo.get(mt);
            if (info == null) {
                info = new MtInfo(DeviceSystem.getFreeSpace((File)mt));
                this.mtInfo.put(mt, info);
            }
            info.expected += expected;
        }

        public void finish() {
            if (this.mtInfo == null) {
                return;
            }
            for (Map.Entry entry : this.mtInfo.entrySet()) {
                File mt = (File)entry.getKey();
                MtInfo info = (MtInfo)entry.getValue();
                long used = info.free - DeviceSystem.getFreeSpace((File)mt);
                String pct = info.expected == 0L ? "?" : Long.toString(100L * used / info.expected);
                dlog.debug("On {0} expected use: {1} actual use: {2} ({3}% of expected)", new Object[]{mt, info.expected, used, pct});
            }
        }

        private static class MtInfo {
            public final long free;
            public long expected;

            public MtInfo(long free) {
                this.free = free;
                this.expected = 0L;
            }

            public String toString() {
                return "free=" + this.free + " expected=" + this.expected;
            }
        }
    }

    private static class MultiAssignedArtifacts
    implements CacheManager.IArtifactsToDownload {
        private final List list;

        public MultiAssignedArtifacts(List list) {
            this.list = list;
        }

        public Collection getRepositories() {
            ArrayList<IRepository> result = new ArrayList<IRepository>(5);
            for (Agent.IAssignedArtifacts a : this.list) {
                for (IRepository o : a.getRepositories()) {
                    if (result.contains(o)) continue;
                    result.add(o);
                }
            }
            return result;
        }

        private boolean isActiveArtifact(CacheManager.ArtifactsToDownload atd, IArtifact artifact) {
            if (artifact.isExploded()) {
                return true;
            }
            ArtifactOfInstallableUnit aiu = atd.findMetadataArtifactReference(artifact);
            if (aiu == null) {
                return false;
            }
            return aiu.getInstallableUnit().getAdapterData().isActiveArtifact(artifact);
        }

        public Collection getAssignedArtifacts(IRepository repo) {
            int n = 0;
            for (Agent.IAssignedArtifacts a : this.list) {
                n += a.getAssignedArtifacts(repo).size();
            }
            LinkedHashSet<IArtifact> activeArtifacts = new LinkedHashSet<IArtifact>(n);
            ArrayList<IArtifact> result = new ArrayList<IArtifact>(n);
            for (CacheManager.ArtifactsToDownload atd : this.list) {
                for (IArtifact element : atd.getAssignedArtifacts(repo)) {
                    IArtifact artifact = element;
                    if (this.isActiveArtifact(atd, artifact)) {
                        if (activeArtifacts.contains(artifact)) continue;
                        activeArtifacts.add(artifact);
                        result.add(artifact);
                        continue;
                    }
                    result.add(artifact);
                }
            }
            return result;
        }

        @Override
        public CacheManager.ArtifactsToDownload download(CicMultiStatus status, AgentJob[] jobs, CacheManager cm, IProgressMonitor monitor) {
            assert (jobs != null);
            assert (jobs.length > 0);
            Profile wantedProfile = jobs[0].getProfile();
            for (CacheManager.ArtifactsToDownload atd : this.list) {
                if (!atd.hasArtifactsForProfile(wantedProfile)) continue;
                SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)21);
                this.reconcileWithPreviousDownloads(cm, atd, (IProgressMonitor)sm.newChild(1));
                return atd.download(status, jobs, cm, (IProgressMonitor)sm.newChild(20));
            }
            log.error("Internal error download of jobs which have not been collected {0}", new Object[]{jobs, new Throwable()});
            return null;
        }

        private void reconcileWithPreviousDownloads(final CacheManager cm, CacheManager.ArtifactsToDownload atd, IProgressMonitor monitor) {
            final SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)atd.getArtifacts().size());
            atd.visitAssignedRecords(new CacheManager.ArtifactsToDownload.IVisitAssignedRecords(){

                public void record(IRepository repo, Iterator recordIterator) {
                    IArtifactOperation.IArtifactOperationRecord record = (IArtifactOperation.IArtifactOperationRecord)recordIterator.next();
                    AddArtifacts.AddInput addInput = AddArtifacts.getAddInput((IArtifactOperation.IArtifactOperationRecord)record);
                    if (addInput == null) {
                        return;
                    }
                    IArtifact artifact = addInput.getArtifact();
                    if (artifact == null) {
                        return;
                    }
                    if (artifact.isExploded()) {
                        try {
                            if (cm.hasArtifact(artifact, (IProgressMonitor)sm.newChild(1))) {
                                log.debug("Exploded artifact was already downloaded: {0}", new Object[]{artifact});
                                recordIterator.remove();
                            }
                        }
                        catch (CoreException e) {
                            log.error((Throwable)e);
                        }
                    }
                }
            });
        }

        @Override
        public boolean hasArtifactsForProfile(Profile profile) {
            for (Agent.IAssignedArtifacts a : this.list) {
                if (!a.hasArtifactsForProfile(profile)) continue;
                return true;
            }
            return true;
        }

        @Override
        public void validate(CicMultiStatus status, IArtifactSession session, IProgressMonitor monitor) {
            SplitProgressMonitor spm = new SplitProgressMonitor(monitor, this.list.size());
            for (Agent.IAssignedArtifacts a : this.list) {
                a.validate(status, session, spm.next());
            }
        }
    }

    private static class SimpleLRUCache<E>
    extends LinkedHashMap<String, E> {
        private final int maxSize;

        SimpleLRUCache(int maxSize) {
            super(maxSize * 3, 0.75f, false);
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, E> eldest) {
            boolean remove;
            boolean bl = remove = this.size() > this.maxSize;
            if (remove) {
                String key = eldest.getKey();
                slog.debug("size info cache: removing entry for key: hash={0}, len={1}", new Object[]{key.hashCode(), key.length()});
            }
            return remove;
        }
    }

    private static class SizeCache {
        private final Map<String, SizeInfo> profileMap = new SimpleLRUCache<SizeInfo>(7);
        private final Map<String, MaxInstallSizeInfo> cacheMap = new SimpleLRUCache<MaxInstallSizeInfo>(7);

        private SizeCache() {
        }

        public boolean get(AgentJob[] jobs, SizeInfo profileSize, MaxInstallSizeInfo cacheSize) {
            String key = SizeCache.getKey(jobs);
            if (this.profileMap.containsKey(key)) {
                slog.debug("size info cache: retrieving info for key: hash={0}, len={1}", new Object[]{key.hashCode(), key.length()});
                profileSize.setSizes(this.profileMap.get(key));
                cacheSize.setSizes(this.cacheMap.get(key));
                return true;
            }
            return false;
        }

        public void put(AgentJob[] jobs, SizeInfo profileSize, MaxInstallSizeInfo cacheSize) {
            String key = SizeCache.getKey(jobs);
            this.profileMap.put(key, profileSize);
            this.cacheMap.put(key, cacheSize);
            slog.debug("size info cache: storing info for key: hash={0}, len={1}", new Object[]{key.hashCode(), key.length()});
        }

        private static String getUserDataKey(Profile profile) {
            LinkedProperties properties = profile.getAllData();
            StringBuffer sb = new StringBuffer(100);
            sb.append("[UserProps:");
            for (Map.Entry entry : properties.entrySet()) {
                String name = (String)entry.getKey();
                if (!Profile.isUserData(name)) continue;
                sb.append(name);
                sb.append('=');
                sb.append(entry.getValue());
                sb.append(';');
            }
            sb.append(']');
            return sb.toString();
        }

        private static String getKey(AgentJob[] jobs) {
            StringBuffer sb = new StringBuffer(100);
            AgentJob[] agentJobArray = jobs;
            int n = jobs.length;
            int n2 = 0;
            while (n2 < n) {
                AgentJob job = agentJobArray[n2];
                Profile profile = job.getProfile();
                sb.append(job.getOfferingOrFix()).append(' ');
                sb.append(profile.getProfileId()).append(' ');
                String nl = profile.getData("cic.selector.nl");
                if (nl != null && nl.length() > 0 && !nl.equals(LanguageCode.ENGLISH.getId())) {
                    sb.append(nl).append(' ');
                }
                sb.append(job.getFeatures()).append(' ');
                sb.append(SizeCache.getUserDataKey(profile));
                ++n2;
            }
            return sb.toString();
        }
    }

    private static class Util {
        private Util() {
        }

        public static boolean checkForAgentInstallerUpdate(CicMultiStatus status, AgentJob job) {
            return Util.isAgentInstallerUpdate(job);
        }

        private static boolean isAgentInstallerUpdate(AgentJob job) {
            if (!AgentInstall.getInstance().isAgentInstallerRunning()) {
                return false;
            }
            if (!job.getProfile().isAgentProfile()) {
                return false;
            }
            if (job instanceof InstallJob) {
                return ((InstallJob)job).getExistingOffering() != null;
            }
            return job.getType().isUpdate();
        }

        public static String getProgressMessage(AgentJob[] jobs) {
            AgentJob.AgentJobType jobType = jobs[0].getType();
            return jobType.isModify() ? Messages.Director_Modifying : (jobType.isRollback() ? Messages.Director_Rolling_Back : (jobType.isUpdate() ? Messages.Director_Updating : (jobType.isUninstall() ? Messages.Director_Uninstalling : Messages.Director_Installing)));
        }

        static CicMultiStatus fixStatus(CicMultiStatus status) {
            IStatus[] children = status.getChildren();
            if (status.getMessage().isEmpty() && children.length == 1) {
                IStatus child = children[0];
                return Statuses.ST.createMultiStatusFromStatus(child);
            }
            return status;
        }

        public static IStatus operationPassed(IStatus status) {
            IStatus result;
            if (!status.matches(2)) {
                return status;
            }
            if (UserFeedback.isOkToContinue(status, false, true)) {
                result = Status.OK_STATUS;
                log.status(status);
            } else {
                result = Statuses.ST.createMultiStatusFromStatus((IStatus)ICicStatus.CANCEL_STATUS);
            }
            return result;
        }

        public static IStatus checkLocations(Profile profile) {
            IStatus cacheStatus;
            String cacheLocation = CacheLocationManager.getInstance().getCacheLocation();
            String installLocation = profile.getInstallLocation();
            if (installLocation == null) {
                return Statuses.ERROR.get(Messages.Director_No_Directory_Specified_For_Install_Location, new Object[]{profile.getProfileId()});
            }
            if (!profile.isAgentProfile() && !(cacheStatus = Util.checkLocation(cacheLocation, Messages.Director_Common_Component_Install_Area_Is_Not_A_Directory, Messages.Director_Cannot_Create_Common_Component_Install_Area)).isOK()) {
                return cacheStatus;
            }
            IStatus installStatus = Util.checkLocation(installLocation, Messages.Director_Install_Location_Is_Not_A_Directory, Messages.Director_Cannot_Create_Install_Location);
            return installStatus;
        }

        private static IStatus checkLocation(String path, String notDirectory, String cannotCreate) {
            File file;
            try {
                file = new File(path).getCanonicalFile();
            }
            catch (IOException iOException) {
                return Statuses.ERROR.get(cannotCreate, new Object[]{path});
            }
            ArrayList<File> missing = new ArrayList<File>();
            while (file != null && !file.exists()) {
                missing.add(file);
                file = file.getParentFile();
            }
            if (file != null && !file.isDirectory()) {
                return Statuses.ERROR.get(notDirectory, new Object[]{file.getPath()});
            }
            IStatus result = Status.OK_STATUS;
            Util.ReverseIterator i = new Util.ReverseIterator(missing);
            while (i.hasNext()) {
                File f = (File)i.next();
                if (f.mkdir()) continue;
                result = Statuses.ERROR.get(cannotCreate, new Object[]{f.getPath()});
                break;
            }
            for (File f : missing) {
                f.delete();
            }
            return result;
        }

        public static void cleanCache(CicMultiStatus status, CacheManager.ArtifactsToDownload downloaded, Agent.IDisableCancel disableCancel, IProgressMonitor monitor, boolean isUninstall) {
            monitor.setCanceled(false);
            monitor = new NoCancelProgressMonitor((IProgressMonitor)monitor);
            DisableRestoreCancelEnablementHelper ceh = new DisableRestoreCancelEnablementHelper(disableCancel, true);
            try {
                Util.cleanCache(status, downloaded, monitor, isUninstall);
            }
            finally {
                ceh.restoreCancelEnablement();
            }
        }

        private static void cleanCache(CicMultiStatus status, CacheManager.ArtifactsToDownload downloaded, IProgressMonitor monitor, boolean isUninstall) {
            try {
                InstallRegistry.getInstance().purgeMetadata();
            }
            catch (CoreException e) {
                status.add((IStatus)Statuses.ERROR.get(Messages.Director_Error_Saving_Install_Registry, new Object[]{e.getMessage()}));
            }
            if (Agent.getInstance().isSkipInstall()) {
                return;
            }
            CacheManager cacheManager = CacheManager.getDefaultInstance();
            if (status.matches(12)) {
                if (downloaded != null) {
                    downloaded.undoTocUpdatesForNonDownloadedFile(cacheManager, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
                    try {
                        Agent.IPurgeableFiles downloadInfo = cacheManager.getDownloadedArtifacts(downloaded, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
                        boolean keepArtifacts = false;
                        if (downloadInfo.getFileCount() > 0 && !(keepArtifacts = cacheManager.keepDownloadedArtifacts((IStatus)status, downloadInfo.getFileCount(), downloadInfo.getTotalSize(), cacheManager.keepFetchedFiles()))) {
                            downloadInfo.purgeFiles(monitor);
                        }
                        if (isUninstall && status.matches(4) && !keepArtifacts) {
                            cacheManager.cleanup(monitor);
                        }
                        downloaded.checkConsistency(cacheManager, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
                    }
                    catch (CacheManager.CacheManagerException e) {
                        if (!e.getStatus().matches(8)) {
                            status.add(e.getStatus());
                        }
                    }
                }
            } else {
                cacheManager.cleanup(monitor);
                if (downloaded != null) {
                    downloaded.checkConsistency(cacheManager, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
                }
            }
            cacheManager.forgetDownloadState();
        }

        public static IStatus cleanInstallLocation(Profile profile) {
            if (profile.isAgentProfile()) {
                return Status.OK_STATUS;
            }
            return profile.cleanInstallLocation();
        }

        public static AgentJob[] checkAndAdjustJobs(AgentJob[] jobs) throws CoreException {
            boolean isInstall = true;
            AgentJob[] agentJobArray = jobs;
            int n = jobs.length;
            int n2 = 0;
            while (n2 < n) {
                AgentJob job = agentJobArray[n2];
                if (job.getType().isUninstall()) {
                    isInstall = false;
                }
                ++n2;
            }
            return Util.checkAndAdjustJobs(isInstall, AdjustedAgentJob.copy(jobs));
        }

        public static AgentJob[] checkAndAdjustJobs(boolean isInstall, AgentJob[] jobs) throws CoreException {
            boolean adjustJobs = true;
            jobs = AgentUtil.addUninstallFixJobs(jobs, adjustJobs);
            int i = 0;
            while (i < jobs.length) {
                IOffering installedOffering;
                AgentJob job = jobs[i];
                Profile profile = job.getProfile();
                StatusUtil.throwIfError((IStatus)Util.checkLocations(profile));
                IOfferingOrFix offeringOrFix = job.getOfferingOrFix();
                IIdentity id = offeringOrFix.getIdentity();
                Version version = offeringOrFix.getVersion();
                InstallRegistry.ProfileInstallRegistry registry = profile.getInstallRegistry();
                if (!isInstall) {
                    if (offeringOrFix instanceof IOffering) {
                        installedOffering = registry.getInstalledOffering(id);
                        if (installedOffering == null) {
                            throw new CoreException((IStatus)Statuses.ERROR.get(Messages.Director_No_Version_Of_Offering_Installed, new Object[]{id}));
                        }
                        if (!offeringOrFix.equals(installedOffering)) {
                            throw new CoreException((IStatus)Statuses.ERROR.get(Messages.Director_Cannot_Uninstall_Offering, new Object[]{id, version, installedOffering.getVersion()}));
                        }
                    } else if (offeringOrFix instanceof IFix) {
                        if (!offeringOrFix.equals(registry.getInstalledFix(id))) {
                            throw new CoreException((IStatus)Statuses.ERROR.get(Messages.Director_Fix_Is_Not_Installed, new Object[]{id, version}));
                        }
                    } else {
                        throw Check.fail((String)"Bad type: {0}", (Object[])new Object[]{offeringOrFix});
                    }
                    jobs[i] = Util.adjustUninstallFeatures(job);
                } else {
                    if (job.getType().isRollback()) {
                        installedOffering = registry.getInstalledOffering(id);
                        IOffering offering = (IOffering)offeringOrFix;
                        if (installedOffering == null) {
                            throw new CoreException((IStatus)Statuses.ERROR.get(NLS.bind((String)Messages.Director_Cannot_Roll_Back, (Object)id), new Object[0]));
                        }
                        if (OfferingProperty.hasUnacceptableRequirementForUserRights((IOffering)offering) || !Agent.getInstance().isRollbackAllowed(profile, offering)) {
                            throw new CoreException((IStatus)Statuses.ERROR.get(Messages.Director_Cannot_Roll_Back_To_Version, new Object[]{id, installedOffering.getVersion(), version}));
                        }
                        if (OfferingProperty.hasUnacceptableRequirementForGroupMode((IOfferingOrFix)offering) || !Agent.getInstance().isRollbackAllowed(profile, offering)) {
                            throw new CoreException((IStatus)Statuses.ERROR.get(Messages.Director_Cannot_Roll_Back_To_Version, new Object[]{id, installedOffering.getVersion(), version}));
                        }
                    }
                    job = jobs[i] = Util.adjustInstallFeatures(job);
                    StatusUtil.throwIfError((IStatus)Util.checkRequiredFeatures(job));
                }
                ++i;
            }
            StatusUtil.throwIfError((IStatus)AgentUtil.checkZeroFeatureSelection(jobs));
            return jobs;
        }

        private static IStatus checkRequiredFeatures(AgentJob job) {
            IOffering offering = job.getOffering();
            if (offering == null) {
                return Status.OK_STATUS;
            }
            HashSet features = new HashSet(job.getFeatures());
            IFeature[] required = OfferingUtil.getRequiredFeatures((IOffering)offering);
            int i = 0;
            while (i < required.length) {
                if (!features.contains(required[i])) {
                    return Statuses.ERROR.get(Messages.Director_Missing_Required_Feature, new Object[]{required[i].getIdentity(), offering.getName()});
                }
                ++i;
            }
            return Status.OK_STATUS;
        }

        public static AgentJob getAdjustedJob(AgentJob job) {
            AgentJob effectiveJob = new AdjustedAgentJob(job, job.getFeatures());
            effectiveJob = job.isUninstall() ? Util.adjustUninstallFeatures(effectiveJob) : Util.adjustInstallFeatures(effectiveJob);
            return effectiveJob;
        }

        public static AgentJob adjustInstallFeatures(AgentJob job) {
            List features = job.getFeatures();
            IOffering offering = job.getOffering();
            if (offering == null) {
                return job;
            }
            InstallRegistry.ProfileInstallRegistry registry = job.getProfile().getInstallRegistry();
            IOffering installedOffering = registry.getInstalledOffering(offering.getIdentity());
            if (installedOffering == null) {
                return job;
            }
            Set<IFeature> installedFeatures = registry.getInstalledFeatures(installedOffering);
            if (installedOffering.compareVersion((IContent)offering) == 0) {
                if (!job.getType().isModify()) {
                    assert (job.getType().isInstall());
                    job = new ModifyJob(job.getProfile(), (IOfferingOrFix)offering);
                }
                installedFeatures.addAll(features);
            } else {
                if (features.size() != 0) {
                    return job;
                }
                if (job.getType().isRollback()) {
                    installedFeatures = registry.getInstalledFeatures(job.getOffering());
                }
            }
            job.setFeatures(installedFeatures);
            return job;
        }

        public static AgentJob adjustUninstallFeatures(AgentJob job) {
            IOffering offering = job.getOffering();
            ArrayList<IFeature> features = job.getFeatures();
            if (offering == null) {
                return job;
            }
            InstallRegistry.ProfileInstallRegistry registry = job.getProfile().getInstallRegistry();
            Set<IFeature> installedFeatures = registry.getInstalledFeatures(offering);
            if (!job.getType().isModify() && features.size() == 0) {
                features = new ArrayList<IFeature>(installedFeatures);
            } else {
                ArrayList<IFeature> newFeatures = new ArrayList<IFeature>(features.size());
                for (IFeature feature : features) {
                    if (!installedFeatures.contains(feature)) continue;
                    newFeatures.add(feature);
                }
                if (job.getType().isModify() || newFeatures.size() < installedFeatures.size()) {
                    ArrayList<IFeature> complement = new ArrayList<IFeature>(installedFeatures);
                    complement.removeAll(features);
                    job = new ModifyJob(job.getProfile(), (IOfferingOrFix)job.getOffering(), AgentJob.AgentJobType.UNINSTALL_JOB);
                    features = complement;
                } else {
                    features = newFeatures;
                }
            }
            job.setFeatures(features);
            return job;
        }

        private static void appendPredefinedSelectors(StringBuffer sb, AgentJob job) {
            Profile profile = job.getProfile();
            String nl = profile.getData("cic.selector.nl");
            sb.append("\n ");
            sb.append(NLS.bind((String)Messages.Director_Predefined_Selectors, (Object[])new Object[]{profile.getWS(), profile.getOS(), profile.getArch(), nl == null ? "" : nl}));
        }

        private static void appendDirectory(StringBuffer sb, AgentJob job) {
            Profile profile = job.getProfile();
            String dir = profile.getInstallLocation();
            sb.append("\n ");
            sb.append(NLS.bind((String)Messages.Director_Directory, (Object)dir));
        }

        public static String toString(AgentJob[] jobs) {
            StringBuffer sb = new StringBuffer(128 * jobs.length);
            int i = 0;
            while (i < jobs.length) {
                AgentJob job = jobs[i];
                if (i > 0) {
                    sb.append('\n');
                }
                AgentJob.AgentJobType type = job.getType();
                IOfferingOrFix offeringOrFix = job.getOfferingOrFix();
                IIdentity id = offeringOrFix.getIdentity();
                Version version = offeringOrFix.getVersion();
                if (offeringOrFix instanceof IFix) {
                    String key = null;
                    if (type.isInstall()) {
                        key = Messages.Director_Installing_Fix;
                    } else if (type.isUninstall()) {
                        key = Messages.Director_Uninstalling_Fix;
                    } else assert (false) : job;
                    sb.append(NLS.bind((String)key, (Object)id, (Object)version));
                } else {
                    List features = job.getFeatures();
                    String featureString = features == null ? "all" : (features.isEmpty() ? "none" : com.ibm.cic.common.core.utils.Util.toFeatureIdString((Collection)features));
                    String key = null;
                    if (type.isInstall()) {
                        key = Messages.Director_Installing_Offering_Features;
                    } else if (type.isUpdate()) {
                        key = Messages.Director_Updating_Offering_Features;
                    } else if (type.isRollback()) {
                        key = Messages.Director_Rolling_Back_Offering_Features;
                    } else if (type.isUninstall()) {
                        key = Messages.Director_Uninstalling_Offering_Features;
                    } else if (type.isModify()) {
                        key = Messages.Director_Modifying_Offering_Features;
                    } else assert (false) : job;
                    sb.append(NLS.bind((String)key, (Object[])new Object[]{id, version, featureString}));
                }
                Util.appendPredefinedSelectors(sb, job);
                Util.appendDirectory(sb, job);
                ++i;
            }
            return sb.toString();
        }

        public static String collectLogString(AgentJob[] jobs) {
            StringBuffer sb = new StringBuffer(128 * jobs.length);
            int i = 0;
            while (i < jobs.length) {
                AgentJob job = jobs[i];
                if (i > 0) {
                    sb.append('\n');
                }
                IOfferingOrFix offeringOrFix = job.getOfferingOrFix();
                IIdentity id = offeringOrFix.getIdentity();
                Version version = offeringOrFix.getVersion();
                if (offeringOrFix instanceof IFix) {
                    sb.append(NLS.bind((String)Messages.Director_Collecting_Fix_Artifacts, (Object)id, (Object)version));
                } else {
                    List features = job.getFeatures();
                    String featureString = features == null ? "all" : (features.isEmpty() ? "none" : com.ibm.cic.common.core.utils.Util.toFeatureIdString((Collection)features));
                    sb.append(NLS.bind((String)Messages.Director_Collecting_Offering_Artifacts, (Object[])new Object[]{id, version, featureString}));
                }
                Util.appendPredefinedSelectors(sb, job);
                ++i;
            }
            return sb.toString();
        }

        public static void logAssignedArtifacts(Agent.IAssignedArtifacts assignedArtifacts) {
            if (!log.isDebugLoggable()) {
                return;
            }
            Collection<IRepository> repos = assignedArtifacts.getRepositories();
            if (repos.size() == 0) {
                log.debug("No installation files to fetch");
            } else {
                StringBuffer sb = new StringBuffer(256 * repos.size());
                sb.append("Source of installation files:");
                for (IRepository repo : repos) {
                    Collection<IArtifact> artifacts = assignedArtifacts.getAssignedArtifacts(repo);
                    sb.append("\n  ");
                    sb.append(NLS.bind((String)"{0} artifacts from {1}", (Object)artifacts.size(), (Object)repo.getLocationStr()));
                    Iterator<IArtifact> j = artifacts.iterator();
                    while (j.hasNext()) {
                        sb.append("\n    ").append(j.next());
                    }
                }
                log.debug(sb.toString());
            }
        }
    }
}

