/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.core;

import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.core.utils.Statuses;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class AgentPathValidator {
    public static IStatus checkSymbolicLinks(String pathToValidate) {
        if (pathToValidate == null || pathToValidate.isEmpty()) {
            return Status.OK_STATUS;
        }
        File validationPathAsFile = new File(pathToValidate);
        while (validationPathAsFile != null) {
            if (validationPathAsFile.exists() && PlatformUtils.isSymlink((File)validationPathAsFile)) {
                File originalPath = new File(pathToValidate);
                String canonicalPath = null;
                try {
                    canonicalPath = originalPath.getCanonicalPath();
                }
                catch (IOException iOException) {
                    return Statuses.WARNING.get(Messages.Agent_Profile_Symbolic_Links_Unsupported_Cannot_Resolve, new Object[]{originalPath.getPath()});
                }
                return Statuses.WARNING.get(Messages.Agent_Profile_Symbolic_Links_Unsupported, new Object[]{originalPath.getPath(), canonicalPath});
            }
            validationPathAsFile = validationPathAsFile.getParentFile();
        }
        return Status.OK_STATUS;
    }
}

