/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.utils;

import com.ibm.cic.agent.core.AgentActivator;
import com.ibm.cic.agent.core.cmd.CmdLine;
import com.ibm.cic.agent.core.utils.SaveCredentialPrompter;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.downloads.TransferUtils;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.downloads.CredentialPrompter;
import com.ibm.cic.common.downloads.CredentialStore;
import com.ibm.cic.common.downloads.ICredentialPrompter;
import com.ibm.cic.common.downloads.PreferencesHolder;
import java.net.URI;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class SaveCredentialUtils {
    private static String bundleId = "com.ibm.cic.agent.core.utils";
    private static String urlString = null;
    private static String userName = null;
    private static String userPassword = null;
    private static String proxyHost = null;
    private static String proxyPort = null;
    private static boolean useSocks = false;
    private static boolean verbose = false;
    private static boolean ppa = false;
    private static String proxyUserName = null;
    private static String proxyUserPassword = null;
    private static int ERROR_CODE_MALFORMED_URL = 1001;
    private static int ERROR_CODE_UNSUPPORT_PROTOCOL = 1002;
    private static int ERROR_CODE_URL_NOT_EXIST = 1003;
    private static int ERROR_CODE_CANNOT_CONNECT_TO = 1004;
    private static int ERROR_CODE_KEYRING_NOT_FULLY_QUALIFIED = 2001;
    private static int ERROR_CODE_KEYRING_NOT_ACCESSIBLE = 2002;
    private static int ERROR_CODE_INVALID_PROXY_PORT = 3001;
    private static int ERROR_CODE_CREDENTIAL_NOT_SAVED = 4001;
    private static final String PPA_URL = "https://www.ibm.com/software/repositorymanager/entitled/repository.xml";
    public static final String agentPluginId = AgentActivator.getPluginId();

    private static void printMessage(String msg) {
        System.out.println(msg);
    }

    private static void printException(Throwable e) {
        if (verbose) {
            System.out.println(String.valueOf(Messages.SaveCredential_Exception) + " " + e.getMessage());
        }
    }

    private static void printVerboseMessage(String msg) {
        if (verbose) {
            System.out.println(msg);
        }
    }

    private static IStatus errorStatus(int errorCode) {
        return new Status(4, agentPluginId, errorCode, NLS.bind((String)Messages.SaveCredential_Error, (Object)"saveCredential"), null);
    }

    public static IStatus save() {
        ppa = CmdLine.CL.containsCommand("-passportAdvantage");
        urlString = ppa ? PPA_URL : CmdLine.CL.getParam1StrVal("-url");
        userName = CmdLine.CL.getParam1StrVal("-userName");
        userPassword = CmdLine.CL.getParam1StrVal("-userPassword");
        proxyHost = CmdLine.CL.getParam1StrVal("-proxyHost");
        proxyPort = CmdLine.CL.getParam1StrVal("-proxyPort");
        useSocks = CmdLine.CL.containsCommand("-useSOCKS");
        verbose = CmdLine.CL.containsCommand("-verbose");
        proxyUserName = CmdLine.CL.getParam1StrVal("-proxyUserName");
        proxyUserPassword = CmdLine.CL.getParam1StrVal("-proxyUserPassword");
        URI uri = null;
        URL url = null;
        try {
            uri = new URI(urlString);
            url = uri.toURL();
        }
        catch (Exception e) {
            SaveCredentialUtils.printMessage(Messages.SaveCredential_Error_MalformedUrl);
            SaveCredentialUtils.printException(e);
            return SaveCredentialUtils.errorStatus(ERROR_CODE_MALFORMED_URL);
        }
        boolean isHttp = url.getProtocol().equalsIgnoreCase("http");
        boolean isHttps = url.getProtocol().equalsIgnoreCase("https");
        if (!(isHttp || isHttps || url.getProtocol().equalsIgnoreCase("ftp"))) {
            SaveCredentialUtils.printMessage(Messages.SaveCredential_Error_UnsupportProtocol);
            return SaveCredentialUtils.errorStatus(ERROR_CODE_UNSUPPORT_PROTOCOL);
        }
        try {
            CredentialStore.INSTANCE.isCredentialInKeyring(null);
        }
        catch (NullPointerException nullPointerException) {
            SaveCredentialUtils.printMessage(Messages.SaveCredential_Error_KeyringIsNotFullyQualified);
            return SaveCredentialUtils.errorStatus(ERROR_CODE_KEYRING_NOT_FULLY_QUALIFIED);
        }
        catch (Exception exception) {
            SaveCredentialUtils.printMessage(Messages.SaveCredential_Error_KeyringIsNotAccessible);
            return SaveCredentialUtils.errorStatus(ERROR_CODE_KEYRING_NOT_ACCESSIBLE);
        }
        IEclipsePreferences prefs = DefaultScope.INSTANCE.getNode(bundleId);
        String sslNonSecureMode = (String)CmdLine.CL.getPreferences().get(ICicPreferenceConstants.SSL_NONSECURE_MODE.key());
        prefs.putBoolean(ICicPreferenceConstants.SSL_NONSECURE_MODE.key(), Boolean.parseBoolean(sslNonSecureMode));
        if (proxyHost != null && proxyPort != null) {
            try {
                Integer.valueOf(proxyPort);
            }
            catch (Exception exception) {
                SaveCredentialUtils.printMessage(Messages.SaveCredential_Error_InvalidProxyPort);
                return SaveCredentialUtils.errorStatus(ERROR_CODE_INVALID_PROXY_PORT);
            }
            if (isHttp || isHttps) {
                prefs.putBoolean(ICicPreferenceConstants.ProxyPreferences.getProxyEnabled((String)"http").key(), true);
                if (useSocks) {
                    prefs.putBoolean(ICicPreferenceConstants.ProxyPreferences.getProxyUseSocks((String)"http").key(), true);
                    prefs.put(ICicPreferenceConstants.ProxyPreferences.getSocksProxyHost().key(), proxyHost);
                    prefs.put(ICicPreferenceConstants.ProxyPreferences.getSocksProxyPort().key(), proxyPort);
                } else {
                    prefs.putBoolean(ICicPreferenceConstants.ProxyPreferences.getProxyUseSocks((String)"http").key(), false);
                    prefs.put(ICicPreferenceConstants.ProxyPreferences.getProxyHost((String)"http").key(), proxyHost);
                    prefs.put(ICicPreferenceConstants.ProxyPreferences.getProxyPort((String)"http").key(), proxyPort);
                }
            } else {
                prefs.putBoolean(ICicPreferenceConstants.ProxyPreferences.getProxyEnabled((String)"ftp").key(), true);
                prefs.put(ICicPreferenceConstants.ProxyPreferences.getSocksProxyHost().key(), proxyHost);
                prefs.put(ICicPreferenceConstants.ProxyPreferences.getSocksProxyPort().key(), proxyPort);
            }
        }
        PreferencesHolder.INSTANCE.add(prefs);
        IStatus rc = SaveCredentialUtils.saveCredentialForUrl(url, userName, userPassword);
        PreferencesHolder.INSTANCE.remove(prefs);
        return rc;
    }

    private static IStatus saveCredentialForUrl(URL url, String uid, String uPwd) {
        CredentialStore.INSTANCE.setNoWrite(true);
        SaveCredentialPrompter prompter = new SaveCredentialPrompter(userName, userPassword, proxyUserName, proxyUserPassword);
        CredentialPrompter.INSTANCE.setPrompter((ICredentialPrompter)prompter);
        try {
            boolean isExist = TransferUtils.existsURL((URL)url, (IProgressMonitor)new NullProgressMonitor());
            if (!isExist) {
                try {
                    url = new URL(String.valueOf(urlString) + "/" + "repository.config");
                }
                catch (Exception e) {
                    SaveCredentialUtils.printMessage(Messages.SaveCredential_Error_MalformedUrl);
                    SaveCredentialUtils.printException(e);
                    return SaveCredentialUtils.errorStatus(ERROR_CODE_MALFORMED_URL);
                }
                isExist = TransferUtils.existsURL((URL)url, (IProgressMonitor)new NullProgressMonitor());
            }
            if (isExist) {
                SaveCredentialUtils.printVerboseMessage(Messages.SaveCredential_URLExist);
                if (!prompter.hasSavedTarget()) {
                    SaveCredentialUtils.printMessage(Messages.SaveCredential_ContainsValidCredential);
                    return Status.OK_STATUS;
                }
            } else {
                SaveCredentialUtils.printMessage(Messages.SaveCredential_URLNotExist);
                if (!prompter.hasSavedTarget()) {
                    return SaveCredentialUtils.errorStatus(ERROR_CODE_URL_NOT_EXIST);
                }
            }
            IStatus rc = Status.OK_STATUS;
            if (prompter.checkTargets()) {
                SaveCredentialUtils.printMessage(Messages.SaveCredential_Successful);
            } else {
                SaveCredentialUtils.printMessage(Messages.SaveCredential_NotSaved);
                rc = SaveCredentialUtils.errorStatus(ERROR_CODE_CREDENTIAL_NOT_SAVED);
            }
            if (verbose) {
                SaveCredentialUtils.printMessage(prompter.getSavedTargetsString());
            }
            return rc;
        }
        catch (Exception e) {
            SaveCredentialUtils.printMessage(ppa ? Messages.SaveCredential_Error_ConnectPPA : Messages.SaveCredential_Error_ConnectUrl);
            SaveCredentialUtils.printMessage(ppa ? Messages.SaveCredential_PPA_Reasons : Messages.SaveCredential_Reasons);
            SaveCredentialUtils.printException(e);
            return SaveCredentialUtils.errorStatus(ERROR_CODE_CANNOT_CONNECT_TO);
        }
    }
}

