/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.userdata.parser;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.CustomPanelData;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.api.IAgent;
import com.ibm.cic.agent.core.api.IAgentJob;
import com.ibm.cic.agent.core.api.ICustomPanelData;
import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.UserDataValidator;
import com.ibm.cic.common.core.model.adapterdata.IAdapterData;
import com.ibm.cic.common.core.model.utils.LicenseUtils;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.MultiStatusUtil;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.eclipseAdapterData.EclipseAdapterData;
import com.ibm.cic.common.eclipseAdapterData.EclipseAgentBundleData;
import com.ibm.cic.common.eclipseAdapterData.IEclipseData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public final class CommonUserDataExtParser {
    private static final String TAG_COMMON_USER_DATA_EXTENSION = "commonUserData";
    private static final String TAG_COMMON_DATA = "commonData";
    private static final String TAG_DATA_KEY = "dataKey";
    private static final String TAG_DATA_DES = "dataDes";
    private static final String TAG_DATA_DEFAULT_VALUE = "dataDefaultValue";
    private static final String TAG_DATA_SENSITIVE = "sensitive";
    private static final String TAG_DATA_VALIDATION_CLASS = "validationClass";
    private static CommonUserDataExtParser instance = null;
    private Map keyCommonDataMap = new HashMap();
    private AgentJob[] profileJobs = null;
    private AgentJob[] allJobs = null;

    static {
        instance = new CommonUserDataExtParser();
    }

    public static CommonUserDataExtParser getInstance() {
        return instance;
    }

    public void initializeCommonUserDataExtensions(AgentJob[] jobs, AgentJob[] jobsInOneProfile) {
        this.allJobs = jobs;
        this.profileJobs = jobsInOneProfile;
        this.keyCommonDataMap = new HashMap();
        this.createCommonUserDataGroup();
    }

    public void initializeCommonUserDataExtensions(AgentJob[] jobs) {
        this.allJobs = jobs;
        this.profileJobs = null;
        this.keyCommonDataMap = new HashMap();
        this.createCommonUserDataGroup();
    }

    public void reset() {
        this.allJobs = null;
        this.profileJobs = null;
        this.keyCommonDataMap = null;
    }

    private IOfferingOrFix[] extractOfferingOrFixFromJob(AgentJob[] jobArray) {
        ArrayList<IOfferingOrFix> offeringList = new ArrayList<IOfferingOrFix>();
        if (jobArray != null && jobArray.length > 0) {
            AgentJob[] agentJobArray = jobArray;
            int n = jobArray.length;
            int n2 = 0;
            while (n2 < n) {
                AgentJob element = agentJobArray[n2];
                IOfferingOrFix offeringOrFix = element.getOfferingOrFix();
                if (offeringOrFix != null) {
                    offeringList.add(offeringOrFix);
                }
                ++n2;
            }
        }
        return offeringList.toArray(new IOfferingOrFix[offeringList.size()]);
    }

    public String[] getCommonUserDataKeys() {
        if (!this.keyCommonDataMap.isEmpty()) {
            Set keySet = this.keyCommonDataMap.keySet();
            return keySet.toArray(new String[keySet.size()]);
        }
        return new String[0];
    }

    public String getCommonUserDataDefaultValue(String key) {
        CommonUserData data = (CommonUserData)this.keyCommonDataMap.get(key);
        if (data != null) {
            return data.getCommonUserDataDefaultValue();
        }
        return "";
    }

    public String getCommonUserDataDescription(String key) {
        CommonUserData data = (CommonUserData)this.keyCommonDataMap.get(key);
        if (data != null) {
            return data.getCommonUserDataDes();
        }
        return "";
    }

    public IStatus getCommonUserDataValidationStatus(Map keyValuePair) {
        CicMultiStatus return_status = Statuses.ST.createMultiStatus();
        Set keySet = keyValuePair.keySet();
        for (String key : keySet) {
            IStatus status;
            CommonUserData data = (CommonUserData)this.keyCommonDataMap.get(key);
            if (data == null || (status = data.getValidationStatus(keyValuePair)) == null) continue;
            if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                return status;
            }
            return_status.add(status);
        }
        if (!return_status.isOK()) {
            Status new_return_status = new Status(return_status.getSeverity(), return_status.getPlugin(), MultiStatusUtil.getFailureMessage((IStatus)return_status));
            return new_return_status;
        }
        return return_status;
    }

    private void createCommonUserDataGroup() {
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint(ComIbmCicCommonCorePlugin.getPluginId(), TAG_COMMON_USER_DATA_EXTENSION).getExtensions();
        if (extensions == null || extensions.length == 0) {
            return;
        }
        if (this.profileJobs != null) {
            this.parseExtensions(extensions, this.profileJobs);
        } else {
            Collection jobArrays = AgentUtil.groupByProfile(this.allJobs, false);
            for (AgentJob[] jobsInOneProfile : jobArrays) {
                this.parseExtensions(extensions, jobsInOneProfile);
            }
        }
    }

    private void parseExtensions(IExtension[] extensions, AgentJob[] jobsInOneProfile) {
        ArrayList<IExtension> extensionsInJob = new ArrayList<IExtension>(extensions.length);
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IOfferingOrFix[] offerings;
            IExtension extension = iExtensionArray[n2];
            IContributor contributor = extension.getContributor();
            String name = contributor.getName();
            if (this.nameIsInOfferings(name, offerings = this.extractOfferingOrFixFromJob(jobsInOneProfile)) || name.equals("com.ibm.cic.agent.core.tests") && (this.profileJobs == null || this.profileJobs.length == 0)) {
                extensionsInJob.add(extension);
            }
            ++n2;
        }
        if (extensionsInJob.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < extensionsInJob.size()) {
            IExtension extension = (IExtension)extensionsInJob.get(i);
            this.parseDefinitions(extension, jobsInOneProfile);
            ++i;
        }
    }

    private boolean nameIsInOfferings(String name, IOfferingOrFix[] offeringArray) {
        if (offeringArray == null || offeringArray.length == 0) {
            return false;
        }
        IOfferingOrFix[] iOfferingOrFixArray = offeringArray;
        int n = offeringArray.length;
        int n2 = 0;
        while (n2 < n) {
            IOfferingOrFix offeringOrFix = iOfferingOrFixArray[n2];
            if (offeringOrFix != null && !LicenseUtils.isPEKOffering((IOfferingOrFix)offeringOrFix)) {
                List ius = offeringOrFix.getInstallableUnits();
                int j = 0;
                while (j < ius.size()) {
                    IAdapterData adapterData;
                    IInstallableUnit unit = (IInstallableUnit)ius.get(j);
                    if ("eclipse".equals(unit.getAdapterId()) && (adapterData = unit.getAdapterData()) instanceof EclipseAdapterData) {
                        IEclipseData[] eclipseData;
                        EclipseAdapterData data = (EclipseAdapterData)adapterData;
                        Collection elements = data.getDataElements();
                        IEclipseData[] iEclipseDataArray = eclipseData = elements.toArray(new IEclipseData[elements.size()]);
                        int n3 = eclipseData.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            EclipseAgentBundleData agentBundleData;
                            IEclipseData element2 = iEclipseDataArray[n4];
                            String dataKind = element2.getDataKind();
                            if (EclipseAgentBundleData.getKind().equals(dataKind) && name.equals((agentBundleData = (EclipseAgentBundleData)element2).getId())) {
                                return true;
                            }
                            ++n4;
                        }
                    }
                    ++j;
                }
            }
            ++n2;
        }
        return false;
    }

    private void parseDefinitions(IExtension extension, AgentJob[] jobsInOneProfile) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        if (elements != null && elements.length > 0) {
            IConfigurationElement[] iConfigurationElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (element.getName().equals(TAG_COMMON_DATA)) {
                    this.parseElement(element, jobsInOneProfile);
                }
                ++n2;
            }
        }
    }

    private void parseElement(IConfigurationElement element, final AgentJob[] jobsInOneProfile) {
        String dataKey = element.getAttribute(TAG_DATA_KEY);
        String dataDes = element.getAttribute(TAG_DATA_DES);
        String dataDefaultValue = element.getAttribute(TAG_DATA_DEFAULT_VALUE);
        boolean sensitive = Boolean.valueOf(element.getAttribute(TAG_DATA_SENSITIVE));
        String validatorClass = element.getAttribute(TAG_DATA_VALIDATION_CLASS);
        if (dataKey == null || dataKey.trim().length() == 0) {
            return;
        }
        if (dataDes == null) {
            dataDes = "";
        }
        if (dataDefaultValue == null) {
            dataDefaultValue = "";
        }
        Profile profile = jobsInOneProfile[0].getProfile();
        if (sensitive) {
            profile.setSensitiveUserData(dataKey);
        }
        UserDataValidator validator = null;
        try {
            if (validatorClass != null && validatorClass.trim().length() > 0) {
                Object obj = element.createExecutableExtension(TAG_DATA_VALIDATION_CLASS);
                if (!(obj instanceof UserDataValidator)) {
                    throw new CoreException((IStatus)new Status(4, element.getNamespaceIdentifier(), 0, "class specified by common user data validation must be an instance of UserDataValidator", null));
                }
                validator = (UserDataValidator)obj;
                validator.init(new IAdaptable(){

                    public Object getAdapter(Class adapter) {
                        if (IAgent.class.equals((Object)adapter)) {
                            return Agent.getInstance();
                        }
                        if (IAgentJob[].class.equals((Object)adapter)) {
                            return jobsInOneProfile;
                        }
                        if (ICustomPanelData.class.equals((Object)adapter)) {
                            return new CustomPanelData(CommonUserDataExtParser.this.allJobs, jobsInOneProfile);
                        }
                        return null;
                    }
                });
            }
        }
        catch (CoreException e) {
            Agent.getLogger().error((Throwable)e);
        }
        CommonUserData data = new CommonUserData(dataKey, dataDes, dataDefaultValue, validator);
        this.keyCommonDataMap.put(dataKey, data);
    }

    static class CommonUserData {
        private final String commonUserDataKey;
        private String commonUserDataDes = "";
        private String commonUserDataDefaultValue = "";
        private UserDataValidator commonUserDataValidator = null;

        CommonUserData(String key, String des, String defaultValue, UserDataValidator validator) {
            this.commonUserDataKey = key;
            this.commonUserDataDes = des;
            this.commonUserDataDefaultValue = defaultValue;
            this.commonUserDataValidator = validator;
        }

        public String getCommonUserDataKey() {
            return this.commonUserDataKey;
        }

        public String getCommonUserDataDes() {
            return this.commonUserDataDes;
        }

        public String getCommonUserDataDefaultValue() {
            return this.commonUserDataDefaultValue;
        }

        public IStatus getValidationStatus(Map nameValuePair) {
            if (this.commonUserDataValidator == null) {
                return Status.OK_STATUS;
            }
            if (!this.commonUserDataValidator.shouldSkipValidation(nameValuePair)) {
                return this.commonUserDataValidator.validateUserData(nameValuePair);
            }
            return Status.OK_STATUS;
        }
    }
}

