/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.sharedUI;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.CustomPanelData;
import com.ibm.cic.agent.core.api.IAgentJob;
import com.ibm.cic.agent.core.api.ICustomPanel;
import com.ibm.cic.agent.core.custompanel.api.CustomPanelWrapper;
import com.ibm.cic.agent.core.custompanel.template.ICustomPanelGenerator;
import com.ibm.cic.agent.core.sharedUI.CustomPanelJobPair;
import com.ibm.cic.agent.core.sharedUI.ITemplateCustomPanelFactory;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.core.sharedUI.TemplateCustomPanelFactory;
import com.ibm.cic.agent.core.sharedUI.WizardType;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.utils.NLS;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class TemplateOfferingCustomPanelFactory
extends TemplateCustomPanelFactory
implements ITemplateCustomPanelFactory {
    private static final String TAG_TEMPLATE_OFFERING_CUSTOM_PANEL = "templateOfferingCustomPanel";
    private static final String TAG_OFFERING_BINDING = "offeringBinding";
    private static final String TAG_ATTR_OFFERING_ID = "offeringId";
    private static final String TAG_ATTR_OFFERING_VERSION = "offeringVersionRange";
    private static final TemplateOfferingCustomPanelFactory INSTANCE = new TemplateOfferingCustomPanelFactory();

    public static TemplateOfferingCustomPanelFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public CustomPanelJobPair[] createCustomPanels(Class<? extends ICustomPanel> panelType, ICustomPanelGenerator customPanelGenerator, WizardType type, AgentJob[] allProductJobs, boolean isMultipleProfile) throws CoreException {
        List<CustomPanelWrapperJobPair> pairs = this.getCustomPanelWrapperJobPairsFromExtensions(allProductJobs, false, isMultipleProfile);
        if (pairs.isEmpty()) {
            return new CustomPanelJobPair[0];
        }
        LinkedList<CustomPanelJobPair> result = new LinkedList<CustomPanelJobPair>();
        for (CustomPanelWrapperJobPair pair : pairs) {
            CustomPanelWrapper wrapper = pair.cpWrapper;
            ICustomPanel customPanel = customPanelGenerator.generateCustomPanel(wrapper);
            if (customPanel == null) continue;
            if (!panelType.isInstance(customPanel)) {
                throw new CoreException((IStatus)new Status(4, Agent.PI_AGENT, NLS.bind((String)"Instance of class {0} is expected; actual type is {1}.", (Object)panelType.getName(), (Object)customPanel.getClass().getName())));
            }
            CustomPanelJobPair cpJobPair = new CustomPanelJobPair(customPanel, pair.job);
            result.add(cpJobPair);
        }
        return result.toArray(new CustomPanelJobPair[result.size()]);
    }

    @Override
    public CustomPanelWrapper[] createCustomPanelTemplates(AgentJob[] allProductJobs) throws CoreException {
        List<CustomPanelWrapperJobPair> pairs = this.getCustomPanelWrapperJobPairsFromExtensions(allProductJobs, true, false);
        if (pairs.isEmpty()) {
            return new CustomPanelWrapper[0];
        }
        LinkedList<CustomPanelWrapper> result = new LinkedList<CustomPanelWrapper>();
        for (CustomPanelWrapperJobPair pair : pairs) {
            result.add(pair.cpWrapper);
        }
        return result.toArray(new CustomPanelWrapper[result.size()]);
    }

    private List<CustomPanelWrapperJobPair> getCustomPanelWrapperJobPairsFromExtensions(AgentJob[] allProductJobs, boolean isSilentInstall, boolean isMultipleProfile) throws CoreException {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.cic.agent.core", TAG_TEMPLATE_OFFERING_CUSTOM_PANEL);
        if (extensionPoint == null) {
            return Collections.EMPTY_LIST;
        }
        IExtension[] extensions = extensionPoint.getExtensions();
        if (extensions.length == 0) {
            return Collections.EMPTY_LIST;
        }
        WizardType wizardType = SharedUIUtils.decideFlowType(allProductJobs);
        if (wizardType == null) {
            return Collections.EMPTY_LIST;
        }
        Collection<AgentJob[]> jobArrays = this.getSortedJobs(allProductJobs, isSilentInstall, isMultipleProfile, wizardType.equals(WizardType.UNINSTALL));
        LinkedHashMap<AgentJob, JobTemplatePanelExtList> jobToTemplateListMap = new LinkedHashMap<AgentJob, JobTemplatePanelExtList>();
        for (AgentJob[] jobsInOneProfile : jobArrays) {
            int extensionNum = 0;
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                ++extensionNum;
                IConfigurationElement[] elements = extension.getConfigurationElements();
                if (elements != null && elements.length != 0) {
                    int offeringBindingNum = 0;
                    IConfigurationElement[] iConfigurationElementArray = elements;
                    int n3 = elements.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement element = iConfigurationElementArray[n4];
                        if (element.getName().equals(TAG_OFFERING_BINDING)) {
                            String offeringVersion;
                            ++offeringBindingNum;
                            String offeringId = element.getAttribute(TAG_ATTR_OFFERING_ID);
                            AgentJob matchedJob = SharedUIUtils.getJob(offeringId, offeringVersion = element.getAttribute(TAG_ATTR_OFFERING_VERSION), jobsInOneProfile);
                            if (matchedJob != null) {
                                int bundleNum = SharedUIUtils.getOfferingBundleNum(extension.getContributor().getName(), matchedJob);
                                JobTemplatePanelExtList panelList = (JobTemplatePanelExtList)jobToTemplateListMap.get(matchedJob);
                                if (panelList == null) {
                                    panelList = new JobTemplatePanelExtList(matchedJob, jobsInOneProfile);
                                    jobToTemplateListMap.put(matchedJob, panelList);
                                }
                                LinkedList<TemplateCustomPanelFactory.TemplatePanelDefinition> templatePanelExtensions = new LinkedList<TemplateCustomPanelFactory.TemplatePanelDefinition>();
                                IConfigurationElement[] childrenElements = element.getChildren();
                                this.parseTemplatePanelDefinitions(childrenElements, templatePanelExtensions, 0, bundleNum, extensionNum, offeringBindingNum);
                                if (!templatePanelExtensions.isEmpty()) {
                                    panelList.addTemplatePanels(templatePanelExtensions);
                                }
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        if (jobToTemplateListMap.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        Collection jobPanelExtList = jobToTemplateListMap.values();
        LinkedList<CustomPanelWrapperJobPair> result = new LinkedList<CustomPanelWrapperJobPair>();
        for (JobTemplatePanelExtList jobPanelList : jobPanelExtList) {
            AgentJob job = jobPanelList.getJob();
            List<TemplateCustomPanelFactory.TemplatePanelDefinition> panelExtensions = jobPanelList.getSortedPanelDefinition();
            IAgentJob[] jobsInOneProfile = jobPanelList.getProfileJobs();
            for (TemplateCustomPanelFactory.TemplatePanelDefinition panelExt : panelExtensions) {
                CustomPanelWrapper cpTemplate;
                if (!panelExt.getWizardTypes().contains(wizardType.getType()) || (cpTemplate = panelExt.createCustomPanelTemplateInstance()) == null) continue;
                try {
                    CustomPanelData data = new CustomPanelData(allProductJobs, jobsInOneProfile);
                    cpTemplate.initCustomPanelData(data);
                    IOffering offering = job.getOffering();
                    if (offering != null) {
                        cpTemplate.setOfferingId(offering.getIdentity().getId());
                    }
                    if (!cpTemplate.canAddPanelToWizard()) continue;
                    result.add(new CustomPanelWrapperJobPair(cpTemplate, job));
                }
                catch (Exception e) {
                    IStatus status = SharedUIUtils.generateCustomPanelExceptionStatus(null, cpTemplate.getPanelTitle(), (Throwable)e);
                    throw new CoreException(status);
                }
            }
        }
        return result;
    }

    private static class CustomPanelWrapperJobPair {
        CustomPanelWrapper cpWrapper;
        AgentJob job;

        CustomPanelWrapperJobPair(CustomPanelWrapper wrapper, AgentJob job) {
            this.cpWrapper = wrapper;
            this.job = job;
        }
    }

    private static class JobTemplatePanelExtList
    extends TemplateCustomPanelFactory.BaseTemplatePanelExtList {
        private final AgentJob job;
        private final AgentJob[] jobsInOneProfile;

        public JobTemplatePanelExtList(AgentJob job, AgentJob[] jobsInOneProfile) {
            this.job = job;
            this.jobsInOneProfile = jobsInOneProfile;
        }

        public AgentJob getJob() {
            return this.job;
        }

        public AgentJob[] getProfileJobs() {
            return this.jobsInOneProfile;
        }
    }
}

