/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.response.impl;

import com.ibm.cic.agent.core.internal.response.IElement;
import com.ibm.cic.agent.core.internal.response.IElementProxy;
import com.ibm.cic.agent.core.internal.response.IFeaturesElement;
import com.ibm.cic.agent.core.internal.response.IFixesElement;
import com.ibm.cic.agent.core.internal.response.IPackageElement;
import com.ibm.cic.agent.core.internal.response.IPropertiesElement;
import com.ibm.cic.agent.core.internal.response.impl.ActionElement;
import com.ibm.cic.agent.core.internal.response.impl.OfferingProxy;
import com.ibm.cic.agent.core.internal.response.impl.ResponseFactory;
import java.util.List;

public class PackageElement
extends ActionElement
implements IPackageElement {
    private static final String ID = "id";
    private static final String VERSION = "version";
    private static final String MIN_VERSION = "minVersion";

    public PackageElement() {
        super("package");
    }

    @Override
    public List getFeatures() {
        return this.getChildren("features");
    }

    @Override
    public List getFixes() {
        return this.getChildren("fixes");
    }

    @Override
    public String getId() {
        return this.getAttribute(ID, null);
    }

    @Override
    public String getVersion() {
        return this.getAttribute(VERSION, null);
    }

    @Override
    public void setId(String value) {
        this.setAttribute(ID, value);
    }

    @Override
    public void setVersion(String value) {
        this.setAttribute(VERSION, value);
    }

    @Override
    public String getMinVersion() {
        return this.getAttribute(MIN_VERSION, null);
    }

    @Override
    public List getProperties() {
        return this.getChildren("properties");
    }

    @Override
    public void setMinVersion(String value) {
        this.setAttribute(MIN_VERSION, value);
    }

    @Override
    public void addChild(IElement element) {
        String name = element.getElementName();
        if (name.equals("feature")) {
            IFeaturesElement fs = ResponseFactory.getInstance().createFeaturesElement();
            fs.addChild(element);
            super.addChild(fs);
        } else if (name.equals("fix")) {
            IFixesElement fs = ResponseFactory.getInstance().createFixesElement();
            fs.addChild(element);
            super.addChild(fs);
        } else if (name.equals("property")) {
            IPropertiesElement ps = ResponseFactory.getInstance().createPropertiesElement();
            ps.addChild(element);
            super.addChild(ps);
        } else {
            super.addChild(element);
        }
    }

    @Override
    public boolean match(IElementProxy elementProxy) {
        if (!(elementProxy instanceof OfferingProxy)) {
            return false;
        }
        OfferingProxy offeringProxy = (OfferingProxy)elementProxy;
        return this.getId().equals(offeringProxy.getOffering().getIdentity().getId());
    }
}

