/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.response.impl;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.InstallJob;
import com.ibm.cic.agent.core.UninstallJob;
import com.ibm.cic.agent.core.internal.headless.ShadowProfile;
import com.ibm.cic.agent.core.internal.response.IElementProxy;
import com.ibm.cic.agent.core.internal.response.IFixElement;
import com.ibm.cic.agent.core.internal.response.impl.Diff;
import com.ibm.cic.agent.core.internal.response.impl.FixProxy;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.SimpleIdentity;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.osgi.framework.Version;

public class DiffFix
extends Diff {
    public DiffFix(IElementProxy source, IElementProxy target) {
        super(source, target);
    }

    public IStatus computeJobs(ShadowProfile tempProfile, List jobs) {
        CicMultiStatus ret = Statuses.ST.createMultiStatus();
        if (this.isCreate() || this.isReplace()) {
            IFix fix = this.findAvailableFix();
            jobs.add(new InstallJob(tempProfile, (IOfferingOrFix)fix));
        } else if (this.isRemove()) {
            IFix installedFix = this.findInstalledFix();
            if (installedFix != null) {
                jobs.add(new UninstallJob(tempProfile, (IOfferingOrFix)installedFix));
            } else {
                throw new IllegalArgumentException();
            }
        }
        return ret;
    }

    private IFix findInstalledFix() {
        return ((FixProxy)this.getTargetElement()).getFix();
    }

    private IFix findAvailableFix() {
        String id = ((IFixElement)this.getSourceElement()).getId();
        String versionString = ((IFixElement)this.getSourceElement()).getVersion();
        List<IOfferingOrFix> fixes = null;
        if (versionString != null) {
            try {
                IOfferingOrFix offeringOrFix = Agent.getInstance().findOfferingOrFix((IIdentity)new SimpleIdentity(id), new Version(versionString), (IProgressMonitor)new NullProgressMonitor());
                fixes = Collections.singletonList(offeringOrFix);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException();
            }
        } else {
            fixes = Agent.getInstance().findLatestOfferingOrUpdateFix(id, null);
        }
        return fixes == null || fixes.isEmpty() ? null : (IFix)fixes.get(0);
    }
}

