/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.expander;

import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.InstallContextTree;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.internal.expander.AgentContextState;
import com.ibm.cic.agent.core.internal.expander.AgentSelectorExpander;
import com.ibm.cic.agent.core.internal.expander.CompatibilityCheck;
import com.ibm.cic.agent.core.internal.expander.ExpanderCache;
import com.ibm.cic.agent.core.internal.expander.IExpanderInput;
import com.ibm.cic.agent.core.internal.expander.InstallContextMerger;
import com.ibm.cic.agent.internal.core.InstallRegistry;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.InstallableUnitPair;
import com.ibm.cic.common.core.model.expander.IContextState;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ExpansionResult
implements IExpanderInput {
    private Profile profile;
    private final AgentJob[] jobs;
    private final Map<IOffering, Collection<IFeature>> offerings;
    private final Set<IFix> fixes;
    private final AgentContextState contextState;
    private IStatus status;
    private boolean doCompatibilityCheck = false;
    private final boolean hasToleranceError;
    private InstallContextTree contextTree = null;
    private ExpanderCache expanderCache = null;

    public static ExpansionResult expand(Profile profile, IProgressMonitor monitor) {
        return new AgentSelectorExpander(profile).expandCached(monitor);
    }

    public static ExpansionResult expand(AgentJob[] jobs, IProgressMonitor monitor) {
        return new AgentSelectorExpander(jobs, true).expandCached(monitor);
    }

    static ExpansionResult expandWithoutInstalled(AgentJob[] jobs, IProgressMonitor monitor) {
        return new AgentSelectorExpander(jobs, false).expandCached(monitor);
    }

    static ExpansionResult success(AgentSelectorExpander expander, AgentContextState contextState) {
        return new ExpansionResult(expander, contextState, Status.OK_STATUS, false, false);
    }

    static ExpansionResult failure(AgentSelectorExpander expander, IStatus status, boolean doCompatibilityCheck, boolean hasToleranceError) {
        return new ExpansionResult(expander, null, status, doCompatibilityCheck, hasToleranceError || status.getCode() == 9001);
    }

    private ExpansionResult(AgentSelectorExpander expander, AgentContextState contextState, IStatus status, boolean doCompatibilityCheck, boolean hasToleranceError) {
        assert (!status.isOK() || contextState != null);
        this.profile = expander.getProfile();
        this.jobs = expander.getJobs();
        this.offerings = expander.getOfferings();
        this.fixes = expander.getFixes();
        this.status = status;
        this.contextState = contextState;
        this.doCompatibilityCheck = doCompatibilityCheck;
        this.hasToleranceError = hasToleranceError;
        AgentJob[] agentJobArray = this.jobs;
        int n = this.jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            assert (job.getProfile() == this.profile);
            ++n2;
        }
    }

    void setCache(ExpanderCache expanderCache) {
        this.expanderCache = expanderCache;
    }

    void reset(Profile newProfile) {
        this.profile = newProfile;
        this.contextTree = null;
    }

    public void clearCache() {
        if (this.expanderCache != null) {
            this.expanderCache.clearCache();
        }
    }

    public IContextState getRootContext() {
        return this.contextState;
    }

    @Override
    public Profile getProfile() {
        return this.profile;
    }

    @Override
    public AgentJob[] getJobs() {
        return this.jobs;
    }

    @Override
    public Map<IOffering, Collection<IFeature>> getOfferings() {
        return this.offerings;
    }

    @Override
    public Set<IFix> getFixes() {
        return this.fixes;
    }

    public boolean isOK() {
        return this.status.isOK();
    }

    public boolean isCancel() {
        return StatusUtil.isCancel((IStatus)this.status);
    }

    public IStatus getStatus() {
        if (!this.isOK() && !this.isCancel() && this.doCompatibilityCheck) {
            this.doCompatibilityCheck = false;
            this.status = new CompatibilityCheck(this.profile, this.status).perform(this.jobs, this.jobs.length);
        }
        return this.status;
    }

    public boolean hasToleranceError() {
        return this.hasToleranceError;
    }

    public IStatus saveInstallRegistry(IProgressMonitor monitor) {
        InstallRegistry.ProfileInstallRegistry registry = this.getProfile().getInstallRegistry();
        registry.markInstalledOfferings(this.getOfferings());
        registry.markInstalledFixes(this.getFixes());
        registry.clearIUs();
        for (InstallContextTree tree : this.getFullContextTree()) {
            InstallRegistry.ContextInstallRegistry contextRegistry = tree.getInstallRegistry();
            for (InstallableUnitPair pair : tree.getOriginalPairs()) {
                if (pair.getTo() == null) continue;
                contextRegistry.markInstalled(pair.getTo());
            }
        }
        try {
            registry.commit(monitor);
            InstallRegistry.getInstance().purgeMetadata();
        }
        catch (CoreException e) {
            return Statuses.ERROR.get((Throwable)e, Messages.Director_Error_Saving_Install_Registry, new Object[]{e.getMessage()});
        }
        return Status.OK_STATUS;
    }

    public InstallContextTree getRootContextTree() {
        if (this.contextTree == null && this.contextState != null) {
            this.contextTree = new InstallContextTree(this.profile, this.contextState);
            this.resolveInstallContexts();
        }
        return this.contextTree;
    }

    public List<InstallContextTree> getFullContextTree() {
        return this.getRootContextTree().getFullTree();
    }

    private void resolveInstallContexts() {
        this.fixRootInstallContext();
        if (InstallRegistry.getInstance().getProfile(this.profile.getProfileId()) != null) {
            this.contextTree.resolveInstallContexts(this.getOneOffering());
        }
        InstallContextMerger.merge(this.contextTree, null);
    }

    private void fixRootInstallContext() {
        InstallContext rootContext = this.profile.getRootContext();
        if (rootContext.getProperty("configLocation") == null && this.contextTree.getSubTrees().isEmpty() && rootContext.getSubcontexts().length == 0) {
            File config = new File(rootContext.getProperty("installLocation"), "configuration");
            rootContext.setLocalProperty("configLocation", config.getPath());
            rootContext.setCreatedDirectory(config);
            rootContext.addAdaptorType("eclipse");
        }
    }

    private IOffering getOneOffering() {
        AgentJob[] agentJobArray = this.jobs;
        int n = this.jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            IOffering offering = job.getOffering();
            if (offering != null) {
                return offering;
            }
            ++n2;
        }
        return null;
    }

    public void setProfileIntuitiveInstallOrder(boolean b) {
        String prev;
        String s = String.valueOf(b);
        if (!s.equals(prev = this.profile.getData(Profile.INTUITIVE_UNINSTALL_INSTALL_ORDER_REQUIRED))) {
            this.profile.setData(Profile.INTUITIVE_UNINSTALL_INSTALL_ORDER_REQUIRED, s);
        }
    }
}

