/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.expander;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.IInstallAdaptor;
import com.ibm.cic.agent.core.IP2Generator;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.internal.expander.AgentContextState;
import com.ibm.cic.agent.core.internal.expander.ExpanderCache;
import com.ibm.cic.agent.core.internal.expander.ExpansionResult;
import com.ibm.cic.agent.core.internal.expander.IExpanderInput;
import com.ibm.cic.agent.core.internal.expander.ProfileSelectorExpander;
import com.ibm.cic.agent.core.internal.expander.SelectorContext;
import com.ibm.cic.agent.core.utils.AgentUserOptions;
import com.ibm.cic.agent.internal.core.AdaptorManager;
import com.ibm.cic.agent.internal.core.InstallRegistry;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.model.ExtensionCategory;
import com.ibm.cic.common.core.model.FixUtil;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IFixApplicableOffering;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.IShareableEntity;
import com.ibm.cic.common.core.model.expander.IContextState;
import com.ibm.cic.common.core.model.utils.OfferingProperty;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.SubtaskOnlyProgressMonitor;
import com.ibm.cic.common.logging.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

class AgentSelectorExpander
extends ProfileSelectorExpander
implements IExpanderInput {
    private static final Logger log = Logger.getLogger();
    private static final Logger tlog = Logger.getLogger((Logger)log, (String)"timing");
    private static final IP2Generator.Factory P2_GENERATOR_FACTORY = AgentSelectorExpander.createP2GeneratorFactory();
    private final AgentJob[] jobs;
    private final List<IOffering> toPrepare = new ArrayList<IOffering>();
    private static final int EXPANDER_CACHE_SIZE = AgentUserOptions.CIC_DISABLE_EXPANDER_CACHE.isSet() ? 0 : 10;
    private static final ExpanderCache EXPANDER_CACHE = new ExpanderCache(EXPANDER_CACHE_SIZE);

    AgentSelectorExpander(Profile profile) {
        this(profile, AgentJob.NO_JOBS);
        this.addInstalled(Collections.emptySet());
    }

    AgentSelectorExpander(AgentJob[] jobs, boolean includeInstalled) {
        this(jobs[0].getProfile(), jobs);
        HashSet<IIdentity> omit = new HashSet<IIdentity>();
        AgentJob[] agentJobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            assert (this.getProfile().equals(job.getProfile()));
            omit.add(job.getOfferingOrFix().getIdentity());
            AgentJob.AgentJobType type = job.getType();
            if (type.isInstall() || type.isModify() || type.isUpdate() || type.isRollback()) {
                IOffering offering = job.getOffering();
                if (offering != null) {
                    this.addOffering(offering, job.getFeatures());
                    omit.addAll(OfferingProperty.getSupercedes((IOffering)offering));
                } else {
                    this.addFix(job.getFix());
                }
            } else if (!type.isUninstall()) assert (false) : job;
            ++n2;
        }
        if (includeInstalled) {
            this.addInstalled(omit);
        }
    }

    private AgentSelectorExpander(Profile profile, AgentJob[] jobs) {
        super(profile);
        this.jobs = jobs;
    }

    private void addInstalled(Set<IIdentity> omit) {
        InstallRegistry.ProfileInstallRegistry registry = this.getProfile().getInstallRegistry();
        IOffering[] iOfferingArray = registry.getInstalledOfferings();
        int n = iOfferingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IOffering offering = iOfferingArray[n2];
            if (!omit.contains(offering.getIdentity())) {
                this.addOffering(offering, registry.getInstalledFeatures(offering));
                this.toPrepare.add(offering);
            }
            ++n2;
        }
        iOfferingArray = registry.getInstalledFixes();
        n = iOfferingArray.length;
        n2 = 0;
        while (n2 < n) {
            IOffering fix = iOfferingArray[n2];
            if (!omit.contains(fix.getIdentity())) {
                this.addFix((IFix)fix);
            }
            ++n2;
        }
    }

    @Override
    public AgentJob[] getJobs() {
        return this.jobs;
    }

    ExpansionResult expandCached(IProgressMonitor monitor) {
        ExpansionResult expansionResult = EXPANDER_CACHE.get(this);
        if (expansionResult == null && !(expansionResult = this.doExpand(monitor)).isCancel()) {
            EXPANDER_CACHE.put(this, expansionResult);
        }
        return expansionResult;
    }

    private ExpansionResult doExpand(IProgressMonitor monitor) {
        tlog.start(tlog.debug(this.toString()));
        SubtaskOnlyProgressMonitor mon = new SubtaskOnlyProgressMonitor(monitor);
        SplitProgressMonitor pm = new SplitProgressMonitor((IProgressMonitor)mon).split(1, 1, 20);
        try {
            this.checkUniqueFeatureIds();
            this.prepareOfferings(pm.checkCanceled().next());
            this.checkAndResolveFixes();
        }
        catch (CoreException e) {
            return ExpansionResult.failure(this, e.getStatus(), false, false);
        }
        try {
            StatusUtil.throwIfError((IStatus)super.expand(pm.next()));
            AgentContextState agentContextState = this.generateP2IUs(null, Collections.emptyList(), super.getRootContext(), pm.next());
            ExpansionResult expansionResult = ExpansionResult.success(this, agentContextState);
            return expansionResult;
        }
        catch (CoreException e) {
            ExpansionResult expansionResult = ExpansionResult.failure(this, e.getStatus(), true, this.hasToleranceError());
            return expansionResult;
        }
        finally {
            tlog.stop();
        }
    }

    @Deprecated
    public IStatus expand(IProgressMonitor monitor) {
        throw new UnsupportedOperationException("Use expandCached instead of expand");
    }

    protected void checkRSEs() {
    }

    private AgentContextState generateP2IUs(IP2Generator parentGen, Collection<IShareableEntity> parentSEs, IContextState cs, IProgressMonitor monitor) throws CoreException {
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor).split(1, 1, cs.getSubContexts().size());
        IP2Generator gen = P2_GENERATOR_FACTORY.create(parentGen, this.getProfile(), cs);
        try {
            if (cs.isRoot()) {
                assert (cs.getParentSEs().isEmpty());
                pm.splitNext(this.getOfferings().size() + 1);
                for (IOffering offering : this.getOfferings().keySet()) {
                    gen.addOffering(offering, pm.next());
                }
            }
            pm.splitNext(this.getFixes().size());
            for (IFix fix : this.getFixes()) {
                gen.addFix(fix, pm.next());
            }
            Map seMap = gen.getProvisioningPlanMap(parentSEs, pm.next());
            AgentContextState newContext = AgentContextState.create(cs, seMap);
            StatusUtil.throwIfError((IStatus)this.collectStatus());
            pm.splitNext(cs.getSubContexts().size());
            for (IContextState subContext : cs.getSubContexts()) {
                newContext.addSubContext(this.generateP2IUs(gen, AgentSelectorExpander.getSelectedParentSEs(newContext, subContext), subContext, pm.next()));
            }
            pm.checkDone();
            AgentContextState agentContextState = newContext;
            return agentContextState;
        }
        finally {
            gen.cleanup();
        }
    }

    private static Collection<IShareableEntity> getSelectedParentSEs(IContextState parent, IContextState child) {
        if (parent == null) {
            return Collections.emptyList();
        }
        HashSet<IIdentity> parentSeIds = new HashSet<IIdentity>();
        for (IShareableEntity se : child.getParentSEs()) {
            parentSeIds.add(se.getIdentity());
        }
        ArrayList<IShareableEntity> result = new ArrayList<IShareableEntity>(parentSeIds.size());
        for (IShareableEntity se : parent.getShareableEntities()) {
            if (!parentSeIds.contains(se.getIdentity())) continue;
            result.add(se);
        }
        return result;
    }

    private static IP2Generator.Factory createP2GeneratorFactory() {
        IInstallAdaptor adaptor = AdaptorManager.getInstance().getAdaptor("p2Eclipse");
        if (!(adaptor instanceof IAdaptable)) {
            throw new IllegalStateException("p2 adapter not found");
        }
        IAdaptable adaptable = (IAdaptable)adaptor;
        IP2Generator.Factory factory = (IP2Generator.Factory)adaptable.getAdapter(IP2Generator.Factory.class);
        if (factory == null) {
            throw new IllegalStateException("p2 generator factory not found");
        }
        return factory;
    }

    @Override
    protected com.ibm.cic.common.core.model.utils.SelectorContext createSelectorContext() {
        SelectorContext context;
        if (this.getOfferings().isEmpty()) {
            context = new SelectorContext(this.getProfile());
        } else {
            IOffering offering = (IOffering)this.getOfferings().keySet().iterator().next();
            context = new SelectorContext(this.getProfile(), (IOfferingOrFix)offering, Collections.EMPTY_SET);
        }
        context.setJobs(this.jobs);
        return context;
    }

    private void checkUniqueFeatureIds() throws CoreException {
        AgentJob[] agentJobArray = this.jobs;
        int n = this.jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            IOffering offering = job.getOffering();
            if (offering != null) {
                StatusUtil.throwIfError((IStatus)OfferingUtil.checkUniqueFeatureIds((IOffering)offering));
            }
            ++n2;
        }
    }

    private void prepareOfferings(IProgressMonitor monitor) throws CoreException {
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, this.toPrepare.size());
        for (IOffering offering : this.toPrepare) {
            StatusUtil.throwIfError((IStatus)Agent.getInstance().prepare((IOfferingOrFix)offering, ExtensionCategory.ALL, pm.next()));
        }
    }

    private void checkAndResolveFixes() throws CoreException {
        LinkedHashSet<IFix> haveOffering = new LinkedHashSet<IFix>();
        for (IFix fix : this.getFixes()) {
            boolean fixApplicable = FixUtil.isFixApplicable((IFix)fix, this.getOfferings().keySet());
            if (!fixApplicable) {
                this.throwFixOfferingApplicabilityNotSatisfied(fix);
            }
            haveOffering.add(fix);
        }
        AgentJob[] agentJobArray = this.jobs;
        int n = this.jobs.length;
        int n2 = 0;
        while (n2 < n) {
            IOffering[] baseOfferings;
            AgentJob job = agentJobArray[n2];
            IFix fix = job.getFix();
            if (fix != null && !haveOffering.contains(fix) && (baseOfferings = Agent.getInstance().getInstalledOfferingsForFix(this.getProfile(), fix)).length == 0) {
                this.throwFixOfferingApplicabilityNotSatisfied(fix);
            }
            ++n2;
        }
    }

    private void throwFixOfferingApplicabilityNotSatisfied(IFix fix) throws CoreException {
        CicMultiStatus ms = Statuses.ERROR.getMultiStatus(Messages.AgentSelectorExpander_fixNotApplicableRequiresAtLeastOneInstalled, new Object[]{fix.getName()});
        FixUtil.reportFixOfferingApplicabilityNotSatisfied((CicMultiStatus)ms, (IFix)fix, (FixUtil.IApplicableOfferingLocator)new FixUtil.IApplicableOfferingLocator(){

            public IOffering getMatchingOffering(IFixApplicableOffering applicability) {
                return Agent.getInstance().findLatestOfferingOrUpdate(applicability.getIdentity(), applicability.getTolerance(), null);
            }

            public IOffering getLatestOffering(IFixApplicableOffering applicability) {
                return Agent.getInstance().findLatestOfferingOrUpdate(applicability.getIdentity(), null, null);
            }
        });
        throw new CoreException((IStatus)ms);
    }
}

