/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.commands;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.internal.commands.AbstractCommand;
import com.ibm.cic.agent.core.internal.commands.HeadlessApplicationException;
import com.ibm.cic.agent.core.internal.commands.XMLElement;
import com.ibm.cic.agent.core.internal.headless.IValidateCommand;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.UserOptions;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public class ValidateCommand
extends AbstractCommand
implements IValidateCommand {
    public ValidateCommand() {
        super("validate");
    }

    @Override
    public IStatus execute(Agent agent, IProgressMonitor monitor) {
        CicMultiStatus result = Statuses.ST.createMultiStatus();
        String filter = this.getAttribute("filter");
        if (filter != null && filter.trim().length() > 0) {
            UserOptions.set((UserOptions.StringOption)UserOptions.CIC_MODEL_VALIDATION_FILTER, (String)filter);
        }
        for (XMLElement child : this.children()) {
            result.add(this.execute(agent, child));
        }
        return result;
    }

    private IStatus execute(Agent agent, XMLElement unit) {
        IOffering offering;
        String idString = unit.getAttribute("id");
        String versionString = unit.getAttribute("version");
        try {
            offering = this.getOffering(agent, idString, versionString);
        }
        catch (HeadlessApplicationException e) {
            return e.getStatus();
        }
        return agent.validate(offering, null);
    }

    @Override
    public int getExecutionPoint() {
        return 4;
    }

    @Override
    public void addOffering(String id, String version, String features) {
        XMLElement childElement = new XMLElement("offering");
        childElement.addAttribute("id", id);
        childElement.addAttribute("version", version);
        this.addChild(childElement);
    }
}

