/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.commands;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentDependencyCheckerUtil;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.BitModeUtils;
import com.ibm.cic.agent.core.CacheLocationManager;
import com.ibm.cic.agent.core.ErrorJob;
import com.ibm.cic.agent.core.ModifyJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.UninstallJob;
import com.ibm.cic.agent.core.internal.commands.AbstractInstallCommand;
import com.ibm.cic.agent.core.internal.commands.HeadlessApplicationException;
import com.ibm.cic.agent.core.internal.commands.XMLElement;
import com.ibm.cic.agent.core.internal.headless.IUninstallCommand;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.model.ExtensionCategory;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFeatureBase;
import com.ibm.cic.common.core.model.IFeatureGroup;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.SimpleIdentity;
import com.ibm.cic.common.core.model.utils.LicenseUtils;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.OutputFormatter;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Version;

public class UninstallCommand
extends AbstractInstallCommand
implements IUninstallCommand {
    public UninstallCommand() {
        super("uninstall");
    }

    @Override
    protected IStatus execute(Agent agent, AgentJob[] agentJobs, IProgressMonitor monitor) {
        CicMultiStatus status = Statuses.ST.createMultiStatus();
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, new int[]{2, 2, 3, 20, 1});
        try {
            AgentJob job;
            AgentJob[] agentJobArray = agentJobs;
            int n = agentJobs.length;
            int n2 = 0;
            while (n2 < n) {
                job = agentJobArray[n2];
                if (agent.isAgentOffering((IOfferingOrFix)job.getOffering()) && !CacheLocationManager.getInstance().isCacheLocationChangeable()) {
                    status.add((IStatus)Statuses.ERROR.get(464, Messages.HeadlessApplication_UninstallIM, new Object[0]));
                    CicMultiStatus cicMultiStatus = status;
                    return cicMultiStatus;
                }
                ++n2;
            }
            spm.splitNext(agentJobs.length);
            agentJobArray = agentJobs;
            n = agentJobs.length;
            n2 = 0;
            while (n2 < n) {
                job = agentJobArray[n2];
                this.prepareJob(status, agent, job, spm.next());
                if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                    CicMultiStatus cicMultiStatus = status;
                    return cicMultiStatus;
                }
                if (spm.isCanceled()) {
                    status.add(Status.CANCEL_STATUS);
                    CicMultiStatus cicMultiStatus = status;
                    return cicMultiStatus;
                }
                ++n2;
            }
            status.add(UninstallCommand.performLocationPermissionCheck(agentJobs));
            if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                CicMultiStatus cicMultiStatus = status;
                return cicMultiStatus;
            }
            status.add(BitModeUtils.check64bitImSupported(agentJobs));
            if (status.isErrorOrCancel()) {
                CicMultiStatus cicMultiStatus = status;
                return cicMultiStatus;
            }
            spm.splitNext(agentJobs.length);
            Set offeringsSeenBefore = AgentJob.getOfferingSetFromJobs(agentJobs);
            AgentJob[] agentJobArray2 = agentJobs;
            int n3 = agentJobs.length;
            n = 0;
            while (n < n3) {
                AgentJob job2 = agentJobArray2[n];
                this.checkJob(status, agent, job2, offeringsSeenBefore, spm.next());
                if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                    CicMultiStatus cicMultiStatus = status;
                    return cicMultiStatus;
                }
                if (spm.isCanceled()) {
                    status.add(Status.CANCEL_STATUS);
                    CicMultiStatus cicMultiStatus = status;
                    return cicMultiStatus;
                }
                ++n;
            }
            status.add(AgentDependencyCheckerUtil.checkOfferingFixDependenciesMultipleProfiles(agentJobs, spm.next()));
            if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                CicMultiStatus cicMultiStatus = status;
                return cicMultiStatus;
            }
            status.add(agent.uninstall(agentJobs, spm.next()));
        }
        finally {
            status.add(agent.unprepare(agentJobs, spm.next()));
        }
        spm.done();
        return status;
    }

    private void prepareJob(CicMultiStatus status, Agent agent, AgentJob job, IProgressMonitor monitor) {
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, new int[]{2, 1, 1});
        IOfferingOrFix offeringOrFix = job.getOfferingOrFix();
        status.add(agent.prepare(offeringOrFix, ExtensionCategory.ALL, spm.next()));
        if (StatusUtil.isErrorOrCancel((IStatus)status)) {
            return;
        }
        status.add(this.prepareInstalledFixes(agent, job.getProfile(), spm.next()));
        if (StatusUtil.isErrorOrCancel((IStatus)status)) {
            return;
        }
        status.add(this.prepareInstalledOfferings(agent, job.getProfile(), spm.next()));
        if (StatusUtil.isErrorOrCancel((IStatus)status)) {
            return;
        }
        spm.done();
    }

    private void checkJob(CicMultiStatus status, Agent agent, AgentJob job, Set offeringsSeenBefore, IProgressMonitor monitor) {
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, new int[]{1, 1});
        IOfferingOrFix offeringOrFix = job.getOfferingOrFix();
        status.add(agent.evaluatePrecheckBundles(offeringOrFix, job));
        if (StatusUtil.isErrorOrCancel((IStatus)status)) {
            return;
        }
        status.add(agent.evaluatePrereqBundles(offeringOrFix, job));
        if (StatusUtil.isErrorOrCancel((IStatus)status)) {
            return;
        }
        status.add(UninstallCommand.checkPrerequisite(agent, job, offeringsSeenBefore, spm.next()));
        if (StatusUtil.isErrorOrCancel((IStatus)status)) {
            return;
        }
        status.add(job.resolveFeatureIds(agent, spm.next()));
        if (StatusUtil.isErrorOrCancel((IStatus)status)) {
            return;
        }
        if (offeringOrFix instanceof IOffering) {
            status.add(UninstallCommand.checkUninstallableFeatures(agent, job));
            if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                return;
            }
        }
    }

    @Override
    public AgentJob[] getAsInputJobs(Agent agent, boolean isWizardMode) {
        ArrayList<AgentJob> result = new ArrayList<AgentJob>();
        for (XMLElement child : this.children()) {
            if (child.getName().equals("data")) continue;
            result.addAll(Arrays.asList(this.getAsInputJob(agent, child, isWizardMode, null)));
        }
        AgentJob[] jobs = AgentJob.toArray(result);
        this.initializeProfilePlatformProperties(jobs);
        this.setAcceptLicense(jobs);
        return jobs;
    }

    @Override
    protected AgentJob[] getAsInputJob(Agent agent, XMLElement unit, boolean isWizardMode, Profile defaultProfile) {
        String profileId = unit.getAttribute("profile");
        Profile profile = agent.getProfile(profileId);
        String idString = unit.getAttribute("id");
        String versionString = unit.getAttribute("version");
        if (profile == null) {
            String installLocation = unit.getAttribute("installLocation");
            if (profileId != null) {
                return ErrorJob.create(false, Messages.UnisntallCommand_NoPackageIsInstalledAtProfileId, profileId);
            }
            if (installLocation != null && (profile = agent.getProfileByInstallLocation(installLocation)) == null) {
                return ErrorJob.create(false, Messages.UnisntallCommand_NoPackageIsInstalledAtLocation, installLocation);
            }
            if (profile == null) {
                if (idString != null) {
                    List profiles = agent.getProfilesByOfferingOrFixId(idString);
                    if (profiles.size() == 1) {
                        profile = (Profile)profiles.get(0);
                    } else if (profiles.size() > 1 && (profile = this.getProfileByOfferingIdVersion(agent, idString, versionString, profiles)) == null) {
                        if (this.isModify()) {
                            return this.getModifyMultipleInstancesError(idString, versionString, profiles);
                        }
                        return ErrorJob.create(false, Messages.UnisntallCommand_InstalledInMoreThenOneLocation, idString);
                    }
                } else {
                    ArrayList result = new ArrayList();
                    Profile[] profileArray = agent.getSortedProfiles(true);
                    int n = profileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Profile p = profileArray[n2];
                        if (!p.isAgentProfile() && p.shouldBeVisible()) {
                            result.addAll(this.createUninstallJobsForAllProfileOfferings(unit, agent, p));
                        }
                        ++n2;
                    }
                    return AgentJob.toArray(result);
                }
            }
        }
        IOfferingOrFix offeringOrFix = null;
        if (profile != null && idString == null && versionString == null) {
            return AgentJob.toArray(this.createUninstallJobsForAllProfileOfferings(unit, agent, profile));
        }
        try {
            offeringOrFix = this.getInstalledOfferingOrFix(profile, idString, versionString);
        }
        catch (HeadlessApplicationException e) {
            try {
                profile = Profile.getLicenseProfile(agent);
                if (profile == null) {
                    throw e;
                }
                offeringOrFix = this.getInstalledOfferingOrFix(profile, idString, versionString);
                if (!(offeringOrFix instanceof IOffering) || !LicenseUtils.isPEKOffering((IOffering)((IOffering)offeringOrFix))) {
                    throw e;
                }
            }
            catch (HeadlessApplicationException headlessApplicationException) {
                return ErrorJob.create(false, e.getStatus());
            }
        }
        if (offeringOrFix instanceof IFix) {
            return new AgentJob[]{new UninstallJob(profile, offeringOrFix)};
        }
        if (offeringOrFix instanceof IOffering) {
            AbstractJob job;
            IOffering offering = (IOffering)offeringOrFix;
            if (this.isModify()) {
                IStatus status = this.getInput().executeProfileCommands(agent, true, (IProgressMonitor)new NullProgressMonitor());
                if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                    return ErrorJob.create(false, status);
                }
                job = new ModifyJob(profile, (IOfferingOrFix)offering, AgentJob.AgentJobType.UNINSTALL_JOB);
            } else {
                job = new UninstallJob(profile, (IOfferingOrFix)offering);
            }
            job.setFeatureIds(unit.getAttribute("features"));
            return new AgentJob[]{job};
        }
        throw new AssertionError((Object)"Bad result from getInstalledOfferingOrFix");
    }

    private Profile getProfileByOfferingIdVersion(Agent agent, String idString, String versionString, List<Profile> profiles) {
        if (profiles.size() == 1) {
            return profiles.get(0);
        }
        if (versionString == null) {
            return null;
        }
        SimpleIdentity id = new SimpleIdentity(idString);
        Version version = new Version(versionString);
        ArrayList<Profile> matchingProfiles = new ArrayList<Profile>();
        for (Profile profile : profiles) {
            IOffering offering = agent.getInstalledOffering(profile, (IIdentity)id);
            if (!version.equals((Object)offering.getVersion())) continue;
            matchingProfiles.add(profile);
        }
        if (matchingProfiles.size() == 1) {
            return (Profile)matchingProfiles.get(0);
        }
        return null;
    }

    private AgentJob[] getModifyMultipleInstancesError(String offeringId, String offeringVersion, List profiles) {
        List installedLocations = this.searchInstalledLocations(profiles);
        String offeringIdVersion = offeringId;
        if (offeringVersion != null) {
            offeringIdVersion = String.valueOf(offeringIdVersion) + "_" + offeringVersion;
        }
        StringBuilder sb = new StringBuilder();
        for (String location : installedLocations) {
            sb.append(OutputFormatter.NEW_LINE_STR).append(location);
        }
        return ErrorJob.create(false, Messages.Cmd_modifyFeatures_multipleInstancesError, offeringIdVersion, sb.toString());
    }

    private List searchInstalledLocations(List<Profile> profiles) {
        ArrayList<String> installedLocations = new ArrayList<String>(profiles.size());
        for (Profile profile : profiles) {
            installedLocations.add(profile.getInstallLocation());
        }
        return installedLocations;
    }

    private List createUninstallJobsForAllProfileOfferings(XMLElement unit, Agent agent, Profile profile) {
        IOffering[] offerings = agent.getInstalledOfferings(profile);
        ArrayList<UninstallJob> result = new ArrayList<UninstallJob>();
        IOffering[] iOfferingArray = offerings;
        int n = offerings.length;
        int n2 = 0;
        while (n2 < n) {
            IOffering offering = iOfferingArray[n2];
            UninstallJob job = new UninstallJob(profile, (IOfferingOrFix)offering);
            job.setFeatureIds(unit.getAttribute("features"));
            result.add(job);
            ++n2;
        }
        return result;
    }

    private static IStatus checkUninstallableFeatures(Agent agent, AgentJob job) {
        IOffering offering = job.getOffering();
        Profile profile = job.getProfile();
        Set installedFeatureSet = agent.getInstalledFeatures(profile, offering);
        List selectedFeatureList = job.getFeatures();
        if (installedFeatureSet.size() <= selectedFeatureList.size()) {
            return Status.OK_STATUS;
        }
        CicMultiStatus ms = Statuses.ST.createMultiStatus();
        for (IFeature selectedFeature : selectedFeatureList) {
            if (!installedFeatureSet.contains(selectedFeature)) continue;
            IStatus status = agent.checkPrerequisite((IFeatureBase)selectedFeature, job);
            if (status.getSeverity() == 4 && selectedFeature.hasApplicabilityFlag(status, 4)) {
                ms.add(status);
                continue;
            }
            if (UninstallCommand.checkForRequiredFeature(selectedFeature, installedFeatureSet, selectedFeatureList)) continue;
            status = Statuses.ERROR.get(551, Messages.Feature_Uninstall_Error_FeatureRequired, new Object[]{selectedFeature.getIdentity().getId()});
            ms.add(status);
        }
        return ms;
    }

    private static boolean checkForRequiredFeature(IFeature feature, Set<IFeature> installedFeatues, List<IFeature> selectedFeatures) {
        return !feature.isRequired() || UninstallCommand.checkForRequiredFeatureGroup(feature.getParent(), installedFeatues, selectedFeatures);
    }

    private static boolean checkForRequiredFeatureGroup(IFeatureGroup group, Set<IFeature> installedFeatues, List<IFeature> selectedFeatures) {
        if (group == null) {
            return false;
        }
        if (group.isRequired()) {
            return UninstallCommand.checkForRequiredFeatureGroup(group.getParent(), installedFeatues, selectedFeatures);
        }
        IFeature[] iFeatureArray = OfferingUtil.getAllFeatures((IFeatureGroup)group);
        int n = iFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFeature childFeature = iFeatureArray[n2];
            if (installedFeatues.contains(childFeature) && !selectedFeatures.contains(childFeature)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public boolean needAccessRepositories() {
        return false;
    }

    @Override
    protected List getOfferingsToOpenServiceRepositories(Agent agent, String id, String version, IProgressMonitor monitor) {
        return Collections.emptyList();
    }

    @Override
    public void refactorAgentProfileId(String newProfileId) {
        for (XMLElement child : this.children()) {
            String id;
            if (!child.getName().equals("offering") || !"com.ibm.cic.agent".equals(id = child.getAttribute("id"))) continue;
            child.addAttribute("profile", newProfileId);
        }
    }
}

