/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.commands;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentActivator;
import com.ibm.cic.agent.core.IImportCommandExtension;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.logging.Logger;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class ImportExtensionFactory {
    private static final Logger logger = Logger.getLogger(ImportExtensionFactory.class, (Plugin)AgentActivator.getDefault());
    public static final String PLUGIN_ID = "com.ibm.cic.agent.core";
    private static final String IMPORT_EXTENSIONS_EXTENSION_POINT = "importExtensions";
    private static final String TAG_IMPORT_EXTENSION = "importExtension";
    private static final String TAG_IMPORT_TYPE = "type";
    private static final String TAG_IMPORT_CLASS = "class";
    private static ImportExtensionFactory instance;
    private final ImportExtension[] importExtensions = this.loadImportExtensions();

    private ImportExtensionFactory() {
    }

    public static synchronized ImportExtensionFactory getInstance() {
        if (instance == null) {
            instance = new ImportExtensionFactory();
        }
        return instance;
    }

    public IImportCommandExtension getImportExtensionCommand(String importType) throws CoreException {
        if (this.importExtensions.length > 0) {
            ImportExtension[] importExtensionArray = this.importExtensions;
            int n = this.importExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                ImportExtension importExtension = importExtensionArray[n2];
                if (importExtension.getImportType().equals(importType)) {
                    Object obj = null;
                    obj = importExtension.getElement().createExecutableExtension(TAG_IMPORT_CLASS);
                    if (obj instanceof IImportCommandExtension) {
                        return (IImportCommandExtension)obj;
                    }
                    throw new CoreException((IStatus)new Status(4, Agent.PI_AGENT, NLS.bind((String)Messages.ImportCommand_ExtensionClassNotInstanceOf, (Object)importExtension.getImportClass(), (Object)IImportCommandExtension.class.getName())));
                }
                ++n2;
            }
        }
        return null;
    }

    private void parseImportExtension(IExtension extension, ArrayList list) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        if (elements != null && elements.length > 0) {
            IConfigurationElement[] iConfigurationElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (element.getName().equals(TAG_IMPORT_EXTENSION)) {
                    String importType = element.getAttribute(TAG_IMPORT_TYPE);
                    String importClass = element.getAttribute(TAG_IMPORT_CLASS);
                    if (importClass == null || importClass.trim().length() == 0) {
                        logger.status((IStatus)new Status(4, Agent.PI_AGENT, NLS.bind((String)Messages.ImportCommand_AttributeNotDefinedInExtension, (Object)TAG_IMPORT_CLASS, (Object)extension.getUniqueIdentifier())));
                    } else if (importType == null || importType.trim().length() == 0) {
                        logger.status((IStatus)new Status(4, Agent.PI_AGENT, NLS.bind((String)Messages.ImportCommand_AttributeNotDefinedInExtension, (Object)TAG_IMPORT_TYPE, (Object)extension.getUniqueIdentifier())));
                    } else {
                        ImportExtension importExtension = new ImportExtension(element, importType.trim(), importClass.trim());
                        list.add(importExtension);
                    }
                }
                ++n2;
            }
        }
    }

    private ImportExtension[] loadImportExtensions() {
        ImportExtension[] importExt = null;
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, IMPORT_EXTENSIONS_EXTENSION_POINT).getExtensions();
        if (extensions == null || extensions.length == 0) {
            return new ImportExtension[0];
        }
        ArrayList list = new ArrayList();
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            this.parseImportExtension(extension, list);
            ++n2;
        }
        importExt = list.size() > 0 ? list.toArray(new ImportExtension[0]) : new ImportExtension[]{};
        return importExt;
    }

    private static class ImportExtension {
        private final IConfigurationElement element;
        private final String importType;
        private final String importClass;

        public ImportExtension(IConfigurationElement element, String importType, String importClass) {
            this.element = element;
            this.importType = importType;
            this.importClass = importClass;
        }

        public IConfigurationElement getElement() {
            return this.element;
        }

        public String getImportType() {
            return this.importType;
        }

        public String getImportClass() {
            return this.importClass;
        }
    }
}

