/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.commands;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.ResponseFileFromInstall;
import com.ibm.cic.agent.core.ResponseFileFromRepositories;
import com.ibm.cic.agent.core.ResponseFileGenerator;
import com.ibm.cic.agent.core.cmd.CmdLine;
import com.ibm.cic.agent.core.internal.commands.AbstractCommand;
import com.ibm.cic.agent.core.internal.headless.IGenerateResponseFileCommand;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.cmd.ACmdLine;
import com.ibm.cic.common.core.cmd.ANetworkCmdOp;
import com.ibm.cic.common.core.console.PrompterUtils;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.SimpleIdentity;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.utils.Statuses;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;

public class GenerateResponseFileCommand
extends AbstractCommand
implements IGenerateResponseFileCommand {
    private String output;
    private String installationDirectory;
    private final List<String> repositories = new ArrayList<String>(2);
    private final Map<IIdentity, Version> packages = new LinkedHashMap<IIdentity, Version>();

    public GenerateResponseFileCommand() {
        super("generateResponseFile");
    }

    @Override
    public int getExecutionPoint() {
        return 4;
    }

    @Override
    public void addRepository(String repo) {
        this.repositories.add(repo);
    }

    @Override
    public void setInstallationDirectory(String installationDirectory) {
        this.installationDirectory = installationDirectory;
    }

    @Override
    public void addPackage(String id, String version) {
        this.packages.put((IIdentity)new SimpleIdentity(id), version != null ? new Version(version) : ResponseFileFromInstall.ANY_VERSION);
    }

    @Override
    public void setOutput(String output) {
        this.output = output;
    }

    @Override
    public IStatus execute(Agent agent, IProgressMonitor monitor) {
        if (this.repositories.isEmpty() && !CmdLine.CL.containsCommand("-connectPassportAdvantage")) {
            return this.generateFromInstalled(agent);
        }
        return this.generateFromRepositories(agent);
    }

    private IStatus generateFromInstalled(Agent agent) {
        ResponseFileFromInstall generator = new ResponseFileFromInstall();
        if (this.installationDirectory != null) {
            Profile profile = agent.getProfileByInstallLocation(this.installationDirectory);
            if (profile == null || profile.isAgentProfile()) {
                return Statuses.ERROR.get(Messages.Cmd_installationDirectory_notFound, new Object[]{this.installationDirectory});
            }
            generator.setProfile(profile);
        }
        return this.generate(agent, generator);
    }

    private IStatus generate(Agent agent, ResponseFileGenerator generator) {
        for (Map.Entry<IIdentity, Version> entry : this.packages.entrySet()) {
            generator.addPackage(entry.getKey(), entry.getValue());
        }
        try {
            if (this.output == null) {
                String xml = generator.generate().toXML();
                agent.getStdoutBuffer().appendNT(xml);
            } else {
                generator.generate(new File(this.output));
                agent.getStdoutBuffer().appendNTnl(NLS.bind((String)Messages.GenerateResponseFileCommand_Summary, (Object)this.output));
            }
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }

    private IStatus generateFromRepositories(Agent agent) {
        if (this.installationDirectory != null) {
            return Statuses.ERROR.get(Messages.GenerateResponseFileCommand_Invalid_Options, new Object[0]);
        }
        PrompterUtils.ConsoleCredentialPrompter credentialPrompts = CmdLine.CL.getConsoleCredentialPrompter();
        try {
            IStatus iStatus = new GenerateFromRepositoriesOp(agent).execute(null);
            return iStatus;
        }
        finally {
            credentialPrompts.restore();
        }
    }

    private class GenerateFromRepositoriesOp
    extends ANetworkCmdOp {
        private final Agent agent;

        public GenerateFromRepositoriesOp(Agent agent) {
            super((ACmdLine)CmdLine.CL);
            this.agent = agent;
        }

        protected IStatus execute(IRepositoryGroup group, IProgressMonitor monitor) {
            Collection repos = group.getRepositories();
            ResponseFileFromRepositories generator = new ResponseFileFromRepositories(repos);
            return GenerateResponseFileCommand.this.generate(this.agent, generator);
        }

        protected Map<String, String> checkPreferences(Map<String, String> preferences) throws CoreException {
            super.checkPreferences(preferences);
            return Collections.emptyMap();
        }

        protected void setPreference(String key, String value) {
        }

        protected boolean isQuery() {
            return true;
        }
    }
}

