/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.OfferingProperty;
import com.ibm.cic.common.core.utils.Comparators;
import com.ibm.cic.common.core.utils.MapList;
import com.ibm.cic.common.core.utils.MapMap;
import com.ibm.cic.common.core.utils.MapSet;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.logging.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SortUtil {
    private static final Logger log = Logger.getLogger();

    private SortUtil() {
        assert (false);
    }

    public static <T extends AgentJob> List<T> sortByNameAndVersion(List<T> jobs) {
        return SortUtil.sortByNameAndVersion(jobs, true);
    }

    public static <T extends AgentJob> List<T> sortByNameAndVersion(List<T> jobs, final boolean increasingVersion) {
        AgentJob[] jobArray = jobs.toArray(new AgentJob[jobs.size()]);
        Arrays.sort(jobArray, new Comparator<AgentJob>(){

            @Override
            public int compare(AgentJob job1, AgentJob job2) {
                return OfferingOrFixComparator.INSTANCE.compare(job1.getOfferingOrFix(), job2.getOfferingOrFix(), increasingVersion);
            }
        });
        return new ArrayList<AgentJob>(Arrays.asList(jobArray));
    }

    public static void sortByNameAndVersion(IOfferingOrFix[] elements) {
        if (elements.length >= 2) {
            Arrays.sort(elements, OfferingOrFixComparator.INSTANCE);
        }
    }

    public static void sortOfferings(IOfferingOrFix[] pkgs) {
        if (pkgs.length < 2) {
            return;
        }
        PackageSorter sorter = new PackageSorter();
        IOfferingOrFix[] iOfferingOrFixArray = pkgs;
        int n = pkgs.length;
        int n2 = 0;
        while (n2 < n) {
            IOfferingOrFix pkg = iOfferingOrFixArray[n2];
            sorter.add(pkg);
            ++n2;
        }
        int i = 0;
        for (IOfferingOrFix pkg : sorter.getSortedPkgs()) {
            pkgs[i++] = pkg;
        }
    }

    public static <T extends AgentJob> List<T> sortByProfileNameAndVersion(List<T> jobs, boolean uninstall) {
        if (jobs.isEmpty()) {
            return Collections.emptyList();
        }
        if (jobs.size() == 1) {
            return Collections.singletonList((AgentJob)jobs.get(0));
        }
        AgentJob[] jobsArray = jobs.toArray(new AgentJob[jobs.size()]);
        SortUtil.sortByProfileNameAndVersion(jobsArray, uninstall);
        return Arrays.asList(jobsArray);
    }

    public static void sortByProfileNameAndVersion(AgentJob[] jobs, boolean uninstall) {
        if (jobs.length < 2) {
            return;
        }
        MapMap profileOfferingToJob = MapMap.newHashHash();
        ProfileSorter sorter = new ProfileSorter();
        AgentJob[] agentJobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            sorter.add(job.getProfile(), job.getOfferingOrFix());
            profileOfferingToJob.put((Object)job.getProfile(), (Object)job.getOfferingOrFix(), (Object)job);
            ++n2;
        }
        int i = 0;
        for (Profile profile : sorter.getSortedProfiles(uninstall)) {
            for (IOfferingOrFix pkg : sorter.getSortedOfferings(profile)) {
                jobs[i++] = (AgentJob)profileOfferingToJob.get((Object)profile, (Object)pkg);
            }
        }
    }

    static <T> List<T> topologicalSort(List<T> elems, MapSet<T, T> after) {
        ArrayList<T> toBeDone = new ArrayList<T>(elems);
        ArrayList<T> result = new ArrayList<T>(toBeDone.size());
        while (!toBeDone.isEmpty()) {
            T elem = SortUtil.findNext(toBeDone, result, after);
            toBeDone.remove(elem);
            result.add(elem);
        }
        return result;
    }

    private static <T> T findNext(List<T> toBeDone, List<T> done, MapSet<T, T> after) {
        for (T elem : toBeDone) {
            if (!SortUtil.allAreDone(after.get(elem), done)) continue;
            return elem;
        }
        log.warning(Messages.SortUtil_Circular_Order_Dependency, new Object[]{Util.toString(toBeDone, (Util.Formatter)new Util.Formatter("\n"))});
        return toBeDone.get(0);
    }

    private static <T> boolean allAreDone(Collection<T> elems, List<T> done) {
        for (T elem : elems) {
            if (done.contains(elem)) continue;
            return false;
        }
        return true;
    }

    private static class OfferingOrFixComparator
    implements Comparator<IOfferingOrFix> {
        static final OfferingOrFixComparator INSTANCE = new OfferingOrFixComparator();

        private OfferingOrFixComparator() {
        }

        @Override
        public int compare(IOfferingOrFix a, IOfferingOrFix b) {
            return this.compare(a, b, true);
        }

        public int compare(IOfferingOrFix a, IOfferingOrFix b, boolean increasingVersion) {
            int cmp = Category.get(a).ordinal() - Category.get(b).ordinal();
            return cmp != 0 ? cmp : Comparators.compareNameVersion((IContent)a, (IContent)b, (boolean)increasingVersion);
        }

        private static enum Category {
            IM_OFFERING,
            FULL_OFFERING,
            EXTN_OFFERING,
            EXTN_OF_EXTN_OFFERING,
            FIX;


            static Category get(IOfferingOrFix oof) {
                if (!(oof instanceof IOffering)) {
                    return FULL_OFFERING;
                }
                IOffering offering = (IOffering)oof;
                if (Agent.getInstance().isAgentOffering((IOfferingOrFix)offering)) {
                    return IM_OFFERING;
                }
                if (!OfferingProperty.isExtension((IOfferingOrFix)offering)) {
                    return FULL_OFFERING;
                }
                if (!OfferingProperty.isExtensionOfExtension((IOffering)offering)) {
                    return EXTN_OFFERING;
                }
                return EXTN_OF_EXTN_OFFERING;
            }
        }
    }

    public static class PackageSorter {
        private final MapSet<String, IOfferingOrFix> idToPkg = MapSet.newHash();
        private MapSet<IOfferingOrFix, IOfferingOrFix> after;

        public PackageSorter() {
        }

        public PackageSorter(List<IOfferingOrFix> pkgs) {
            this();
            for (IOfferingOrFix pkg : pkgs) {
                this.add(pkg);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("offering after map:");
            if (this.after == null) {
                sb.append(" null");
            } else {
                for (String id : this.idToPkg.keySet()) {
                    for (IOfferingOrFix pkg : this.idToPkg.get((Object)id)) {
                        sb.append("\n  ").append(id).append(' ').append(pkg.getVersion()).append(':');
                        for (IOfferingOrFix pkg2 : this.after.get((Object)pkg)) {
                            sb.append(' ').append(pkg2.getIdentity());
                        }
                    }
                }
            }
            return sb.toString();
        }

        public void add(IOfferingOrFix pkg) {
            this.idToPkg.add((Object)pkg.getIdentity().getId(), (Object)pkg);
        }

        public List<IOfferingOrFix> getSortedPkgs() {
            this.buildAfterMapList();
            return this.buildSortedList();
        }

        private void buildAfterMapList() {
            this.after = MapSet.newLinkedHash((int)this.idToPkg.size());
            for (String id : this.idToPkg.keySet()) {
                for (IOfferingOrFix pkg : this.idToPkg.get((Object)id)) {
                    for (String afterId : OfferingProperty.getOfferingDisplayAfter((IOfferingOrFix)pkg)) {
                        for (IOfferingOrFix afterPkg : this.idToPkg.get((Object)afterId)) {
                            if (afterPkg == pkg) continue;
                            this.after.add((Object)pkg, (Object)afterPkg);
                            log.debug("Offering after: {0} -> {1}", new Object[]{pkg.getIdentity(), afterPkg.getIdentity()});
                        }
                    }
                }
            }
        }

        private List<IOfferingOrFix> buildSortedList() {
            ArrayList pkgs = new ArrayList();
            for (String id : this.idToPkg.keySet()) {
                pkgs.addAll(this.idToPkg.get((Object)id));
            }
            Collections.sort(pkgs, OfferingOrFixComparator.INSTANCE);
            return SortUtil.topologicalSort(pkgs, this.after);
        }
    }

    public static class ProfileSorter {
        private final MapList<Profile, IOfferingOrFix> profileMap = new MapList();
        private final Map<String, Profile> offeringIdToProfile = new HashMap<String, Profile>();
        private MapSet<Profile, Profile> after;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("profile after map:");
            if (this.after == null) {
                sb.append(" null");
            } else {
                for (Profile profile : this.profileMap.keySet()) {
                    sb.append("\n  ").append(profile.getProfileId()).append(':');
                    for (Profile p2 : this.after.get((Object)profile)) {
                        sb.append(' ').append(p2.getProfileId());
                    }
                }
            }
            sb.append("\noffering to profile map:");
            for (String offeringId : this.offeringIdToProfile.keySet()) {
                sb.append("\n  ").append(offeringId).append(": ").append(this.offeringIdToProfile.get(offeringId).getProfileId());
            }
            return sb.toString();
        }

        public void add(AgentJob job) {
            this.add(job.getProfile(), job.getOfferingOrFix());
        }

        public void add(Profile profile, IOfferingOrFix pkg) {
            this.profileMap.add((Object)profile, (Object)pkg);
            this.offeringIdToProfile.put(pkg.getIdentity().getId(), profile);
        }

        public List<Profile> getSortedProfiles() {
            return this.getSortedProfiles(false);
        }

        public List<Profile> getSortedProfiles(boolean reverse) {
            ArrayList<Profile> profiles = new ArrayList<Profile>(this.profileMap.keySet());
            if (this.profileMap.size() < 2) {
                return profiles;
            }
            this.buildAfterMapList();
            Collections.sort(profiles, new Comparator<Profile>(){
                private final Comparator<String> icuComparator = Comparators.getIcuComparator();

                @Override
                public int compare(Profile p1, Profile p2) {
                    return this.icuComparator.compare(p1.getProfileId(), p2.getProfileId());
                }
            });
            List<Profile> result = SortUtil.topologicalSort(profiles, this.after);
            if (reverse) {
                Collections.reverse(result);
            }
            return result;
        }

        public List<IOfferingOrFix> getSortedOfferings(Profile profile) {
            List pkgs = this.profileMap.get((Object)profile);
            return new PackageSorter(pkgs).getSortedPkgs();
        }

        private void buildAfterMapList() {
            this.after = MapSet.newLinkedHash((int)this.profileMap.size());
            for (Profile profile : this.profileMap.keySet()) {
                for (IOfferingOrFix pkg : this.profileMap.get((Object)profile)) {
                    for (String offeringId : OfferingProperty.getOfferingDisplayAfter((IOfferingOrFix)pkg)) {
                        Profile afterProfile = this.offeringIdToProfile.get(offeringId);
                        if (afterProfile == null || afterProfile == profile) continue;
                        this.after.add((Object)profile, (Object)afterProfile);
                        log.debug("Profile after: {0} -> {1} due to offering {2}", new Object[]{profile.getProfileId(), afterProfile.getProfileId(), offeringId});
                    }
                }
            }
        }
    }
}

