/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class PreparedAgentBundles {
    private final Agent agent;
    private final LinkedList prepared = new LinkedList();

    public PreparedAgentBundles(Agent agent) {
        this.agent = agent;
    }

    public IStatus prepare(IOfferingOrFix toPrepare, String[] agentBundleIds, String[] selectorIds, IProgressMonitor monitor) {
        if (agentBundleIds.length == 0) {
            return Status.OK_STATUS;
        }
        IStatus status = this.agent.prepareAgentBundles(toPrepare, agentBundleIds, selectorIds, monitor);
        if (status.matches(12)) {
            return status;
        }
        this.prepared.add(new PreparedAgentBundle(toPrepare, agentBundleIds, selectorIds));
        return status;
    }

    public IStatus unload() {
        CicMultiStatus ms = Statuses.ST.createMultiStatus();
        for (PreparedAgentBundle p : this.prepared) {
            IStatus status = this.agent.unloadAgentBundles(p.oof, p.agentBundleIds, p.selectorIds, null);
            ms.add(status);
        }
        return ms;
    }

    private static class PreparedAgentBundle {
        public IOfferingOrFix oof;
        public String[] agentBundleIds;
        public String[] selectorIds;

        public PreparedAgentBundle(IOfferingOrFix oof, String[] agentBundleIds, String[] selectorIds) {
            this.oof = oof;
            this.agentBundleIds = agentBundleIds;
            this.selectorIds = selectorIds;
        }
    }
}

