/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.api.ILocationCheck;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.extensions.ExtensionManager;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public final class LocationCheckManager {
    private static final String TAG_LOC_CHECKS = "locationChecks";
    private static final String TAG_RESERVED_LOC_CHECKS = "reservedLocationChecks";
    private static final String TAG_RESERVED_LOC_CHECK = "reservedLocationCheck";
    private static final String TAG_CLASS_ATTR = "class";
    private List<LocationCheckBinding> locationCheckList = null;
    private List<ILocationCheck> reservedLocationCheckList = null;
    private static final LocationCheckManager INSTANCE = new LocationCheckManager();

    public static LocationCheckManager getInstance() {
        return INSTANCE;
    }

    public void resetLocationCheckList() {
        this.reservedLocationCheckList = null;
        this.locationCheckList = null;
    }

    private void initializeLocationChecks(AgentJob[] jobs) throws CoreException {
        this.resetLocationCheckList();
        this.locationCheckList = new ArrayList<LocationCheckBinding>();
        if (jobs != null) {
            IConfigurationElement[] extensions;
            IConfigurationElement[] iConfigurationElementArray = extensions = ExtensionManager.getInstance().getConfigurationElements(Agent.getBundleId(), TAG_LOC_CHECKS);
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement extension = iConfigurationElementArray[n2];
                IContributor contributor = extension.getContributor();
                String name = contributor.getName();
                List<AgentJob> iJobs = SharedUIUtils.getJobsThatIncludeIUName(name, jobs);
                for (AgentJob iJob : iJobs) {
                    this.locationCheckList.add(new LocationCheckBinding(iJob, new LocationCheckExtension(extension).getCheck()));
                }
                ++n2;
            }
        } else {
            throw new CoreException((IStatus)Statuses.ERROR.get(Messages.LocationCheckManager_Initialization_Called_with_no_Jobs, new Object[0]));
        }
    }

    public IStatus perform(Profile profile, AgentJob.AgentJobType jobType, IProgressMonitor monitor) {
        return this.perform(profile, null, jobType, monitor);
    }

    private IStatus perform(Profile profile, AgentJob job, AgentJob.AgentJobType jobType, IProgressMonitor monitor) {
        IStatus checkResult;
        CicMultiStatus checkResults = Statuses.ST.createMultiStatus();
        if (profile.isAgentProfile() || profile.isLicenseProfile()) {
            return Status.OK_STATUS;
        }
        int moncount = 0;
        if (this.reservedLocationCheckList == null) {
            try {
                this.reservedLocationCheckList = LocationCheckManager.createReservedLocationChecks();
            }
            catch (CoreException e) {
                return e.getStatus();
            }
        }
        moncount += this.reservedLocationCheckList.size();
        if (this.locationCheckList != null) {
            moncount += this.locationCheckList.size();
        }
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, moncount);
        if (this.locationCheckList != null && job != null && AgentJob.AgentJobType.INSTALL_JOB == jobType) {
            for (LocationCheckBinding checkBind : this.locationCheckList) {
                checkResult = checkBind.run(job, jobType, spm.next());
                if (StatusUtil.isErrorOrCancel((IStatus)checkResult)) {
                    return this.formatStatus(checkResult);
                }
                checkResults.add(checkResult);
            }
        }
        if (this.reservedLocationCheckList != null) {
            int i = 0;
            while (i < this.reservedLocationCheckList.size()) {
                ILocationCheck locCheck = this.reservedLocationCheckList.get(i);
                checkResult = locCheck.run(profile, jobType, spm.next());
                if (StatusUtil.isErrorOrCancel((IStatus)checkResult)) {
                    return this.formatStatus(checkResult);
                }
                checkResults.add(checkResult);
                ++i;
            }
        }
        return this.formatStatus((IStatus)checkResults);
    }

    public IStatus initializeAndPerform(AgentJob[] jobArray, IProgressMonitor monitor) {
        CicMultiStatus checkResults = Statuses.ST.createMultiStatus();
        try {
            this.initializeLocationChecks(jobArray);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, jobArray.length);
        AgentJob[] agentJobArray = jobArray;
        int n = jobArray.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            IStatus checkResult = this.perform(job.getProfile(), job, job.getType(), spm.next());
            checkResults.add(checkResult);
            ++n2;
        }
        return this.formatStatus((IStatus)checkResults);
    }

    public IStatus perform(Profile[] profileArray, AgentJob.AgentJobType jobType, IProgressMonitor monitor) {
        CicMultiStatus checkResults = Statuses.ST.createMultiStatus();
        Profile[] profileArray2 = profileArray;
        int n = profileArray.length;
        int n2 = 0;
        while (n2 < n) {
            Profile element = profileArray2[n2];
            IStatus checkResult = this.perform(element, jobType, monitor);
            if (StatusUtil.isErrorOrCancel((IStatus)checkResult)) {
                return checkResult;
            }
            checkResults.add(checkResult);
            ++n2;
        }
        return this.formatStatus((IStatus)checkResults);
    }

    private IStatus formatStatus(IStatus status) {
        if (status.isOK()) {
            return status;
        }
        if (status.getMessage() == null || status.getMessage().equals("")) {
            if (status.getChildren().length == 1) {
                return this.formatStatus(status.getChildren()[0]);
            }
            if (status.getSeverity() == 8) {
                return Statuses.ST.createMultiStatusWithChild((IStatus)ICicStatus.CANCEL_STATUS, null, new Object[0]);
            }
            return Statuses.ST.createMultiStatusWithChild(status, Messages.LocationCheckManager_problem_detected, new Object[0]);
        }
        return status;
    }

    private static List<ILocationCheck> createReservedLocationChecks() throws CoreException {
        ArrayList<ILocationCheck> result = new ArrayList<ILocationCheck>();
        IConfigurationElement[] elements = ExtensionManager.getInstance().getConfigurationElements(Agent.getBundleId(), TAG_RESERVED_LOC_CHECKS);
        if (elements != null && elements.length > 0) {
            IConfigurationElement[] iConfigurationElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (element.getName().equals(TAG_RESERVED_LOC_CHECK)) {
                    result.add(new LocationCheckExtension(element).getCheck());
                }
                ++n2;
            }
        }
        return result;
    }

    private static class LocationCheckBinding {
        private final ILocationCheck check;
        private final AgentJob job;

        public LocationCheckBinding(AgentJob job, ILocationCheck iLocationCheck) {
            this.check = iLocationCheck;
            this.job = job;
        }

        public IStatus run(AgentJob currentJob, AgentJob.AgentJobType jobType, IProgressMonitor monitor) {
            if (this.job.sameJob(currentJob) && currentJob.getOffering() != null && currentJob.isInstall()) {
                return this.check.run(this.job.getProfile(), jobType, monitor);
            }
            return Status.OK_STATUS;
        }
    }

    private static final class LocationCheckExtension {
        private ILocationCheck locCheck;
        private final IConfigurationElement element;

        public LocationCheckExtension(IConfigurationElement element) {
            this.element = element;
        }

        public ILocationCheck getCheck() throws CoreException {
            if (this.locCheck == null) {
                this.locCheck = this.createCheck();
            }
            return this.locCheck;
        }

        private ILocationCheck createCheck() throws CoreException {
            Object obj = this.element.createExecutableExtension(LocationCheckManager.TAG_CLASS_ATTR);
            if (!(obj instanceof ILocationCheck)) {
                throw new CoreException((IStatus)Statuses.ERROR.get(Messages.LocationCheckManager_does_not_implement_interface, new Object[]{this.element.getAttribute(LocationCheckManager.TAG_CLASS_ATTR), LocationCheckManager.TAG_LOC_CHECKS, ILocationCheck.class.getName()}));
            }
            return (ILocationCheck)obj;
        }
    }
}

