/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.ResponseFileBuilder;
import com.ibm.cic.agent.core.internal.headless.IInput;
import com.ibm.cic.agent.core.utils.AgentUserOptions;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.api.utils.PlatformUtils;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.core.preferences.ProxyPreferenceUtil;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.RebootRequest;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.licensing.common.util.LicensePolicyData;
import com.ibm.cic.licensing.common.util.LicensePolicyDataWriter;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CommandRecorder {
    private final ResponseFileBuilder rfb = new ResponseFileBuilder().includeDefaults(AgentUserOptions.CIC_INCLUDE_DEFAULTS_WHEN_RECORDING.isSet());
    private LicensePolicyData licensePolicyData = null;

    public static IStatus validateRecordFile(String recordFilePath) {
        return CommandRecorder.validateRecordFile(new File(recordFilePath));
    }

    public static IStatus validateRecordFile(File recordFile) {
        IStatus validationStatus = Status.OK_STATUS;
        if (recordFile.exists()) {
            if (!FileUtil.canWrite((File)recordFile)) {
                validationStatus = Statuses.ERROR.get(Messages.CommandRecorder_Cannot_Write_to_Record_File, new Object[]{recordFile.getAbsolutePath()});
            }
        } else {
            File recordFileDir = recordFile.getAbsoluteFile().getParentFile();
            if (!FileUtil.isDirectoryWriteable((File)recordFileDir)) {
                validationStatus = Statuses.ERROR.get(Messages.CommandRecorder_Cannot_Create_Record_File, new Object[]{recordFile.getAbsolutePath()});
            }
        }
        return validationStatus;
    }

    public IStatus saveToFile(File recordFile) {
        this.recordPreferences();
        IStatus status = this.initializeRecordingFile(recordFile);
        if (StatusUtil.isErrorOrCancel((IStatus)status)) {
            return status;
        }
        if (RebootRequest.isSet() && !RebootRequest.shouldRebootNow()) {
            this.rfb.rebootLater(true);
        }
        try {
            this.saveLicenseSettings(recordFile);
            this.rfb.save(recordFile);
        }
        catch (IOException e) {
            return Statuses.ERROR.get(451, (Throwable)e, Messages.CommandRecorder_Exeption_During_Save, new Object[0]);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        return status;
    }

    private IStatus initializeRecordingFile(File recordFile) {
        if (!recordFile.exists()) {
            try {
                recordFile.getAbsoluteFile().getParentFile().mkdirs();
                recordFile.createNewFile();
            }
            catch (IOException e) {
                return Statuses.ERROR.get(451, (Throwable)e, Messages.CommandRecorder_Exeption_During_Save, new Object[0]);
            }
        }
        if (!CicCommonSettings.isWindows()) {
            boolean rspFileAttributes;
            String mask = "600";
            if (CicCommonSettings.getAccessRightsMode().isGroupMode()) {
                mask = "660";
            }
            if (!(rspFileAttributes = PlatformUtils.chmod((String[])new String[]{recordFile.getAbsolutePath()}, (String)mask, (boolean)false))) {
                return Statuses.WARNING.get(Messages.CommandRecorder_Error_Setting_Response_File_Attributes, new Object[]{recordFile.getPath()});
            }
        }
        return Status.OK_STATUS;
    }

    public IInput getRecordedCommand() {
        this.recordPreferences();
        return this.rfb.getAsInput();
    }

    public void recordJobs(AgentJob[] jobs, boolean install) {
        if (jobs.length == 0) {
            return;
        }
        this.updateServerCommand();
        AgentJob[] agentJobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            if (job.isAcceptLicense()) {
                this.rfb.acceptLicense(true);
            }
            AgentJob.AgentJobType type = job.getType();
            IOffering offering = job.getOffering();
            IFix fix = job.getFix();
            IFeature[] features = job.getFeaturesArray();
            this.rfb.profile(job.getProfile());
            if (AgentJob.AgentJobType.INSTALL_JOB.equals(type) || AgentJob.AgentJobType.UPDATE_JOB.equals(type)) {
                if (offering != null) {
                    this.rfb.install(offering, features);
                } else {
                    this.rfb.install(fix);
                }
            } else if (AgentJob.AgentJobType.UNINSTALL_JOB.equals(type)) {
                if (offering != null) {
                    this.rfb.uninstall(offering);
                } else {
                    this.rfb.uninstall(fix);
                }
            } else if (AgentJob.AgentJobType.MODIFY_JOB.equals(type)) {
                if (install) {
                    this.rfb.modifyInstall(offering, features);
                } else {
                    this.rfb.modifyUninstall(offering, features);
                }
            } else if (AgentJob.AgentJobType.ROLLBACK_JOB.equals(type)) {
                this.rfb.rollback(offering);
            } else assert (false) : "Unknown job type: " + job;
            ++n2;
        }
    }

    public void recordImport(String type, Profile profile, Properties dataProps) {
        this.rfb.profile(profile);
        this.rfb.doImport(type, profile, dataProps);
    }

    private void recordPreferences() {
        this.rfb.sharedLocation();
        this.recordProxySettings();
        for (ICicPreferenceConstants.PreferenceTag tag : ICicPreferenceConstants.ALL_PREFERENCES) {
            if (tag.equals((Object)ICicPreferenceConstants.REPOSITORY_LOCATIONS)) continue;
            this.recordPreference(tag);
        }
    }

    private void recordProxySettings() {
        ProxyPreferenceUtil prefUtils = ProxyPreferenceUtil.INSTANCE;
        List proxies = prefUtils.getActiveProxies();
        prefUtils.setProxies((Collection)proxies, new ProxyPreferenceUtil.ISetPreferences(){

            public void setValueOrNull(ICicPreferenceConstants.PreferenceTag tag, String value) {
                if (value != null) {
                    CommandRecorder.this.rfb.preference(tag.key(), value);
                }
            }
        });
    }

    private void recordPreference(ICicPreferenceConstants.PreferenceTag tag) {
        if (!tag.isNeedRecord()) {
            return;
        }
        this.rfb.preference(tag);
        ICicPreferenceConstants.PreferenceTag[] preferenceTagArray = tag.subPrefs();
        int n = preferenceTagArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICicPreferenceConstants.PreferenceTag subPref = preferenceTagArray[n2];
            this.recordPreference(subPref);
            ++n2;
        }
    }

    public void updateServerCommand() {
        IRepositoryGroup repoGroup = Agent.getInstance().getRepositoryGroup();
        for (IRepository repo : repoGroup) {
            String repoName;
            if (!repo.isOpen()) continue;
            String repoLocation = repo.getLocationStr();
            if ("Jar".equals(repo.getRepositoryInfo().getType()) && (repoName = repo.getName()) != null && !repoName.isEmpty() && !repoLocation.endsWith(repoName)) {
                repoLocation = String.valueOf(repoLocation) + File.separator + repoName;
            }
            this.rfb.repository(repoLocation);
        }
    }

    public void setRebootLater(boolean param) {
        this.rfb.rebootLater(param);
    }

    private void saveLicenseSettings(File recordFile) throws IOException {
        if (this.licensePolicyData != null) {
            String licenseFileName = "license.opt";
            File licensePolicyFile = new File(recordFile.getParentFile(), licenseFileName);
            LicensePolicyDataWriter.write((File)licensePolicyFile, (LicensePolicyData)this.licensePolicyData);
            this.rfb.license(licenseFileName);
        }
    }

    public void setLicenseSettings(LicensePolicyData policyData) {
        assert (this.licensePolicyData == null);
        this.licensePolicyData = policyData;
    }
}

