/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core;

import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.agent.internal.core.VariableProvider;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.repository.nls.ContentResourceManager;
import com.ibm.cic.common.core.utils.FileURLUtil;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.NetworkInfo;
import com.ibm.cic.common.core.utils.PathUtil;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.LogManager;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.Locale;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;

public abstract class AbstractVariableSubstitution {
    private static final String EMPTY_STRING = "";
    public static final String VARIABLE_ARG_DELIM = ":";
    public static final String VARIABLE_PREFIX = "${";
    public static final char VARIABLE_ARG_SEPARATOR = ',';
    private static boolean loggedDeprecatedSystemProperty = false;
    private static final Logger log = Logger.getLogger();
    public static final String DEFAULT_INSTALL_ROOT_LOCATION_VAR = "defaultInstallRootLocation";
    public static final String CANONICAL_LOCATION_VAR = "canonicalLocation";
    public static final String CREATE_TEMP_FILE_VAR = "createTempFile";
    public static final String DOMAIN_NAME_VAR = "domainName";
    public static final String ENVIRONMENT_VAR = "environment";
    public static final String FILE_URL_VAR = "fileUrl";
    public static final String FULL_HOST_NAME_VAR = "fullHostName";
    public static final String HOST_NAME_VAR = "hostName";
    public static final String SHORT_HOST_NAME_VAR = "shortHostName";
    public static final String NL_PROPERTY_VAR = "NLProperty";
    @Deprecated
    public static final String SYSTEM_PROPERTY_OLD = "systemProperty";
    public static final String SYSTEM_PROPERTY_VAR = "system";
    public static final String TEMP_LOCATION_VAR = "tempLocation";
    public static final String USER_HOME_VAR = "homeLocation";
    public static final String USER_NAME_VAR = "user";
    public static final String GEN_LOGFILE_VAR = "genlogfile";
    public static final String BETA_PROPERTY_VAR = "beta";
    NetworkInfo networkInfo = null;

    public static String getVarFromNameAndArg(String name, String arg) {
        return arg == null ? name : String.valueOf(name) + VARIABLE_ARG_DELIM + arg;
    }

    protected static String getVarNameFromVar(String variable) {
        int i = variable.indexOf(VARIABLE_ARG_DELIM);
        return (i < 0 ? variable : variable.substring(0, i)).trim();
    }

    protected static String getVarArgFromVar(String variable) {
        int i = variable.indexOf(VARIABLE_ARG_DELIM);
        return i < 0 ? null : variable.substring(i + 1).trim();
    }

    public String performVariableSubstitutions(String s) throws VariableSubstitutionException {
        return this.performVariableSubstitutions(s, true, true, AllowAbsolutePath.FALSE);
    }

    public String performVariableSubstitutions(String s, AllowAbsolutePath allowAbsolutePath) throws VariableSubstitutionException {
        return this.performVariableSubstitutions(s, true, true, allowAbsolutePath);
    }

    protected String performVariableSubstitutions(String s, boolean varMustSubstitute) throws VariableSubstitutionException {
        return this.performVariableSubstitutions(s, varMustSubstitute, true, AllowAbsolutePath.FALSE);
    }

    public String performVariableSubstitutions(String s, boolean varMustSubstitute, boolean logWarning, AllowAbsolutePath allowAbsolutePath) throws VariableSubstitutionException {
        int suffixIndex;
        int prefixIndex;
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(s);
        int fromIndex = 0;
        boolean isSubstituted = false;
        while ((prefixIndex = sb.indexOf(VARIABLE_PREFIX, fromIndex)) >= 0 && (suffixIndex = this.getVariableSuffixIndex(sb, prefixIndex)) >= 0) {
            String variableArg;
            String variable = sb.substring(prefixIndex + VARIABLE_PREFIX.length(), suffixIndex);
            String variableName = AbstractVariableSubstitution.getVarNameFromVar(variable);
            String variableValue = this.substitute(variableName, variableArg = this.performVariableSubstitutions(AbstractVariableSubstitution.getVarArgFromVar(variable), allowAbsolutePath), allowAbsolutePath);
            if (variableValue != null) {
                sb.replace(prefixIndex, suffixIndex + 1, variableValue);
                fromIndex = prefixIndex + variableValue.length();
                isSubstituted = true;
            } else {
                fromIndex = suffixIndex + 1;
            }
            if (this.isPathVariable(variableName, variableArg) && allowAbsolutePath == AllowAbsolutePath.TRUE) {
                sb.replace(fromIndex, sb.length(), PathUtil.fixSlashes((String)sb.substring(fromIndex)));
            }
            if (!varMustSubstitute || variableValue != null) continue;
            if (logWarning) {
                log.warning(Messages.AbstractVariableSubstitution_Fail_Substitute_Variable_Warning, new Object[]{variable});
                continue;
            }
            throw new VariableSubstitutionException(Messages.AbstractVariableSubstitution_Fail_Substitute_Variable_Error, variable);
        }
        return isSubstituted ? sb.toString() : s;
    }

    protected boolean isPathVariable(String variableName, String variableArg) {
        return variableName.equals(DEFAULT_INSTALL_ROOT_LOCATION_VAR) || variableName.equals(CREATE_TEMP_FILE_VAR) || variableName.equals(TEMP_LOCATION_VAR) || variableName.equals(USER_HOME_VAR) || variableName.equals(GEN_LOGFILE_VAR);
    }

    private int getVariableSuffixIndex(StringBuffer sb, int fromIndex) {
        int length = sb.length();
        int brackets = 0;
        int i = fromIndex;
        while (i < length) {
            char c = sb.charAt(i);
            if (c == '{') {
                ++brackets;
            } else if (c == '}' && --brackets == 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected String substitute(String variableName, String variableArg, AllowAbsolutePath allowAbsolutePath) throws VariableSubstitutionException {
        String result = this.substituteNoVP(variableName, variableArg);
        if (result == null) {
            result = VariableProvider.getInstance().substitute(null, variableName, variableArg);
        }
        return result;
    }

    protected String substituteNoVP(String variableName, String variableArg) {
        this.checkDeprecatedVariable(variableName);
        if (variableName.equals(SYSTEM_PROPERTY_VAR) || variableName.equals(SYSTEM_PROPERTY_OLD)) {
            if (variableArg != null) {
                String data = System.getProperty(variableArg);
                return data != null ? data : EMPTY_STRING;
            }
        } else {
            if (variableName.equals(USER_HOME_VAR)) {
                return this.getCanonicalLocation(System.getProperty("user.home"));
            }
            if (variableName.equals(USER_NAME_VAR)) {
                String user = System.getProperty("user.name");
                return user != null ? user : EMPTY_STRING;
            }
            if (variableName.equals(TEMP_LOCATION_VAR)) {
                return this.getCanonicalLocation(System.getProperty("java.io.tmpdir"));
            }
            if (variableName.equals(CANONICAL_LOCATION_VAR)) {
                return this.getCanonicalLocation(variableArg);
            }
            if (variableName.equals(HOST_NAME_VAR)) {
                if (variableArg != null) {
                    if (variableArg.equals(SHORT_HOST_NAME_VAR)) {
                        return this.getShortHostName();
                    }
                    if (variableArg.equals(DOMAIN_NAME_VAR)) {
                        return this.getDomainName();
                    }
                    if (variableArg.equals(FULL_HOST_NAME_VAR)) {
                        return this.getFullHostName();
                    }
                }
            } else {
                if (variableName.equals(CREATE_TEMP_FILE_VAR)) {
                    return this.createTempFile(variableArg);
                }
                if (variableName.equals(ENVIRONMENT_VAR)) {
                    return PlatformUtils.getEnvironmentVariable((String)variableArg);
                }
                if (variableName.equals(FILE_URL_VAR)) {
                    return this.getFileUrl(variableArg);
                }
                if (variableName.toLowerCase().equals(FILE_URL_VAR.toLowerCase())) {
                    return this.getFileUrl(variableArg);
                }
                if (variableName.equals(NL_PROPERTY_VAR)) {
                    return this.getNLProperty(variableArg);
                }
                if (variableName.equals(DEFAULT_INSTALL_ROOT_LOCATION_VAR)) {
                    return PlatformUtils.getDefaultInstallRootLocation((boolean)this.is64bit());
                }
                if (variableName.equals(GEN_LOGFILE_VAR)) {
                    return this.genLogfile(variableArg);
                }
                if (variableName.equals(BETA_PROPERTY_VAR)) {
                    return CicCommonSettings.getBetaProperty();
                }
            }
        }
        return null;
    }

    public boolean is64bit() {
        return false;
    }

    private String getNLProperty(String variableArg) {
        String return_value = null;
        if (variableArg != null) {
            String[] args = variableArg.split(String.valueOf(','), -1);
            if (args.length < 2) {
                return_value = variableArg;
            } else {
                String path = args[0].trim();
                String key = args[1].trim();
                String translationkey = "%" + key;
                Locale locale = this.getNLPropertyLocale(args.length == 3 ? args[2].trim() : null);
                if (locale == null) {
                    locale = Locale.getDefault();
                }
                ContentResourceManager crm = new ContentResourceManager(path, locale);
                return_value = crm.getString(translationkey, key);
            }
        }
        return return_value;
    }

    protected Locale getNLPropertyLocale(String localeString) {
        Locale locale = null;
        if (localeString != null && localeString.length() != 0) {
            String[] segments = localeString.split("_");
            switch (segments.length) {
                case 1: {
                    locale = new Locale(segments[0]);
                    break;
                }
                case 2: {
                    locale = new Locale(segments[0], segments[1]);
                    break;
                }
                case 3: {
                    locale = new Locale(segments[0], segments[1], segments[2]);
                    break;
                }
            }
        }
        return locale;
    }

    private String getFileUrl(String variableArg) {
        if (variableArg == null) {
            return null;
        }
        File f = new File(variableArg);
        try {
            return FileURLUtil.toUnescapedFileURL((File)f).toString();
        }
        catch (MalformedURLException e) {
            return e.toString();
        }
    }

    private String createTempFile(String variableArg) {
        try {
            File parentFolder = null;
            String prefix = "temp";
            String suffix = null;
            if (variableArg != null) {
                String name;
                int i;
                Path p = new Path(variableArg);
                File f = p.toFile();
                parentFolder = f.getParentFile();
                if (parentFolder != null) {
                    if (!parentFolder.isAbsolute()) {
                        parentFolder = new File(System.getProperty("java.io.tmpdir"), parentFolder.getPath());
                    }
                    if (!parentFolder.exists()) {
                        parentFolder.mkdirs();
                    }
                }
                if ((i = (name = f.getName()).lastIndexOf(46)) < 0) {
                    prefix = name;
                } else {
                    prefix = name.substring(0, i);
                    suffix = name.substring(i);
                    if (suffix.length() < 2) {
                        suffix = null;
                    }
                }
                if (prefix.length() < 3) {
                    prefix = "temp_" + prefix;
                }
            }
            File tempFile = FileUtil.createTempFile((String)prefix, suffix, parentFolder);
            return tempFile.getCanonicalPath();
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    private String genLogfile(String variableArg) {
        String prefix = null;
        String suffix = null;
        if (variableArg != null) {
            int i = variableArg.lastIndexOf(46);
            if (i < 0) {
                prefix = variableArg;
            } else {
                prefix = variableArg.substring(0, i);
                suffix = variableArg.substring(i);
                if (suffix.length() < 2) {
                    suffix = null;
                }
            }
        }
        File file = LogManager.createExternalLogFile(prefix, suffix);
        String result = null;
        try {
            result = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            result = file.getAbsolutePath();
        }
        return result;
    }

    protected String getCanonicalLocation(String location) {
        if (location == null || location.trim().length() < 1) {
            return EMPTY_STRING;
        }
        try {
            File f = new File(location);
            return f.getCanonicalPath();
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    private String getShortHostName() {
        if (this.networkInfo == null) {
            this.getNetworkInfo();
        }
        return this.networkInfo != null ? this.networkInfo.getShortHostName() : EMPTY_STRING;
    }

    private String getFullHostName() {
        if (this.networkInfo == null) {
            this.getNetworkInfo();
        }
        return this.networkInfo != null ? this.networkInfo.getFullHostName() : EMPTY_STRING;
    }

    private String getDomainName() {
        if (this.networkInfo == null) {
            this.getNetworkInfo();
        }
        return this.networkInfo != null ? this.networkInfo.getDomainName() : EMPTY_STRING;
    }

    private void getNetworkInfo() {
        try {
            this.networkInfo = NetworkInfo.getNetworkInfo();
        }
        catch (UnknownHostException unknownHostException) {}
    }

    @Deprecated
    protected void checkDeprecatedVariable(String variableName) {
        if (variableName.equals(SYSTEM_PROPERTY_OLD) && !loggedDeprecatedSystemProperty) {
            this.reportDeprecatedVariable(SYSTEM_PROPERTY_OLD, SYSTEM_PROPERTY_VAR);
            loggedDeprecatedSystemProperty = true;
        }
    }

    @Deprecated
    protected void reportDeprecatedVariable(String oldVar, String newVar) {
        log.warning("Substitution variable ''{0}'' is deprecated; use ''{1}'' instead", new Object[]{oldVar, newVar});
    }

    public static enum AllowAbsolutePath {
        TRUE,
        FALSE;

    }

    public static class VariableSubstitutionException
    extends CoreException {
        public VariableSubstitutionException(String message, Object ... args) {
            this((IStatus)Statuses.ERROR.get(message, args));
        }

        public VariableSubstitutionException(IStatus status) {
            super(status);
        }
    }
}

