/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.util;

import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.util.Debug;
import com.ibm.gsk.ikeyman.util.KeymanSettings;
import com.ibm.gsk.ikeyman.util.LogFileFilter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserPrincipal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FilePermissions {
    static Set<AclEntryPermission> ownerPermissions = null;
    static Set<AclEntryPermission> groupPermissions = null;
    static Set<AclEntryPermission> othersPermissions = null;
    static String permissions = KeymanSettings.Setting.DefaulFileCreatePermission.getString().toLowerCase();

    public static void setFilePermissions(File file) throws KeyManagerException {
        if (!permissions.equals("") && file.exists()) {
            try {
                Files.setPosixFilePermissions(file.toPath(), PosixFilePermissions.fromString(permissions));
            }
            catch (NoClassDefFoundError e) {
            }
            catch (NoSuchMethodError e) {
            }
            catch (UnsupportedOperationException e) {
                if (permissions.startsWith("rw")) {
                    try {
                        FilePermissions.initACLsFromString(permissions);
                        FilePermissions.setACL(file.toPath(), permissions);
                    }
                    catch (IOException e1) {
                        throw new KeyManagerException(KeyManagerException.ExceptionReason.UNSUPPORTED_CALLBACK, e1.getMessage());
                    }
                }
                Debug.log("Unsupported or invalid permissions setting: " + permissions, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.UNSUPPORTED_CALLBACK, "Wrong permission string: " + permissions + ", permissions must be in format: rwxrwxrwx");
            }
            catch (IOException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.UNSUPPORTED_CALLBACK, e.getMessage());
            }
        }
    }

    public static void setFilePermissions(String fileName) throws KeyManagerException {
        FilePermissions.setFilePermissions(new File(fileName));
    }

    public static void setLogFilePermissions() {
        String[] fileNames;
        File curDir = new File(Debug.getCurrentDir());
        for (String file : fileNames = curDir.list(new LogFileFilter())) {
            try {
                FilePermissions.setFilePermissions(new File(file));
            }
            catch (KeyManagerException e) {
                // empty catch block
            }
        }
    }

    private static void setACL(Path path, String permissions) throws IOException {
        FilePermissions.setOwnerACL(path, permissions);
    }

    private static void setOwnerACL(Path path, String permissions) throws IOException {
        UserPrincipal self = path.getFileSystem().getUserPrincipalLookupService().lookupPrincipalByName(System.getProperty("user.name", "unknown"));
        AclFileAttributeView view = Files.getFileAttributeView(path, AclFileAttributeView.class, new LinkOption[0]);
        AclEntry entry = AclEntry.newBuilder().setType(AclEntryType.ALLOW).setPrincipal(self).setPermissions(ownerPermissions).build();
        List<AclEntry> acl = view.getAcl();
        acl.clear();
        acl.add(entry);
        view.setAcl(acl);
    }

    private static void initACLsFromString(String permissions) {
        if (ownerPermissions != null) {
            return;
        }
        char[] perms = permissions.toCharArray();
        ownerPermissions = new HashSet<AclEntryPermission>();
        if (perms.length > 0 && perms[0] == 'r') {
            ownerPermissions.add(AclEntryPermission.READ_ACL);
            ownerPermissions.add(AclEntryPermission.READ_DATA);
            ownerPermissions.add(AclEntryPermission.READ_ATTRIBUTES);
            ownerPermissions.add(AclEntryPermission.READ_NAMED_ATTRS);
        }
        if (perms.length > 1 && perms[1] == 'w') {
            ownerPermissions.add(AclEntryPermission.APPEND_DATA);
            ownerPermissions.add(AclEntryPermission.DELETE);
            ownerPermissions.add(AclEntryPermission.SYNCHRONIZE);
            ownerPermissions.add(AclEntryPermission.WRITE_ACL);
            ownerPermissions.add(AclEntryPermission.WRITE_ATTRIBUTES);
            ownerPermissions.add(AclEntryPermission.WRITE_NAMED_ATTRS);
            ownerPermissions.add(AclEntryPermission.WRITE_OWNER);
            ownerPermissions.add(AclEntryPermission.WRITE_DATA);
        }
        if (perms.length > 2 && perms[2] == 'x') {
            ownerPermissions.add(AclEntryPermission.EXECUTE);
        }
        groupPermissions = new HashSet<AclEntryPermission>();
        if (perms.length > 3 && perms[3] == 'r') {
            groupPermissions.add(AclEntryPermission.READ_ACL);
            groupPermissions.add(AclEntryPermission.READ_DATA);
            groupPermissions.add(AclEntryPermission.READ_ATTRIBUTES);
            groupPermissions.add(AclEntryPermission.READ_NAMED_ATTRS);
        }
        if (perms.length > 4 && perms[4] == 'w') {
            groupPermissions.add(AclEntryPermission.APPEND_DATA);
            groupPermissions.add(AclEntryPermission.DELETE);
            groupPermissions.add(AclEntryPermission.SYNCHRONIZE);
            groupPermissions.add(AclEntryPermission.WRITE_ACL);
            groupPermissions.add(AclEntryPermission.WRITE_ATTRIBUTES);
            groupPermissions.add(AclEntryPermission.WRITE_NAMED_ATTRS);
            groupPermissions.add(AclEntryPermission.WRITE_OWNER);
            groupPermissions.add(AclEntryPermission.WRITE_DATA);
        }
        if (perms.length > 5 && perms[5] == 'x') {
            groupPermissions.add(AclEntryPermission.EXECUTE);
        }
        othersPermissions = new HashSet<AclEntryPermission>();
        if (perms.length > 6 && perms[6] == 'r') {
            othersPermissions.add(AclEntryPermission.READ_ACL);
            othersPermissions.add(AclEntryPermission.READ_DATA);
            othersPermissions.add(AclEntryPermission.READ_ATTRIBUTES);
            othersPermissions.add(AclEntryPermission.READ_NAMED_ATTRS);
        }
        if (perms.length > 7 && perms[7] == 'w') {
            othersPermissions.add(AclEntryPermission.APPEND_DATA);
            othersPermissions.add(AclEntryPermission.DELETE);
            othersPermissions.add(AclEntryPermission.SYNCHRONIZE);
            othersPermissions.add(AclEntryPermission.WRITE_ACL);
            othersPermissions.add(AclEntryPermission.WRITE_ATTRIBUTES);
            othersPermissions.add(AclEntryPermission.WRITE_NAMED_ATTRS);
            othersPermissions.add(AclEntryPermission.WRITE_OWNER);
            othersPermissions.add(AclEntryPermission.WRITE_DATA);
        }
        if (perms.length > 8 && perms[8] == 'x') {
            othersPermissions.add(AclEntryPermission.EXECUTE);
        }
    }

    public static void main(String[] args) {
        String os = System.getProperty("os.name");
        String file = null;
        file = os.startsWith("Windows") ? "C:/ikeymantest.txt" : "/ikeymantest.txt";
        System.out.println("====== Creating File: " + file + " =========");
        File f = new File(file);
        try {
            OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(f));
            out.write("========Test String=====");
            ((Writer)out).close();
            FilePermissions.setFilePermissions(f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (KeyManagerException e) {
            e.printStackTrace();
        }
        System.out.println("====== All done =========");
    }
}

