/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.util;

import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.util.StateMachineFactory;
import java.math.BigInteger;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AliasRange {
    private static final int DEFAULT_HEX_STRING_LENGTH = 18;
    private String aliasRange;
    private String[] components = null;

    public AliasRange(String aliasRange) {
        this.aliasRange = aliasRange;
    }

    public void validate(ValidationMode mode) throws KeyManagerException {
        BigInteger value2;
        BigInteger value1;
        if (this.getComponents().length > 2 && (value1 = new BigInteger(this.getComponents()[1], 16)).compareTo(value2 = new BigInteger(this.getComponents()[2], 16)) >= 0) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_ALIAS_RANGE_FORMAT, this.aliasRange);
        }
        if (mode == ValidationMode.EKM && (this.getComponents()[1].length() > 18 || this.getComponents().length > 2 && this.getComponents()[2].length() > 18)) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_ALIAS_RANGE_FORMAT, this.aliasRange);
        }
    }

    public Enumeration<String> getAliasEnumerator() throws KeyManagerException {
        return new AliasEnumeration();
    }

    public boolean containsAlias(String alias) throws KeyManagerException {
        AliasRange other = new AliasRange(alias);
        if (!other.getComponents()[0].equals(this.getComponents()[0])) {
            return false;
        }
        if (other.getComponents().length > 2) {
            return false;
        }
        BigInteger otherValue = new BigInteger(other.getComponents()[1], 16);
        if (this.getComponents().length > 2) {
            BigInteger lower = new BigInteger(this.getComponents()[1], 16);
            BigInteger upper = new BigInteger(this.getComponents()[2], 16);
            return otherValue.compareTo(lower) >= 0 && otherValue.compareTo(upper) <= 0;
        }
        BigInteger thisValue = new BigInteger(this.getComponents()[1], 16);
        return otherValue.equals(thisValue);
    }

    private String[] getComponents() throws KeyManagerException {
        if (this.components == null) {
            StateMachineFactory.AliasRangeParser parser = StateMachineFactory.getAliasRangeParser();
            for (int i = 0; i < this.aliasRange.length(); ++i) {
                try {
                    parser.handle(Character.valueOf(this.aliasRange.charAt(i)));
                    continue;
                }
                catch (Exception e) {
                    throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_ALIAS_RANGE_FORMAT, this.aliasRange);
                }
            }
            this.components = parser.getHex2().equals("") ? new String[]{parser.getPrefix(), parser.getHex1()} : new String[]{parser.getPrefix(), parser.getHex1(), parser.getHex2()};
        }
        return this.components;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AliasEnumeration
    implements Enumeration<String> {
        private String prefix;
        private BigInteger currentVal;
        private BigInteger finalVal;

        public AliasEnumeration() throws KeyManagerException {
            this.prefix = AliasRange.this.getComponents()[0];
            this.currentVal = new BigInteger(AliasRange.this.getComponents()[1], 16);
            this.finalVal = AliasRange.this.getComponents().length > 2 ? new BigInteger(AliasRange.this.getComponents()[2], 16) : this.currentVal;
        }

        @Override
        public boolean hasMoreElements() {
            return this.currentVal.compareTo(this.finalVal) <= 0;
        }

        @Override
        public String nextElement() {
            String returnValue = this.prefix + this.getCurrentValue();
            this.currentVal = this.currentVal.add(BigInteger.ONE);
            return returnValue;
        }

        private String getCurrentValue() {
            String value = this.currentVal.toString(16);
            while (value.length() < 18) {
                value = "0" + value;
            }
            return value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ValidationMode {
        NORMAL,
        EKM;

    }
}

