/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore;

import com.ibm.gsk.ikeyman.keystore.EntryBagFactory;
import com.ibm.gsk.ikeyman.keystore.EntryInterfaceFactory;
import com.ibm.gsk.ikeyman.keystore.entry.Entry;
import com.ibm.gsk.ikeyman.keystore.entry.PrivateKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.SecretKeyItem;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectorFactory {
    public static Selector<EntryBagFactory.EntryBag<? extends Entry>> getEntryBagCollectionSelector(EntryBagFactory.EntryBag<? extends Entry> ... entryBags) {
        return new SelectorByTypeImpl((EntryBagFactory.EntryBag[])entryBags);
    }

    public static Selector<EntryInterfaceFactory.EntryInterface<? extends Entry, ? extends DatabaseDescriptorFactory.DatabaseDescriptor>> getEntryInterfaceSelectorByType(EntryInterfaceFactory.EntryInterface<? extends Entry, ? extends DatabaseDescriptorFactory.DatabaseDescriptor> ... entryInterfaces) {
        return new SelectorByTypeImpl((EntryBagFactory.EntryBag[])entryInterfaces);
    }

    public static Selector<EntryInterfaceFactory.EntryInterface<? extends Entry, ? extends DatabaseDescriptorFactory.DatabaseDescriptor>> getEntryInterfaceSelectorPrimarySecondary(EntryInterfaceFactory.EntryInterface<? extends Entry, ? extends DatabaseDescriptorFactory.DatabaseDescriptor> primary, EntryInterfaceFactory.EntryInterface<? extends Entry, ? extends DatabaseDescriptorFactory.DatabaseDescriptor> secondary) {
        return new InterfaceSelectorPrimarySecondaryImpl(primary, secondary);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InterfaceSelectorPrimarySecondaryImpl
    implements Selector<EntryInterfaceFactory.EntryInterface<? extends Entry, ? extends DatabaseDescriptorFactory.DatabaseDescriptor>> {
        private EntryInterfaceFactory.EntryInterface<? extends Entry, ? extends DatabaseDescriptorFactory.DatabaseDescriptor> primaryInterface;
        private EntryInterfaceFactory.EntryInterface<? extends Entry, ? extends DatabaseDescriptorFactory.DatabaseDescriptor> secondaryInterface;
        private Collection<EntryInterfaceFactory.EntryInterface<? extends Entry, ? extends DatabaseDescriptorFactory.DatabaseDescriptor>> entryInterfaces = new ArrayList<EntryInterfaceFactory.EntryInterface<? extends Entry, ? extends DatabaseDescriptorFactory.DatabaseDescriptor>>();

        public InterfaceSelectorPrimarySecondaryImpl(EntryInterfaceFactory.EntryInterface<? extends Entry, ? extends DatabaseDescriptorFactory.DatabaseDescriptor> primary, EntryInterfaceFactory.EntryInterface<? extends Entry, ? extends DatabaseDescriptorFactory.DatabaseDescriptor> secondary) {
            this.primaryInterface = primary;
            this.secondaryInterface = secondary;
            this.entryInterfaces.add(this.primaryInterface);
            if (secondary != null) {
                this.entryInterfaces.add(this.secondaryInterface);
            }
        }

        @Override
        public Collection<EntryInterfaceFactory.EntryInterface<? extends Entry, ? extends DatabaseDescriptorFactory.DatabaseDescriptor>> getAll() {
            return this.entryInterfaces;
        }

        @Override
        public EntryInterfaceFactory.EntryInterface<? extends Entry, ? extends DatabaseDescriptorFactory.DatabaseDescriptor> select(Entry item) {
            if (this.secondaryInterface != null && !(item instanceof PrivateKeyItem) && !(item instanceof SecretKeyItem)) {
                return this.secondaryInterface;
            }
            return this.primaryInterface;
        }

        @Override
        public int compare(Entry e1, Entry e2) {
            if (this.secondaryInterface != null) {
                boolean e1IsSecondary = this.secondaryInterface.contains(e1.getLabel());
                boolean e2IsSecondary = this.secondaryInterface.contains(e2.getLabel());
                if (e1IsSecondary && e2IsSecondary) {
                    int returnValue = e1.compareTo(e2);
                    return returnValue;
                }
                if (e1IsSecondary) {
                    return 1;
                }
                if (e2IsSecondary) {
                    return -1;
                }
            }
            int returnValue = e1.compareTo(e2);
            return returnValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Selector<T extends EntryBagFactory.EntryBag>
    extends Comparator<Entry> {
        public Collection<T> getAll();

        public T select(Entry var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SelectorByTypeImpl<T extends EntryBagFactory.EntryBag<? extends Entry>>
    implements Selector<T> {
        private Collection<T> certBags;

        public SelectorByTypeImpl(T[] entryBags) {
            this.certBags = Arrays.asList(entryBags);
        }

        @Override
        public Collection<T> getAll() {
            ArrayList<T> returnList = new ArrayList<T>();
            returnList.addAll(this.certBags);
            return returnList;
        }

        @Override
        public T select(Entry item) {
            ArrayList classes = new ArrayList();
            Class<?> c = item.getClass();
            classes.add(c);
            for (Class<?> i : c.getInterfaces()) {
                classes.add(i);
            }
            while ((c = c.getSuperclass()) != null) {
                classes.add(c);
                for (Class<?> i : c.getInterfaces()) {
                    classes.add(i);
                }
            }
            for (Class clazz : classes) {
                for (EntryBagFactory.EntryBag bag : this.getAll()) {
                    if (!bag.getSupportedTypes().contains(clazz)) continue;
                    return (T)bag;
                }
            }
            return null;
        }

        @Override
        public int compare(Entry e1, Entry e2) {
            return e1.compareTo(e2);
        }
    }
}

