/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore;

import com.ibm.crypto.pkcs11impl.provider.PKCS11SecretKey;
import com.ibm.gsk.ikeyman.error.InternalKeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.keystore.entry.DisplayItemFactory;
import com.ibm.gsk.ikeyman.util.Debug;
import com.ibm.security.x509.KeyIdentifier;
import com.ibm.security.x509.SubjectKeyIdentifierExtension;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import javax.crypto.SecretKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryFilterFactory {
    public static EntryFilter<KeyStore> newKeyStoreKeyEntryFilter() {
        return new KeyStoreKeyEntryFilter(PrivateKey.class);
    }

    public static EntryFilter<KeyStore> newKeyStoreSecretKeyEntryFilter() {
        return new KeyStoreKeyEntryFilter(SecretKey.class);
    }

    public static EntryFilter<KeyStore> newKeyStoreCertEntryFilter() {
        return new KeyStoreCertEntryFilter();
    }

    public static EntryFilter<KeyStore> newCertificateRequestEntryFilter() {
        return new CertReqEntryFilter(true);
    }

    public static EntryFilter<KeyStore> newPKCS11KeyEntryFilter() {
        return new CertReqEntryFilter(false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CertReqEntryFilter
    implements EntryFilter<KeyStore> {
        private boolean certRequests;

        public CertReqEntryFilter(boolean certRequests) {
            this.certRequests = certRequests;
        }

        @Override
        public boolean isEntry(KeyStore container, String label, String password) throws KeyManagerException {
            try {
                if (container.isKeyEntry(label)) {
                    X509Certificate cert;
                    try {
                        cert = (X509Certificate)container.getCertificate(this.getCertForAlias(container, label));
                    }
                    catch (Exception e) {
                        cert = (X509Certificate)container.getCertificate(label);
                    }
                    if (cert == null) {
                        return false;
                    }
                    return !(this.certRequests ^ CertReqEntryFilter.isCertRequest(cert));
                }
                return false;
            }
            catch (KeyStoreException e) {
                throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.UNINITIALISED_KEY_STORE, (Throwable)e);
            }
        }

        private String getCertForAlias(KeyStore container, String alias) throws KeyManagerException {
            ArrayList<String> aliases;
            try {
                aliases = Collections.list(container.aliases());
            }
            catch (KeyStoreException e) {
                return null;
            }
            for (String a : aliases) {
                if (!a.matches(alias + "cert[\\d]+")) continue;
                return a;
            }
            return null;
        }

        protected static boolean isCertRequest(X509Certificate cert) throws KeyManagerException {
            for (DisplayItemFactory.ExtensionItem extension : DisplayItemFactory.getExtensionItems(cert)) {
                byte[] keyID;
                if (!(extension.getExtension() instanceof SubjectKeyIdentifierExtension)) continue;
                SubjectKeyIdentifierExtension ski = (SubjectKeyIdentifierExtension)extension.getExtension();
                try {
                    keyID = ((KeyIdentifier)ski.get("key_id")).getIdentifier();
                }
                catch (IOException e) {
                    throw new KeyManagerException(KeyManagerException.ExceptionReason.IO_ERROR, (Throwable)e);
                }
                String str = new String(keyID);
                if (!str.equals("IkeymanCertificateRequest")) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface EntryFilter<T> {
        public boolean isEntry(T var1, String var2, String var3) throws KeyManagerException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KeyStoreCertEntryFilter
    implements EntryFilter<KeyStore> {
        private KeyStoreCertEntryFilter() {
        }

        @Override
        public boolean isEntry(KeyStore container, String label, String password) throws KeyManagerException {
            try {
                return container.isCertificateEntry(label);
            }
            catch (KeyStoreException e) {
                throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.UNINITIALISED_KEY_STORE, (Throwable)e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KeyStoreKeyEntryFilter
    implements EntryFilter<KeyStore> {
        private Class<? extends Key> keyType;
        private CertReqEntryFilter crf;

        public KeyStoreKeyEntryFilter(Class<? extends Key> keyType) {
            this.keyType = keyType;
            this.crf = new CertReqEntryFilter(true);
        }

        @Override
        public boolean isEntry(KeyStore container, String label, String password) throws KeyManagerException {
            Debug.entering(label);
            if (this.crf.isEntry(container, label, password)) {
                return false;
            }
            try {
                if (container.isKeyEntry(label)) {
                    Key tempKey = container.getKey(label, password.toCharArray());
                    if (this.keyType.isInstance(tempKey)) {
                        if (tempKey instanceof PKCS11SecretKey) {
                            return ((PKCS11SecretKey)tempKey).getNeverExtractable() == false;
                        }
                        Debug.exiting();
                        return true;
                    }
                    Debug.exiting();
                    return false;
                }
                Debug.exiting();
                return false;
            }
            catch (KeyStoreException e) {
                Debug.exiting();
                throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.UNINITIALISED_KEY_STORE, (Throwable)e);
            }
            catch (NoSuchAlgorithmException e) {
                Debug.log(e.getMessage(), label);
                Debug.exiting();
                return true;
            }
            catch (UnrecoverableKeyException e) {
                Debug.log(e.getMessage(), label);
                Debug.exiting();
                return true;
            }
        }
    }
}

