/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.io;

import com.ibm.gsk.ikeyman.util.Debug;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;

public class LockedFileOutputStream
extends OutputStream {
    private FileOutputStream outputStream;

    public LockedFileOutputStream(String fileName) throws IOException {
        FileLock lock;
        this.outputStream = new FileOutputStream(fileName, true);
        FileChannel channel = this.outputStream.getChannel();
        try {
            lock = channel.tryLock();
        }
        catch (OverlappingFileLockException e) {
            Debug.throwing(e);
            this.outputStream.close();
            throw new IOException("Unable to acquire file lock for " + fileName);
        }
        if (lock == null) {
            this.outputStream.close();
            throw new IOException("Unable to acquire file lock for " + fileName);
        }
        channel.truncate(0L);
    }

    public LockedFileOutputStream(File file) throws IOException {
        this(file.getAbsolutePath());
    }

    public void write(int b) throws IOException {
        this.outputStream.write(b);
    }

    public void close() throws IOException {
        this.outputStream.close();
    }

    public void flush() throws IOException {
        this.outputStream.flush();
    }
}

