/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.infocommands;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import java.io.PrintStream;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;

@DTFJPlugin(version="1.*", runtime=false)
public class InfoSystemCommand
extends BaseJdmpviewCommand {
    public InfoSystemCommand() {
        this.addCommand("info sys", "", "shortened form of info system");
        this.addCommand("info system", "", "displays information about the system the core dump is from");
    }

    public void run(String command, String[] args, IContext context, PrintStream out) throws CommandException {
        if (this.initCommand(command, args, context, out)) {
            return;
        }
        if (args.length != 0) {
            out.println("\"info system\" command does not take any parameters");
            return;
        }
        this.doCommand();
    }

    public void doCommand() {
        try {
            this.out.println("\nMachine OS:\t" + this.ctx.getImage().getSystemType());
        }
        catch (DataUnavailable exc) {
            this.out.println("\nMachine OS:\tdata unavailable");
        }
        catch (CorruptDataException exc) {
            this.out.println("\nMachine OS:\tdata corrupted");
        }
        try {
            this.out.println("Machine name:\t" + this.ctx.getImage().getHostName());
        }
        catch (DataUnavailable exc) {
            this.out.println("Machine name:\tdata unavailable");
        }
        catch (CorruptDataException exc) {
            this.out.println("Machine name:\tdata corrupted");
        }
        this.out.println("Machine IP address(es):");
        try {
            Iterator itIPAddresses = this.ctx.getImage().getIPAddresses();
            while (itIPAddresses.hasNext()) {
                Object addr = itIPAddresses.next();
                if (addr instanceof InetAddress) {
                    this.out.println("\t\t" + ((InetAddress)addr).getHostAddress());
                    continue;
                }
                if (!(addr instanceof CorruptData)) continue;
                this.out.println("\t\tdata corrupted");
            }
        }
        catch (DataUnavailable du) {
            this.out.println("\t\tdata unavailable");
        }
        try {
            this.out.println("System memory:\t" + this.ctx.getImage().getInstalledMemory());
        }
        catch (DataUnavailable exc) {
            this.out.println("System memory:\tdata unavailable");
        }
        try {
            long createTimeMillis = this.ctx.getImage().getCreationTime();
            if (createTimeMillis != 0L) {
                SimpleDateFormat fmt = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                String createTimeStr = fmt.format(new Date(createTimeMillis));
                this.out.println("\nDump creation time:\t" + createTimeStr);
            }
        }
        catch (DataUnavailable d) {
            this.out.println("Dump creation time:\tdata unavailable");
        }
        this.out.println("\nJava version:");
        if (this.ctx.getRuntime() != null) {
            try {
                this.out.println(this.ctx.getRuntime().getVersion() + "\n");
            }
            catch (CorruptDataException e) {
                this.out.println("version data corrupted\n");
            }
        } else {
            this.out.println("\tmissing, unknown or unsupported JRE");
        }
    }

    public void printDetailedHelp(PrintStream out) {
        out.println("displays information about the system the core dump is from\n\nparameters: none\n\nprints information about the system the core dump is from:\n  - operating system\n  - host name and IP addresses\n  - amount of memory\n  - virtual machine(s) present\n");
    }
}

